---
title: 配置 Gradle 用于 GitHub 包
intro: '您可以配置 Gradle 以将包发布到 {% data variables.product.prodname_registry %} 并将存储在 {% data variables.product.prodname_registry %} 上的包用作 Java 项目中的依赖项。'
product: '{% data reusables.gated-features.packages %}'
redirect_from:
  - /articles/configuring-gradle-for-use-with-github-package-registry
  - /github/managing-packages-with-github-package-registry/configuring-gradle-for-use-with-github-package-registry
  - /github/managing-packages-with-github-packages/configuring-gradle-for-use-with-github-packages
versions:
  free-pro-team: '*'
  enterprise-server: '>=2.22'
---

{% data reusables.package_registry.packages-ghes-release-stage %}

**注：**安装或发布 Docker 映像时，{% data variables.product.prodname_registry %} 当前不支持外部图层，如 Windows 映像。

### 向 {% data variables.product.prodname_registry %} 验证

{% data reusables.package_registry.authenticate-packages %}

#### 使用个人访问令牌进行身份验证

{% data reusables.package_registry.required-scopes %}

您可以使用 Gradle Groovy 或 Kotlin DSL，通过 Gradle 向 {% data variables.product.prodname_registry %} 验证，方法是编辑 *build.gradle* 文件 (Gradle Groovy) 或 *build.gradle.kts* 文件 (Kotlin DSL) 以包含您的个人访问令牌。 您还可以配置 Gradle Groovy 和 Kotlin DSL 以识别仓库中的一个或多个包。

{% if currentVersion != "free-pro-team@latest" %}
Replace *REGISTRY-URL* with the URL for your instance's Maven registry. If your instance has subdomain isolation enabled, use `maven.HOSTNAME`. If your instance has subdomain isolation disabled, use `HOSTNAME/_registry/maven`. In either case, replace *HOSTNAME* with the host name of your {% data variables.product.prodname_ghe_server %} instance.
{% endif %}

将 *USERNAME* 替换为您的 {% data variables.product.prodname_dotcom %} 用户名，将 *TOKEN* 替换为您的个人访问令牌，将 *REPOSITORY* 替换为要发布的包所在仓库的名称，将 *OWNER* 替换为 {% data variables.product.prodname_dotcom %} 上拥有该仓库的用户或组织帐户的名称。 {% data reusables.package_registry.lowercase-name-field %}

{% note %}

**注：**{% data reusables.package_registry.apache-maven-snapshot-versions-supported %} 关于示例，请参阅“[配置 Apache Maven 用于 {% data variables.product.prodname_registry %}](/packages/using-github-packages-with-your-projects-ecosystem/configuring-apache-maven-for-use-with-github-packages)”。

{% endnote %}

##### 将 Gradle Groovy 用于一个仓库中单个包的示例

```shell
plugins {
    id("maven-publish")
}

publishing {
    repositories {
        maven {
            name = "GitHubPackages"
            url = uri("https://maven.pkg.github.com/<em>OWNER</em>/<em>REPOSITORY</em>")
            credentials {
                username = project.findProperty("gpr.user") ?: System.getenv("<em>USERNAME</em>")
                password = project.findProperty("gpr.key") ?: System.getenv("<em>TOKEN</em>")
            }
        }
    }
    publications {
        gpr(MavenPublication) {
            from(components.java)
        }
    }
}
```

##### 将 Gradle Groovy 用于同一个仓库中多个包的示例

```shell
plugins {
    id("maven-publish") apply false
}

subprojects {
    apply plugin: "maven-publish"
    publishing {
        repositories {
            maven {
                name = "GitHubPackages"
                url = uri("https://maven.pkg.github.com/<em>OWNER</em>/<em>REPOSITORY</em>")
                credentials {
                    username = project.findProperty("gpr.user") ?: System.getenv("<em>USERNAME</em>")
                    password = project.findProperty("gpr.key") ?: System.getenv("<em>TOKEN</em>")
                }
            }
        }
        publications {
            gpr(MavenPublication) {
                from(components.java)
            }
        }
    }
}
```

##### 将 Kotlin DSL 用于同一个仓库中单个包的示例

```shell
plugins {
    `maven-publish`
}

publishing {
    repositories {
        maven {
            name = "GitHubPackages"
            url = uri("https://maven.pkg.github.com/<em>OWNER</em>/<em>REPOSITORY</em>")
            credentials {
                username = project.findProperty("gpr.user") as String? ?: System.getenv("<em>USERNAME</em>")
                password = project.findProperty("gpr.key") as String? ?: System.getenv("<em>TOKEN</em>")
            }
        }
    }
    publications {
        register<MavenPublication>("gpr") {
            from(components["java"])
        }
    }
} ?: System.getenv("<em>USERNAME</em>")
                password = project.findProperty("gpr.key") as String? ?: System.getenv("<em>TOKEN</em>")
            }
        }
    }
    publications {
        register<MavenPublication>("gpr") {
            from(components["java"])
        }
    }
}
```

##### 将 Kotlin DSL 用于同一个仓库中多个包的示例

  ```shell
  plugins {
  `maven-publish` apply false
  }

  subprojects {
  apply(plugin = "maven-publish")
  configure<PublishingExtension> {
  repositories {
  maven {
  name = "GitHubPackages"
  url = uri("https://maven.pkg.github.com/<em>OWNER</em>/<em>REPOSITORY</em>")
  credentials {
  username = project.findProperty("gpr.user") as String? ?: System.getenv("<em>USERNAME</em>")
  password = project.findProperty("gpr.key") as String? ?: System.getenv("<em>TOKEN</em>")
  }
  }
  }
  publications {
  register<MavenPublication>("gpr") {
  from(components["java"])
  }
  }
  }
  } ?: System.getenv("<em>USERNAME</em>")
  password = project.findProperty("gpr.key") as String? ?: System.getenv("<em>TOKEN</em>")
  }
  }
  }
  publications {
  register<MavenPublication>("gpr") {
  from(components["java"])
  }
  }
  }
  }
  ```

  #### 使用 `GITHUB_TOKEN` 进行身份验证

  {% data reusables.package_registry.package-registry-with-github-tokens %}

  有关将 `GITHUB_TOKEN` 用于 Maven 的更多信息，请参阅“[使用 Maven 发布 Java 包](/actions/language-and-framework-guides/publishing-java-packages-with-maven#publishing-packages-to-github-packages)”。

  ### 发布包

  {% data reusables.package_registry.default-name %} 例如，{% data variables.product.prodname_dotcom %} 将名为 `com.example.test` 的包发布到 `OWNER/test` {% data variables.product.prodname_registry %} 仓库中。

  {% data reusables.package_registry.viewing-packages %}

  {% data reusables.package_registry.authenticate-step %}
  2. 创建包后，您可以发布包。

   ```shell
   $ gradle publish
  ```

### 安装包

通过添加包作为您项目中的依赖项，您可以安装包。 更多信息请参阅 Gradle 文档中的“[声明依赖项](https://docs.gradle.org/current/userguide/declaring_dependencies.html)”。

{% data reusables.package_registry.authenticate-step %}
2. 将包依赖项添加到您的 *build.gradle* 文件 (Gradle Groovy) 或 *build.gradle.kts* 文件 (Kotlin DSL)。

  使用 Grady Groovy 的示例：
  ```shell
  dependencies {
  implementation 'com.example:package'
  }
  ```
  使用 Kotlin DSL 的示例：
  ```shell
  dependencies {
  implementation("com.example:package")
  }
  ```

3. 将 maven 插件添加到您的 *build.gradle* 文件 (Gradle Groovy) 或 *build.gradle.kts* 文件 (Kotlin DSL)。

  使用 Grady Groovy 的示例：
  ```shell
  plugins {
  id 'maven'
  }
  ```
  使用 Kotlin DSL 的示例：
  ```shell
  plugins {
  `maven`
  }
  ```

  3. 安装包。

  ```shell
  $ gradle install
  ```

### 延伸阅读

- "[配置 Apache Maven 用于 {% data variables.product.prodname_registry %}](/packages/using-github-packages-with-your-projects-ecosystem/configuring-apache-maven-for-use-with-github-packages)"
- “[删除包](/packages/publishing-and-managing-packages/deleting-a-package/)”
