---
title: 全球隐私实践
redirect_from:
  - /eu-safe-harbor/
  - /articles/global-privacy-practices
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

GitHub provides the same high standard of privacy protection—as described in GitHub’s [Privacy Statement](/github/site-policy/github-privacy-statement#githubs-global-privacy-practices)—to all our users and customers around the world, regardless of their country of origin or location, and GitHub is proud of the level of notice, choice, accountability, security, data integrity, access, and recourse we provide.

GitHub also complies with certain legal frameworks relating to the transfer of data from the European Economic Area, the United Kingdom, and Switzerland (collectively, “EU”) to the United States. When GitHub engages in such transfers, GitHub relies on Standard Contractual Clauses as the legal mechanism to help ensure your rights and protections travel with your personal information. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about the European Commission’s decisions on international data transfer, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection_en).

### Standard Contractual Clauses

GitHub relies on the European Commission-approved Standard Contractual Clauses (“SCCs”) as a legal mechanism for data transfers from the EU. SCCs are contractual commitments between companies transferring personal data, binding them to protect the privacy and security of such data. GitHub adopted SCCs so that the necessary data flows can be protected when transferred outside the EU to countries which have not been deemed by the European Commission to adequately protect personal data, including protecting data transfers to the United States.

To learn more about SCCs, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en).

### 隐私盾框架

GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-US Privacy Shield Framework as a legal basis for transfers of personal information in light of the judgment of the Court of Justice of the EU in Case C-311/18.

The EU-US and Swiss-US Privacy Shield Frameworks are set forth by the US Department of Commerce regarding the collection, use, and retention of User Personal Information transferred from the European Union, the UK, and Switzerland to the United States. GitHub 已通过美国商务部遵守隐私盾原则的认证。 If our vendors or affiliates process User Personal Information on our behalf in a manner inconsistent with the principles of either Privacy Shield Framework, GitHub remains liable unless we prove we are not responsible for the event giving rise to the damage.

For purposes of our certifications under the Privacy Shield Frameworks, if there is any conflict between the terms in these Global Privacy Practices and the Privacy Shield Principles, the Privacy Shield Principles shall govern. 要详细了解隐私盾原则和查看我们的认证，请访问[隐私盾网站](https://www.privacyshield.gov/)。

The Privacy Shield Frameworks are based on seven principles, and GitHub adheres to them in the following ways:

- **通知**
  - 我们在收集您的个人信息时会通知您。
  - 我们在[隐私声明](/articles/github-privacy-statement/)中告诉您，我们收集和使用您的信息的目的是什么、我们在什么限制条件下与谁分享该信息，以及您对自己数据的访问权限。
  - 我们告诉您，我们正在参与隐私盾框架以及这对您意味着什么。
  - 我们有一个 {% data variables.contact.contact_privacy %}，遇到隐私权问题时可通过它联系我们。
  - 我们告诉您，在出现争议时您有权诉诸有约束力的仲裁，并且这对您是免费的。
  - 我们告诉您，我们受联邦贸易委员会的管辖。
- **选择**
  - 我们让您选择如何处理您的数据。 将数据用于超出您许可范围的用途之前，我们会告诉您并征得您的同意。
  - 我们将为您提供合理的选择机制。
- **继续转移的问责制**
  - 我们将您的信息转移给替我们处理数据的第三方时，该第三方必须与我们签订合同，按照我们的隐私声明保护这些数据。 我们根据隐私盾原则将您的数据转移给供应商后，我们仍对这些数据负责。
  - 我们只与第三方供应商分享他们完成交易所需的数据量。
- **安全**
  - 我们将采用[所有合理和适当的安全措施](https://github.com/security)保护您的个人信息。
- **数据完整性和目的限制**
  - 我们仅出于向您提供服务的相关目的收集您的数据。
  - 我们尽可能少地收集有关您的信息，除非您自己选择向我们提供更多信息。
  - 我们采取合理步骤，确保我们拥有的个人数据准确、最新、可靠且适用于预期用途。
- **访问**
  - 您始终可以在[用户个人资料](https://github.com/settings/profile)中访问您提供的数据。 您可以在那里访问、更新、更改或删除您的信息。
- **追索、执行和责任**
  - 如果您对我们的隐私实践有疑问，可通过 {% data variables.contact.contact_privacy %} 联系我们，我们最迟在 45 天内答复您。
  - 万一发生我们无法解决的争议，您可以免费申请有约束力的仲裁。 更多信息请参阅我们的[隐私声明](/articles/github-privacy-statement/)。
  - 我们将对相关的隐私实践进行定期审核，以核实我们是否遵守承诺。
  - 我们要求员工尊重我们的隐私承诺，违反隐私政策的行为将受到纪律处分，包括终止雇佣关系。


#### 争议解决流程

As further explained in the [Resolving Complaints](/github/site-policy/github-privacy-statement#resolving-complaints) section of our [Privacy Statement](/github/site-policy/github-privacy-statement), we encourage you to contact us should you have a Privacy Shield-related (or general privacy-related) complaint. For any complaints that cannot be resolved with GitHub directly, we have selected to cooperate with the relevant EU Data Protection Authority, or a panel established by the European data protection authorities, for resolving disputes with EU individuals, and with the Swiss Federal Data Protection and Information Commissioner (FDPIC) for resolving disputes with Swiss individuals. 如果您需要适用的数据保护当局联系人的信息，请联系我们。

此外，如果您是欧盟成员国的居民，您有权向当地监管机构提出投诉。

#### 独立仲裁

在某些有限的情况下，如果所有其他形式的争议解决均未成功，作为最后手段，欧盟、欧洲经济区 (EEA)、瑞士和英国人士可以诉诸具有约束力的隐私盾仲裁。 要详细了解这种解决方法及其适用性，请认真阅读[隐私盾](https://www.privacyshield.gov/article?id=ANNEX-I-introduction)。 仲裁不是强制性的；它是您可以选择使用的工具。

We are subject to the jurisdiction of the US Federal Trade Commission (FTC).

更多信息请参阅我们的[隐私声明](/articles/github-privacy-statement/)。
