---
title: GitHub 服务条款
redirect_from:
  - /tos/
  - /terms/
  - /terms-of-service/
  - /github-terms-of-service-draft/
  - /articles/github-terms-of-service
versions:
  free-pro-team: '*'
---

感谢您使用 GitHub！ 我们很高兴在这里与您邂逅。 在访问或使用 GitHub 之前，请仔细阅读本服务条款协议。 由于它是我们与用户之间的重要合同，因此我们尽可能明确阐述。 为方便起见，我们在列出完整的法律条款之前，用简短的非约束性摘要介绍这些条款。

### 摘要

| 节                                                           | 说明                                                            |
| ----------------------------------------------------------- | ------------------------------------------------------------- |
| [A. 定义](#a-definitions)                                     | 一些基本术语，其定义方式将有助于您理解此协议。 不明确时请回头参阅本节内容。                        |
| [B. 帐户条款](#b-account-terms)                                 | 这些是在GitHub 上开设帐户的基本要求。                                        |
| [C. 可接受的使用](#c-acceptable-use)                              | 这些是您使用 GitHub 帐户时必须遵循的基本规则。                                   |
| [D. 用户生成内容](#d-user-generated-content)                      | 您在 GitHub 上发布的内容归您所有。 但您对此负有一些责任，我们请您向我们授予一些权利，以便我们能够为您提供服务。  |
| [E. 私有仓库](#e-private-repositories)                          | 本节讨论 GitHub 如何处理您在私有仓库中发布的内容。                                 |
| [F. 版权和 DMCA 政策](#f-copyright-infringement-and-dmca-policy) | 本节介绍当您认为有人正在侵犯您在 GitHub 上的版权时，GitHub 将如何应对。                   |
| [G. 知识产权通告](#g-intellectual-property-notice)                | 说明 GitHub 在网站和服务中的权利。                                         |
| [H. API 条款](#h-api-terms)                                   | 这些是使用 GitHub 的 API 时需遵守的规则，无论您是使用 API 来开发还是数据收集。              |
| [I. 附加产品条款](#i-github-additional-product-terms)             | 我们对 GitHub 的功能和产品有一些具体的规则。                                    |
| [J. 测试版预览](#j-beta-previews)                                | 这些是适用于 GitHub 仍在开发中的功能的一些附加条款。                                |
| [K. 付款](#k-payment)                                         | 您负责付款。 我们负责对您准确计费。                                            |
| [L. 取消和终止](#l-cancellation-and-termination)                 | 您可以随时取消此协议并关闭您的帐户。                                            |
| [M. 与 GitHub 的通信](#m-communications-with-github)            | 我们只使用电子邮件和其他电子方式与用户保持联系。 我们不提供电话支持。                           |
| [N. 免责声明](#n-disclaimer-of-warranties)                      | 我们按原样提供服务，我们对此服务不作任何承诺或保证。 **请仔细阅读本节内容；您应该理解要求。**             |
| [O. 责任限制](#o-limitation-of-liability)                       | 对因您使用或不能使用服务或本协议下产生的损害或损失，我们不承担责任。 **请仔细阅读本节内容；它限制了我们对您的义务。** |
| [P. 免除和赔偿](#p-release-and-indemnification)                  | 您对自己使用服务负全部责任。                                                |
| [Q. 这些服务条款的更改](#q-changes-to-these-terms)                   | 我们可能修改本协议，但我们会提前 30 天向您通知会影响您权利的更改。                           |
| [R. 其他](#r-miscellaneous)                                   | 关于法律详情，包括我们对法律的选择，请参阅本节内容。                                    |

### GitHub 服务条款
生效日期：2020 年 4 月 2 日


### A. 定义
**概述：***我们在整个协议中使用这些基本术语，它们具有特定含义。 在我们使用每个术语时，您应该了解我们表达的意思。 我们不会对定义进行检验，但它仍然是有用的信息。*

1. “帐户”代表您与 GitHub 之间的法律关系。 “用户帐户”代表单个用户登录和使用服务的授权，并在 GitHub 上作为用户的身份。 “组织”是可能与一个实体或者一个或多个用户相关联的共享工作空间，其中多个用户可以同时跨多个项目进行协作。 用户帐户可以是任意数量的组织之成员。
2. “协议”是一种统称，包括本文档中包含或引用的所有条款、条件、通知（“服务条款”或“条款”）和所有其他操作规则、政策（包括 GitHub 隐私声明，请参阅 [github.com/site/privacy](https://github.com/site/privacy)），以及我们可能不时在网站上发布的程序。 我们大多数站点政策可在 [docs.github.com/categories/site-policy](/categories/site-policy) 上查阅。
3. “测试版预览”是指识别为 alpha、beta、预览、提早访问或评估或者具有类似含义的字词或短语的软件、服务或功能。
4. “内容”是指通过网站提供或显示的内容，包括但不限于通过网站或服务提供的代码、文本、数据、文章、图像、照片、图形、软件、应用程序、程序包、设计、功能及其他材料。 “内容”也包括服务。 “用户生成的内容”是由我们用户创建或上传的书面或其他形式的内容。 “您的内容”是您创建或拥有的内容。
5. “GitHub”和“我们是指 GitHub Inc.，以及我们的附属公司、董事、子公司、承包商、许可人、高管、代理和员工。
6. “服务”是指 GitHub 提供的应用程序、软件、产品和服务，包括任何测试版预览。
7. “用户”、“您”和“您的”是指访问或使用网站或服务、访问或使用帐户的任何部分或指示使用帐户以执行其功能的个人、公司或组织。 用户必须年满 13 岁。 特殊条款可能适用于企业或政府帐户（请参阅[第 B(5) 节：附加条款](#5-additional-terms)）。
8. “网站”是指 [github.com](https://github.com/) 上的 GitHub 网站，以及 GitHub 在该网站上或通过该网站提供的所有内容、服务和产品。 它还指代 GitHub 拥有的 github.com 子域，例如 [education.github.com](https://education.github.com/) 和 [pages.github.com](https://pages.github.com/)。 这些条款还适用于 GitHub 的会议网站（例如 [githubuniverse.com](https://githubuniverse.com/)）和产品网站（例如 [atom.io](https://atom.io/)）。 有时，GitHub 拥有的网站可能会提供不同或附加的服务条款。 如果这些附加条款与本协议有冲突，则以适用于相关页面或服务的更具体条款为准。

### B. 帐户条款
**概述：***用户帐户和组织具有不同的管理控制权；每个用户必须创建自己的帐户；必须年满 13 岁；必须提供有效的电子邮件地址；并且不能拥有一个以上的免费帐户。 您自行负责自己的帐户以及登录或使用帐户时发生的任何事情。 您有责任确保自己的帐户安全。*

#### 1. 帐户控制
- 用户. 在符合这些条款的情况下，您对自己的用户帐户及其中的内容具有最终管理控制权。

- 组织. 根据这些条款创建的组织之所有者，对该组织及其中的内容具有最终管理控制权。 在服务中，所有者可以管理用户对组织数据和项目的访问。 一个组织可以有多个所有者，但必须至少指定一个用户帐户为组织的所有者。 如果您是这些条款下的组织之所有者，我们认为您应该对在该组织上或通过该组织执行的操作负责。

#### 2. 必需信息
您必须提供有效的电子邮件地址才能完成注册过程。 要求的任何其他信息（例如您的真实姓名）都是可选的，除非您代表法律实体接受这些条款（在这种情况下，我们需要有关该法律实体的更多信息），或者您选择[付费帐户](#k-payment)（在这种情况下，出于计费目的需要您提供其他信息）。

#### 3. 帐户要求
对于 GitHub 服务上的用户帐户，我们有一些简单的规则。
- 只允许人类创建帐户。 不允许通过“自动程序”或其他自动方法注册帐户。 我们允许机器帐户：
- 机器帐户是由代表该帐户接受条款、提供有效电子邮件地址并对其操作负责的个人所建立的帐户。 机器帐户专用于执行自动化任务。 多个用户可以指示一个机器帐户的操作，但该帐户的所有者对机器的操作承担最终责任。 除了免费用户帐户之外，您最多可以拥有一个免费机器帐户。
- 一个人或一个法律实体最多可以拥有一个免费帐户（如果您选择还控制一个机器帐户，没问题，但是它只能用于运行机器）。
- 用户必须年满 13 岁。 虽然我们很高兴看到优秀的年轻编码者热衷于学习编程，但我们必须遵守美国法律。 GitHub 并未针对 13 岁以下的儿童定制服务，因此我们不允许任何 13 岁以下的用户使用我们的服务。 如果我们发现任何用户未满 13 岁，我们将[立即终止该用户的帐户](#l-cancellation-and-termination)。 如果您是美国以外的国家/地区的居民，您所在国家/地区规定的最低年龄可能会更大；在这种情况下，您有责任遵守您所在国家/地区的法律。
- 您的登录名只能由一个人使用，即不允许多人共享一个登录名。 付费组织只能在订阅允许的范围内向多个用户帐户提供访问权限。
- 不得违反美国或任何其他适用司法管辖区的出口管制或制裁法律使用 GitHub。 如果您是[特别指定国民 (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx)或被美国政府机构实施的类似封锁或被拒方禁令所限制的个人，或者代表他们工作，则您不得使用 GitHub。 government agency.  GitHub 可能会根据美国政府的授权，允许某些受制裁国家或地区的人访问某些 GitHub 服务。 government authorizations.  更多信息请参阅我们的[出口管制政策](/articles/github-and-export-controls)。

#### 4. 用户帐户安全
在使用我们的服务时，您负责维护您的帐户安全。 我们提供双重身份验证等工具，帮助您维护帐户的安全性，但您的帐户内容及其安全性取决于您。
- 您对在您的帐户下发布的所有内容和活动负责（即使是拥有帐户的其他人在您的帐户下发布的内容）。
- 您负责维护您的帐户和密码的安全。 GitHub 不能也不会对您未能遵守此安全保护义务而造成的任何损失或损害承担责任。
- 如果您获悉通过您的帐户发生任何未授权的服务使用或访问，包括对您的密码或帐户的任何未授权使用，请立即[通知 GitHub](https://support.github.com/contact)。

#### 5. 附加条款
在某些情况下，第三方的条款可能适用于您对 GitHub 的使用。 例如，您可能是 GitHub 上本身具有条款或许可协议的组织的成员；您可能下载与 GitHub 相集成的应用程序；或者，您可能使用 GitHub 来验证另一项服务。 请注意，虽然这些条款是我们与完全协商一致的，但其他方的条款则制约着他们与你的关系。

如果您是政府用户或者在政府部门访问或使用 GitHub 服务，则 [GitHub 服务条款政府修正](/articles/amendment-to-github-terms-of-service-applicable-to-u-s-federal-government-users/)适用，并且您同意其条款。

如果您注册了 GitHub Enterprise Cloud，则 [Enterprise Cloud 附录](/articles/github-enterprise-cloud-addendum/)适用于您，并且您同意其规定。

### C. 可接受的使用
**短版本：** *GitHub 托管全球各地大量的协作项目，仅当用户能够善意一起工作时，该协作才能正常进行。 在使用服务时，必须遵守此部分的条款，包括对您可以发布的内容、对服务的操作的一些限制，以及其他限制规定。 简言之，要互惠互利。*

您对网站和服务的使用不得违反任何相关法律，包括版权法或商标法、出口管制或制裁法律，或您的司法管辖区的法规。 您有责任确保您对服务的使用符合法律和任何适用条例。

您同意在任何情况下都不会违反我们的[可接受使用政策](/articles/github-acceptable-use-policies)或[社区指导方针](/articles/github-community-guidelines)。

### D. 用户生成内容
**短版本：** *您创建的内容归您所有，但您允许我们对其拥有某些权限，以便我们能够显示和分享您发布的内容。 您仍然可以控制您的内容并对其负责，您授予我们的权利仅限于我们提供服务所需的权利。 如果我们需要，我们有权删除内容或关闭帐户。*

#### 1. 关于用户生成内容的责任
您在使用服务时可能创建或上传用户生成的内容。 对于您发布、上传、链接或通过服务提供的任何用户生成内容，无论内容的形式如何，您对其内容以及由此造成的任何伤害负有全部责任。 我们对用户生成内容的任何公开显示或滥用概不负责。

#### 2. GitHub 可删除内容
We do not pre-screen User-Generated Content, but we have the right (though not the obligation) to refuse or remove any User-Generated Content that, in our sole discretion, violates any [GitHub terms or policies](/github/site-policy).

#### 3. 内容所有权、发布权利和许可授予
您对您的内容保有所有权和责任。 如果您发布不是您自己创建或者您没有所有权的内容，则您同意对您发布的任何内容负责；您只会提交您有权发布的内容；并且您将完全遵守与您发布的内容有关的任何第三方许可。

因为您对您的内容保有所有权和责任，所以我们需要授予我们——及其他 GitHub 用户——第 D.4 — D.7 部分所列的某些法律权限。 这些许可授予适用于您的内容。 如果您上传的内容具有已经向 GitHub 授予运行服务所需权限的许可，则无需其他许可。 您了解，您对第 D.4-D.7 部分授予的任何权利不会收取任何费用。 您授予我们的许可将在您从我们的服务器删除您的内容后结束，除非其他用户已经复刻它。

#### 4. 向我们授予许可
我们需要合法的权利来为您服务，例如托管、发布以及分享您的内容。 您授权我们和我们的合法继承者存储、解析和显示您的内容，以及视需要偶尔制作副本来渲染网站和提供服务。 这包括如下权利：将您的内容复制到我们的数据库并制作备份；向您及其他用户显示；将其解析为搜索索引或在我们的服务器上分析；与其他用户分享；执行（如果您的内容是音乐或视频之类的内容）。

此许可并未授权 GitHub 销售您的内容或者在服务条款之外使用。

#### 5. 向其他用户授予许可
您公开发布的任何用户生成内容，包括议题、评论以及对其他用户仓库的贡献，都可供其他人查看。 设置公开显示您的仓库，即表示您同意允许他人查看和“复刻”您的仓库（这意味着他人可以从他们控制的仓库自行复制您仓库中的内容）。

如果您将页面和仓库设为公开显示，则表示您向每个用户授予非独占、全球许可，允许他们通过 GitHub 服务使用、显示和执行您的内容，以及通过 GitHub 的功能（例如通过复刻）只在 GitHub 上重制您的内容。 如果您[采用许可](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository)，您得授予进一步的权利。 如果您上传不是您创建或拥有的内容，则您负责确保上传的内容根据向其他 GitHub 用户授予这些许可的条款进行许可。

#### 6. 仓库许可下的参与。
只要您参与包含许可通告的仓库，则表示您在相同条款下许可您的参与，并且同意您有权利在这些条款下许可您的参与。 如果您使用单独的协议在不同条款下许可您的参与，如参与者许可协议，则该协议优先。

不只是它如此运作吧？ 对。 这在开源社区中广泛接受的行为规范；通常被简称为“入站=出站”。 我们只是将它明确化了。

#### 7. 精神权利
对您上传、发布或提交到服务任何部分的内容，您保留所有精神权利，包括完整性和归属的权利。 但您对 GitHub 放弃这些权利并且同意不宣称这些权利，以便我们合理行使第 D.4 部分授予的权利，而没有任何其他目的。

在适用法律不能强制执行本协议的范围内，您授权 GitHub 无归属使用您的内容，并在必要时对您的内容进行合理的修改，以便呈现网站和提供服务。

### E. 私有仓库
**短版本：** *您可以访问私有仓库。 我们将私有仓库的内容视为机密， 而且我们仅出于支持的原因、经您同意或出于安全的需要而访问它们。*

#### 1. 私有仓库的控制
某些帐户可能有私有仓库，允许用户控制对内容的访问。

#### 2. 私有仓库的保密
GitHub 将私有仓库的内容视为您的机密。 GitHub 将保护私有仓库的内容，防止受未授权的使用和访问，在披露时就像处理我们自己性质类似的机密信息一样，在任何情况下都不低于合理的谨慎程度。

#### 3. 访问
GitHub 人员仅在以下情况下才可访问您私有仓库的内容：
- 出于支持原因，并征得您的同意和确认。 如果 GitHub 基于支持原因而访问私有仓库，仅在所有者同意并确认后才访问。
- 当出于安全原因而需要访问时，包括为保持 GitHub 系统和服务的持续保密性、完整性、可用性和弹性而需要访问时。

您可选择对您私有仓库启用其他访问权限。 例如：
- 例如，您可向不同的 GitHub 服务或功能授予对私有仓库中您的内容的额外访问权限。 这些权限可能因服务或功能而异，但 GitHub 将继续将您的私有仓库内容视为机密。 如果这些服务或功能除了提供 GitHub 服务所需的权限之前，还需要其他权限，我们将会说明这些权限。

#### 4. 排除
如果我们有理由相信私有仓库的内容违反法律或本协议的条款，则我们有权利访问、检查和删除该内容。 此外，我们可能[按法律要求](/github/site-policy/github-privacy-statement#for-legal-disclosure)披露您的私有仓库的内容。

### F. 版权侵权和 DMCA 政策
如果您认为我们网站上的内容侵犯了您的版权， 请按照我们的[数字千禧年版权法政策](/articles/dmca-takedown-policy/)联系我们。 如果您是版权所有者并且您认为 GitHub 上的内容侵犯了您的权利，请通过[我们便利的 DMCA 表](https://github.com/contact/dmca)联系我们，或发送电子邮件到 copyright@github.com。 发出虚假或无聊的撤销通知可能会产生法律后果。 在发送撤销请求之前，您必须考虑合法用途，如公平使用和许可使用。

我们将终止此政策[反复违反者](/articles/dmca-takedown-policy/#e-repeated-infringement)的帐户。

### G. 知识产权通告
**短版本：** *我们拥有服务和我们的所有内容。 为便于您使用我们的内容，我们向您授予某些权限，但你只能以我们允许的方式使用我们的内容。*

#### 1. GitHub 对内容的权利
GitHub 和我们的许可人、供应商、代理和/或我们的内容提供者保留对与网站和服务所有知识产权的所有权。 我们保留本协议或法律未明确授予您的所有权利。 网站和服务外观的版权归 © GitHub, Inc. 所有。 未经 GitHub 明确的书面许可，您不得重复、复制或重复使用 HTML/CSS、Javascript 或者可视设计元素或概念的任何部分。

#### 2. GitHub 商标和徽标
如果您想要使用 GitHub 的商标，必须遵循我们所有的商标指南，包括我们徽标页面 https://github.com/logos 上的指南。

#### 3. GitHub 政策的许可
本协议的许可采用[知识共享零许可](https://creativecommons.org/publicdomain/zero/1.0/)原则。 更多信息请参阅我们的[站点政策仓库](https://github.com/github/site-policy#license)。

### H. API 条款
**短版本：** *在使用 GitHub 的任何 API（应用程序提供商界面）时，您同意这些服务条款以及本 H 部分，包括通过第三方产品使用 API 访问GitHub。*

滥用或过于频繁地通过 API 请求 GitHub 可能导致暂时或永久中止您的帐户访问 API。 GitHub 将单方面决定是否滥用或过度使用 API。 在暂停帐户之前，我们采取合理的努力通过电子邮件警告您。

您不能分享超过 GitHub 比率限制的 API 令牌。

您不能使用 API 从 GitHub 下载数据或内容用于垃圾邮件，包括出售 GitHub 用户的个人信息，如招募者、猎头和招聘网站。

GitHub API 的所有使用都必须遵守这些服务条款和 [GitHub 隐私声明](https://github.com/site/privacy)。

GitHub 可为需要高通量访问或者会导致 GitHub 服务转售的访问的用户提供基于订阅的 API 访问。

### I. GitHub 附加产品条款
**短版本：** *您需要按照 GitHub 不同功能和产品的特定条款和条件，并且在同意本协议时也同意补充条款和条件。*

某些服务功能可能受 GitHub 附加产品条款中规定的该功能或产品特定附加条款的约束。 访问或使用服务即表示您也同意 [GitHub 附加产品条款](/github/site-policy/github-additional-product-terms)。

### J. 测试版预览
**短版本：** *测试版预览可能不受支持或可能随时更改，您可以通过那些在程序未公开时必须保密的程序接收机密信息，我们希望获得您的反馈，以改进我们的试用版预览。*

#### 1. 可能会变动

测试版预览不受支持，可能随时更改而不另行通知。 此外，测试版预览不像服务一样采取同样的安全措施和审核。 **使用测试版预览的风险您自行承担。**

#### 2. 保密

作为测试版预览的用户，您可能有权访问在世界上其他地方无法获取的特殊信息。 鉴于此类信息的敏感性，确保您对此类信息保密对我们而言非常重要。

**保密义务。**您同意，我们向您提供的任何非公开信息，例如关于私有测试版预览的信息，均应视为 GitHub 的机密信息（统称为“机密信息”），无论其是否被标记或标识为机密信息。 您同意，只将此类机密信息用于测试和评估预测试版预览的目的（“目的”），而不得用于任何其他用途。 您应该像对待自己的机密信息一样保护我们的机密信息，并且至少要采取合理的预防措施，以防止未经授权使用、披露、发布或传播我们的机密信息。 您承诺不向任何第三方披露、公布或传播任何机密信息，除非我们不禁止或限制此种披露（例如，您可能参与了 GitHub 组建的关于私人测试版预览功能的小组讨论）。

**例外。**机密信息不包括如下信息：(a) 不是因为您违反本协议的行为或不作为而变得公开的信息（例如当私人测试版预览变成公开测试版预览时）；(b) 在我们向你披露之前您已知道；(c) 由您独立开发，且不违反对我们或任何第三方的任何保密义务；或 (d) 经 GitHub 许可披露。 如果法律要求您披露机密信息，则不视同违反本协定的条款，但要合理事先书面通知 GitHub，除非法律禁止事先通知。

#### 3. 反馈

我们一直在努力改进产品和服务，作为测试版预览的用户，您的反馈将有助于我们的改进。 如果您选择提供关于我们产品或服务的任何想法、知识、算法、代码贡献、意见、增强要求、建议或任何其他反馈（统称为“反馈”），则表示您确认并同意，GitHub 将对反馈拥有免版税、全部付清、全球范围、可转让、可再许可、不可撤销且永久性的许可，有权实施、使用、修改及商业利用反馈和 /或将反馈纳入我们的产品、服务和文档中。

### K. 付款
**短版本：** *您负责与您使用 GitHub 相关的任何费用。 我们有责任向您明确和准确地告知这些费用，如果这些价格发生变化，会提前让您知道。*

#### 1. 定价
我们的定价和付款条件发布于 [github.com/price](https://github.com/pricing)。 如果您同意订阅价格，在付款期限内将保持这个价格；但在付款期结束时价格可能会有变化。

#### 2. 升级、降级和更改
- 当您从免费计划升级到任何付款计划时，我们会立即对您计费。
- 如果您从月度结算方案改为年度结算方案，GitHub 将在下一个月度结算日期向您收取全年费用。
- 如果您升级到更高的服务水平，我们将立即按升级的计划对您计费。
- 您可随时通过[选择计划选项](https://github.com/pricing)或进入[计费设置](https://github.com/settings/billing)更改您的服务水平。 如果您选择降级您的帐户，可能会失去对您帐户的内容、功能或容量的访问权限。 请参阅我们关于[取消](#l-cancellation-and-termination)的部分以获取该内容的副本。

#### 3. 计费时间表；无退款
**基于计划的付款** 对于月度或年度付款计划，服务分别按月或年预先开具帐单，不可退款。 对于只使用部分服务、降级使用或未使用的月数，将不予退款，也没有积分补偿；但服务将在已付费的计费周期内保持有效。 为了平等对待每一个人，将不会有例外情况。

**基于使用情况的计费** 一些服务功能根据使用情况计费。 这些服务功能的数量有限，可能包含在您的限期计划中，无需额外收费。 如果您选择购买超出计划所含数量的付费服务功能，则根据您上月的实际使用情况支付这些服务功能。 这些购买的每月费用将定期收取。 详情请参阅 [GitHub 附加产品条款](/github/site-policy/github-additional-product-terms)。

**发票** 对于开发票的用户，用户同意以美元全额预付费用，没有任何形式的扣减或抵销。 Dollars. 用户必须在 GitHub 发票日期的三十 (30) 天内支付费用。 除本协定另有规定外，根据本协议应付的金额不可退款。 如果用户未及时支付任何费用，GitHub 有权寻求法律或公平裁决的任何行动，并且 (i) 以每月 1.0% 或法律允许的最高利率（取较小者）对逾期金额收取利息，并收取所有恢复费用，以及 (ii) 终止适用的订单。 用户独自负责本协议造成或与之相关的所有税、费、关税和政府评估（基于 GitHub 净收入的税除外）。

#### 4. 授权
同意这些条款即表示您许可我们从您备案的信用卡、PayPal 帐户或您授权给 GitHub 的其他已批准付款方式扣费。

#### 5. 付款责任
您负责与您使用服务相关的所有费用，包括税款。 使用服务即表示您同意向 GitHub 支付与您使用服务有关的任何费用。  如有争议，请联系 [GitHub 支持](https://support.github.com/contact)。 您负责向我们提供付费帐户的有效付款方式。 免费帐户无需提供付款信息。

### L. 取消和终止
**短版本：** *您可随时关闭您的帐户。 如果您关闭帐户，我们将负责任地处理您的信息。*

#### 1. 帐户取消
您有责任通过 GitHub 适当取消您的帐户。 您可以进入屏幕顶部全球导航栏的 Settings（设置）[随时取消您的帐户](/articles/how-do-i-cancel-my-account/)。 Account（帐户）屏幕提供了一个简单、没有问题的取消链接。 我们无法通过回复电子邮件或电话申请来取消帐户。

#### 2. 取消后
我们将根据需要保留并使用您的信息，以履行我们的法律义务、解决争端和执行我们的协议，但是除非法律要求，否则 我们将在取消或终止后 90 天内删除您的全部个人资料和仓库的内容（虽然有些信息可能保留在加密的备份中）。 这些信息在您的帐户取消后无法恢复。

我们不会删除您已贡献到其他用户的仓库或者该用户已复刻的内容。

在帐户取消、终止或降级后，我们将应要求作出合理努力，向帐户所有者提供一份合法、非侵权帐户内容的副本。 您必须在取消、终止或降级后 90 天内提出此请求。

#### 3. GitHub 可能终止
GitHub 有权在任何时候暂停或终止您对网站全部或任何部分的访问，无论有无理由或有无通知，均立即生效。 GitHub 保留随时以任何理由拒绝提供服务的权利。

#### 4. 存续
本协议在终止时性质上应存续的所有条款都*将*在终止时存续，包括但不限于所有权条款、担保免责声明、赔偿和责任限制。

### M. 与 GitHub 的通信
**短版本：** *我们使用电子邮件和其他电子方式与用户保持联系。*

#### 1. 需要电子通信
出于合同目的，您 (1) 同意通过您提交的电子邮件地址或通过服务从我们接收电子形式的通信；和 (2) 同意我们以电子形式提供的所有服务条款、协议、通知、披露和其他通信满足任何法律要求（如果以书面形式提供的这些通信满足法律要求）。 本部分不影响您不可放弃的权利。

#### 2. 给 GitHub 的法律通知必须是书面的
在合同或者任何法律或条例要求向 GitHub 发出通知的任何情况下，通过电子邮件或 GitHub Support 的邮件系统进行的通信不构成向 GitHub 或其高管、员工、代理或代表发出的法律通知。 给 GitHub 的法律通知必须是书面的，并且[提供给 GitHub 的法律代理](/articles/guidelines-for-legal-requests-of-user-data/#submitting-requests)。

#### 3. 无电话支持
GitHub 仅通过电子邮件、服务中通信和电子信息提供支持。 我们不提供电话支持。

### N. 免责声明
**短版本：** *我们按原样提供服务，对此服务我们不作任何承诺或保证。 请仔细阅读本节内容；您应该理解要求。*

GitHub 按“原样”和“可获得性”提供网站和服务，不作任何形式的保证。 不限于此，关于网站和服务，我们明确否认所有保证，无论是明示、暗示还是法定保证，包括但不限于任何适销性、特定目的适用性、权利、安全性、准确性和非侵权。

GitHub 不保证服务将满足您的要求；服务不中断、及时、安全或无错；通过服务提供的信息准确、可靠或正确；任何缺陷或错误将得到更正；服务在任何特定时间或地点可用；服务没有病毒或其他有害成分。 对于因您下载和/或使用从服务获取的文件、信息、内容或其他材料而造成的任何损失风险，GitHub 概不负责。

### O. 责任限制
**短版本：** *对因您使用或不能使用服务或本协议下产生的损害或损失，我们不承担责任。 请仔细阅读本节内容；它限制了我们对您的义务。*

您理解并同意，对于以下原因产生的任何利润、使用、声誉或数据损失，或者任何偶然、间接、特殊、后果性或惩戒性损害，我们对您或任何第三方不承担任何责任：

- 使用、披露或显示您的用户生成内容；
- 您使用或无法使用服务；
- 服务的任何修改、价格变动、暂停或终止；
- 一般服务或提供服务的软件或系统；
- 对您的传输或数据的未授权访问或更改；
- 任何第三方对服务的声明或行为；
- 您通过使用服务输入或接收的任何其他用户交互；或
- 与服务有关的任何其他事项。

无论我们是否被告知此类损害的可能性，即使本协议规定的补救措施未能达到其基本目的，我们的责任都是有限的。 对于因超出我们合理控制范围的事项而导致的任何故障或延误，我们概不负责。

### P. 免除和赔偿
**短版本：** *您负责您对服务的使用。 如果您伤害别人或与别人发生争端，我们不会涉入。*

如果您与一个或多个产品用户有争议，对于此类争议引起的或以任何方式与之相关的、已知或未知的、任何类型或性质的任何和所有索赔、要求和损害赔偿（实际和后果性的），您同意免除 GitHub 的任何赔偿责任。

您同意，对于因您使用网站和服务，包括但不限于您违反本协议，而引起的任何和所有索赔、责任和费用，您负责赔偿我们、为我们抗辩并保护我们免受任何损害，但 GitHub 应 (1) 及时向您提供有关索赔、要求、诉讼或程序的书面通知；(2) 赋予您对索赔、要求、诉讼或程序进行抗辩和解决的唯一控制权（但您对任何索赔、要求、诉讼或程序的解决方案必须无条件免除 GitHub 的所有责任）；以及 (3) 向您提供所有合理的协助，但费用由您承担。

### Q. 这些条款的变更
**短版本：** *我们希望用户了解我们条款的重要变化，但有些更改并不是那么重要——我们不想每次修复错误时都打扰您。 因此，虽然我们可以随时修改本协议，但我们会向用户通知任何影响您权利的更改，并给您时间进行调整。*

我们有权利独自裁量随时修订这些服务条款，并在发生任何此类修正时更新这些服务条款。 本协议如有重大更改，如价格变动，我们将至少在更改生效前 30 天在网站上发布通知来告知用户。 对于非重大修改，您继续使用网站即表示同意我们对这些服务条款的修订。 在我们的[站点政策](https://github.com/github/site-policy)仓库中可查看这些条款的所有变更。

我们保留随时和不时修改或停用（临时或永久）网站或其任何部分的权利，可能通知，也可能不通知。

### R. 其他

#### 1. 管辖法律
除非适用法律另有规定，否则，您与 GitHub 之间的本协议以及对网站或服务的任何访问或使用，均受美国联邦法律和加利福尼亚州法律的管辖，不考虑冲突法原则。 您和 GitHub 均同意，位于加利福尼亚州旧金山县的法院具有专属管辖权和审判权。

#### 2. 不可转让
GitHub 可随时将这些服务条款和/或 [GitHub 隐私声明](https://github.com/site/privacy)全部或部分转让或委托给任何个人或实体，可以征求或不征求您的同意，包括 D.4 部分的许可授予。 未经我们事先书面同意，您不得转让或委托服务条款或隐私声明下的任何权利或义务，任何未经授权的转让和授权都是无效的。

#### 3. 章节标题和摘要
在整个本协议中，每一节都包括下列条款和条件的标题和简短摘要。 这些章节的标题和简短摘要不具有法律约束力。

#### 4. 可分割性、非弃权和继续有效
如果本协议的任何部分被认为无效或不可执行，则该部分将被解释为反映缔约方的初衷。 其余部分仍具有完全效力。 GitHub 方面未执行本协议的任何规定，并不构成我们放弃执行该规定的权利。 我们在本协议下的权利在本协议终止后仍然有效。

#### 5. 修订；完整协议
本协议只能通过 GitHub 授权代表签署的书面修订加以修改，或 GitHub 根据 [Q. 这些条款的变更](#q-changes-to-these-terms)发布的修订版予以修改。 这些服务条款以及 GitHub 隐私声明，构成了您与我们之间的完整、专有协议声明。 本协议取代任何口头或书面的提议或事先协议，以及您与 GitHub 之间关于这些条款所述主题的任何其他通信，包括任何保密或非披露协议。

#### 6. 问题
对服务条款有疑问吗？ [请联系我们](https://support.github.com/contact)。
