---
title: GitHub 敏感数据删除政策
redirect_from:
  - /articles/github-sensitive-data-removal-policy
versions:
  free-pro-team: '*'
---

如果您认为 GitHub 上的内容侵犯了您拥有的有效版权，请参阅我们的 [DMCA 删除政策](/articles/dmca-takedown-policy/)和[提交 DMCA 删除通知的指南](/articles/guide-to-submitting-a-dmca-takedown-notice/)。 我们大部分删除行动都基于 DMCA 通知和删除流程。

但是，我们知道，用户有时可能无意或有意地在 GitHub 上发布涉及安全的敏感内容。 我们提供敏感数据删除流程，以便在 DMCA 流程不适用的某些特殊情况下删除这些敏感数据，例如您面临密码暴露带来的安全风险；您需要删除特定内容，但您没有版权，或者该内容不受版权保护。 本指南说明了 GitHub 需要您提供哪些信息，才能处理从仓库中删除敏感数据的请求。

### 什么是敏感数据？

就本文档而言，“敏感数据”是指符合以下条件的内容：(i) 应该保密，*并且* (ii) 一旦公开，会对您或您的组织造成特定安全风险。

#### 敏感数据删除请求适用于：
- 可访问您组织的服务器、网络或域的访问凭据，例如用户名与密码组合、访问令牌或其他敏感密钥。
- 可代表您访问第三方的 AWS 令牌和其他类似访问凭据。 您必须能够证明该令牌确实属于您。
- 对组织构成特定安全风险的文档（例如网络图）。 内部服务器名称、IP 地址和 URL 本身不够敏感；您必须能够证明内部服务器名称在特定文件或代码段中的使用构成了安全威胁。

#### 敏感数据删除请求_不_适用于：
-  请求删除可能侵犯您或您组织之版权的内容。 如果您对 GitHub 如何处理版权相关事项有疑问，或者要举报涉嫌侵权的内容，请参阅我们的 [DMCA 删除政策](/articles/dmca-takedown-policy/)。 敏感数据删除流程一般不会删除整个文件或仓库，而只是删除这些文件中的特定敏感数据部分。 但可能存在文件中全是敏感信息的情况，在这种情况下，您必须证明删除该文件是避免安全风险的合理措施，并且这可能会增加处理请求所需的时间。
- 商标纠纷。 如果您对 GitHub 如何处理商标相关事项有疑问，或者要举报包含您组织的商标或服务标志的内容，请查看我们的[商标政策](/articles/github-trademark-policy/)。
- 在 GitHub 上的文件中仅提及您公司的身份、名称、品牌、域名或对您公司的其他引用。 您必须能够阐明为什么使用您公司的身份会威胁到您公司的安全状况，我们才会根据本政策采取行动。
- 隐私投诉。 如果您担心自己的隐私，或者就隐私问题代表您的员工与我们联系 - 例如，有人发布了你们的私密电子邮件地址或其他个人信息 - 请通过[我们的隐私联系表](https://github.com/contact/privacy)联系我们。
- 整个文件或仓库并不构成特定的安全风险，但是您认为在其他方面令人反感。
- 受我们的[社区指导方针](/articles/github-community-guidelines/)约束的内容，例如恶意软件或万能工具。 如果您对我们的社区指导方针有疑问，或者认为 GitHub 上的内容涉嫌违反我们的指导方针，您可以使用 {% data variables.contact.report_content %} 联系我们。

### 投诉须知

**先问清。**向我们发送删除数据请求之前尝试直接联系用户，是一个良好的开端。 他们可能在其公开的个人资料页面上或者仓库的自述文件或支持文件中列出了联系信息，您也可以通过在仓库中创建议题或拉取请求，与他们取得联系。 这不是强制要求，但值得赞赏。

**不要使用自动程序。**应该让训练有素的专业人员来评估您发送的每个请求中的事实。 如果您将工作外包给第三方，请务必了解他们的运作方式，确保他们不使用自动程序来批量提交投诉。 这些投诉通常包含不构成任何安全威胁的数据，并且不提供充分的说明，即使该投诉有效，也需要来回确认，耗时费力。

**发送正确的请求。**我们的敏感数据删除流程是仅针对高风险内容的特殊服务。 我们不能使用此流程来删除其他类型的内容，例如涉嫌侵权的内容，我们也不能在处理敏感数据删除请求的同时处理任何其他类型的删除请求。 如果您将敏感数据删除请求与任何涉嫌侵权内容的删除请求分开发送，我们将能够更快地帮助您。 如果您不确定自己的请求是仅涉及敏感数据，还是同时涉及了其他法律问题，请咨询法律顾问。

**处理时间。**尽管我们会尽快处理敏感数据删除请求，但由于我们要处理的请求数量很大，因此审查您的请求可能需要一些时间。 多次请求，或从不同的联系点发送多个请求，可能会导致延迟。

### 此流程实际上是如何运作的？

1. **投诉人调查。**请求方自行负责调查并提供[我们所需的详细信息](#your-request-must-include)，最重要的是解释数据如何构成安全风险。 GitHub 不能代表任何个人或组织搜索或初步确定敏感数据。

2. **投诉人发送敏感数据删除请求。**进行调查后，投诉人编写并向 GitHub [发送敏感数据删除请求](#sending-a-sensitive-data-removal-request)。 如果请求不够详细，导致不足以证明存在安全风险和指引 GitHub 找到数据，我们将回复您并要求提供更多信息。

3. **GitHub 要求用户进行更改。**在大多数情况下，我们会联系创建仓库的用户，给他们删除或修改投诉中指出的敏感数据或对投诉提出异议的机会。

4. **用户更改后通知 GitHub。**如果用户选择进行指定的更改，则必须规定的时间内告知我们。 如果没有，我们将禁用仓库。 如果用户通知我们已进行更改，我们将进行核实然后通知投诉人。

  或

5. **用户可提出异议。**如果用户认为所涉内容不是受本政策约束的敏感数据，可以提出异议。 如果他们提出异议，我们通常会让投诉人联系用户，并在合理的范围内直接与他们一起解决问题。

6. **投诉人审查更改。**如果用户进行了更改，则投诉人必须进行审查。 如果认为改动不够，投诉人必须向 GitHub 详细说明原因。 GitHub 可能会禁用仓库，或者再给用户一次更改的机会。

7. **用户可申请再次更改机会。**如果用户错过了删除通知指定的敏感数据的机会，我们可能应其申请再提供 1 个工作日的更改时间。 在这种情况下，GitHub 会通知投诉人。

#### 复刻呢？ （或如何处理复刻？）
GitHub 的最佳功能之一是用户能够“复刻”彼此的仓库。 这意味着什么？ 从本质上讲，这意味着用户可以将 GitHub 上的项目复制到自己的仓库中。 在许可或法律允许的情况下，用户可以对复刻进行更改，然后将其推送到主项目或只保留为自己的项目变体。 每个此类副本都是原仓库的[复刻](/articles/github-glossary/#fork)，或者说原仓库也可以称为复刻的“父仓库”。

GitHub will not automatically disable forks when disabling a parent repository. 这是因为复刻属于不同的用户，并且可能进行了重大更改。 GitHub 不会对复刻进行任何独立调查。 我们希望敏感数据删除请求发送者进行这种调查，如果他们认为复刻也包含敏感数据，则应在其请求中明确包括这些复刻。

### 发送敏感数据删除请求

鉴于 GitHub 托管内容的类型（主要是软件代码）以及管理内容的方式（使用 Git），我们需要投诉内容尽可能具体。 为了核实用户是否完全删除了被举报的敏感数据，我们需要确切了解要审查的位置。

这些指南旨在尽可能简单明了地处理敏感数据删除请求。

#### 您的请求必须包括：

1. 每个包含敏感数据的文件的可点击有效链接。 （请注意，我们不会处理搜索结果、示例或屏幕截图。）
2. 每个文件中包含敏感数据的具体行号。
3. 简要说明您标识的每个条目如何对您或您的组织构成安全风险。 ***不仅要指出敏感数据，还要解释这些数据如何构成安全风险，这非常重要***。
4. 如果您是代表面临安全风险之组织行事的第三方，请附上声明，表明您具有代表该组织行事的合法权利。
5. 可选：如果您的请求非常紧迫，请告知我们并说明原因。 我们会尽快响应所有敏感数据删除请求。 但是，如果您的请求在时间上特别紧迫，例如最近的凭据暴露，请说明原因。

### 如果提交请求

您可以通过我们的[联系表格](https://support.github.com/contact)提交删除敏感数据的申请。 请在邮件正文中包含请求的纯文本版本。 以附件形式发送请求可能导致处理延迟。

### 异议

如果您收到我们的敏感数据删除请求，可通过回复我们的电子邮件提出异议，请尽可能详细地说明为什么您认为所涉内容不是受本政策约束的敏感数据。
