---
title: GitHub 隐私声明
redirect_from:
  - /隐私/
  - /privacy-policy/
  - /privacy-statement/
  - /github-privacy-policy/
  - /articles/github-privacy-policy/
  - /articles/github-privacy-statement/
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

感谢您将自己的源代码、项目和个人信息交托给 GitHub Inc. （“GitHub”、“我们”）。 保管您的私人信息是一项重大责任，我们希望您了解我们的处理方式。

所有大写术语采用 [GitHub 服务条款](/github/site-policy/github-terms-of-service)中的定义，除非本文另有说明。


### 精简版

We use your personal information as this Privacy Statement describes. No matter where you are, where you live, or what your citizenship is, we provide the same high standard of privacy protection to all our users around the world, regardless of their country of origin or location.

当然，下面的精简版和摘要无法面面俱到，因此请继续往下阅读以了解详情。

### 摘要

| 节                                                                             | 说明                                                                                                                                                                                                                                   |
| ----------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [GitHub 收集哪些信息](#what-information-github-collects)                            | GitHub 直接从您的注册、付款、交易和用户个人资料中收集信息。 我们还自动从您的使用信息、cookie 和类似技术以及设备信息中收集，但在必要时会征得您的同意。 GitHub 可能还会从第三方收集用户个人信息。 我们只收集极少量的必要个人信息，除非您自己选择提供更多信息。                                                                                           |
| [GitHub_不_收集哪些信息](#what-information-github-does-not-collect)                  | 我们不会有意收集 13 岁以下儿童的信息，也不会收集[敏感个人信息](https://gdpr-info.eu/art-9-gdpr/)。                                                                                                                                                                |
| [GitHub 如何使用您的信息](#how-github-uses-your-information)                          | In this section, we describe the ways in which we use your information, including to provide you the Service, to communicate with you, for security and compliance purposes, and to improve our Service. 我们还介绍了在法律要求的情况下处理个人信息的法律依据。 |
| [我们如何分享所收集的信息](#how-we-share-the-information-we-collect)                      | 在以下情况下，我们可能会与第三方分享您的信息：经您同意、与我们的服务提供商分享、出于安全目的、为履行我们的法律义务，或者公司实体或业务单位的控制权发生变更或出售。 我们不会出售您的个人信息，也不会在 GitHub 上发布广告。 您可以查看可访问您信息的服务提供商列表。                                                                                               |
| [其他重要信息](#other-important-information)                                        | 我们针对 GitHub 上的仓库内容、公共信息和组织而提供的附加说明。                                                                                                                                                                                                  |
| [其他服务](#additional-services)                                                  | 我们提供有关其他服务产品的信息，包括第三方应用程序、GitHub Pages 和 GitHub 应用程序。                                                                                                                                                                                |
| [您如何访问和控制我们收集的信息](#how-you-can-access-and-control-the-information-we-collect) | 我们为您提供访问、更改或删除个人信息的途径。                                                                                                                                                                                                               |
| [我们使用 cookie 和跟踪技术](#our-use-of-cookies-and-tracking)                         | 我们使用 cookie 支持网站的整体功能，并在网站的某些部分使用少量的跟踪和分析服务。 我们提供了一个非常透明地说明此技术的网页。 请参阅本节了解更多信息。                                                                                                                                                      |
| [GitHub 如何保护您的信息](#how-github-secures-your-information)                       | 我们采取所有合理必要的措施，保护 GitHub 上个人信息的机密性、完整性和可用性，并保护我们服务器的弹性。                                                                                                                                                                               |
| [GitHub 的全球隐私实践](#githubs-global-privacy-practices)                           | We provide the same high standard of privacy protection to all our users around the world.                                                                                                                                           |
| [我们如何与您交流](#how-we-communicate-with-you)                                      | 我们通过电子邮件与您通信。 您可以在帐户设置中或通过联系我们来控制我们与您联系的方式。                                                                                                                                                                                          |
| [解决投诉](#resolving-complaints)                                                 | In the unlikely event that we are unable to resolve a privacy concern quickly and thoroughly, we provide a path of dispute resolution.                                                                                               |
| [隐私声明的变更](#changes-to-our-privacy-statement)                                  | 如果本隐私声明发生重大变更，我们会在任何此类变更生效之前 30 天通知您。 您也可以在我们的站点政策仓库中跟踪变更。                                                                                                                                                                           |
| [许可](#license)                                                                | 本隐私声明的许可采用[知识共享零许可](https://creativecommons.org/publicdomain/zero/1.0/)原则。                                                                                                                                                           |
| [联系 GitHub](#contacting-github)                                               | 如果您对我们的隐私声明有疑问，请随时联系我们。                                                                                                                                                                                                              |
| [翻译](#translations)                                                           | 我们提供本隐私声明的一些翻译版本的链接。                                                                                                                                                                                                                 |

## GitHub 隐私声明

### GitHub 收集哪些信息

**用户个人信息**是关于我们用户的任何个人信息，这些信息可以单独或结合其他信息来识别他们的身份，或者以其他方式与他们合理关联。 用户名和密码、电子邮件地址、真实姓名、互联网协议 (IP) 地址和照片等信息是典型的“用户个人信息”。

用户个人信息不包括汇总的非个人识别信息，即不能识别用户身份或与他们没有合理关联的信息。 我们可能会将此类汇总的非个人识别信息用于研究目的，以及运营、分析、改善和优化我们的网站及服务。

#### 用户直接向 GitHub 提供的信息

##### Registration information
创建帐户时，我们需要您提供一些基本信息。 创建用户名和密码时，我们会要求您提供有效的电子邮件地址。

##### Payment information
如果您注册我们的付费帐户、通过 GitHub 赞助计划汇款或在 GitHub Marketplace 上购买应用程序，我们将收集您的全名、地址和信用卡信息或 PayPal 信息。 请注意，GitHub 不会处理或存储您的信用卡信息或 PayPal 信息，但我们的第三方付款处理商会这样做。

如果您在 [GitHub Marketplace](https://github.com/marketplace) 上列出并销售应用程序，我们需要您的银行信息。 If you raise funds through the [GitHub Sponsors Program](https://github.com/sponsors), we require some [additional information](/github/supporting-the-open-source-community-with-github-sponsors/becoming-a-sponsored-developer#submitting-your-bank-information) through the registration process for you to participate in and receive funds through those services and for compliance purposes.

##### Profile information
您可以选择在帐户个人资料中向我们提供更多信息，例如您的全名、头像等，可包括照片、简历、地理位置、公司和第三方网站的 URL。 此类信息可能包括用户个人信息。 请注意，您的个人资料信息可能对我们服务的其他用户显示。

#### GitHub 在您使用服务时自动收集的信息

##### Transactional information
如果您拥有我们的付费帐户、在 [GitHub Marketplace](https://github.com/marketplace) 上出售上架的应用程序或通过 [GitHub 赞助计划](https://github.com/sponsors)筹集资金，我们会自动收集有关您在服务中的交易的某些信息，例如日期、时间和收取金额。

##### Usage information
如果您访问我们的服务或网站，我们将与大多数服务商一样自动收集一些基本信息，但在必要时会征得您的同意。 这包括有关您如何使用服务的信息，例如您查看的页面、推荐站点、您的 IP 地址和会话信息，以及每个请求的日期和时间。 这是我们针对网站的每个访客收集的信息，无论他们是否有帐户。 此类信息可能包括用户个人信息。

##### Cookies and similar technologies information
如下所述，在必要时会征得您的同意，我们通过 cookie 和类似技术自动收集信息（例如 cookie ID 和设置）以保持您的登录状态、记住您的首选项以及识别您和您的设备 。

##### Device information
我们可能会收集有关您设备的某些信息，例如其 IP 地址、浏览器或客户端应用程序信息、语言首选项、操作系统和应用程序版本、设备类型和 ID 以及设备型号和制造商。 此类信息可能包括用户个人信息。

#### 从第三方收集信息

GitHub 可能会从第三方收集用户个人信息。 例如，如果您报名参加培训或从我们的供应商、合作伙伴或附属公司获取有关 GitHub 的信息，就可能会发生这种情况。 GitHub 不从第三方数据中间商购买用户个人信息。

### GitHub 不收集哪些信息

我们不会有意收集**[敏感个人信息](https://gdpr-info.eu/art-9-gdpr/)**，例如显示种族或民族、政见、宗教或信仰或工会成员资格的个人数据；用于唯一识别自然人的遗传数据或生物数据处理信息；有关健康的数据或涉及自然人的性生活或性取向的数据。 如果您选择在我们的服务器上存储任何敏感个人信息，则您有责任遵守有关该数据的任何法规管制。

13 岁以下的孩子不得在 GitHub 上拥有帐户。 GitHub 不会有意收集 13 岁以下孩子的信息，也没有专门为他们定制任何内容。 如果我们得知或有理由怀疑您是 13 岁以下的用户，我们不得不关闭您的帐户。 我们并不想阻止您学习代码，但这是规则。 有关帐户终止的信息，请参阅我们的[服务条款](/github/site-policy/github-terms-of-service)。 不同国家/地区可能有不同的最低年龄限制，如果您未达到您所在国家/地区提供数据收集许可的最低年龄，则不得在 GitHub 上拥有帐户。

我们不会有意收集**存储在您的仓库中**或其他自由内容输入中的用户个人信息。 用户仓库中的任何个人信息由仓库所有者负责。

### GitHub 如何使用您的信息

- 我们可能将您的信息用于以下目的：
- 我们使用您的[注册信息](#registration-information)创建您的帐户并为您提供服务。
- 我们使用您的[付款信息](#payment-information)为您提供付费帐户服务、Marketplace 服务、赞助计划或您要求的任何其他 GitHub 付费服务。
- 我们使用您的用户个人信息，特别是您的用户名，在 GitHub 上识别您的身份。
- 我们使用您的[个人资料信息](#profile-information)填写您的帐户个人资料，并根据您的要求将其分享给其他用户。
- 我们使用您的电子邮件地址与您通信，但需要征得您的同意，**并且以您的同意为前提**。 请参阅我们的[电子邮件通信](#how-we-communicate-with-you)部分了解更多信息。
- 我们使用用户个人信息响应支持请求。
- 我们使用用户个人信息和其他数据为您提供建议，例如推荐您可能想要关注或贡献的项目。 我们根据您在 GitHub 上的公开行为（例如您加星标的项目）确定您的编码兴趣，然后向您推荐类似的项目。 这些推荐是自动生成的，但对您的权利没有任何法律影响。
- 我们可能使用用户个人信息邀请您参与调查、测试版程序或其他研究项目，但在必要时会征得您的同意。
- 我们使用[使用信息](#usage-information)和[设备信息](#device-information)来更好地了解用户如何使用 GitHub 并改善我们的网站和服务。
- 出于安全目的，或者为了调查可能的欺诈行为或企图损害 GitHub 或我们用户的行为时，我们可能会使用您的用户个人信息。
- 我们可能会使用您的用户个人信息来履行我们的法律义务、保护我们的知识产权和执行我们的[服务条款](/github/site-policy/github-terms-of-service)。
- 我们对用户个人信息的使用范围仅限于本隐私声明中列出的目的。 如果我们要将您的用户个人信息用于其他目的，则需要您的事先许可。 在您的[用户个人资料](https://github.com/settings/admin)中，始终可以查看我们拥有哪些信息、我们如何使用这些信息以及您授予了我们哪些权限。

#### 我们处理信息的法律依据

如果我们处理您的用户个人信息受某些国际法律（包括但不限于欧盟通用数据保护条例 (GDPR)）的约束，则 GitHub 必须告知您有关我们处理用户个人信息的法律依据。 GitHub 根据以下法律依据处理用户个人信息：

- 合同履行：
  * 您在创建 GitHub 帐户时，需要提供您的[注册信息](#registration-information)。 我们需要使用这些信息与您签订服务条款协议，并在履行合同的基础上处理这些信息。 我们还会根据其他法律依据处理您的用户名和电子邮件地址，如下所述。
  * 如果您拥有我们的付费帐户，我们会在履行合同的基础上收集和处理额外的[付款信息](#payment-information)。
  * 当您在 Marketplace 上买卖应用程序，或通过 GitHub 赞助计划收发资金时，我们会处理[付款信息](#payment-information)和其他元素，以便履行适用于这些服务的合同。
- 同意：
  * 在以下情况下，我们需要征得您的同意才能使用您的用户个人信息：您在[用户个人资料](https://github.com/settings/admin)中填写信息时；您决定参与 GitHub 培训、研究项目、测试版程序或调查时；以及用于营销目的（如果适用）时。 所有这些用户个人信息都是完全可选的，您可以随时访问、修改和删除它。 虽然不能完全删除您的电子邮件地址，但您可以将其设为私密。 您可以随时撤回同意。
- 合法利益：
  * 一般来说，我们处理用户个人信息的其他依据是维护我们的合法利益，例如，出于法律合规目的、安全目的，或为了保持 GitHub 系统、网站和服务的持续保密性、完整性、可用性和弹性。
- 如果要请求删除我们在您同意的基础上处理的数据，或者对我们处理个人信息的方式有异议，请使用我们的[隐私问题联系表](https://support.github.com/contact/privacy)。。

### 我们如何分享所收集的信息

我们在以下情况下可能会与第三方分享您的用户个人信息：

#### 经您同意
在告知您我们将分享哪些信息、与谁分享以及原因之后，如果您同意，我们将分享您的用户个人信息。 例如，如果您购买我们 Marketplace 上列出的应用程序，我们将分享您的用户名以便该应用程序开发者为您提供服务。 此外，您可以通过在 GitHub 上的操作来指示我们分享您的用户个人信息。 例如，如果您加入组织，则表明您愿意向组织所有者提供在组织访问日志中查看您的活动的权限。

#### 与服务提供商分享
我们会与有限数量的服务提供商分享用户个人信息，他们替我们处理这些信息以提供或改善我们的服务，并且通过签署数据保护协议或作出类似承诺，同意遵守与我们隐私声明类似的隐私限制。 我们的服务提供商履行付款处理、客户支持事件单、网络数据传输、安全及其他类似服务。 虽然 GitHub 在美国处理所有用户个人信息，但我们的服务提供商可能在美国或欧盟外部处理数据。 如果您想知道我们的服务提供商有哪些，请参阅我们关于[子处理商](/github/site-policy/github-subprocessors-and-cookies)的页面。

#### 出于安全目的
If you are a member of an Organization, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) associated with that Organization with an owner and/or administrator of the Organization, to the extent that such information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

#### 法律要求披露
为遵守法律程序和履行法律义务，GitHub 力求提高透明度。 如果法律强制或要求披露用户的信息，我们会尽合理努力通知该用户，除非法律或法院命令不允许我们通知，或者在极少数紧急情况下来不及通知。 GitHub 可能会根据有效传票、法院命令、搜查令或类似的政府命令，向执法机构披露我们收集的用户个人信息或其他信息，或者我们出于善意，认为这种披露是履行我们法律义务的必要行动，有助于保护我们、第三方或公众的财产或权利时，我们也会这样做。

有关我们为响应法律要求而披露的更多信息，请参阅我们的[用户数据法律要求指南](/github/site-policy/guidelines-for-legal-requests-of-user-data)。

#### 控制权变更或出售
如果我们参与公司实体或业务单位的合并、出售或收购，我们可能会分享用户个人信息。 如果发生任何此类所有权变更的情况，我们将确保根据条款保护用户个人信息的机密性，并且在传输您的任何用户个人信息之前在网站上或通过电子邮件通知您。 接收任何用户个人信息的组织必须遵守我们在隐私声明或服务条款中所作的任何承诺。

#### 汇总的非个人识别信息
我们会与他人分享某些汇总的非个人识别信息，包括我们用户使用 GitHub 的整体情况或用户对我们其他方面（例如我们的会议或活动）的反应。 例如，[我们可能会汇总 GitHub 上开源活动的统计信息](https://octoverse.github.com/)。

我们**不会**出于金钱或其他报酬而出售您的用户个人信息。

请注意：《2018 年加州消费者隐私法案》(“CCPA”) 要求企业在其隐私政策中声明，他们是否会披露个人信息以换取金钱或其他有价值的报酬。 While CCPA only covers California residents, we voluntarily extend its core rights for people to control their data to _all_ of our users, not just those who live in California. 您可以在[此处](/github/site-policy/githubs-notice-about-the-california-consumer-privacy-act)了解有关 CCPA 以及我们如何遵守它的更多信息。

### 其他重要信息

#### 仓库内容

GitHub 人员[不会访问私有仓库，除非](/github/site-policy/github-terms-of-service#e-private-repositories)出于安全原因，或者为了协助仓库所有者解决支持问题、保持服务的完整性或履行我们的法律义务而需要这样做。 However, while we do not generally search for content in your repositories, we may scan our servers and content to detect certain tokens or security signatures, known active malware, or other content known to violate our Terms, such as violent extremist or terrorist content or child exploitation imagery based on algorithmic fingerprinting techniques. 我们的服务条款提供了[更多详细信息](/github/site-policy/github-terms-of-service#e-private-repositories)。

如果您的仓库是公共仓库，则任何人都可以查看其内容。 如果您的公共仓库中含有私人、机密或[敏感个人信息](https://gdpr-info.eu/art-9-gdpr/)，例如电子邮件地址或密码，则该信息可能会被搜索引擎索引或被第三方使用。

更多信息请参阅[公共仓库中的用户个人信息](/github/site-policy/github-privacy-statement#public-information-on-github)。

#### GitHub 上的公共信息

GitHub 的许多服务和功能都是面向公众的。 如果您的内容是面向公众的，则第三方可能会按照我们的服务条款访问和使用它，例如查看您的个人资料或仓库，或者通过我们的 API 拉取数据。 我们不会出售您的内容；它是您的财产。 但是，我们会允许第三方（例如研究或存档组织）汇编面向公众的 GitHub 信息。 据悉，数据中间商等其他第三方也会搜刮 GitHub 和汇编数据。

与您的内容相关的用户个人信息可能被第三方收集在这些 GitHub 数据汇编中。 如果您不希望自己的用户个人信息出现在第三方的 GitHub 数据汇编中，请不要公开自己的用户个人信息，并确保在您的用户个人资料和 [Git 提交设置](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address)中[将您的电子邮件地址配置为私密](https://github.com/settings/emails)。 在当前版本中，用户的电子邮件地址默认设置为私密，但旧版 GitHub 的用户可能需要更新其设置。

如果您要汇编 GitHub 数据，则必须遵守我们有关[搜刮](/github/site-policy/github-acceptable-use-policies#5-scraping-and-api-usage-restrictions)和[隐私](/github/site-policy/github-acceptable-use-policies#6-privacy)的服务条款，并且只能出于我们用户授权的目的使用所收集的任何面向公众的用户个人信息。 例如，如果 GitHub 用户出于身份识别和归因的目的而将电子邮件地址设为公开，则您不得将该电子邮件地址用于商业广告。 我们希望您合理地保护从 GitHub 收集的任何用户个人信息，并且必须及时回应 GitHub 或 GitHub 用户的投诉以及删除和“别碰”要求。

同样，GitHub 上项目包含的公开用户个人信息可能在协作过程中被收集。 如果您要针对 GitHub 上的任何用户个人信息问题提出投诉，请参阅我们的[解决投诉](/github/site-policy/github-privacy-statement#resolving-complaints)部分。


#### 组织

您可以通过在 GitHub 上的操作来表明您愿意分享自己的用户个人信息。 如果您与组织协作或成为组织成员，则其帐户所有者可能会收到您的用户个人信息。 当您接受组织邀请时，您将被告知所有者可以看到的信息类型（更多信息请参阅[关于组织成员](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)）。 如果您接受含有[验证域](/github/setting-up-and-managing-organizations-and-teams/verifying-your-organizations-domain)的组织的邀请，则该组织的所有者将能够在该组织的验证域中查看您的完整电子邮件地址。

Please note, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) with the owner(s) of the Organization you are a member of, to the extent that your User Personal Information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

如果您与已同意[公司服务条款](/github/site-policy/github-corporate-terms-of-service)、数据保护附录 (DPA) 和本隐私声明的帐户进行协作或成为其成员，则对于您在该帐户中的活动，当本隐私声明与 DPA 之间发生任何冲突时，以 DPA 为准。

请联系帐户所有者，详细了解他们在组织中如何处理您的用户个人信息，以及您访问、更新、更改或删除存储在该帐户中的用户个人信息的方式。

### 其他服务

#### 第三方应用程序

您可以选择在自己的帐户中启用或添加第三方应用程序（称为“开发者产品”）。 这些开发者产品并非使用 GitHub 的必要条件。 我们会在您要求时（例如从 Marketplace 购买开发者产品）将您的用户个人信息分享给第三方；但是，对于您使用第三方开发者产品以及您选择与之分享的用户个人信息，您自行负责。 您可以查看我们的 [API 文档](/v3/users/)，以了解您使用自己的 GitHub 个人资料向开发者产品验证时会提供哪些信息。

#### GitHub Pages

如果您创建 GitHub Pages 网站，则您有责任发布隐私声明，准确说明您如何收集、使用和分享个人信息和其他访客信息，以及如何遵守适用的数据隐私法律、法规和条例。 请注意，GitHub 可能会从 GitHub Pages 网站的访客收集用户个人信息，包括访客 IP 地址的日志，以履行法律义务、维护网站和服务的安全性和完整性。

#### GitHub 应用程序

You can also add applications from GitHub, such as our Desktop app, our Atom application, or other application and account features, to your Account. 这些应用程序都有其各自的条款，并且可能收集不同类型的用户个人信息；但是，所有 GitHub 应用程序均受本隐私声明的约束，我们只收集必要的用户个人信息，并且仅用于您许可的目的。

### 您如何访问和控制我们收集的信息

如果您已经是 GitHub 用户，则可以通过[编辑用户个人资料](https://github.com/settings/profile)或联系 [GitHub 支持](https://support.github.com/contact)或 [GitHub 高级支持](https://enterprise.githubsupport.com/hc/en-us)，访问、更新、更改或删除您的基本用户个人资料信息。 您可以在个人资料中限制信息、保持更新个人信息或者联系 [GitHub 支持](https://support.github.com/contact)或 [GitHub 高级支持](https://enterprise.githubsupport.com/hc/en-us)，以控制我们收集的信息。

如果 GitHub 处理您的信息，例如 [GitHub 从第三方获取](#information-we-collect-from-third-parties)的信息，但您没有帐户，则您可以通过联系 [GitHub 支持](https://support.github.com/contact)或 [GitHub 高级支持](https://enterprise.githubsupport.com/hc/en-us)，根据适用法律，访问、更新、更改、删除或反对处理您的个人信息。

#### 数据可移植性

作为 GitHub 用户，您可以随时带走您的数据。 例如，您可以[将您的仓库克隆到桌面](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop)，也可以使用我们的[数据移植工具](https://developer.github.com/changes/2018-05-24-user-migration-api/)下载我们拥有的与您相关的信息。

#### 数据保留和删除

一般来说，只要您的帐户处于活动状态或需要为您提供服务，GitHub 就会保留您的用户个人信息。

如果您想取消帐户或删除用户个人信息，可以在[用户个人资料](https://github.com/settings/admin)中进行。 我们将根据需要保留并使用您的信息，以履行我们的法律义务、解决争端和执行我们的协议，但是除非法律要求，否则我们将在您请求后 90 天内（在合理时间内）删除您的完整个人资料。 您可以联系 [GitHub 支持](https://support.github.com/contact)或 [GitHub 高级支持](https://enterprise.githubsupport.com/hc/en-us)，请求在 30 天内删除您的数据，但需要征得我们的同意。

删除帐户后，某些数据，例如对其他用户仓库的贡献和对其他议题的评论，仍然保留。 但是，我们通过将其与[空用户](https://github.com/ghost)相关联，从议题、拉取请求和评论的作者字段中删除或去识别化您的用户个人信息，包括您的用户名和电子邮件地址。

也就是说，[通过 Git 提交设置](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address)提供的电子邮件地址将始终与您在 Git 系统中的提交相关联。 如果您已选择将自己的电子邮件地址设为私密，则还应更新您的 Git 提交设置。 我们无法更改或删除 Git 提交历史记录中的数据 — 虽然 Git 软件设计用于维护记录，但我们让您来控制在该记录中放入哪些信息。

### 我们使用 cookie 和跟踪技术

#### Cookie

GitHub 使用 cookie 让服务交互变得简单而有意义。 Cookie 是网站通常存储在访客的计算机硬盘或移动设备上的小型文本文件。 我们使用 cookie（以及类似技术，例如 HTML5 localStorage）保持登录状态、记住您的首选项，并为 GitHub 的未来开发提供信息。 出于安全目的，我们使用 cookie 来识别设备。 使用我们的网站，即表示您同意我们将这些类型的 cookie 放在您的计算机或设备上。 如果您禁止浏览器或设备接受这些 cookie，则将无法登录或使用 GitHub 的服务。

我们提供了一个有关 [cookie 和跟踪技术](/github/site-policy/github-subprocessors-and-cookies)的网页，介绍我们设置的 cookie、对这些 cookie 的需求以及它们的类型（临时或永久）。 它还列出了我们的第三方分析提供商和其他服务提供商，并明确说明了允许他们跟踪我们网站的哪些部分。

#### 跟踪和分析

我们使用许多第三方分析和服务提供商来帮助我们评估用户对 GitHub的使用； 汇编有关活动的统计报告；以及改善我们的内容和网站性能。 我们仅在网站的某些区域使用这些第三方分析提供商，他们全部与我们签署了数据保护协议，这些协议限制了他们可以收集的用户个人信息类型以及他们处理信息的目的。 此外，我们使用自己的内部分析软件来提供功能并改善我们的内容和性能。

有些浏览器纳入了“别跟踪”(DNT) 功能，可向您访问的网站发送信号，表明您不希望被跟踪。 GitHub 响应浏览器的 DNT 信号，并遵循[关于响应 DNT 信号的 W3C 标准](https://www.w3.org/TR/tracking-dnt/)。 如果您没有在支持 DNT 的浏览器上启用 DNT，则我们网站某些部分的 cookie 会长期跟踪您在其他在线服务上的在线浏览活动，不过，我们不允许我们分析和服务提供商以外的第三方长期跟踪 GitHub 用户在 GitHub 上的活动。

### GitHub 如何保护您的信息

GitHub 采取所有合理必要的措施保护用户个人信息，使其免遭未经授权的访问、更改或破坏；保持数据准确性；并帮助确保用户个人信息的适当使用。

GitHub 实施明文规定的安全信息程序。 我们的程序：
- 符合行业公认的框架；
- 包括合理设计的安全保障措施，以保护用户数据的机密性、完整性、可用性和弹性；
- 适合 GitHub 业务运营的性质、规模和复杂性；
- 包括事件响应和数据泄露通知流程；以及
- 遵守 GitHub 开展业务所在地区适用的信息安全相关法律和法规。

如果出现涉及用户个人信息的数据泄露事件，我们会立即采取措施以减轻泄露影响并及时通知所有受影响的用户。

GitHub 上的数据传输使用 SSH、HTTPS (TLS) 进行加密，git 仓库的内容在静态时进行加密。 我们在顶级数据中心管理自己的机笼和机架，物理和网络安全性俱佳，并且对通过第三方存储提供商存储的数据进行加密处理。

没有任何传输方法或电子存储方法是 100% 安全的。 因此，我们无法保证其绝对安全。 更多信息请参阅我们的[安全披露](https://github.com/security)。

### GitHub 的全球隐私实践

GitHub, Inc. and, for those in the European Economic Area, the United Kingdom, and Switzerland, GitHub B.V. are the controllers responsible for the processing of your personal information in connection with the Service, except (a) with respect to personal information that was added to a repository by its contributors, in which case the owner of that repository is the controller and GitHub is the processor (or, if the owner acts as a processor, GitHub will be the subprocessor); or (b) when you and GitHub have entered into a separate agreement that covers data privacy (such as a Data Processing Agreement).

Our addresses are:

- GitHub, Inc., 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107.
- GitHub B.V., Vijzelstraat 68-72, 1017 HL Amsterdam, The Netherlands.

We store and process the information that we collect in the United States in accordance with this Privacy Statement, though our service providers may store and process data outside the United States. 但是我们理解，不同国家和地区的用户对隐私保护有不同的预期，即使美国没有与其他国家/地区相同的隐私框架，我们也会努力满足这些需求。

We provide the same high standard of privacy protection—as described in this Privacy Statement—to all our users around the world, regardless of their country of origin or location, and we are proud of the levels of notice, choice, accountability, security, data integrity, access, and recourse we provide. 无论我们在哪里开展业务，都会与我们的数据保护官合作，努力遵守适用的数据隐私法律，我们的数据保护官作为跨职能团队的一部分，负责监督我们的隐私合规工作。 此外，如果我们的供应商或附属公司有权访问用户个人信息，则他们必须签署协议，遵守我们的隐私政策和适用的数据隐私法律。

特点：

 - 我们在您同意的基础上收集您的用户个人信息，GitHub 提供明确的数据收集指导原则：不含糊、知情、具体、自愿同意。
 - 我只收集实现目的所需的最少量用户个人信息，除非您自己选择提供更多信息。 我们建议您只提供无压力分享的数据。
 - 我们提供简单的方法让您能够在法律允许的范围内访问、更改或删除我们收集的用户个人信息。
 - 对于用户个人信息，我们向用户提供通知、选择、问责、安全和访问，并且限制处理目的。 我们还为用户提供追索和执行方法。

#### 跨境数据传输

GitHub processes personal information both inside and outside of the United States and relies on Standard Contractual Clauses as the legally provided mechanism to lawfully transfer data from the European Economic Area, the United Kingdom, and Switzerland to the United States. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about our cross-border data transfers, see our [Global Privacy Practices](/github/site-policy/global-privacy-practices).

### 我们如何与您交流

我们使用您的电子邮件地址与您通信，但需要征得您的同意，**并且以您的同意为前提**。 例如，如果您向我们的支持团队提出请求，我们将通过电子邮件答复您。 对于在 GitHub 上如何使用和分享您的电子邮件地址，您有很多控制权。 您可以在[用户个人资料](https://github.com/settings/emails)中管理您的通信首选项。

根据设计，Git 版本控制系统将许多操作与用户的电子邮件地址相关联，例如提交消息。 我们在很多方面无法更改 Git 系统。 如果您希望自己的电子邮件地址保持私密，即使在公共仓库中发表评论时也不可见，[您可以在用户个人资料中创建私密电子邮件地址](https://github.com/settings/emails)。 You should also [update your local Git configuration to use your private email address](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). 这不会改变我们与您联系的方式，但会影响其他人查看您的情况。 在当前版本中，用户的电子邮件地址默认设置为私密，但旧版 GitHub 的用户可能需要更新其设置。 Please see more about email addresses in commit messages [here](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address).

根据您的[电子邮件设置](https://github.com/settings/emails)，GitHub 有时可能会发送有关新动态的通知电子邮件，例如您关注的仓库中有变动、出现新功能、有反馈请求、有重要政策变动或需要提供客户支持。 根据您的选择和适用的法律法规，我们还可能会发送营销电子邮件。 在我们发送的每封营销电子邮件的底部，都有一个“退订”链接。 请注意，您不能选择不接收我们的重要通讯，例如来自我们支持团队的电子邮件或系统电子邮件，但是您可以在个人资料中配置通知设置以选择不接收其他通讯。

我们的电子邮件可能包含一个像素标签，它是一个很小的清晰图像，可以告诉我们您是否打开了电子邮件以及您的 IP 地址是什么。 我们使用此像素标签使我们的电子邮件对您更有效，并确保我们不会发送您不需要的电子邮件。

### 解决投诉

如果您对 GitHub 处理您的用户个人信息的方式有疑问，请立即告诉我们。 我们乐于提供帮助。 您可以通过填写[隐私问题联系表](https://support.github.com/contact/privacy)联系我们。 也可以直接向我们发送电子邮件，电子邮件地址：privacy@github.com，主题行注明“隐私问题”。 我们将尽快回复 — 最迟不超过 45 天。

您还可以直接联系我们的数据保护官。

| 我们的美国总部                   | 我们的欧盟办事处           |
| ------------------------- | ------------------ |
| GitHub 数据保护官              | GitHub BV          |
| 88 Colin P. Kelly Jr. St. | Vijzelstraat 68-72 |
| San Francisco, CA 94107   | 1017 HL Amsterdam  |
| 美国                        | 荷兰                 |
| privacy@github.com        | privacy@github.com |

#### 争议解决流程

万一您和 GitHub 之间就我们处理用户个人信息的问题出现争议，我们将尽最大努力予以解决。 Additionally, if you are a resident of an EU member state, you have the right to file a complaint with your local supervisory authority, and you might have more [options](/github/site-policy/global-privacy-practices#dispute-resolution-process).

### 隐私声明的变更

GitHub 可能会不时更改我们的隐私声明，不过大多数情况都是小变动。 如果本隐私声明发生重大变更，我们会在变更生效之前至少 30 天通知用户 - 在我们网站的主页上发布通知，或者发送电子邮件到您的 GitHub 帐户中指定的主电子邮件地址。 我们还会更新我们的[站点政策仓库](https://github.com/github/site-policy/)，通过它可跟踪本政策的所有变更。 对于本隐私声明的非重大变更或不影响您权利的变更，我们建议用户经常查看我们的站点政策仓库。

### 许可

本隐私声明的许可采用[知识共享零许可](https://creativecommons.org/publicdomain/zero/1.0/)原则。 更多信息请参阅我们的[站点政策仓库](https://github.com/github/site-policy#license)。

### 联系 GitHub
有关 GitHub 隐私声明或信息实践的问题，请通过我们的[隐私问题联系表](https://support.github.com/contact/privacy)联系我们。

### 翻译

以下是本文档翻译成其他语言的版本。 如果任何这些版本与英文版之间存在任何冲突、含糊或明显不一致，以英文版为准。

#### 法语
Cliquez ici pour obtenir la version française: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(12.20.19)(FR).pdf)

#### 其他翻译版本：

For translations of this statement into other languages, please visit [https://docs.github.com/](/) and select a language from the drop-down menu under “English.”
