---
title: GitHub Marketplace 开发者协议
redirect_from:
  - /articles/github-marketplace-developer-agreement
versions:
  free-pro-team: '*'
---

**参与 GITHUB 的 MARKETPLACE 计划必须遵守这些条款和条件（以下简称“协议”）。 注册参与 MARKETPLACE 计划或单击下面的“I ACCEPT（我接受）”，即表示您确认自己理解本协议，并接受其所有条款和条件。  如果您代表公司或其他法律实体签订本协议，则表示您拥有让该实体受本协议约束的法律权限，在这种情况下，“您”即表示您所代表的实体。**

Effective Date: July 21, 2020

### 1.  定义

本协议中使用但未定义的大写术语，其含义应与位于 [https://docs.github.com/articles/github-terms-of-service](/articles/github-terms-of-service) 的“GitHub 服务条款”（以下简称“条款”或 “ToS”）中规定的含义相同 。

“操作”是指可用于实施自定义逻辑而不必创建应用程序来执行 GitHub 特定任务的机制。

“品牌特征”是指当事方不时拥有（或许可）的每一方各自的商品名称、商标、服务商标、徽标、域名和其他独特品牌特征。

“开发者”是指您，即创建可用于 GitHub 并且可通过 Marketplace 访问的软件、内容和数字资料的公司或个人。

“开发者应用程序”或“开发者产品”是指您创建的可用于 GitHub 并且可通过 Marketplace 访问的软件、内容和数字资料，包括 Action。

“最终用户”是指将通过 GitHub Marketplace 获得开发者产品许可的任何个人、公司或其他法律实体。

“GitHub API” 是指 GitHub 专有的应用程序接口。  GitHub API 的访问和使用受 ToS 约束。

“GitHub Marketplace” 或 “Marketplace” 是指由 GitHub 运营的专有在线市场站点，开发者产品可通过该站点交付给最终用户。

“产品推介”是指在 GitHub Marketplace 上推介开发者产品时提供的内容。

“税收”是指任何类型的任何联邦、州、地方或外国所得税、总收入税、特许经营税、预估税、替代性最低稅、销售税、使用税、转让税、增值税、货物税、不动产税或个人财产税、预扣税或其他税， 包括与上述税项相关的任何利息、罚金或附加税或附加费。

“使用数据”是指就最终用户使用 GitHub Marketplace 和开发者产品的许可签发生成的 Marketplace 相关数据， 包括但不限于使用情况统计和销售数据汇总。 使用数据不包括并且特别排除银行信息和支付信息。

### 2.  用途和许可授予

**2.1** 本协议规定了开发者在 GitHub Marketplace 上发布产品推介以供最终用户购买其产品并用于 GitHub.com 时所应遵循的条款和条件。  本协议适用于免费分发和向最终用户收费的开发者产品。  开发者同意仅将 GitHub Marketplace 用于本协议允许或适用法律允许的用途。  在 GitHub 与开发者之间，开发者对开发者产品承担全部责任。

**2.2** 开发者向 GitHub 授予非排他性、全球范围、可转让、可转许可、完全付清、免收特许权使用费的许可，以便其 (a) 托管、 链接、复制、修改、公开执行、公开展示、测试、分发、提供、许可以及以其他方式使用产品推介； (b) 出于与  Marketplace 运营和推广相关的管理和示范目的而复制、执行、展示、使用和访问产品推介； 以及 (c) 复制、展示、分发和以其他方式使用开发者根据本协议提供给 GitHub 的开发者品牌特征，以便仅用于 Marketplace 相关用途和履行其在本协议下的义务。

**2.3** 除了以上授予的许可之外， GitHub 可以出于 Marketplace 市场推广的目的将开发者根据本协议向 GitHub 提供的开发者品牌特征用在任何演示文稿、通讯稿、市场推广资料、新闻稿、客户名单（包括但不限于发布到 GitHub 网站上的任何客户名单）、宣传活动和其他广告宣传册中。  如果开发者停止在 Marketplace 上发行特定开发者产品，GitHub 将在商业上合理的时间期限之后，停止使用已停止发行的开发者产品的品牌特征。  本协议中的任何内容均不赋予开发者使用任何 GitHub 品牌特征的权利。

**2.4** 开发者授予每个最终用户非排他性、全球范围权利或许可，允许其执行、展示并使用开发者产品以及其中所含、被其所访问或者通过其传播的涉及 Marketplace 的任何内容。  开发者必须在其开发者产品中包括一个单独的最终用户许可协议 (“EULA”)，以替代上一句话约束最终用户对开发者产品的权利。  开发者确认并同意，每个开发者产品的适用 EULA 仅限于开发者与最终用户之间的约定。  GitHub 不应根据任何 EULA 而承担任何责任或任何义务。

**2.5** 除了在本协议中授予的许可权之外，(a) 开发者保留对开发者产品的所有权利；(b) 每一方都保留其独立于本协议之外的所有权利，包括根据《美国版权法》或其他司法管辖区的类似法律所享有的权利；并且 (c) 每一方拥有对各自品牌的所有权利、所有权和权益。  每一方都有责任保护和履行其各自拥有的权利，任何一方都没有义务代表另一方这样做。

**2.6** 开发者确认并同意，对于合理（GitHub 自行确定其合理性）声称开发者不具备对开发者产品的所有必要知识产权的任何第三方，GitHub 有权向其提供开发者的名称、地址和其他联系信息。

### 3.  限制和责任

不论上文第 2 节“用途和许可授予”中规定的任何要求， 开发者确认并同意，其使用 Marketplace 及参与本计划的明确前提是开发者遵守本协议，包括但不限于本节（第 3 节）中规定的限制和合规要求。

**3.1** 开发者同意保护所有最终用户的隐私权和合法权利。  如果最终用户向开发者提供，或产品以其他方式收集、披露、访问或使用，最终用户的名称、密码或其他个人信息，那么开发者必须 (a) 告知最终用户此类信息将被提供给开发者产品；(b) 向最终用户提供法律上适当的隐私权通知和保护。  此外，开发者产品只能出于开发者获得最终用户许可的有限目的而使用该等信息。 如果开发者产品存储或传输最终用户提供的或从最终用户获取的个人或敏感信息， 则开发者必须确保所有该等操作能够安全进行，并且必须及时回应 GitHub 或 Marketplace 最终用户的投诉以及删除和“别碰”要求。

**3.2** 要使用和访问 GitHub API，开发者必须通过成为订阅者而获得 API 凭据(“令牌”)。 开发者不得与任何第三方分享其令牌，应保证该令牌和所有登录信息的安全，并且应使用此令牌作为开发者访问 GitHub API 的唯一手段。

**3.3** 开发者确认并同意，不利用 Marketplace 从事违反 Marketplace 政策或涉及以下情况的任何活动（包括开发者产品分发）：

- 1\. 违反任何适用的法律或条例或促成非法活动；
- 2\. 包含或安装任何主动恶意软件或漏洞利用程序，或者使用我们的平台传递漏洞利用程序（例如将其嵌入在命令和控制系统中）；
- 3\. 干扰、破坏、损坏、损害或未经授权访问任何第三方的机器、系统、硬件、服务器、 网络、设备、 数据或其他财产或服务；
- 4\. 包含虚假或误导内容；
- 5\. 侵犯任何方的任何专有权利，包括专利、商标、商业秘密、版权、肖像权或其他权利；
- 6\. 诽谤、中伤或欺诈性内容；
- 7\. 允许未经授权下载流内容或媒体；
- 8\. 显示或链接到非法内容；
- 9\. 骚扰、辱骂、威胁或煽动暴力对待任何个人或团体，包括 GitHub 员工、高管和代理或任何最终用户；
- 10\. 属于或包含淫秽内容；
- 11\. 歧视或辱骂任何个人或团体；
- 12\. 将最终用户转到模仿 Marketplace 或冒充 Marketplace 的任何其他网站，或者提供跳转到该等网站的链接。

**3.4** 开发者在任何情况下不得通过开发者产品或其他方式重新包装或转售 Marketplace、GitHub API 或使用数据。 开发者不得以任何会或可能会破坏服务、 GitHub API、使用数据或通过 Marketplace 存储或传输的任何其他数据或信息之安全性的方式，来使用 GitHub API 或任何使用数据。 此外，开发者不得（也不得试图）干预、修改或禁用 Marketplace 或 GitHub API 的任何特征、功能或安全控件；废除、避免、绕过、移除、停用或以其他方式规避 Marketplace 或 GitHub API 的任何保护机制；或者从 Marketplace 或 GitHub API 中逆向工程、反编译、 拆分或推导源代码、基础想法、算法、结构或组织形式。

**3.5** 开发者确认，开发者独自对开发者产品的内容、开发、运行、支持或维护承担全部责任，而 GitHub 对此不承担任何类型的责任或义务 。 在不限制上述规定的前提下，开发者将完全负责：
- (i) 其开发者产品的技术安装和运行；
- (ii) 在开发者产品之上、之内或通过开发者产品制作和展示信息和内容；
- (iii) 确保其开发者产品不违反或侵犯任何第三方的知识产权；
- (iv) 确保开发者产品不具备冒犯性、亵渎性、淫秽性、诽谤性或其他非法性质；
- (v) 确保其开发者产品不含恶意软件，也不会将恶意软件引入 Marketplace、GitHub API、任何使用数据或通过 Marketplace 存储或传输的其他数据中；以及
- (vi) 确保其开发者产品不被设计成或用于在未经同意的情况下向任何 GitHub.com 用户、代理或最终用户其发送商业电子消息。

**3.6** 开发者在设计和实施开发者产品方面，应尊重和遵守 GitHub API 在技术和政策上的限制以及本协议的限制。 在不限制上述规定的前提下，开发者不得在调用或以其他方式使用 GitHub API 时违反任何明确的速率限制。

**3.7** 如果 GitHub 确定开发者违反了本节（第 3 节）中的任何要求或义务，则 GitHub 有权立即终止本协议。

**3.8** 本协议的任何规定均不得阻止任何一方开发和/或发布与另一方的应用程序相似或竞争的应用程序。

### 4.  下架

**4.1** 您自行下架。 在下一个日历月第一日之前三十 (30) 天向 GitHub 发出书面通知后，您可以从 Marketplace 未来分发中删除您的产品推介，但必须遵守本协议关于 Marketplace 已分发产品的规定，包括但不限于退款要求。 从 Marketplace 未来分发中删除产品推介，不会：(a) 影响先前已购买或安装该产品的最终用户的许可权；或 (b) 改变您对于用户先前已购买或安装的产品提供交付或支持服务的义务。

尽管有上述规定，但在任何情况下，GitHub 都不会在 Marketplace 的任何部分保留由于以下原因（通过书面通知获悉）从 Marketplace 中删除的任何产品推介：:

- (i) 被指控侵犯或确实侵犯任何人的任何版权、商标、商业秘密、商业外观、专利或其他知识产权；
- (ii) 被指控诽谤或确实诽谤；
- (iii) 被指控侵犯或确实侵犯任何第三方的公开或隐私权；或者
- (iv) 被指控或确定该产品推介不符合适用法律。

如果您根据本第 4.1 节的 (i)、(ii)、(iii) 或 (iv) 条从 Marketplace 中删除了产品推介，但最终用户在删除日期之前的一年内购买了该产品，则对于退还该最终用户在删除日期之前一年内为该产品支付的任何金额，GitHub 不承担任何责任。

**4.2** GitHub 审查和下架。 虽然 GitHub 没有义务监视产品推介或其内容，但 GitHub 可能会随时审查或检验您的产品是否符合本协议、Marketplace 计划政策以及任何其他适用的条款、义务、法律或法规。 GitHub 有权自行决定拒绝在 Marketplace 上展示某个产品推介。 您在注册 Marketplace 的过程中或继续使用 Marketplace 的过程中，可能被要求提供自己的个人信息（例如身份或联系信息）。 您同意确保自己提供给 Marketplace 的任何信息将始终是准确、正确且最新的。 作为产品推介规范的一部分，GitHub 可能会要求您在产品推介信息的文件中包含您的姓名和电子邮件地址等信息。 GitHub 在我们的目录中推荐该产品或用于其他用途时，可能会使用此信息。

如果 GitHub 根据您的通知或以其他方式获知并自行确定您的产品推介或其任何部分或品牌特征
- (a) 侵犯任何第三方的知识产权或任何其他权利；
- (b) 违反任何适用法律或受到禁制令；
- (c) 为色情、淫秽内容，或者以其他方式违反 GitHub 的托管政策或其他服务条款（由 GitHub 自行决定不时更新）；
- (d) 分发不当；
- (e) 可能造成 GitHub 或任何第三方的责任；
- (f) 被 GitHub 视为存在恶意或缺陷；
- (g) 违反本协议的条款或 Marketplace 计划的政策；
- (h) 展示该产品推介会影响 GitHub 服务器的完善性（例如用户无法访问其内容或遇到其他困难）；
- (i) 被 GitHub 认为会给 Marketplace 最终用户的数据增加不应有的风险或损害用户使用 Marketplace 或 GitHub 的体验；
- (j) 因您违反 EULA 而遭到用户投诉；或
- (k) 在其他方面违反条款或本协议，

GitHub 可能：阻止该产品推介在 Marketplace 上展示；从 Marketplace 中删除该产品推介； 标记、过滤或修改相关材料（包括但不限于描述、屏幕截图或元数据）；或者，自行决定对该产品推介进行重新分类。 GitHub 有权自行决定暂停或禁止在 Marketplace 上展示任意产品推介。

如果您的产品推介由于存在缺陷、恶意、侵犯他人知识产权、诽谤、侵犯第三方公开或隐私权或不符合适用法律而被非自愿删除，但最终用户在下架日期之前一年内购买了该产品，则：

- (i) 您必须退还该最终用户在下架日期之前一年内为该产品支付的所有金额。
- (ii) GitHub 可自行决定从您的未来销售中扣除上文 (i) 小节中所述的金额。

**4.3** GitHub 可能会不时检查上架产品的可用更新，包括但不限于漏洞修复或功能增强。 如果您在 Marketplace 上更新您的上架产品，则表示您同意此更新将被自动请求、下载和安装，而无需另行通知您。  GitHub 不保证此类更新的时间。 为免生疑问，更新上架产品应遵循与产品上架相同的条款和条件，包括但不限于本协议的第 4.2 节（GitHub 审查和下架）。

**4.4** 最终用户下架。 如果最终用户以违反条款的方式使用您的开发者产品，则我们有权暂停或终止该最终用户使用该开发者产品，并且对您不承担任何责任。

### 5.  声明、保证和承诺

**5.1** 开发者声明并保证，开发者已通知其开发者应用程序的所有用户：其帐户数据将在服务之外传输，开发者条款将管制此类帐户数据的隐私、安全或完整性。 开发者进一步声明并保证，在开发者应用程序存储、处理或传输帐户数据方面，没有适当的用户事先同意或适用法律的要求，开发者和开发者应用程序均不得：
- (i) 以不利于帐户数据完整性的方式修改帐户数据的内容；
- (ii) 向任何第三方披露帐户数据；或
- (iii) 将帐户数据用于向用户提供开发者应用程序功能以外的任何目的。 开发者应采用合理的隐私和安全措施来维护和处理所有帐户数据，以保护所有帐户数据的机密性和安全性并符合所有适用的隐私法律法规。

**5.2** 开发者同意遵守“GitHub 数据保护附录”。

**5.3** 开发者声明、保证和承诺：(i) 其开发者产品和开发者品牌特征不会违反、盗用或侵犯任何第三方的知识产权；(ii) 开发者将遵守所有适用的地方、州、国家和国际法律法规，包括但不限于所有适用的出口管制法律，并保留开发、实施和分发其开发者产品所需的所有许可、批准及其他授权；(iii) 其开发者产品不包含任何恶意软件，也不会将任何恶意软件引入 Marketplace、GitHub API、任何使用数据或使用 Marketplace 存储或传输的其他数据；(iv) 其开发者产品不会设计成或用于在未经同意的情况下向任何 GitHub 客户、代理或最终用户发送商业电子消息；(v) 拥有向 GitHub 和最终用户授予许可的所有权利、权力和权限；(vi) 承认 GitHub 有权根据本协议第 6 节的规定收取交易费用和/或产品推介费用；(vii) 用于推广开发者产品或开发者上传到 Marketplace 的任何图像和文字都是真实、准确的，并且不会有意误导或迷惑最终用户。

**5.4** 免责声明。 MARKETPLACE 和 GITHUB API 的所有方面，包括所有服务器和网络组件，均“按原样”和“按可用”提供，在法律允许的最大范围内不提供任何形式的保证，并且 GITHUB 明确否认任何明示或暗示的保证，包括但不限于对适销性、所有权、适合特定用途和不侵权的任何暗示保证。  开发者确认，GITHUB 不保证 MARKETPLACE 或 GITHUB API 不中断、及时、安全、无错误或没有病毒、恶意软件或蠕虫（也称为专门设计为破坏、瘫痪或损害您的软件、硬件、计算机系统或网络的计算机代码或其他技术），并且开发者从 GITHUB、MARKETPLACE 或 GITHUB API 获取的任何信息或建议均不构成任何保证，除非在这些条款中有明确说明。  对于未经授权使用 MARKETPLACE 外部的任何开发者产品，GITHUB 概不负责，并且特别声明不承担任何义务。

### 6.  定价和付款条款

**6.1** GitHub 是最终用户通过 Marketplace 购买开发者产品的记录商。

**6.2** 开发者应用程序在 Marketplace 清单上的价格应设置为美元 (USD)。 开发者对于每个上架产品的定价设置有完全控制权，但一旦设定，就无法更改。 您可以撤销现有上架产品的定价计划，然后为其添加新的定价计划，前提是新的定价计划对现有最终客户没有不利影响。 您为开发者产品设置的价格将决定您将收到的付款金额。 GitHub 将以美元汇出 75% 的销售价格，不扣除税款，但适用法律要求的任何预扣税款除外。 其余 25% 的销售价格将分配给 GitHub 并由 GitHub 保留。  每个月底，在达到最低值 500 美元后，GitHub 将汇出您的应得款项。

**6.3** 退款要求。 您将负责制定关于向最终客户退款的条款和条件。 在任何情况下，GitHub 都不负责为退款提供任何支持，GitHub 也没有义务支付任何退款。

**6.4** 您支持自己的开发者产品。 您将自行负责支持和维护自己的开发者产品以及对其的任何投诉。 您的支持联系信息将显示在每个应用程序的详细信息页面中，以便用户请求客户支持。 对开发者产品的支持不足可能导致产品曝光率低，在某些情况下还会导致产品从 Marketplace 或 GitHub.com 上为用户存储先前已购或已下载开发者产品的任何其他地方被删除。

### 7.  所有权

除了本协议中明确提供的有限许可之外，本协议中的任何内容均不构成将某一方之品牌特征或其他技术中的知识产权转让给任何其他方，也不构成将某一方的任何知识产权转让给任何其他方。

### 8.  责任限制

在任何情况下或基于任何法律理论（无论是合同、侵权、疏忽或其他方面），GITHUB 或其关联公司、高管、董事、员工、代理人或供应商对开发者或本协议下的任何第三方遭受的任何间接、附带性、特殊、示范性、后果性、惩罚性或其他类似损害不承担任何责任，包括利润损失、销售或业务损失、数据丢失、业务中断，或者开发者或任何其他第三方与本协议相关的任何其他损失，无论开发者是否被告知可能或可以预见到此类损害。无论本协议是否包含相反规定，GITHUB 对开发者或本协议所产生的任何第三方的总责任均不超过六 (6) 个月的费用。

### 9.  保障赔偿

**9.1** 在适用法律允许的最大范围内，对于因 (a) 开发者使用 Marketplace 时违反本协议、条款或任何适用的法律法规；(b) 开发者的产品侵犯任何第三方的任何版权、商标、商业秘密、专利或其他知识产权；(c) 开发者数据或个人信息的任何丢失或泄露；以及 (d) 开发者的 EULA（或 ToS）所产生或与之相关的任何及所有索赔、诉讼、讼案或起诉，以及任何损失、责任、损害、费用和开支（包括合理的律师费），开发者同意为 GitHub、其关联公司及其各自的董事、高管、员工和代理人进行辩护、赔偿并确保他们免受损害。

### 10. 终止

**10.1** 本协议持续有效，直到任一方如下所述终止协议。

**10.2** 任一方均可在提前四十五 (45) 天书面通知对方后因任何原因终止本协议，终止于 45 天期过后的下一个日历月生效。 在这 45 天期间，在提供该等终止通知时有效的条款适用于 45 天通知期至实际终止之日的期间。

**10.3** GitHub 在 (a) 您违反了本协议的任何规定或 (b) 法律要求 GitHub 终止协议时可随时终止本协议。

**10.4** 开发者终止的影响。 在收到开发者的四十五 (45) 天提前书面终止通知后，将被禁止开发者通过 Marketplace 吸收新客户。 在 Marketplace 中终止并删除开发者产品时，将向您支付任何未付款项。 如果终止是因 GitHub 修改这些条款（第 11 条）而发起的，则在此类修改之前有效的条款适用于 45 天通知期至实际终止之日的期间。

**10.5** 第 2、3、4、5、8、9 以及 第12-18 条规定的义务在本协议到期或终止后仍然有效。

### 11. 修改

开发者承认并同意，GitHub 可能会不时修改本协议、Marketplace、GitHub API、一般 API 政策、GitHub 隐私政策、GitHub 开发者计划 ToS 和 GitHub.com ToS（"修改"）。 所有修改将通过 Marketplace、GitHub 网站 www.GitHub.com 或通过 GitHub 与开发者的直接沟通形式进行传达。 开发者进一步承认并同意，此类修改可随时实施，无需向开发者发出任何通知。 开发者应在任何修改首次通知之日起四十五 (45) 天内（或修改通知中指定的较短期限）（“符合期”）符合此类修改：在最新版本的开发者产品中实施和使用最新版本的 GitHub API，并对开发者产品进行任何可能需要的更改，以符合此类修改的要求。 开发者确认知悉，修改可能会对开发者产品产生不利影响，包括但不限于改变应用程序与 GitHub API 通信的方式。 对于此类修改或此类修改造成的任何不利影响，GitHub 对开发者或任何最终用户概不负责。 开发者在符合期后继续访问或使用 Marketplace 或 GitHub API 即表示接受对所发布的修改的约束。

### 12. 转让；完整协议；修订

**12.1** 未经 GitHub 事先书面同意，开发者不得通过法律或其他方式直接或间接转让本协议的全部或部分或者开发者在本协议下享有的权利，或者委托履行开发者在本协议下承担的职责。  GitHub 无需开发者事先批准即可转让或转移本协议授予的权利。  此外，GitHub 无需开发者同意即可委托其在本协议下承担的责任或义务。

**12.2** 本协议与“条款”一起构成双方就本协议标的所达成的全部协议。 GitHub 在任何时候未执行本协议的任何条款并不构成对该条款或本协议任何其他条款的放弃。

### 13. 可分割性

如果本协议中的任何条款被具有管辖权的法院裁定为不可执行，该类条款应由法院修改并作出解释，以便在法律允许的最大范围内最好地实现原始条款，并且本协议的其余条款仍然有效。

### 14. 缔约方关系

双方都是独立缔约方。 本协议不在双方之间建立合伙、特许经营、合资企业、代理、信托或雇佣关系。  开发者同意，GitHub 所属集团公司的每个成员都是本协议的第三方受益人，此类其他公司有权直接执行并依赖本协议中授予利益或授予有利于 GitHub 的权利的任何条款。  任何其他人员、公司或法律实体均不得成为本协议的第三方受益人。

### 15. 通知

本协议下 GitHub 提供给开发者的所有通知均以书面形式递送 (i) 由国家认可的隔夜递送服务（“快递公司”）递送，或通过美国邮件寄到开发者提供给 GitHub 的联系人邮寄地址；或 (ii) 通过电子邮件发送到开发者提供的电子邮件地址。 mail to the contact mailing address provided by Developer to GitHub; or (ii) electronic mail to the electronic mail address provided by Developer. 开发者必须以书面形式通知 GitHub，通知可通过快递公司或美国邮件递送到以下地址：GitHub, Inc., Attn: Legal Department, 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107 USA。 Mail to the following address: GitHub, Inc., Attn: Legal Department, 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107 USA. 所有通知若是通过电子邮件发送，则视为在邮件发出后立即送达；若是以其他方式递送，则视为在签收时送达，如果更早，则视为在邮件投递或上面允许的快递公司揽收二 (2) 个工作日后送达。

### 16. 管辖法律

本协议受加利福尼亚州法律管辖，不考虑法律冲突原则。 开发者特此明确同意服从加利福尼亚州和旧金山县的联邦及州法院的专属个人管辖权，以解决与本协议相关的任何争议。  尽管有上述规定，GitHub 有权在任何司法管辖区寻求禁令补救或其他类型的紧急法律救济。

### 17. 出口限制

通过 Marketplace 分销的开发者产品可能受美国或其他国家或地区的出口管制或限制。  开发者同意遵守所有适用的美国和国际出口法律法规。  这些法律可能包括对目的地、内容和/或最终用户的限制。

### 18.  使用数据
为了运营和改善 Marketplace，GitHub 可能会从 Marketplace 和 GitHub API 或者 GitHub 为用户存储先前已购或已下载产品的任何地方收集使用数据。  使用数据将按照 GitHub 当时有效的隐私政策进行维护。  受限使用数据由 GitHub 单方面决定是否供开发者使用。

# 附录1：数据保护附录

本数据保护附录（本"附录"）附加到您与 GitHub 之间的 GitHub Marketplace 开发者协议（本“协议”）并成为其一部分。 本附录中未定义的术语采用协议中的含义。 如果发生冲突或不一致，本附录的含义优先于协议中的含义。

**A1-1. 目的和范围** GitHub 维护来自世界各地的人们的个人信息，其中一些人所在的国家和地区制定了严格的数据保护法律。 本附录将确定您在接收和处理 GitHub 中的任何受保护数据时所承担的责任。

**A1-2. 定义**

- a. “Applicable Data Protection Laws” means any laws, regulations, regulatory frameworks, or other legislations relating to the processing and use of Personal Information, as applicable to the Agreement, including:
   - The EU General Data Protection Regulation 2016/679 (“GDPR”), along with any implementing or corresponding equivalent national laws or regulations;
   - 《2018 年加州消费者隐私法案》，加利福尼亚州 民事 法典第 1798.100 及其后各段 ("CCPA"); and
   - 《 2018 年英国数据保护法》及其中包含的 GDPR 实施条例。
- b. “Personal Information” means any information which relates to an individual GitHub End User, customer or employee which could, alone or together with other information, personally identify him or her, whether supplied by GitHub for processing by the Developer or whether generated by the Developer in the course of performing its obligations under this Agreement.
- c. “处理”是指以手动或自动方式对 GitHub 保护数据执行的任何操作或一组操作，包括收集、记录、组织、存储、改编、更改、检索、查阅、使用、通过传输、传播或其他方式披露、阻止、删除或销毁。
- d. “受保护数据”是指 GitHub 转移给开发者的有关 GitHub 最终用户的任何机密信息，包括个人信息、元数据、使用数据或与 GitHub 最终用户相关的其他数据或信息。

**A1-3. Compliance with Data Transfer Laws**

- a. GitHub 合规声明。 GitHub complies with Applicable Data Protection Laws. GitHub relies on Standard Contractual Clauses ("SCCs") for all transfers out of the European Union, European Economic Area, United Kingdom, and Switzerland to provide its services. 此外，GitHub 还通过了欧盟-美国 和瑞士-美国认证。 Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-U.S. Privacy Shield Framework as a legal basis for transfers of Personal Information in light of the judgment of the Court of Justice of the EU in Case C-311/18. GitHub 只出于数据收集时指定的有限目的向开发者转移个人信息。
- b. 开发者合规声明。 Developer represents and warrants that it will (i) comply with Applicable Data Protection Laws; and (ii) abide by the requirements of European Economic Area and Swiss data protection law regarding the collection, use, transfer, retention, and other processing of Personal Information from the European Economic Area, United Kingdom, and Switzerland. All transfers of Personal Information to a third country or an international organization will be subject to appropriate safeguards as described in Article 46 of the GDPR and such transfers and safeguards will be documented according to Article 30(2) of the GDPR.

**A1-4. 数据保护**

- a. 通知. 开发者必须表明自己是从最终用户收集的所有数据的收集者和处理者。 开发者不得以 GitHub 的名义收集任何个人信息。 开发者必须向最终用户充分说明其隐私实践，例如发布隐私政策。
- b. 目的限制。
   - i. GitHub 将为开发者提供受保护的数据元素，其目的是建立和促进开发者与最终用户之间的关系和便于开发者向最终用户提供服务。 开发者必须仅限于此类目的而使用受保护的数据，除非最终用户同意其他用途。
   - ii. 开发者处理和向第三方传递受保护的数据时，必须仅限于与最终用户之协议中所述的为最终用户提供服务的有限特定目的，除非最终用户同意其他用途。
- c. 数据质量和相称性。 开发者必须保持受保护数据的准确性和最新性。
- d. 安全. 开发者必须采取所有合理的安全措施，防范在处理受保护数据时面临的风险，例如意外或非法破坏、意外丢失、篡改、未经授权的披露或访问等风险。
- e. 数据保留和删除。 除非法律禁止，否则开发者必须应 GitHub 的合理要求，退回或销毁存储在所有位置的不再需要用于收集时指定的有限目的的所有个人信息和相关数据。 开发者必须具备或制定信息销毁流程，以满足 GitHub 在协议第 3.8 节中提出的安全要求。
- f. 再处理和向外传输。 开发者向子处理商传输受保护的数据时，应自行负责。 In the event that Developer must transfer the Protected Data to a third party, or Developer installs, uses, or enables third party services to process the Protected Data on Developer’s behalf, Developer must ensure that the third party will provide at least the same level of privacy protection as is required herein.

**A1-5. 受保护数据的使用**

- a. 允许的用途。 开发者只能出于第 4(b)(i) 节中规定的目的处理受保护的数据，不得用于其他目的。
- b. 不得用于营销。 开发者不得将受保护的数据用于推广任何第三方商品或服务，也不得向任何第三方出售受保护的数据。
- c. 自动化决策。 如果开发者做出影响 GitHub 客户权利（包括就业、信用或健康）的自动化决策，开发者必须向相关个人提供通知。

**A1-6. 合规**

- a. 开发者必须按照以下方式遵守有关其隐私和数据使用实践的合理信息要求：
   - i. 开发者将应要求提供其隐私声明、隐私政策、隐私通知或任何类似文档。 开发者还将提供任何相关合规报告的通知，包括隐私盾合规情况。
   - ii. 开发者将遵守 GitHub Marketplace 开发者协议第 3.7 节中的信息安全和审核义务。

**A1-7. 终止**

- a. 暂停。 如果开发者未履行保持足够的隐私保护级别的义务，GitHub 可暂停传输受保护的数据，或暂时禁止代表 GitHub 收集和处理受保护的数据，直到违规问题修复或协议终止。
- b. 因故终止。 在以下情况下，GitHub 可终止本协议，而不会影响法律或权益方面的任何其他主张：
   - i. 开发者通知 GitHub 无法再履行其隐私保护义务；
   - ii. 根据第 7(a) 节暂停传输、收集或处理受保护的数据，暂停时间超过一个月；
   - iii. 开发者实质性或持续违反本数据保护附录下的任何保证或声明；
   - iv. 开发者不再经营业务、解散、破产或清盘。
- c. 违规。 不遵守本数据保护附录的规定被视为实质性违反主服务协议。
- d. 通知。 如果开发者确定无法再履行本协议下的隐私义务，则必须立即通知 GitHub。 如果开发者获得了隐私盾认证，但认证失效或因其他原因无法保持认证，开发者必须立即通知 GitHub。
- e. 修改。 GitHub 可能会根据法律要求不时修改本附录，并在三十天内通知开发者。 如果开发者无法遵守对附录的修改，GitHub 可终止协议。
- f. 终止后，开发者必须：
   - i. 采取合理、适当的措施停止处理受保护的数据；
   - ii. 在终止后的 30 天内，删除开发者代表 GitHub 存储的任何受保护数据；以及
   - iii. 向 GitHub 提供合理保证，保证开发者已停止处理受保护数据并删除了所存储的受保护数据。

**A1-8. 数据处理责任**
- a. 直接赔偿责任。 开发者应根据 Marketplace 开发者协议第 8 节“责任限制”中的条款，赔偿因其任何违反本附录的行为对 GitHub 造成的实际损害。
