---
title: GitHub Enterprise 订阅协议
redirect_from:
  - /articles/github-enterprise-agreement/
  - /articles/github-enterprise-subscription-agreement
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

只要单击“我同意”或类似按钮或者使用任何产品（定义如下），即表示客户接受本协议的条款和条件。 如果客户代表法人实体签订本协议，则客户表示其拥有确保该法人实体受本协议约束的法律权限。

本协议适用于以下 GitHub 产品（详细定义见下文，统称为**“产品”**）：

-   GitHub Enterprise（由 GitHub Enterprise Server - 可能包括附加软件 - 和 GitHub Enterprise Cloud 组成）和 GitHub One；

-   任何测试版预览；

-   任何相关的支持；以及

-   任何相关的专业服务。

本协议包含以下“部分”和“附录”，都被引用成为本协议的一部分：

* 第 1 部分：一般条款和条件；

* 第 2 部分：GitHub Enterprise 服务器许可条款；

* 第 3 部分：GitHub Enterprise Cloud 服务条款；

* EXHIBIT A: Definitions.

如果客户从授权的 GitHub 经销商购买了任何产品，本协议的以下部分将替换为客户与 GitHub 经销商协作一致的条款：第 1.1 条（期限与终止）；1.2（付款）；第 2.3 条（交付）；以及第 2.4 条（验证）。

## 第 1 部分：一般条款和条件

第 1 部分规定适用于客户购买和使用任何产品的条款和条件。 Capitalized terms used but not defined in the body of this Agreement are defined in Exhibit A.

### 1.1 期限与终止。

#### 1.1.1 期限。

本协议从“生效日期”开始到一方根据本第 1.1 条终止一直有效。

#### 1.1.2 为便利而终止。 帐户取消。

任一方都可终止订单或本协议，不需要理由，但必须在当前订阅期结束前至少三十 (30) 天发出书面通知。 如果客户选择终止订单或协议，客户有责任到屏幕顶部全局导航栏中的 Settings（设置）向 GitHub 正常注销此帐户。 GitHub 无法通过回复电子邮件或电话申请来注销帐户。

#### 1.1.3 因实质违规而终止。

如果一方违反本协议下的实质性义务并且在收到通知后三十 (30) 天内未弥补违规的影响，则另一方可在通知后立即终止本协议。 每一方也有权利在书面通知后立即终止本协议，而不向另一方提供弥补期，如下所示：由 GitHub 终止 - 如果客户违反本协议中与 GitHub 的知识产权相关的条款（包括客户不遵守许可证的授予或任何许可限制），或者客户的帐户暂停超过九十 (90) 天；或由任一方终止 - 如果另一方违反本第 1.4 条中的保密义务。

#### 1.1.4 终止的影响；幸存。

在本协议终止后，客户不得执行其他订单；但本协议对尚未完成的所有订单保持有效。 当订单终止或到期时，对于该订单：(i) 软件和/或服务的订阅期将立即结束；(ii) 订单中的任何订阅许可将自动终止，并且客户不再有权使用产品；(iii) 如果在终止前欠有任何费用，客户必须立即支付这些费用；(iv) 客户必须销毁其拥有或控制的所有软件副本，并且向 GitHub 书面证实已经销毁；以及 (v) 每一方应在服务允许的范围内立即归还（或应另一方的要求销毁）属于另一方的所有机密信息。 尽管有上述规定，但客户可继续使用软件来迁移其数据，并且可申请在本协议或订单终止或到期后最长九十 (90) 天的时间来迁移其仓库中的数据；不过，客户在此期间不得将软件或服务用于生产。 根据其性质应合理幸存的任何条款在本协议或订单终止或到期时都将幸存。

### 1.2 付款。

#### 1.2.1 费用。

客户同意以美元全额支付费用，预先付款没有任何扣减或折扣。 Dollars. 客户必须在 GitHub 发票日期三十 (30) 天内支付费用。 本协议下应付的金额不可退款，第 1.5.1 和 1.6.2 条中规定的除外。 如果客户未及时支付任何费用，GitHub 有权寻求法律或公平裁决的任何行动，并且 (i) 以每月 1.0% 或法律允许的最高利率（取较小者）对逾期金额收取利息，并收取所有恢复费用，以及 (ii) 终止适用的订单或 SOW。 客户独自负责本协议造成或与之相关的所有税、费、关税和政府评估（基于 GitHub 净收入的税除外）。

#### 1.2.2 购买附加订阅许可证。

客户通过 GitHub 的网站或其销售团队提交申请，可获得本协议下的附加订阅许可证。 如果客户购买附加订阅许可证，客户必须支付其当前适用的费用，按比例支付适用订阅期的剩余时间。 在客户的订阅许可证再续订一个订阅期之后，除非订单另有规定，否则 GitHub 将以年为基础对所有订阅许可证开一次发票。

#### 1.2.3 附加软件。

附加软件基于每个用户授予许可。 为免生疑问，除非订单中另有说明，否则在任何特定时间，客户拥有的附加软件订阅许可数量，必须与其在本协议下拥有的产品订阅许可数量相等。 例如，如果客户已持有 100 用户的产品订阅许可，想要购买“高级安全”订阅，则该客户必须购买 100 用户的高级安全订阅许可。

### 1.3 专业服务。

在客户申请专业服务后，GitHub 将提供详述该等专业服务的 SOW。 GitHub 将执行每个 SOW 中描述的专业服务。 GitHub 将控制专业服务执行的方式和途径，并保留确定分配人员的权利。 GitHub 可能使用第三方执行专业服务，但 GitHub 对他们的行为和疏漏负责。 客户承认并同意，GitHub 保留在执行专业服务时使用或开发的任何内容的权利、资格和利益，包括软件、工具、规格、想法、概念、发明、流程、技术和知识。 在客户执行专业服务时 GitHub 向客户的任何交付范围内，GitHub 授予客户非独占、不可转让、全球、免版税、有限期的许可，允许他们在本协议有效期内使用这些交付物，只能与客户的软件或服务使用相结合。

### 1.4 保密。

任一方都不得使用另一方的机密信息，本协议明确允许的除外。 每一方都同意至少使用在保护自身类似性质信息时的谨慎程度来保护对方的机密信息，但在任何情况下至少采用合理的谨慎程度。 每一方都同意采用所有合理的预防措施防止未授权而披露对方的机密信息，包括但不限于仅向以下代表披露该等机密信息 (i) 需要知道该等信息，(ii) 是足以符合本第 1.4 的适当协议的相关方，以及 (iii) 了解本第 1.4 条所述的使用和披露限制。 每一方均应对其代表的所有行为和疏漏负责。 上述义务不限制任一方根据法院、行政机关或其他政府机构的命令和要求披露另一方的机密信息，前提是需要做出该等披露的一方必须合理通知另一方，以便该方对该等命令或要求提出抗辩，除非法律禁止该等通知。 本第 1.4 条规定的限制在本协议终止或到期后仍然幸存。

### 1.5 索赔抗辩。

双方在本第 1.5 条所述的范围内互相保护对方不受第三方索赔的损害，并且支付任何不利最终判决或认可的调解所产生的费用，但必须及时向抗辩方书面通知索赔，并且抗辩方有权利控制抗辩及其调解。 被抗辩方必须向抗辩方提供所有请求的协助、信息和权限。 抗辩方将向另一方补偿在提供协助时发生的合理自付费用，事先未获另一方的书面通知，不得确定或承认关于第三方索赔的事项，不能有不合理的扣留或延误。 本第 1.5 条规定双方对该等索赔的唯一救济和全部责任。

#### 1.5.1 GitHub。

GitHub 将保护客户不会遭受在其声称客户被授权使用软件或服务的范围内，因侵犯独立第三方的版权、专利、商标或不当使用商业秘密而被独立第三方提起的任何索赔。 如果 GitHub 无法根据商业合理条款解决任何此类索赔，则可自行选择：(i) 修改、修复或更换软件或服务（如适用）；或 (ii) 终止客户的订阅并退还任何尚未使用的预付订阅费。 对于因以下原因引起的任何此类索赔，GitHub 不承担本第 1.5.1 条下所述的任何义务：(a) 修改软件或服务，或将软件或服务与本协议（包括文档）未明确允许的设备、装置、软件、系统或数据一起组合、操作或使用；(b) 客户在收到停用通知后未停止使用软件或服务；(c) 客户在第 1.5.2 条下的义务；(d) GitHub 免费提供的产品或服务（包括免费使用软件或服务）；或 (e) 访问或使用测试预览版。 为明确 GitHub 在本第 1.5.1 条下的义务，软件和服务包括 GitHub 在此合并的开源组件。

#### 1.5.2 客户。

客户将保护 GitHub 免遭独立第三方因以下原因而提出的任何索赔：(i) 客户上传到软件或服务的内容；(ii) 客户违反本协议，包括客户泄露机密信息或违反 GitHub 接受的使用条款；(iii) 客户修改软件；或 (iv) 客户任何第三方品牌的设备、装置、软件、系统或数据与软件或服务一起组合、操作或使用。

### 1.6 表示和保证；免责声明；责任限制。

#### 1.6.1 一般保证。

每一方都向对方表示并保证，其拥有签订本协议的法定权力和权限，并且本协议以及每份订单和 SOW 均由该方拥有所有必要权限的员工或代理签订，以约束该方遵守本协议的条款和条件。

#### 1.6.2 有限保证。

**(i) 软件。**GitHub 保证：(1) 未经修改的软件在提供给客户下载时不会包含或传播任何恶意软件、病毒或蠕虫（也称为专门设计为破坏、瘫痪或损害客户的软件、硬件、计算机系统或网络的计算机代码或其他技术）；以及 (2) 自提供给客户首次下载之日起九十 (90) 天内，未经修改的软件实质上符合其文档所述。 GitHub 不保证客户对软件的使用不会中断或者软件的运行没有错误。 如果客户修改软件或以第 2 条和文档未明确允许的任何方式使用软件，则本第 1.6.2(i) 条的保证不适用。 GitHub 因违反此保证而产生的唯一责任以及客户获得的唯一补偿是由 GitHub 选择并付费 (a) 修复软件；(b) 更换软件；或 (c) 关于有缺陷的软件而终止本协议，并退还当前订阅其内对有缺陷的软件已预付但未使用的费用。

**(ii) 专业服务。** GitHub 向客户保证，本协议下执行的任何专业服务将由适当的合格人员以专业而熟练的方式执行。 GitHub 因违反此保证而产生的唯一责任以及对客户的唯一补救措施是由 GitHub 选择并付费：(1) 及时重新执行不符合此保证的任何专业服务；或 (2) 如果违约问题无法弥补，则终止 SOW 并退还尚未使用的预付费用。

#### 1.6.3  免责声明。

**(i) 一般。** 除本协议明确提供的保证之外，GitHub 不作任何形式的任何其他保证和表示，并在此特别否认任何其他保证，无论是明示、暗示还是法定保证，包括但不限于适销性、特定用途适用性、非侵权或者交易处理或使用过程产生的任何保证或条件。 除非本协议明确说明，GitHub 不提供任何口头或书面的建议或信息，也不形成任何保证或条件。

**(ii) 服务。** GitHub **“按原样”**和**“视情况”**提供服务，不含任何形式的保证。 不限于此，关于服务，GitHub 明确否认所有保证，无论是明示、暗示还是法定保证，包括但不限于对适销性、适合特定用途、权利、安全性、准确性和非侵权的任何保证。 GitHub 不保证服务将满足客户的要求；服务不中断、及时、安全或无错；通过服务提供的信息准确、可靠或正确；任何缺陷或错误将得到更正；服务在任何特定时间或地点可用；服务没有病毒或其他有害成分。 对于因客户下载和/或使用从服务获取的文件、信息、内容或其他材料而造成的任何损失风险，GitHub 概不负责。

**(iii) 测试版预览。**客户可自行决定选择使用测试版预览。 测试版预览不受支持，可能随时更改而不另行通知。 测试版预览的可靠性及可用性可能不如服务。 测试版预览不像服务一样采取同样的安全措施和审核。 GitHub 不承担测试版预览引起或与之相关的责任。 **客户使用测试版预览自担风险。**

#### 1.6.4 责任限制。

**(i)   间接损害。 在适用法律允许的最大范围内，对于本协议造成或与之相关的任何间接、特殊、偶发性、惩罚性或后果性损害（包括利润收入或数据损失），或者获取替代产品的费用，任一方对另一方概不负责，无论损害是何原因造成，也不管该等责任是否源自基于合同、保证、民事侵权（包括疏忽）、严格责任或其他的任何索赔，以及一方是否被告知存在此类损害的可能。**

**(ii) 全部责任限制。 在适用法律允许的最大范围内，任一方在本协议下源自所有诉因和所有责任理论的全部累计责任，不超过客户在引发该等责任的索赔之前 12 个月内实际支付给 GitHub 的费用。 对于免费提供的产品和服务（包括产品的使用），GitHub 的责任限于最高 5,000.00 美元的直接损害。 对于测试版预览，GitHub 的责任限于最高 500.00 美元的直接损害。**

**(iii) 例外。 本第 1.6.4 条所述的除外和限制不适用于以下原因引起的责任 (1) 一方违反其在第 1.4 条中的保密义务（与内容（不包括 GitHub 内容）相关的责任除外，这些责任仍然受限于上述限制和除外条款）；(2) 一方违反其在第 1.5 条中的抗辩义务；或 (3) 客户不遵守第 2.1 和 2.2 条中的许可授予或许可限制。**

### 1.7 订阅许可。

订阅许可基于每个用户授予，多个用户不能使用同一个订阅许可。 客户仅在同一订阅许可最后重新分配起九十 (90) 天后才可再次分配给新用户，除非是以下原因的重新分配 (i) 永久硬件故障或丢失，(ii) 用户雇用或合同终止，或 (iii) 为涵盖用户的缺席而临时分配订阅许可。 当客户将订阅许可从一个用户重新分配给另一个用户时，客户必须阻止前用户访问该订阅许可和客户的组织。

### 1.8 附属公司。

客户的附属公司被授权根据本协议使用软件和服务，但客户对他们访问和使用软件与服务完全负责。

### 1.9 支持。

GitHub 将对软件和服务提供如下支持：

#### 1.9.1 标准支持。

GitHub 每天二十四 (24) 小时、每周五 (5) 天（不包括周末和美国全国性假日）对软件和服务提供标准技术支持，不收取额外费用。 </em>GitHub 每天二十四 (24) 小时、每周五 (5) 天（不包括周末和美国全国性假日）对软件提供标准技术支持，不收取额外费用。 标准支持只通过 GitHub 以基于 web 的支持单提供，支持请求必须从 GitHub 支持团队可与之交互的用户发起。

#### 1.9.2 增强的支持服务。

GitHub 可能根据[支持条款](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise)， 按照订单或 SOW 中指定的支持级别、费用和订阅期为软件和服务提供增强的支持服务（包括 Premium、Premium Plus 和工程直接支持服务）。

#### 1.9.3 除外条款。

GitHub 将采取合理的努力更正客户向 GitHub 告知的软件中任何重大、可重现的错误。 但 GitHub 在以下情况下不负责提供支持 (i) 有人（非 GitHub）修改软件；(ii) 客户以对软件或其性能产生不利影响的方式更改其操作系统或环境；(iii) 客户以本协议或文档授权以外的方式使用软件；或 (iv) 客户对软件存在疏忽或误用。

### 1.10 知识产权。

在双方之间，GitHub 对产品拥有所有权利、资格和利益，包括所有知识产权。 GitHub 保留产品中本协议项下未明确授予客户的所有权利。 GitHub 可使用、修改客户提供或在论坛中发布的任何反馈、评论或建议，以及将其合并到产品中，而对客户没有任何义务。

### 1.11 反馈。

客户可向 GitHub 提供关于产品的反馈。 反馈是客户自愿提供的，并且不是客户的机密信息，即使被指定为机密信息。 GitHub 可出于以下目的充分运用和利用此类反馈：(i) 改善 GitHub 现有和未来产品的运行、功能、使用以及商业化；和 (ii) 发布有关产品质量的汇总统计信息，但任何此类发布中不得包含用于明确识别客户、其员工或客户专有软件代码的数据。

### 1.12 遵守法律法规。

客户在使用产品时应遵守所有适用的法律和法规，包括但不限于数据保护和雇佣法律和法规。

### 1.13 一般规定。

#### 1.13.1 管辖法律；审判地。

如果客户的总部在美洲，本协议将受加利福尼亚州法律管辖并据以解释，不适用任何冲突法原则，本协议项下产生的任何法律诉讼或程序将以独占方式在北加利福尼亚区的联邦或州法院提起诉讼，双方特此同意本协议的属于管辖权和地点。 如果客户总部在美洲以外，本协议将受爱尔兰法律管辖，本协议项下产生的任何法律诉讼或程序将以独占方式在都柏林的法院提起诉讼，双方特此同意本协议的属于管辖权和地点。 双方明确同意，《联合国国际货物销售合同公约》和《统一计算机信息交易法》不适用于本协议。 即使前面有相反的规定，GitHub 也可向具有适当管辖权的任何法院提出衡平法救济要求。

#### 1.13.2 美国政府用户。 政府用户.

产品完全使用私人基金开发，被视为联邦联邦收购条例 12.212 和 27.405-3 以及国防联邦收购条例补充 227.7202-3 所述的“商业计算机软件”和“商业计算机软件文档”。 The Products are licensed to the U.S. 产品作为受限制的计算机软件和有限权利数据许可给美国政府最终用户。 没有技术数据或计算机软件是在本协议下开发的。 Any use, disclosure, modification, distribution, or reproduction of the Products or Documentation by the U.S. Government or its contractors is subject to the restrictions set forth in this Agreement. 禁止所有其他使用。

#### 1.13.3 出口。

The Products are subject to export restrictions by the U.S. </em>产品受美国政府实施的出口和制裁限制以及某些外国政府的进口限制之约束，客户在使用产品时应遵守所有适用的进出口法律法规。 客户不得也不得允许任何第三方从美国转移或出口产品，或者允许出口或再出口产品的任何部分或任何直接派生品到：(i) 被禁运或恐怖主义支持的国家（或其任何国民或居民）；(ii) 美国商务部的拒绝订购表（Table of Denial Orders）或美国财政部的特别指定国民（Specially Designated Nationals）名单中的任何人；(iii) 被限制或禁止出口或再出口的任何国家/地区，或者美国政府或其任何机构要求出口或再出口时获取出口许可证或其他政府批准但未事先获得此类许可证或批准的国家/地区；或 (iv) 违反美国或外国机构或机关的任何进出口限制、法律或法规的其他实体或个人。 Commerce Department's Table of Denial Orders or U.S. Treasury Department's list of Specially Designated Nationals; (iii) to any country to which such export or re-export is restricted or prohibited, or as to which the U.S. government or any agency thereof requires an export license or other governmental approval at the time of export or re-export without first obtaining such license or approval; or (iv) otherwise in violation of any export or import restrictions, laws or regulations of any United States or foreign agency or authority. 客户表示并保证 (a) 客户不是任何此类被禁国家的国民或居民或受其控制，也不在任何此类被禁方名单中，以及 (b) 客户的任何数据都不在《美国国际军火贩运条例》的控制下。 International Traffic in Arms Regulations. 客户承认并同意，事先未获得美国政府的允许，产品不得用于设计或开发核能、化学或生物武器或导弹技术。 Government.

#### 1.13.4 未经许可不得公开。

GitHub 可将客户识别为现有客户和潜在客户。 但未经客户允许，GitHub 不得在任何广告或营销材料中使用客户的名称或徽标。

#### 1.13.5 转让。

事先未获对方的书面同意，任一方都不得转让本协议的全部或部分，不得不合理地扣留此类同意，任何此类尝试都将无效并作废，例外情况是：与合并、收购、公司重组或转让方的业务或资产全部或实质性出售相关时，GitHub 可在通知对方后全部转让本协议，无需获得对方的同意。

#### 1.13.6 通知。

除非本协议另有说明，否则本协议项下的任何通知、请求、要求或其他通信都必须是书面的（电子邮件可接受），必须参照本协议，并且在以下情况下被视为已正常送达：(i) 签收（如果是亲自送达）；(ii) 预定接收者确认收到后一 (1) 个工作日（如果是通过电子邮件发送）；(iii) 用挂号邮件寄送后五 (5) 个工作日，并有书面签收和电子邮件确认；或 (iv) 国际公认的快递公司和电子邮件寄送后三 (3) 个工作日，并有书面签收确认。 通知可寄送到本协议中所述的地址，除非一方通知另一方更改了地址。

#### 1.13.7 不可抗力。

GitHub 如果因其合理控制力之外的特殊原因（包括天灾、自然灾害、罢工、封锁、暴乱、战争、流行病或者电力、电信或网络故障而无法履行其在本协议下的义务，GitHub 不承担责任。

#### 1.13.8 独立缔约方。

每一方都是关于本协议主题的独立缔约方。 本协议中的任何内容都不得视为或以任何方式构成在双方之间建立法律关联、伙伴关系、合资企业、雇用、代理、信托或其他类似关系，任一方不得以合同来约束另一方。

#### 1.13.9 弃权。

一方在本协议项下的义务仅在另一方授权的代表书面签字后才可放弃。 一方未行使或延迟行使本协议项下的任何权利不构成放弃，任何单一或部分行使不妨碍法律或衡平法下任何权利的任何其他或进一步行使。

#### 1.13.10 完整协议。

本协议与附录以及每个订单和 SOW 一起，构成双方关于其主题的完整协议和谅解，并取代双方之间关于该主题的所有之前或同时的谅解和协议，无论是口头还是书面的协议。 任何客户购买单的条款、书面条款或条件或者客户提交到 GitHub 的文档，若其中所含条款不同于或超过本协议条款，任何订单或 SOW 将作废或无效。

#### 1.13.11 修正；偏好顺序。

GitHub 有权利独自裁量随时修订本协议，并在发生任何此类修正时更新本协议。 本协议如有重大更改，如价格变动，GitHub 将至少在更改生效前 30 天在服务上发布通知，向客户通知本协议的重大变更。 对于非重大修改，客户继续使用服务即表示同意我们对本协议的修订。 客户在我们的[站点政策](https://github.com/github/site-policy)仓库中可查看本协议的所有更改。 如果本协议条款与任何订单或 SOW 有任何冲突，则订单或 SOW 的条款只管制该订单或 SOW。

#### 1.13.12 可分割性。

如果本协议的任何条款被具有合法管辖权的法院视为非法、无效或不可执行，则双方将修改或改正本协议，使该条款尽可能有效。 无法以这种方式修改或改正的任何条款将被视为删除，而本协议的其余条款将继续保持完全效力。


## 第 2 部分：GITHUB ENTERPRISE 服务器许可条款

第 2 部分详述适用于客户使用软件的条款。

### 2.1 许可的授予。

GitHub 授予客户非独占、不可转让、全球、免版税、有限期的许可，以许可他们出于客户的内部业务目的，在适用的订阅期内根据文档安装和使用软件，并且仅适用于客户订单中所述的订阅许可数。 软件包含第三方许可给 GitHub 的组件，其中包括其许可证需要 GitHub 为可用组件提供源代码的软件。 这些组件的源代码将在请求时提供。 在不限制上述规定的条件下，此许可允许客户下载并运行适用于 Linux 文件的 Microsoft SQL Server 标准版容器映像（"**SQL Server 映像**），但只能与本软件一起使用，如文档所述。 当客户不再有权使用本软件时，客户使用 SQL Server 映像的权利即告终止，并且客户必须在其使用权限结束时卸载 SQL Server 映像。 Microsoft Corporation 可随时禁用 SQL Server 映像。

### 2.2 许可限制。

除了法律或适用的第三方许可证明确允许之外，客户及其附属公司不得也不得允许第三方：(i) 再许可、销售、租赁、出租、转让、让渡或再分发软件；(ii) 出于第三方利益而托管软件；(iii) 披露或允许任何第三方访问软件，本第 2 明确许可的除外；(iv) 入侵或修改许可密钥，或者避开或更改任何许可注册过程；(v) 修改软件或创建派生作品，或者将软件与其他软件合并，客户修改除外；(vi) 反汇编、反编译、绕过任何代码混淆，或者对软件全部或部分进行逆向工程或尝试推导其任何源代码；(vii) 修改、遮盖或删除软件或文档中包含的任何所有权通告；或 (viii) 以本协议未明确允许的其他方式使用或复制软件或文档。

### 2.3 交付。

GitHub 将在安全、有密码保护的网站提供许可密钥给客户下载。 本第 2 部分的所有交付都是电子形式。 为避免疑问，客户负责安装任何软件，并承认 GitHub 在提供许可密钥后对软件没有进一步的交付义务。 当有更新时，GitHub 将放在同一网站上供下载。 客户必须在商业合理的基础上更新软件，但每年不少于一 (1) 次。 客户负责对其用户名和密码保密。

### 2.4 验证。

在 GitHub 请求时，客户将及时向 GitHub 提供软件生成的报告，验证客户在根据本协议使用软件。 对于超出协议条款的任何其他使用，GitHub 将给客户开发票，从其第一次使用日期起生效。

### 2.5 更新；发行版。

#### 2.5.1 一般。

GitHub 将在客户下载软件和许可密钥的安全网站上提供软件的更新和发行版。

#### 2.5.2 支持的发行版。

对软件发行版，GitHub 只提供从原始发行日期起一 (1) 年的支持，或提供从发行版最近更新日期起六 (6) 个月的支持（取较长者）。 如果客户需要软件早期发行版的支持，必须根据共同商定的订单或 SOW 支付支持费用。

### 2.6 关于使用 GitHub Insights 和 Learning Lab for Enterprise Server 时的数据保护注意事项。

如果客户对 GitHub Insights 或 Learning Lab for Enterprise Server 的计划使用需要处理个人数据，则客户完全负责确定是否完成数据保护影响评估，或以其他方式确保对客户的计划使用进行正式的法律分析。 是否使用 GitHub Insights 或 Learning Lab for Enterprise Server 来处理客户员工和/或用户的数据，完全由客户自行决定；如果客户决定进行该等处理，则客户应自行负责遵循适用的法律。


### 第 3 部分：GITHUB ENTERPRISE CLOUD 服务条款

当客户或 GitHub 代表客户在服务上创建公司帐户和/或组织时，本第 3 部分详述适用于客户使用服务的条款。

### 3.1 帐户条款。

#### 3.1.1 帐户控制。

**(i) 用户。**客户承认，用户对其个人帐户及其中的内容保留最终的管理控制权。 [GitHub 的标准服务条款](/github/site-policy/github-terms-of-service)管辖用户对服务的使用，但本第 3 条下所述的用户活动除外。

**(ii) 组织。**根据本第 3 部分，客户对代表客户创建的任何组织以及发布到其组织内仓库的用户生成内容具有最终管理控制权。 本第 3 部分将管辖客户组织的使用。

#### 3.1.2 帐户要求。

要创建帐户，客户必须符合以下条件：

**(i)** 客户不得为 13 岁以下的儿童创建任何个人帐户。 如果 GitHub 发现任何未满 13 岁的用户，将立即终止该用户的帐户。 如果客户或其用户位于美国以外的国家，该国家的最小年龄限制可能更大，在这种情况下，客户有责任遵守该国的法律。

**(ii)** 用户登录名不能多人共享。

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. 更多信息请参阅 [GitHub 的出口管制政策](/articles/github-and-export-controls)。

#### 3.1.3 帐户安全。

客户负责：(i) 在其公司帐户下发布的所有内容和发生的活动；(ii) 保持其帐户登录凭据的安全；以及 (iii) 在获悉通过其帐户对服务的任何未授权使用或访问时及时[通知 GitHub](https://support.github.com/contact)。  GitHub 对客户不遵守本第 3.1.3 所造成的任何损失或损害概不负责。

#### 3.1.4 其他条款。

在某些情况下，第三方的条款可能适用于客户对服务的使用。 例如，客户可能是本身具有条款或许可协议的组织的成员；客户可能下载与服务相集成的应用程序；或者，客户可能使用服务向另一项服务验证。 虽然本协议是 GitHub 与客户的完全协议，但其他方的条款也会管辖他们与客户的关系。

#### 3.1.5 U.S. 联邦政府条款。 5. 美国联邦政府条款.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/articles/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 3.2 遵守法律；可接受的使用；隐私。

#### 3.2.1 遵守法律法规。
客户对服务的使用不得违反任何相关法律，包括版权法或商标法、出口管制法律或其司法管辖区的法规。

#### 3.2.2 可接受的使用。
客户对服务的使用必须遵守 [GitHub 可接受的使用政策](/articles/github-acceptable-use-policies)和 [GitHub 社区指导方针](/articles/github-community-guidelines)。 客户不得在任何司法管辖区将服务用于非法、淫秽、冒犯性或欺诈性内容或活动，例如鼓吹或造成伤害；干扰或违反网络或系统的完整性或安全性；避开过滤器；发送主动、辱骂或欺诈性消息、病毒或有害代码；或者违反第三方权利。

#### 3.2.3 隐私。
[The GitHub Privacy Statement](/articles/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. 任何个人、实体或服务从服务收集数据都必须遵守 [GitHub 隐私声明](/articles/github-privacy-statement)，特别是收集用户个人信息（定义见“GitHub 隐私声明”）时。 如果客户从 GitHub 收集任何用户个人信息，则客户仅将其用于外部用户已授权的目的。 客户将合理保护任何此类个人信息，并且客户会及时响应 GitHub 或外部用户的投诉、删除请求以及“不要联系”请求。

### 3.3 内容责任；所有权；许可权利。

#### 任何个人、实体或服务从服务收集数据都必须遵守 GitHub 隐私声明</a>，特别是收集用户个人信息（如“GitHub 隐私声明”中的定义）时。
客户在使用服务时可能创建或上传用户生成的内容。 客户对其通过服务发布、上传、链接或以其他方式提供的用户生成内容独自负责，无论用户生成的内容是何种形式。 GitHub 对用户生成内容的任何公开显示或滥用概不负责。

#### 3.3.2 内容所有权、发布权利和许可授予。

**(i)** 客户保留客户创建或拥有的客户内容的所有权。 客户承认：(a) 对客户内容负责，(b) 只会提供客户有权利发布的客户内容（包括第三方或用户生成的内容），以及 (c) 客户将完全遵守与客户发布的客户内容相关的任何第三方许可。

**(ii)** 客户免费授予第 3.3.3 至 3.3.6 条所述的权利，用于这两条所述的目的，直到客户从 GitHub 服务器中删除客户内容，但公开发布以及外部用户已经复刻的内容除外，这些内容的有效期直到所有客户内容复刻从 GitHub 服务器中删除。 如果客户上传的客户内容具有已经向 GitHub 授予运行服务所需的许可，则无需其他许可。

#### 3.3.3 向 GitHub 授予的许可。
客户向 GitHub 授予存储、剖析和显示客户内容的权利，并仅在提供服务需要时才创建偶尔的副本。 这些权利包括将客户内容复制到 GitHub 数据库和制作备份；向客户以及客户选择要向其显示内容的人员显示客户内容；将客户内容剖析为搜索索引或在 GitHub 的服务器上分析；与客户选择要共享的外部用户共享客户内容；以及执行客户内容，有点像音乐或视频一样。 这些权利适用于公共和私有仓库。 此许可并未向 GitHub 授予销售客户内容或者在服务外部分发或使用内容的权利。 客户向 GitHub 授予以无归属方式使用客户内容所需的权利，以及根据提供服务的需要对客户内容进行合理改编的权利。

#### 3.3.4 向外部用户授予的许可。
**(i)** 客户快速发布的任何内容，包括议题、评论以及对外部用户仓库的贡献，都可供其他人查看。 只要将其仓库设置为公开显示，即表示客户同意允许外部用户查看客户的仓库以及对其复刻。

**(ii)** 如果客户将其页面和仓库设为公开显示，客户向外部用户授予非独占、全球许可，允许他们通过服务使用、显示和执行客户内容，以及通过 GitHub 提供的功能（例如通过复刻）只在服务上重制允许的客户内容。 如果客户[采用许可](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository)，则可以授予对客户内容的更多权利。 如果客户上传其未创建或拥有的客户内容，则客户负责确保其上传的客户内容根据向外部用户授予这些许可的条款进行许可。

#### 3.3.5 仓库许可下的参与。
只要客户参与包含许可通告的仓库，则表示客户在相同的条款下许可该等参与，并且同意其有权利在这些条款下许可该等参与。 如果客户使用单独的协议在不同的条款下许可其参与，如参与者许可协议，则该协议优先。

#### 3.3.6 精神权利。
客户对其上传、发布或提交到服务任何部分的客户内容保留所有精神权利，包括完整性和归属的权利。 但客户对 GitHub 放弃这些权利并且同意不宣称这些权利，唯一目的是让 GitHub 合理行使第 3.3 条中宣称的权利，而没有任何其他目的。

### 3.4. 私有仓库。 私有仓库.

#### 3.4.1 控制。
客户负责管理对其私有仓库的访问，包括邀请、组织和团队的管理控制以及访问的终止。

#### 3.4.2 保密。
GitHub 将客户私有仓库中的客户内容视为客户的机密信息。 GitHub 将根据本第 1.4 条对私有仓库的客户内容实施保护和严格保密。

#### 3.4.3 访问。
GitHub 只能在以下情况下访问客户的私有仓库 (i) 经客户同意并确认，出于支持原因，或者 (ii) 出于安全原因而需要访问时。  客户可选择对其私有仓库启用其他访问权限。 例如，客户可向不同的 GitHub 服务或功能授予对私有仓库中客户内容的额外访问权限。 这些权利可能根据服务或功能而不同，但 GitHub 仍会将客户私有仓库中的客户内容视为客户的机密信息。 如果这些服务或功能除了提供服务所需的权限之前，还需要其他权限，GitHub 将会说明这些权限。

#### 3.4.4 除外条款。
如果 GitHub 有理由相信私有仓库的内容违反法律或本协议，则 GitHub 有权利访问、检查和删除该内容。 此外，法律可能要求 GitHub 披露客户私有仓库中的内容。 除非法律要求另有约束或者是回应安全威胁或其他安全风险，否则 GitHub 对此类操作需发出通知。

### 3.5. Intellectual Property Notices.

#### 3.5.1 GitHub 对内容的权利。
服务外观的版权归 © GitHub, Inc. 所有。 未经 GitHub 明确的书面许可，客户不得重复、复制或重复使用 HTML/CSS、Javascript 或者可视设计元素或概念的任何部分。

#### 3.5.2 版权侵权和 DMCA 政策。

如果客户是版权所有者，并且认为服务上的内容侵犯了其版权，则客户可根据 GitHub 的[数字千禧年版权法政策](https://github.com/contact/dmca)联系 GitHub - 通过其 [DMCA 表](https://github.com/contact/dmca-notice)联系 GitHub 或发电子邮件到 copyright@github.com。

#### 3.5.3 GitHub 商标和徽标。

如果客户要使用 GitHub 的商标，客户必须遵守 GitHub 的所有商标指导方针，包括 [GitHub 徽标和使用页面](https://github.com/logos)中的政策。

### 3.6 暂停。
GitHub 有权利因违反本协议或为了保护服务的完整性、操作性和安全性而随时暂停服务的全部或部分，包括删除内容，在通知后立即生效，除非法律或法律程序禁止发出该等通知，或者妨碍预防对服务或任何第三方的迫切伤害。 GitHub 通常以横幅或者在此类暂停时或暂停之前发电子邮件的形式来提供通知。 GitHub 将根据需要自由裁量善意定制任何暂停，以保持服务的完整性、操作性和安全性。

### 3.7 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 3.8 服务更改。
GitHub 通过更新和添加新功能来更改服务。 根据第 3.7 条，GitHub 保留随时临时或永久修改或中止服务（或其任何部分）的权利，可能通知或不通知。

### 3.9 附加服务功能。

某些服务功能可能受 [GitHub 附加产品条款](/github/site-policy/github-additional-product-terms)中规定的附加条款的约束。 客户访问或使用这些功能，即表示同意 GitHub 附加产品条款。

## EXHIBIT A: DEFINITIONS

**“活跃用户”**是指在断电时尝试访问服务的用户。

“**附加软件**”是指 GitHub 可能不时提供的 Advanced Security、Insights、Learning Lab for Enterprise Server 及其他软件附加产品。

**“高级安全”**是指使客户能够通过可自定义的自动语义代码分析来识别安全漏洞的软件功能。

**“附属公司”**是指一方直接或间接控制或者共同控制的任何实体，这里的“控制”是指对实体的所有权或者直接管理权超过百分之五十 (50%)。

**“所有用户”**统指客户的用户以及使用服务的外部用户。

**“美洲”**是指美国、加拿大、墨西哥或者中美洲、南美洲或加勒比海地区的国家。

**“测试版预览”**是指识别为 alpha、beta、预览、提早访问或评估或者具有类似含义的字词或短语的软件、服务或功能。

**“机密信息”**是指所有任一方以书面、口头或其他方式向另一方披露、指定为机密或接收方知道或理应知道为机密、在披露的情况下为机密以及信息性质对披露方为机密的所有非公共信息。 为避免疑问，除了单独存储在客户私人仓库中的客户内容之外，发布在服务上的任何内容都不会被视为机密信息。 机密信息不包含以下任何信息 (i) 并非接收方的过错而成为公众已知的信息；(ii) 接收方理由知道，而不受有权披露的披露方以外来源的机密或专有限制；(iii) 经披露方批准可以披露，而没有该披露方正式授权人员签名的书面文档限制；(iv) 接收方独立开发，没有访问或使用另一方的机密信息；或 (v) 存储或发布在服务上的客户私人仓库以外。

**“Connect”** 或 **“GitHub Connect”** 是指软件中用于支持软件与服务相连接的功能。 GitHub Connect 的使用受 [GitHub 附加产品条款](/github/site-policy/github-additional-product-terms)中规定的 GitHub Connect 条款的约束。

**“内容”**是指通过服务刊登、显示或提供的任何文本、数据、文章、图像、照片、图片、软件、应用程序、设计、功能及其他材料。

**“公司帐户”**是指用户代表实体创建的帐户。

**“客户”**统指通过单击“我同意”或类似按钮，或者通过访问产品，与 GitHub 签订本协议的公司或组织及其附属机构和代表。

**“客户内容”**是指客户创建、拥有或持有权利的内容。

**“客户修改”**是指客户为软件随附或链接的开源许可下许可的任何库开发漏洞修复、自定义或其他功能时所独自进行的软件修改。

**“文档”**是指与 GitHub 提供给客户的软件或服务相关的任何手册、文档及其他支持材料。

**“生效日期”**是以下日期中的较早日期 (i) 客户同意本协议的上述条款和条件，或 (ii) 第一次下单购买产品。

**“基本服务”**是旨 GitHub 核心版本控制功能必要的服务，包括创建、复刻和克隆仓库；创建、提交和合并分支；创建、审查和合并拉取请求；以及 web、API 和 Git 客户端连接到核心 Git 工作流程。 下面是未包含的外围功能和服务示例：web 挂钩、Gist、页面和电子邮件通知。

**“外部用户”**是指访问或使用服务的个人，不包括客户的用户。 “费用”是指客户因以下原因而必须向 GitHub 支付的费用 (i) 在适用的订阅期内使用产品，或 (ii) 获得专业服务，该等费用反映在订单或 SOW 中。

**“反馈”“**是指关于 GitHub 产品或服务的任何想法、知识、算法、代码贡献、建议、增强请求、建议或任何其他反馈。

**“费用”**是指客户因以下原因而必须向 GitHub 支付的费用：(i) 在适用的订阅期内使用产品，或 (ii) 获得专业服务，此类费用反映在订单或 SOW 中。

**“复刻”**是指将一个仓库的内容复制到另一个仓库。

**GitHub"**统指 GitHub, Inc.、其附属公司和代表。

**“GitHub 内容”**是指 GitHub 创建、拥有或持有权利的内容。

**"GitHub Insights"** 或 **“Insights”** 是一种软件功能，可为客户提供与其使用软件有关的指标、分析和建议。 GitHub Insights 不包含 GitHub 原有的组织洞察和仓库洞察功能。

**“GitHub One”** 是指产品包，其中包括 GitHub Enterprise、Advanced Security、Insights、Learning Lab for Enterprise Server 以及 Premium Plus 或 Engineering Direct Support。

**"Learning Lab for Enterprise Server"** 是指帮助用户学习 GitHub 功能（包括相关文档）的软件功能。

**“许可密钥”**是指软件的访问控制机制使用的数据文件，可让客户安装、操作和使用软件。

**“机器帐户”**是指代表机器帐户接受适用服务条款、提供有效的电子邮件地址并负责其操作的个人注册的帐户。 机器帐户专用于执行自动化任务。 多个用户可指示机器帐户的操作，但帐户所有者对机器的操作最终负责。

**“订单”**是指双方用来订购产品的书面或电子文档（包括报价）。

**“组织”**是指与一个实体或者一个或多个用户相关的共享工作空间，其中多个用户可以一次协作处理多个项目。 用户可以是多个组织的成员。

**“中断”**是指基本服务中断，影响 50% 以上的活跃用户。

**“私有仓库”**是指允许用户控制内容访问权限的仓库。

**“专业服务”**是指 GitHub 根据共同执行的 SOW 提供的培训、咨询或实现服务。 专业服务不包括支持。

**“公共仓库”**是指其内容对所有用户可见的仓库。

**“发行版”**是指 GitHub 一般提供给其用户的软件版本，包括文档对应的任何更改，其中包含增强、新特色或新功能，更改一般用第一个小数点右边（如 x.x.x 改为 x.y.x）或左边（如 x.x.x 改为 y.x.x）的数字变动来表示。

**“代表”**是指一方的员工、代理、独立承包商、顾问以及法律和财务顾问。

**“擦除”**擦除是指通过自动化过程（如自动程序或网络爬虫 ）从服务中提取数据，不包括通过 GitHub 的 API 收集信息。

**“服务”**是指托管的 GitHub Enterprise Cloud 服务。 服务包括：组织帐户、SAML 单点登录、访问配置及任何适用的文档。 此功能和服务列表并不详尽，可能会不时更新。

**“服务积分”**是指 GitHub 返还给合格帐户的美元信用，计算方式如下所述。

**“软件”**是指 GitHub Enterprise Server 本地软件。 软件包括 GitHub 向客户提供的或客户根据本协议可访问的 GitHub Connect 功能、任何适用文档、任何软件更新以及客户订阅中包含的附加软件（如果有）。

**“SOW”**是指共同执行的工作声明，其中详述 GitHub 将会执行的专业服务、任何相关费用以及每一方的相关义务。

**“订阅许可”**是指分配给每个用户代表客户安装、操作、访问及使用产品的许可。 客户在其 GitHub Enterprise Server 实例和 GitHub Enterprise Cloud 组织上为每个用户只分配一个订阅许可。 每个用户可以访问客户允许的多个客户 Enterprise Server 实例或 Enterprise Cloud 组织。 但为了明确，在客户向用户分配订阅许可后，客户没有权限对订阅许可复刻而让一个客户在 Enterprise Server 上使用某订阅许可，同时让另一个用户在另一个 GitHub Enterprise Server 实例或 GitHub Enterprise Cloud 的组织上使用同一个订阅许可。

**“订阅期”**是指从订单适用生效日期起一 (1) 年或订单中另外规定的时间。

**“支持”**是指 GitHub 可能为服务或软件提供的技术支持。

**“更新”**是指 GitHub 一般提供给其用户的软件版本，包括文档对应的任何更改，其中包含错误更正或漏洞修复，更改一般用第二个小数点右边（如 x.x.x 改为 x.x.y）的数字变动来表示。

**"正常运行时间“**是指在指定季度中 GitHub 基本服务不会出现影响 50% 以上活跃用户的中断的时间百分比。

**“用户”**(i) 对于软件，是指发起软件执行或与之交互或指示软件执行其功能的个人或机器帐户；以及 (ii) 对于服务，是指以下个人或机器帐户 (a) 访问或使用服务，(b) 访问或使用客户帐户的任何部分，或 (c) 指示使用客户帐户执行功能，在每种情况下都是代表客户。 用户数不应超过客户购买的订阅许可数。

**“用户生成的内容”**是指第三方或外部用户创建或拥有的内容。
