---
title: GitHub 数据保护附录
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

## 简介

双方同意，GitHub 数据保护和安全附录（统称为**“数据保护附录”**或 **“DPA”**）管辖双方在与 GitHub Enterprise Cloud 托管服务（简称为**“服务”**）相关的客户个人数据处理与安全方面的义务。 GitHub 在此 DPA 中向使用服务的所有客户做出承诺。 客户对非 GitHub 产品的使用由单独的条款（包括不同的隐私和安全条款）管辖。

如果 DPA 与客户与 GitHub 的协议中任何其他条款之间有任何冲突或不一致，以 DPA 为准。 DPA 的条款取代 GitHub 隐私声明中的任何冲突条款，非冲突条款可能适用于处理本文定义的客户个人数据。 为明确起见，与附件 1 中标准合同条款第 10 条一致，标准合同条款优先于 DPA 中任何其他条款。


## GITHUB 数据保护

### 1.  定义。

1.1 “**适用数据保护法律**”是指与处理及使用客户个人数据相关、适用于客户使用 GitHub 和 GitHub 服务的法律、法规、监管框架或其他立法，包括：

  a.  《欧盟通用数据保护条例 2016/679》(**"GDPR"**)，以及生效且适用的任何实施中或相应的等效国家法律或法规；以及

  b.  《2018 年加州消费者隐私法案》，加利福尼亚州 民事 法典第 1798.100 及其后各段 (**"CCPA"**)；以及

  c.  《 2018 年英国数据保护法》及其中包含的 GDPR 实施条例。

1.2 “**控制方**”、“**数据主体**”、“**成员国**”、“**个人数据**”、“**个人数据泄露**”、“**处理**”、“**处理方**”和“**监督机构**”的含义采用“适用数据保护法律”中的定义。 如果发生冲突，GDPR 中的含义优先。

1.3  “**客户个人数据**”是指客户为控制方的任何个人数据，无论是客户提供给 GitHub 处理还是 GitHub 履行其在本协议下义务的过程中产生的个人数据。 包括诸如帐单信息、IP 地址、公司电子邮件地址以及客户作为控制方的任何其他个人数据。

1.4  “**客户仓库数据**”是指客户在其任何私有仓库中上传或创建的任何数据或信息。

1.5 “**数据泄露**”是指个人数据泄露或者任何其他已确认或合理怀疑的客户受保护数据泄露。

1.6  “**最终用户**”是指控制 GitHub 帐户并且已同意 GitHub 服务条款及其个人数据被 GitHub 传输、存储或处理的个别数据主体。 例如，客户每个有 GitHub 帐户的员工或承包商也是 GitHub 最终用户。

1.7  数据处理“**允许的目的**”是指按本协议“GitHub 隐私声明”及本附录 A 所述提供服务的有限和特定目的，或者数据主体授权使用客户个人数据的目的。

1.8  “**受保护数据**”包括 GitHub 根据本协议代表客户处理的任何客户个人数据和任何客户仓库数据。

1.9  “**敏感数据**”是指显示种族或民族；政见、宗教、信仰或工会成员资格；为唯一识别自然人而进行的遗传数据或生物数据处理；健康、自然人性别或性取向相关数据；违法行为、刑事定罪或安全措施相关数据等的任何客户个人数据。

### 2. 身份与合规。

#### 2.1 数据处理。
GitHub 可作为其接收的与本协议相关的任何客户个人数据的处理方，并且 GitHub 只根据本协议及其他书面通信所述的客户指示将客户个人数据用于允许的目的。 如果 GitHub 无法遵守客户的指示，比如由于与适用数据保护法律冲突，或者适用数据保护法律或其他法律要求处理，则 GitHub 将在允许的范围内通知客户。 GitHub 在美国或欧盟处理所有客户个人数据；但 GitHub 的子处理方可能在美国或欧盟以外处理数据。 此外，GitHub 可作为任何客户仓库数据的处理方。

#### 2.2 数据控制方。
GitHub 从客户以及直接从创建最终用户帐户的数据主体接收客户个人数据。 客户其直接传输到 GitHub 的客户个人数据的唯一控制方。

#### 2.3 GitHub 合规性；数据传输。
GitHub 将遵守与客户个人数据处理相关的适用数据保护法律。

为提供服务而从欧盟、欧洲经济区、英国和瑞士传出任何客户个人数据，均应遵守附件 1（标准合同条款）中的标准合同条款。 GitHub 将遵守欧洲经济区和瑞士数据保护法有关收集、使用、传输、保留和其他方式处理来自欧洲经济区、英国和瑞士的客户个人数据的要求。 所有向第三国或国际组织传输客户个人数据的行为都将受到 GDPR 第 46 条所述的适当保护措施的约束，并且此类传输和保护措施将根据 GDPR 第 30(2) 条的规定进行记录。

此外，GitHub 还通过了欧盟-美国 和瑞士-美国认证。 In addition, GitHub is certified to the EU-U.S. and Swiss-U.S. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-U.S. Privacy Shield Framework as a legal basis for transfers of Personal Data in light of the judgment of the Court of Justice of the EU in Case C-311/18.  GitHub agrees to notify Customer if it makes a determination that it can no longer meet its obligation to provide the same level of protection as is required by the Privacy Shield principles.  GitHub 同意，在确定无法再履行其义务提供隐私盾原则所要求的保护级别时通知客户。


### 3. 数据保护。

#### 3.1 目的限制。
GitHub 仅为允许的目的处理和传播受保护数据，除非双方书面同意扩展的目的。

#### 3.2 数据质量和相称性。
GitHub 将保持客户个人数据的准确性和最新性，或使客户能够做到这一点。 GitHub 将采取商业上合理的措施来确保其代表客户收集的任何受保护数据充分、相关且传输和处理符合相关目的。 在任何情况下 GitHub 都不会有意代表客户收集敏感数据。 客户同意，GitHub 服务未预期存储敏感数据；如果客户选择将敏感数据上传到服务，则客户必须遵守 GDPR 第 9 条或适用数据保护法律中的同等条款。

#### 3.3 数据保留和删除。
在客户合理要求时，除非法律禁止，否则 GitHub 将在三天内退回、销毁或去识别所有位置存储、不再需要用于允许目的的所有客户个人数据及相关数据。 GitHub 可在适用数据保护法律需要的范围内保留客户个人数据及相关数据，并且仅保留适用数据保护法律要求的范围和期限，但 GitHub 要确保客户个人数据仅用于适用数据保护法律指定的目的，而不能用于其他目的，同时客户个人数据仍受适用数据保护法律的保护。

#### 3.4 数据处理。
关于处理客户的受保护数据，GitHub 根据 GDPR 第 28(3) 条的要求提供以下信息：

a.  客户个人数据*处理的主题和期限*在协议和本附录中描述。

b.  客户个人数据的*处理性质和目的*在本附录第 3.1 条描述。

c.  *要处理的客户个人数据类型*在“GitHub 隐私声明”中描述，包括用户名、密码、电子邮件地址和 IP 地址等客户个人数据。 GitHub 还处理客户帐户记帐所需的信息，但不处理或存储信用卡信息。 客户可选择向 GitHub 提供其他客户个人数据，如客户的配置文件设置，或者将客户个人数据上传到其 GitHub 仓库。

d.  *与客户个人数据相关的数据主体类别*是客户本身及其最终用户。

e.  *客户的义务和权利*在协议和本附录中描述。

### 4. 安全和审核义务。

#### 4.1 技术和组织安全措施。
考虑技术、实施成本、处理性质、处理范围、处理背景和目的，以及自然人权利和自由的不同可能性和严重性的风险，GitHub 在处理受保护数据时将实施适当的技术和组织措施来确保适合风险的安全性，比如防止意外或非法销毁、丢失、篡改、未授权披露或访问。 GitHub 将定期监控是否符合这些措施，并在协议整个期限内继续采取适当的保护措施。 有关 GitHub 与安全保护相关的责任，请参阅 GitHub 安全附录第 1.1 条。

#### 4.2 事件响应和违规通知。
GitHub 将遵守 GitHub 安全附录和适用数据保护法律中的信息安全义务，包括数据泄露通知义务。 有关 GitHub 与数据泄露及通知相关的责任，请参阅 GitHub 安全附录第 1.2 条。

#### 4.3 GitHub 人员。
GitHub 声明并保证，将采取合理措施确保处理受保护数据的所有 GitHub 人员已同意对受保护数据保密，并且已接受遵守本附录和适用数据保护法律的适当培训。

#### 4.4 记录。
GitHub 将维护代表客户执行的处理活动所有类别的完整、准确和最新书面记录，其中包含适用数据保护法律要求的信息。 在协助不会对 GitHub 的安全性或个别数据主体的隐私权利产生风险的范围内，GitHub 将应客户要求向其提供合理需要的这些记录，比如帮助客户证明其遵守适用数据保护法律。 要详细了解 GitHub 的要求以便在发生安全事件时提供协助，请参阅 GitHub 安全附录的第 1.2 条。

#### 4.5 合规报告。
GitHub 将根据 GitHub 安全附录第 2.3 条提供安全合规报告，并根据 GitHub 安全附录第 2.3 条提供隐私合规报告。 客户同意，适用数据保护法律（包括适用的 GDPR 第 28(3)(h) 条）授予的任何信息和审核权利将通过这些合规报告来满足，并且仅限于不提供充分信息的 GitHub 合规报告条款的范围，或者客户必须响应监管或监督机构审核的范围。 GitHub 安全附录第 3.1 条描述双方与监管或监督机构审核相关的责任。

#### 4.6 协助。
对于数据隐私影响评估、数据主体权利请求、监督机构咨询及其他类似事务等问题，GitHub 将向客户提供合理的协助，在每一种情况下只与客户个人数据的处理相关，并且考虑处理的性质。

### 5. 受保护数据的使用和披露。

#### 5.1 不用于营销。
GitHub 不将受保护数据用于宣传第三方内容，也不向任何第三方销售受保护数据，因合并或收购而造成的数据转移除外。

#### 5.2 GitHub 隐私声明。
“GitHub 隐私声明”公布在 [https://help.github.com/articles/github-privacy-statement/](/articles/github-privacy-statement) 上，详细说明 GitHub 的隐私和数据使用做法，包括对 cookie 的使用、争议解决流程以及 GitHub 的 GDPR 合规的进一步详情。

### 6. 再处理和向外传输。

#### 6.1 数据保护。
GitHub 对受保护数据向外传输到其再处理方（如其第三方支付处理方）负责。 如果 GitHub 将受保护数据传输到第三方再处理方，或者 GitHub 安装、使用或允许第三方或第三方服务代表 GitHub 处理受保护数据，GitHub 将确保第三方再处理方受书面协议约束，要求他们提供至少与本 DPA 和适用数据保护法律对 GitHub 要求相同级别的机密性、安全性和隐私保护。

#### 6.2 GitHub 再处理方的接受。
客户授权 GitHub 根据协议的第 6 部分以及任何其他限制指定（并允许每个再处理方根据第 6 部分指定）再处理方。 GitHub 自本附录生效日期起可继续使用当前使用的再处理方。

#### 6.3 外部再处理的总体同意。
客户总体上同意 GitHub 使用外部再处理方，条件是 GitHub 符合以下要求：

a.  任何外部再处理方必须书面同意只在欧洲委员会已经宣布具有“充分”保护级别的国家处理数据；或只按照与“标准合同条款”相当的条款处理数据，或根据适当欧洲数据保护机构授予的“具约束力公司规则”批准处理数据，或根据合规且有效的欧盟-美国和瑞士-美国 隐私盾认证处理数据；以及

b.  GitHub 将外部再处理方对客户个人数据的访问严格限于仅执行此服务所需，并且 GitHub 会禁止再处理方出于任何其他目的而处理客户个人数据。

#### 6.4 再处理方披露协议。
GitHub 在 [https://docs.github.com/articles/github-subprocessors-and-cookies/](/articles/github-subprocessors-and-cookies) 上维护其用来处理客户个人数据的外部再处理方清单，包括处理的客户个人数据类别、再处理方执行的处理类型说明以及处理的地点。 GitHub 将应客户的书面申请而向客户提供再处理方清单以及规范他们处理客户个人数据的条款。 根据再处理方保密性限制，GitHub 在向客户提供清单和条款之前可能会删除任何机密或商业敏感信息。 在 GitHub 不能向客户披露机密或敏感信息的情况下，双方同意，GitHub 将提供其合理可以提供的与其再处理协议相关的所有信息。

#### 6.5 对再处理方的异议。
GitHub 在增加或删除任何再处理方时，将在其 <https://github.com/github/site-policy> 网站中公告更改，提前向第三方提供书面通知，包括第 6.4 条中所列的类别。 如果客户对 GitHub 新增再处理方持有合理的异议，客户必须及时书面通知 GitHub。 GitHub 将尽可能采取商业合理的努力为受影响的服务提供替代解决方案，以避免招异议的再处理方处理数据。 如果 GitHub 无法提供替代解决方案而双方在九十天内无法解决冲突，客户可终止协议。

### 7. 终止。

#### 7.1 暂停。
如果 GitHub 未履行保持适当安全或隐私保护级别的义务，客户可临时暂停所有客户个人数据的传输，或禁止代表客户进行的客户个人数据收集和处理，直到 GitHub 履行义务或协议终止。

#### 7.2 因故终止。
除了客户在协议项上拥有的任何终止权利之外，在下列情况下，客户亦可在不损害法律或衡平法的任何其他要求时终止协议：

a.  GitHub 通知客户无法再履行其隐私保护义务；

b.  根据第 7.1 条，所有客户个人数据的传输、收集或处理已经临时暂停超过一个月；

c.  GitHub 实质性或持续违反本附录下的任何保证或表示；

d.  GitHub 不再经营业务、解散、破产或清盘；或

e.  客户根据第 6.5 条反对再处理方，并且 GitHub 在九十天内无法提供替代解决方案。

#### 7.3 违约。
不遵守本附录的重大条款被视为协议下的重大违约。

#### 7.4 未履行义务。
如果法律或法规的变动导致本附录的执行无法进行或商业上不合理，则双方可善意重新协商本附录。 如果重新协调无法解决问题，或者双方无法达成协议，则双方可在三十天后终止协议。

#### 7.5 通知。
如果 GitHub 确定其无法再履行本附录项下的隐私义务，GitHub 将立即书面通知客户。

#### 7.6 修改。
GitHub 可在提前三十天通知客户后，根据适用数据保护法律的要求不时修改本附录。

#### 7.7 Termination Requirements.
Upon Termination, GitHub must:

a.  采取合理、适当的措施停止处理客户个人数据；

b.  在终止后的九十天内，删除或去识别 GitHub 根据第 3.3 条代表客户存储的任何客户个人数据；以及

c.  向客户提供合理的保证，确保 GitHub 已履行其在第 7.7 条中的义务。

### 8. 数据处理责任。

#### 8.1 Limitations.
Except as limited by the Applicable Data Protection Laws, any claims brought under this Addendum will be subject to the terms of the Agreement regarding Limitations of Liability.

## Attachment 1 – The Standard Contractual Clauses (Processors)
Execution of the applicable agreement by Customer includes execution of this Attachment 1 to the GitHub Data Protection Addendum, which is countersigned by GitHub, Inc.

In countries where regulatory approval is required for use of the Standard Contractual Clauses, the Standard Contractual Clauses cannot be relied upon under European Commission 2010/87/EU (of February 2010) to legitimize export of data from the country, unless Customer has the required regulatory approval.

For the purposes of Article 46(2) of the General Data Protection Regulation (EU 2016/679) for the transfer of personal data to processors established in third countries which do not ensure an adequate level of data protection, Customer (as data exporter) and GitHub (as data importer, whose signature appears below), each a “party,” together “the parties,” have agreed on the following Contractual Clauses (the “Clauses” or “Standard Contractual Clauses”) in order to adduce adequate safeguards with respect to the protection of privacy and fundamental rights and freedoms of individuals for the transfer by the data exporter to the data importer of the personal data specified in Appendix 1.

#### Clause 1: Definitions
(a) 'personal data', 'special categories of data', 'process/processing', 'controller', 'processor', 'data subject' and 'supervisory authority' shall have the same meaning as in the General Data Protection Regulation (EU 2016/679) on the protection of individuals with regard to the processing of personal data and on the free movement of such data;

(b) 'the data exporter' means the controller who transfers the personal data;

(c) 'the data importer' means the processor who agrees to receive from the data exporter personal data intended for processing on his behalf after the transfer in accordance with his instructions and the terms of the Clauses and who is not subject to a third country's system ensuring adequate protection within the meaning of Article 45(2) of the General Data Protection Regulation (EU 2016/679);

(d) 'the subprocessor' means any processor engaged by the data importer or by any other subprocessor of the data importer who agrees to receive from the data importer or from any other subprocessor of the data importer personal data exclusively intended for processing activities to be carried out on behalf of the data exporter after the transfer in accordance with his instructions, the terms of the Clauses and the terms of the written subcontract;

(e) 'the applicable data protection law' means the legislation protecting the fundamental rights and freedoms of individuals and, in particular, their right to privacy with respect to the processing of personal data applicable to a data controller in the Member State in which the data exporter is established;

(f) 'technical and organisational security measures' means those measures aimed at protecting personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing.

#### Clause 2: Details of the transfer
The details of the transfer and in particular the special categories of personal data where applicable are specified in Appendix 1 below which forms an integral part of the Clauses.

#### Clause 3: Third-party beneficiary clause
1. The data subject can enforce against the data exporter this Clause, Clause 4(b) to (i), Clause 5(a) to (e), and (g) to (j), Clause 6(1) and (2), Clause 7, Clause 8(2), and Clauses 9 to 12 as third-party beneficiary.

2. The data subject can enforce against the data importer this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where the data exporter has factually disappeared or has ceased to exist in law unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law, as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity.

3. The data subject can enforce against the subprocessor this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses.

4. The parties do not object to a data subject being represented by an association or other body if the data subject so expressly wishes and if permitted by national law.

#### Clause 4: Obligations of the data exporter
The data exporter agrees and warrants:

(a) that the processing, including the transfer itself, of the personal data has been and will continue to be carried out in accordance with the relevant provisions of the applicable data protection law (and, where applicable, has been notified to the relevant authorities of the Member State where the data exporter is established) and does not violate the relevant provisions of that State;

(b) that it has instructed and throughout the duration of the personal data processing services will instruct the data importer to process the personal data transferred only on the data exporter's behalf and in accordance with the applicable data protection law and the Clauses;

(c) that the data importer will provide sufficient guarantees in respect of the technical and organisational security measures specified in Appendix 2 below;

(d) that after assessment of the requirements of the applicable data protection law, the security measures are appropriate to protect personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing, and that these measures ensure a level of security appropriate to the risks presented by the processing and the nature of the data to be protected having regard to the state of the art and the cost of their implementation;

(e) that it will ensure compliance with the security measures;

(f) that, if the transfer involves special categories of data, the data subject has been informed or will be informed before, or as soon as possible after, the transfer that its data could be transmitted to a third country not providing adequate protection within the meaning of the General Data Protection Regulation (EU 2016/679);

(g) to forward any notification received from the data importer or any subprocessor pursuant to Clause 5(b) and Clause 8(3) to the data protection supervisory authority if the data exporter decides to continue the transfer or to lift the suspension;

(h) to make available to the data subjects upon request a copy of the Clauses, with the exception of Appendix 2, and a summary description of the security measures, as well as a copy of any contract for subprocessing services which has to be made in accordance with the Clauses, unless the Clauses or the contract contain commercial information, in which case it may remove such commercial information;

(i) that, in the event of subprocessing, the processing activity is carried out in accordance with Clause 11 by a subprocessor providing at least the same level of protection for the personal data and the rights of data subject as the data importer under the Clauses; and

(j) that it will ensure compliance with Clause 4(a) to (i).

#### Clause 5: Obligations of the data importer
The data importer agrees and warrants:

(a) to process the personal data only on behalf of the data exporter and in compliance with its instructions and the Clauses; if it cannot provide such compliance for whatever reasons, it agrees to inform promptly the data exporter of its inability to comply, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract;

(b) that it has no reason to believe that the legislation applicable to it prevents it from fulfilling the instructions received from the data exporter and its obligations under the contract and that in the event of a change in this legislation which is likely to have a substantial adverse effect on the warranties and obligations provided by the Clauses, it will promptly notify the change to the data exporter as soon as it is aware, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract;

(c) that it has implemented the technical and organisational security measures specified in Appendix 2 before processing the personal data transferred;

(d) that it will promptly notify the data exporter about:

(i) any legally binding request for disclosure of the personal data by a law enforcement authority unless otherwise prohibited, such as a prohibition under criminal law to preserve the confidentiality of a law enforcement investigation,

(ii) any accidental or unauthorised access, and

(iii) any request received directly from the data subjects without responding to that request, unless it has been otherwise authorised to do so;

(e) to deal promptly and properly with all inquiries from the data exporter relating to its processing of the personal data subject to the transfer and to abide by the advice of the supervisory authority with regard to the processing of the data transferred;

(f) at the request of the data exporter to submit its data processing facilities for audit of the processing activities covered by the Clauses which shall be carried out by the data exporter or an inspection body composed of independent members and in possession of the required professional qualifications bound by a duty of confidentiality, selected by the data exporter, where applicable, in agreement with the supervisory authority;

(g) to make available to the data subject upon request a copy of the Clauses, or any existing contract for subprocessing, unless the Clauses or contract contain commercial information, in which case it may remove such commercial information, with the exception of Appendix 2 which shall be replaced by a summary description of the security measures in those cases where the data subject is unable to obtain a copy from the data exporter;

(h) that, in the event of subprocessing, it has previously informed the data exporter and obtained its prior written consent;

(i) that the processing services by the subprocessor will be carried out in accordance with Clause 11; and

(j) to send promptly a copy of any subprocessor agreement it concludes under the Clauses to the data exporter.

#### Clause 6: Liability
1. The parties agree that any data subject who has suffered damage as a result of any breach of the obligations referred to in Clause 3 or in Clause 11 by any party or subprocessor is entitled to receive compensation from the data exporter for the damage suffered.

2. If a data subject is not able to bring a claim for compensation in accordance with paragraph 1 against the data exporter, arising out of a breach by the data importer or his subprocessor of any of their obligations referred to in Clause 3 or in Clause 11, because the data exporter has factually disappeared or ceased to exist in law or has become insolvent, the data importer agrees that the data subject may issue a claim against the data importer as if it were the data exporter, unless any successor entity has assumed the entire legal obligations of the data exporter by contract of by operation of law, in which case the data subject can enforce its rights against such entity. The data importer may not rely on a breach by a subprocessor of its obligations in order to avoid its own liabilities.

3. If a data subject is not able to bring a claim against the data exporter or the data importer referred to in paragraphs 1 and 2, arising out of a breach by the subprocessor of any of their obligations referred to in Clause 3 or in Clause 11 because both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, the subprocessor agrees that the data subject may issue a claim against the data subprocessor with regard to its own processing operations under the Clauses as if it were the data exporter or the data importer, unless any successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law, in which case the data subject can enforce its rights against such entity. The liability of the subprocessor shall be limited to its own processing operations under the Clauses.

#### Clause 7: Mediation and jurisdiction
1. The data importer agrees that if the data subject invokes against it third-party beneficiary rights and/or claims compensation for damages under the Clauses, the data importer will accept the decision of the data subject:

(a) to refer the dispute to mediation, by an independent person or, where applicable, by the supervisory authority;

(b) to refer the dispute to the courts in the Member State in which the data exporter is established.

2. The parties agree that the choice made by the data subject will not prejudice its substantive or procedural rights to seek remedies in accordance with other provisions of national or international law.

#### Clause 8: Cooperation with supervisory authorities
1. The data exporter agrees to deposit a copy of this contract with the supervisory authority if it so requests or if such deposit is required under the applicable data protection law.

2. The parties agree that the supervisory authority has the right to conduct an audit of the data importer, and of any subprocessor, which has the same scope and is subject to the same conditions as would apply to an audit of the data exporter under the applicable data protection law.

3. The data importer shall promptly inform the data exporter about the existence of legislation applicable to it or any subprocessor preventing the conduct of an audit of the data importer, or any subprocessor, pursuant to paragraph 2. In such a case the data exporter shall be entitled to take the measures foreseen in Clause 5(b).

#### Clause 9: Governing Law.
The Clauses shall be governed by the law of the Member State in which the data exporter is established.

#### Clause 10: Variation of the contract
The parties undertake not to vary or modify the Clauses. This does not preclude the parties from adding clauses on business related issues where required as long as they do not contradict the Clause.

#### Clause 11: Subprocessing
1. The data importer shall not subcontract any of its processing operations performed on behalf of the data exporter under the Clauses without the prior written consent of the data exporter. Where the data importer subcontracts its obligations under the Clauses, with the consent of the data exporter, it shall do so only by way of a written agreement with the subprocessor which imposes the same obligations on the subprocessor as are imposed on the data importer under the Clauses. Where the subprocessor fails to fulfil its data protection obligations under such written agreement the data importer shall remain fully liable to the data exporter for the performance of the subprocessor's obligations under such agreement.

2. The prior written contract between the data importer and the subprocessor shall also provide for a third-party beneficiary clause as laid down in Clause 3 for cases where the data subject is not able to bring the claim for compensation referred to in paragraph 1 of Clause 6 against the data exporter or the data importer because they have factually disappeared or have ceased to exist in law or have become insolvent and no successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses.

3. The provisions relating to data protection aspects for subprocessing of the contract referred to in paragraph 1 shall be governed by the law of the Member State in which the data exporter is established.

4. The data exporter shall keep a list of subprocessing agreements concluded under the Clauses and notified by the data importer pursuant to Clause 5 (j), which shall be updated at least once a year. The list shall be available to the data exporter's data protection supervisory authority.

#### Clause 12: Obligation after the termination of personal data processing services
1. The parties agree that on the termination of the provision of data processing services, the data importer and the subprocessor shall, at the choice of the data exporter, return all the personal data transferred and the copies thereof to the data exporter or shall destroy all the personal data and certify to the data exporter that it has done so, unless legislation imposed upon the data importer prevents it from returning or destroying all or part of the personal data transferred. In that case, the data importer warrants that it will guarantee the confidentiality of the personal data transferred and will not actively process the personal data transferred anymore.

2. The data importer and the subprocessor warrant that upon request of the data exporter and/or of the supervisory authority, it will submit its data processing facilities for an audit of the measures referred to in paragraph 1.

### Appendix 1 to the Standard Contractual Clauses
Data exporter: Customer is the data exporter.

**Data importer:** The data importer is GitHub, Inc., a global producer of software and services.

**Data subjects:** Data subjects include the data exporter’s representatives and end-users including employees, contractors, collaborators, and customers of the data exporter. Data subjects may also include individuals attempting to communicate or transfer personal information to users of the services provided by data importer. GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following types of data subjects in the Customer Personal Data:

-   Employees, contractors and temporary workers (current, former, prospective) of data exporter;
-   Dependents of the above;
-   Data exporter's collaborators/contact persons (natural persons) or employees, contractors or temporary workers of legal entity collaborators/contact persons (current, prospective, former);
-   Users (e.g., customers, clients, patients, visitors, etc.) and other data subjects that are users of data exporter's services;
-   Partners, stakeholders or individuals who actively collaborate, communicate or otherwise interact with employees of the data exporter and/or use communication tools such as apps and websites provided by the data exporter;
-   Stakeholders or individuals who passively interact with data exporter (e.g., because they are the subject of an investigation, research or mentioned in documents or correspondence from or to the data exporter); or
-   Professionals with professional privilege (e.g., doctors, lawyers, notaries, religious workers, etc.).

**Categories of data:** The personal data transferred that is included in e-mail, documents and other data in an electronic form in the context of the Service.  GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following categories in the Customer Personal Data:
-   Authentication data (for example, username, email, password);
-   Contact information (for example, email);
-   Unique identification numbers and signatures (IP addresses, unique identifier in tracking cookies or similar technology).
-   Other unique identifying information. Data subjects may include more data such as real names, avatar images, and other personal information;

**Special categories of data (if appropriate):** The data importer does not intentionally collect or process any special categories of data in carrying out its services to the data exporter.

However, because the data importer provides storage services and does not control the categories of data it stores, the data exporter may choose to transfer special categories of data. Consequently, the data exporter is solely responsible for ensuring that it complies with all obligations imposed by applicable laws and regulations relating to the collection and processing of any special categories of data, including obtaining the explicit consent of the data subject prior to processing sensitive personal data.

**Processing operations:** The personal data transferred will be subject to the following basic processing activities: GitHub uses personal data for the limited purposes set forth in the GitHub Privacy Statement, available at [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), and the “Data Processing” section of the DPA. Subcontractors: In accordance with the DPA, the data importer may hire other companies to provide limited services on data importer’s behalf, such as providing customer support. Any such subcontractors will be permitted to obtain Customer Personal Data only to deliver the services the data importer has retained them to provide, and they are prohibited from using Customer Personal Data for any other purpose.

### Appendix 2 to the Standard Contractual Clauses
Description of the technical and organizational security measures implemented by the data importer in accordance with Clauses 4(d) and 5(c):

**1. Personnel.** Data importer’s personnel will not process Customer Personal Data without authorization. Personnel are obligated to maintain the confidentiality of any Customer Personal Data and this obligation continues even after their engagement ends.

**2. Data Privacy Contact.** The data privacy officer of the data importer can be reached at the following address: GitHub, Inc. Attn: Privacy 88 Colin P. Kelly Jr. Street San Francisco, CA 94107 USA

**3. Technical and Organization Measures.** The data importer has implemented and will maintain appropriate technical and organizational measures, internal controls, and information security routines intended to protect Customer Personal Data, as defined in the GitHub Security Exhibit, against accidental loss, destruction, or alteration; unauthorized disclosure or access; or unlawful destruction as follows: The technical and organizational measures, internal controls, and information security routines set forth in the GitHub Security Exhibit are hereby incorporated into this Appendix 2 by this reference and are binding on the data importer as if they were set forth in this Appendix 2 in their entirety. Signature of GitHub, Inc. appears below.

Signing the Standard Contractual Clauses, Appendix 1 and Appendix 2 on behalf of the data importer

![Screen Shot 2020-07-20 at 2 20 29 PM](/assets/images/help/site-policy/docusign-signature.png)

Lynn Hashimoto, Head of Product & Regulatory Legal

GitHub, Inc.


## SECURITY EXHIBIT

### 1. 信息安全计划。

#### 1.1 安全管理。

Throughout the duration of the Agreement, GitHub will maintain and enforce a written information security program (**"Security Program"**) that aligns with industry recognized frameworks; includes security safeguards reasonably designed to protect the confidentiality, integrity, availability, and resilience of Customer Protected Data; is appropriate to the nature, size, and complexity of GitHub's business operations; and complies with the Applicable Data Protection Laws and other specific information security related laws and regulations that are applicable to the geographic regions in which GitHub does business.

a. 安全官。 GitHub 指定了资深员工负责监管和执行其安全计划，以及负责关于信息安全事务的治理和内部沟通。

b. 安全计划更改。 GitHub 不会对其安全计划做出对任何客户受保护数据安全性有不利影响的更改，根据适用的法律和法规，更改需发出通知。

c. GitHub 将保持标准的安全行业做法，包括但不限于：

- 漏洞管理计划
- 安全开发培训、审查和代码编写实践
- 生产系统逻辑和物理访问控制
- 外部技术评估和审核
- 安全政策、标准和标准操作程序
- 安全和隐私意识培训


#### 1.2 Security Incident Management.
Throughout the duration of the Agreement, and where applicable, GitHub will provide a Security incident management program as follows:

a. 安全可用性和上报。 GitHub 将维护适当的全天候安全联系和上报流程，以确保客户和员工可以向 GitHub 安全团队提交问题。

b. 事件响应。 If GitHub becomes aware of a breach of security leading to the accidental or unlawful destruction, loss, alteration, unauthorized disclosure of, or access to Customer Personal Data (each a **"Security Incident"**), GitHub will promptly and without undue delay (1) notify Customer of the Security Incident; (2) investigate the Security Incident and provide Customer with detailed information about the Security Incident; (3) take reasonable steps to mitigate the effects and to minimize any damage resulting from the Security Incident.

c. 通知。 安全事件通知将通过 GitHub 选择的方式提交给客户的一个或多个管理员。 客户独自负责确保客户的管理员监控并回应任何通知。 客户独自负责履行事件通知法律下适用于客户的义务，并且履行与任何安全事件相关的任何第三方通知义务。

d. 合理协助。 GitHub 将采取商业合理的努力协助客户履行其在适用法律或法规下的义务，以向相关的监管机构和数据主体通知该等安全事件。

#### 1.3 Due Diligence over Subcontractors and Vendors.
GitHub will maintain appropriate due diligence when utilizing subcontractors and vendors. GitHub 将维护至少三年的供应商评估报告和任何评估工作。

#### 1.4 Data Center Physical Safeguards.
To the extent GitHub utilizes third party vendors to host production environments, GitHub will select vendors that comply with physical security controls outlined in industry standards and that issue an annual external audit report such as SOC 2 or ISO 27001 certification. 对电信区域、机箱或机架或者网络设备及其他“数据传输线路”或设备的访问的控制如下：

a. 访问将由一个或多个入口的胸卡读取器控制；

b. 仅用作出口的大门只有“单向”球形门拉手或安装有防护杆出口装置；

c. 所有大门配备有门报警器触点；

d. 所有出口门都有视频监控；以及

e. 所有读卡和视频系统都会连接到发电机或 UPS 备份系统。

### 2. 信息申请和合规报告。

#### 2.1 Requests for Information.
Upon Customer's written request and no more than once annually, GitHub will respond to one request for information to assess security and compliance risk-related information. 回应将在收到申请后三十天内以书面形式提供，任何申请需要澄清时待定。

#### 2.2 Response Contents.
GitHub will include in its annual response relevant audit reports for production datacenter, IaaS, PaaS or private hosting providers, as deemed relevant by GitHub, in its sole discretion and based on data and services rendered.

#### 2.3 GitHub Security Audit Report.
GitHub will execute external audits to produce a SOC1, type 2, audit report and a SOC2, type 2, audit report. GitHub 将在协议期限内继续每年至少执行一次审核并发布相应的报告。

### 3. 配合监管审计。
Should Customer realize a regulatory audit or an audit in response to a Supervisory Authority that requires participation from GitHub, GitHub will fully cooperate with related requests by providing access to relevant knowledgeable personnel, documentation, and application software. 客户对任何此类监管或主管机关审计具有以下责任：

a. 客户必须确保使用独立第三方（意指监管者或监管者的代表），并且客户不能访问与其不相关的发现和数据。

b. 该等审计通知必须是书面的，并且要及时提供给 GitHub，等待监管者通知，并且允许适当人员提供协助。 当监管机构未提前向客户通知审计或调查时，GitHub 将及时按照监管机构的要求回应。

c. 任何第三方审计机构必须在监管机构允许的范围向 GitHub 披露任何发现和建议的措施。

d. 在监管审计时，只允许在正常上班时间（太平洋时间）访问。

e. 在法律允许的范围内，客户必须对通过 GitHub 任何该等审计收集的性质为机密的任何信息保密。
