---
title: GitHub 社区指导方针
redirect_from:
  - /community-guidelines/
  - /articles/github-community-guidelines
versions:
  free-pro-team: '*'
---

数百万开发者在 GitHub 上托管了数百万个项目，包括开源和闭源项目，我们很荣幸能够为促进社区的日常协作发挥作用。 走在一起，我们都有机会和责任让这个社区成为我们值得骄傲的地方。

GitHub 的用户来自世界各地，有上周才创建其第一个 "Hello World" 项目的新人，也有享誉全球的软件开发高手，他们带来了各种不同的观点、想法和经验。 我们致力于让 GitHub 成为一个海纳百川的环境，接纳各种不同的声音和观点，打造一个所有人都能畅所欲言的空间。

我们依靠社区成员传达期望、[仲裁](#what-if-something-or-someone-offends-you)他们的项目以及{% data variables.contact.report_abuse %}或{% data variables.contact.report_content %}。 我们不主动寻求仲裁内容。 通过概述我们期望社区内出现的情况，我们希望帮助您理解如何在 GitHub 上进行最佳的协作，以及哪种操作或内容可能违反我们的[服务条款](#legal-notices)。 我们将调查任何滥用举报，并且可能在我们的网站上仲裁我们确定违反了 GitHub 服务条款的公共内容。

### 建立强大的社区

GitHub 社区的主要目的是协作处理软件项目。 我们希望人们能够更好地协作。 虽然我们维护网站，但这实际上是我们一起构建的*社区*，我们需要大家共同将其打造成最好的工具。

* **包容开放** - 其他协作的经验水平或背景可能与您不同，但这并不意味着他们不能贡献好的想法。 鼓励大家欢迎新的协作者和刚入门的新手。

* **互相尊重。**粗鲁是正常对话的天敌。 保持礼貌和专业，不要发表被理性的人视为冒犯、侮辱或仇恨的言论。 不要骚扰或打击任何人。 在所有互动中应互相尊重和体谅。

  您可能要发表反对的意见。 没问题。 但请记住，您的批评要对事不对人。 不要说脏话、人身攻击、纠结于帖子的语气而罔顾其实际内容或制造下意识的矛盾。 而应该提供合理的反驳论据，保持友善的对话。

* **共情沟通** - 意见相左或分歧是生活中的常态。 作为社区的一部分，意味着您要与各种背景和观点的人互动，其中许多人的观点可能与您不同。 如果您不同意某人的观点，请先试图理解他们并体会他们的情感，然后再发表意见。 这将有助于营造尊重和友好的氛围，让人舒适自在地提出问题、参与讨论和做出贡献。

* **清楚明确，紧扣主题** - 人们使用 GitHub 的目的是完成工作和提高效率。 脱离主题的评论对于完成工作和取得成效是一种干扰（有时可能受欢迎，但这种情况很少）。 紧扣主题有助于产生积极和富有成效的讨论。

   此外，在互联网上与陌生人交流可能并不容易。 很难传达或读懂语气，容易被误解为嘲讽。 尽可能清晰表达，并考虑其他人如何理解您的表达。

### 如果某事或某人冒犯您会怎么样？

我们通过社区来了解何时需要解决问题。 我们不主动监控网站上的冒犯性内容。 如果您发现网站上有您反感的某事或某人，GitHub 提供了以下工具帮助您立即采取行动：

* **传达期望** - 如果您参与一个没有设置其社区特定指南的社区，请提交拉取请求来建议他们在 README 或 [CONTRIBUTING 文件](/articles/setting-guidelines-for-repository-contributors/)中说明， 或者在[专用行为守则](/articles/adding-a-code-of-conduct-to-your-project/)中规定。

* **仲裁评论** - 如果您对仓库拥有 [写入权限](/articles/repository-permission-levels-for-an-organization/)，则可以编辑、删除或隐藏任何人对提交、拉取请求和议题的评论。 对仓库具有读取权限的任何人都可查看评论的编辑历史记录。 评论作者和具有仓库写入权限的人员可以删除评论编辑历史记录中的敏感信息。 更多信息请参阅“[追踪评论中的变化](/articles/tracking-changes-in-a-comment)”和“[管理破坏性评论](/articles/managing-disruptive-comments)”。

* **锁定对话**- 如果某个议题或拉取请求中的讨论失控，您可以[锁定对话](/articles/locking-conversations/)。

* **阻止用户** - 如果您遇到一个连续表现出不良行为的用户，可以[阻止该用户访问您的个人帐户](/articles/blocking-a-user-from-your-personal-account/)或[阻止该用户访问您的组织](/articles/blocking-a-user-from-your-organization/)。

当然，如果您需要更多关于处理某种情况的帮助，可随时联系我们以{% data variables.contact.report_abuse %}。

### 不允许什么？

我们致力于维持一个用户能够自由表达意见并对彼此想法（包括技术和其他方面）提出挑战的社区。 但当思想被压制时，这种讨论不可能促进富有成果的对话，因为因为社区成员被禁声或害怕说出来。 因此，您应该始终尊重他人，言行文明，不要对他人有任何人身攻击以谁为由攻击他人。 我们不容忍以下越界行为：

* **暴力威胁** - 不得暴力威胁他人，也不得利用网站组织、宣传或煽动现实世界中的暴力或恐怖主义行为。 仔细考虑您使用的文字、发布的图像、编写的软件以及其他人会如何解读它们。 即使您只是开个玩笑，但别人不见得这样理解。 如果您认为别人*可能*会将您发布的内容解读为威胁或者煽动暴力或恐怖主义， 不要在 GitHub 上发布。 在非常情况下， 如果我们认为可能存在真正的人身伤害风险或公共安全威胁，我们可能会向执法机构报告暴力威胁。

* **仇恨言论和歧视** - 虽然不禁止谈论年龄、身材、能力、种族、性别认同和表达、经验水平、国籍、外貌、民族、宗教或性认同和性取向等话题，但我们不允许基于身份特征攻击任何个人或群体。 只要认识到以一种侵略性或侮辱性的方式处理这些（及其他）敏感的专题，就可能使其他人感到不受欢迎甚至不安全。 虽然总是存在误解的可能性，但我们期望社区成员在讨论敏感问题时保持尊重和平静。

* **欺凌和骚扰** - 我们不容忍欺凌或骚扰。 这意味着我们不允许针对任何特定个人或群体的典型骚扰或恐吓行为。 一般来说，如果您屡次三番采取多余的行动，就很可能走进了欺凌或骚扰的歧途。

* **冒充** - 不得通过复制他人头像、在他人的电子邮件地址下发布内容、使用类似的用户名或以他人身份发帖等方式来误传您的身份。 冒充是骚扰的一种形式。

* **人肉和侵犯隐私** - 不得发布他人的个人信息，例如电话号码、私人电子邮件地址、实际地址、信用卡号码、社会保障/国民身份号码或密码。 根据具体情况，例如在恐吓或骚扰的情况下，我们可能会认为发布他人信息（例如未经当事人同意而拍摄或散发的照片或视频）是侵犯隐私的行为，特别是当此类材料会给当事人带来安全风险时。

* **性淫秽内容** - 不得发布色情内容。 但这并不意味着禁止一切裸体或与性有关的所有代码和内容。 我们认识到，性行为是生活的一部分，非色情的性内容可能是您项目的一部分，或者出于教育或艺术目的而呈现。 我们不允许淫秽性内容或可能涉及利用或性化未成年人的内容。

* **过激的暴力内容** - 不得在没有合理的上下文或警告的情况下发布暴力图像、文本或其他内容。 在视频游戏、新闻报道以及对历史事件的描述中通常可以包含暴力内容，但我们不允许不加选择地发布暴力内容，或者以其他用户很难避开的方式发布（例如头像或议题评论）。 在其他情况下发布明确警告或免责声明有助于用户就他们是否想要参与这类内容作出明智的决定。

* **错误信息和虚假信息** - 不得发布歪曲现实的内容，包括不准确或虚假的信息（错误信息），或者故意欺骗的信息（假信息），因为这种内容可能伤害公众，或者干扰所有人公平和平等参与公共生活的机会。 例如，我们不允许可能危及群体福祉或限制他们参与自由和开放社会的内容。 鼓励积极参与表达想法、观点和经验，不得质疑个人帐户或言论。 我们通常允许模仿和讽刺，但要符合我们的“可接受使用政策”，而且我们认为上下文对于如何接收和理解信息很重要；因此，通过免责声明或其他方式澄清您的意图以及您的信息的来源，可能是适当的做法。

* **主动恶意软件或漏洞利用程序** - 本社区不允许恶意利用社区的其他成员。 我们不允许任何人利用我们的平台传递漏洞利用程序（例如，利用 GitHub 传递恶意的可执行文件）或攻击基础设施（例如，组织拒绝服务攻击或支配命令和控制服务器）。 但请注意，我们不禁止发布可用于开发恶意软件或漏洞利用程序的源代码，因为此类源代码的发布和分发具有教育价值，并且能够为安全社区带来净收益。


### 如果有人违反规则会怎么样？

当用户举报不当行为或内容时，我们可能会采取各种措施。 它通常取决于特定案例的确切情况。 我们知道，有时人们可能会出于各种原因而去说或去做一些不适当的事情。 也许他们并未意识到自己的言论会被如何解读。 或者他们只是想让自己的情绪得到宣泄。 当然，有时候，有些人只是想散发垃圾信息或存心捣乱。

每种情况都需要采用不同的方法，我们会努力调整对策，以满足报告的具体情况的需要。 我们将逐案审查每一份滥用报告。 在每个案例中，我们都会安排一个多元化的团队，调查内容及相关事实，并以本行为准则为决策指导，采取适当的措施。

为响应滥用举报，我们可能采取的措施包括但不限于：

* 删除内容
* 屏蔽内容
* 帐户暂停
* 帐户终止

### 法律声明

我们将这些社区指导方针专用于公共领域，让所有人根据 [CC0-1.0](https://creativecommons.org/publicdomain/zero/1.0/) 的条款使用、重新使用、调整或适应。

这些只是指导方针；不影响我们的[服务条款](/articles/github-terms-of-service/)，也不打算作为完整的清单。 GitHub 保留根据[服务条款](/articles/github-terms-of-service/#c-acceptable-use)完全酌处的权利，可以删除任何内容或终止其活动违反我们可接受使用条款的任何帐户。 这些指导方针说明了我们何时将行使这一酌处权。
