---
title: GitHub 附加产品条款
versions:
  free-pro-team: '*'
---

创建帐户后，您有权访问许多不同的功能和产品，它们都是服务的一部分。 由于其中许多功能和产品具有不同的功能，因此可能需要特定于该功能或产品的附加条款和条件。 下面，我们列出了这些功能和产品，以及适用于服务中这些部分的相应附加规则。

使用 GitHub 必须遵守适用的条款（“协议”）和以下 GitHub 附加产品条款（“附加条款”）。 同意协议并使用附加产品和功能，即表示您也同意这些附加条款。 任何违反附加条款的行为都构成违反协议。 附加条款中未定义的大写术语，将采用协议中规定的含义。

### 1. Marketplace

如果您通过 GitHub Marketplace 上架开发者产品，则在提交要上架的项目之前，您必须同意 [GitHub Marketplace 开发者协议](/github/site-policy/github-marketplace-developer-agreement)。

如果您通过 GitHub Marketplace 购买开发者产品，则 [GitHub Marketplace 服务条款](/github/site-policy/github-marketplace-terms-of-service)将管制您的购买。 协议和 [GitHub Marketplace 服务条款](/github/site-policy/github-marketplace-terms-of-service)将管辖您对 GitHub Marketplace 的使用。

### 2. 第三方集成

#### a. 创建应用程序
如果您要创建可收集用户个人信息或用户生成内容，并通过 GitHub 的 API、OAuth 机制或其他方式与服务集成的第三方应用程序或其他开发者产品（“开发者产品”），则必须遵守以下要求：
- 您必须遵守本协议和 GitHub 隐私声明。
- 您收集的用户个人信息或用户生成内容只能用于用户授权的目的，除非法律或许可另有准许。
- 您必须采取所有合理的安全措施，防范在处理用户个人信息或用户生成内容时面临的风险，例如意外或非法破坏、意外丢失、篡改、未经授权的披露或访问等风险。
- 您不得自称代表 GitHub 收集任何用户个人信息或用户生成内容，必须向用户充分披露您的隐私实践，例如发布隐私政策。
- 您必须向用户提供有效的方法，以便在通过 GitHub 收集的任何用户个人信息或用户生成内容不再需要用于用户授权的有限、指定目的之后，他们可以删除这些信息，法律要求保留或通过其他方式（如通过许可）允许保留的除外。

#### b. 使用第三方应用程序
您可以授权开发者产品使用、访问和披露您仓库（包括私有仓库）的内容。 有些开发者产品通过 [GitHub Marketplace](https://github.com/marketplace) 提供。 有些开发者产品可用于执行自动化任务，通常有多个用户可指示开发者产品的操作。 但是，如果您用自己的帐户购买和/或设置开发者产品，或者您是具有集成开发者产品的帐户之所有者，则您应对在您的帐户上或通过您的帐户执行的开发者产品操作负责。 请参阅我们的[隐私声明](/github/site-policy/github-privacy-statement#third-party-applications)，了解有关我们如何与开发者产品共享数据的更多信息。

**GitHub 对开发者产品不做任何形式的担保，对于经您授权可访问您内容的第三方之披露行为不承担任何责任。 您使用任何第三方应用程序均应自担风险。**

### 3. Git LFS 支持

如果您在帐户上启用了 Git Large File Storage ("Git LFS")，就可以像处理 Git 管理的任何文件一样获取、修改和推送大文件。 您的帐户自带一定数量的可用于 Git LFS 的带宽和存储空间，具体数量可查阅 [Git LFS 文档](/github/managing-large-files/about-storage-and-bandwidth-usage)。 Git LFS 带宽和存储用量显示在您的[帐户设置](https://github.com/settings/billing)中。 如果要超出分配的带宽和存储空间使用 Git LFS，您可以[购买额外的数据包](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage)。

### 4. 页面

每个 GitHub 帐户都可以访问 [GitHub Pages 静态托管服务](/github/working-with-github-pages/about-github-pages)。 这种托管服务旨在为所有用户托管静态网页，但主要用作个人和组织项目的展示。 页面上允许一些货币化工作，如捐款按钮和筹款链接。

GitHub Pages 受某些特定带宽和使用限制的约束，可能不适用于某些高带宽用途或其他禁止用途。 请参阅我们的 [GitHub Pages 指南](/github/working-with-github-pages/about-github-pages)了解更多信息。 GitHub 保留随时收回任何 GitHub 子域而不承担任何责任的权利。

### 5. Actions 和 Packages

#### a. Actions 的使用
GitHub Actions 使您能够直接在您的 GitHub 仓库中创建自定义软件开发生命周期工作流程。 每个帐户都自带可用于 Actions 的计算和存储空间，具体数量取决于您的帐户计划，可在 [Actions 文档](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions)中查阅。 Actions 的计算用量显示在[您的帐户设置](https://github.com/settings/billing)中，在达到自带空间的上限之前您会收到电子邮件通知。 如果要超出自带空间使用 Actions，您可以[启用超限](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions)。

自带和付费空间的计算用量以分钟为单位计算，具体取决于您执行的 Actions 类型（例如 Linux、Windows、macOS）。 每个 Action 的作业或任务所用的时间将取整到最接近的分钟数。 要判断自带空间是否充足，可以用倍数乘以执行每个作业或任务所用的时间量（取整之前），具体取决于 Action 的类型。 超限分钟数按[规定的每分钟价格](https://github.com/features/actions)收费，具体取决于您执行的 Actions 类型。 Actions 和 Packages 共用存储空间，您的存储空间用量显示在您的[帐户设置](https://github.com/settings/billing)中。 有关自带空间用量计算的更多信息，请参阅 [Actions 文档](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions)。

对 Actions 和任何 Action 服务元素的使用，不得违反协议、[可接受使用政策](/github/site-policy/github-acceptable-use-policies)或 GitHub Actions [服务限制](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits)。 此外，Actions 不得用于：
- 密码破解;
- 使用我们的服务器破坏、非授权访问或尝试非授权访问任何服务、设备、数据、帐户或网络（[GitHub 漏洞赏金计划](https://bounty.github.com)授权的活动除外）；
- the provision of a stand-alone or integrated application or service offering Actions or any elements of Actions for commercial purposes;
- any activity that places a burden on our servers, where that burden is disproportionate to the benefits provided to users (for example, don't use Actions as a content delivery network or as part of a serverless application, but a low benefit Action could be ok if it’s also low burden); or
- 与使用 GitHub Actions 的仓库相关的软件项目创建、测试、部署或发布无关的任何其他活动。

为防止违反这些限制和滥用 GitHub Actions，GitHub 可能会监视您对 GitHub Actions 的使用。 滥用 GitHub Actions 可能会导致作业终止，或者您使用 GitHub Actions 的权限受限。

#### b. Packages 的使用
GitHub Packages 可用于下载、发布和管理内容包。 每个帐户计划都自带可用于 Packages 的带宽和存储空间，具体数量可查阅 [Packages 文档](/github/managing-packages-with-github-package-registry/about-github-package-registry)。 Actions 和 Packages 共用这两个服务功能之间的存储空间。 存储和带宽用量显示在您的[帐户设置](https://github.com/settings/billing)中，在达到自带空间的上限之前您会收到电子邮件通知。 如果要超出自带的带宽和存储空间使用 Packages，您可以[启用超限](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages)。

带宽用量根据仓库中通过 Packages 传出的数据量计算，但是通过 Actions 的包传输不会计入您的自带或付费数量。 Packages 带宽使用受[可接受使用政策](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use)约束，自带的带宽空间由您的[帐户计划](https://github.com/pricing)确定。

Actions 和 Packages 存储用量是这两个服务功能之间的共用量。 存储用量按一个月的加权平均数计算，不会每月重置。 公共和私有仓库的自带存储空间不同，私有仓库的自带空间取决于您的[帐户计划](https://github.com/pricing)。

#### c. Actions 和 Packages 的付款与计费
Actions 和 Packages 根据用量计费。 不能单独购买额外的 Actions 或 Packages 数量。  对于按月计费的客户，必须有记录在档的付款方式才能选择支付这些服务功能的额外数量。 除非您是按发票计费的客户，否则将根据您上个月的用量每月定期向您收费。 对于发票客户，必须在 GitHub 发票日期后的三十 (30) 天内支付费用。 对于预付服务功能超限费用的客户，未使用的预付分钟数不会结转到下一个计费期，也不会退款。

您可以在[帐户设置](https://github.com/settings/billing/cost_management)中设置每月支出限额。 在达到自带空间上限和指定的付费额外数量支出限额之前，您会收到电子邮件通知。

### 6. Learning Lab

**注册。**为了完成在 Learning Lab for Organizations 的注册，您同意为 Learning Lab 单独创建一个组织，并且您授权我们代表您添加 Learning Lab 课程材料到该组织。

**Learning Lab 课程材料。**GitHub 提供的任何课程材料完全归 GitHub 所有；但 GitHub 授予您全球、非独占、有限期、不可转让、免版税的许可，允许您出于与 Learning Lab 使用相关的内部业务目的而复制、维护、使用和运行这些材料。 许可的授予受限于与源代码一起提供的任何附加开源许可协议。  您创建的课程材料完全归您所有，但是您授予 GitHub 全球、非独占、永久、不可转让、免版税的许可，允许 GitHub 复制、维护、使用、托管以及在服务上运行这些课程材料。 您对 GitHub 课程材料的使用以及对自己课程材料的创建和存储并不构成对方对任一方各自知识产权的共同所有权。

**隐私。**Learning Lab 可能收集个人信息。 您可以在 GitHub.com 配置文件设置面板中控制 Learning Lab 可以收集的信息。 如果 Learning Lab 代表 GitHub 收集个人信息，GitHub 将根据 [GitHub 隐私声明](/github/site-policy/github-privacy-statement)处理这些信息。 如果您通过 Learning Lab 注册或正在学习私人课程，GitHub 可能与组织管理员分享您的注册信息和课程完成进度。 这可能包括您的 GitHub 用户名、课程开始日期和课程结束日期等个人数据。 为帮助引导改进课程内容，还可能以汇总形式显示课程完成数据。

### 7. Connect

要访问 GitHub Connect，客户必须至少在 GitHub.com 上有一 (1) 个帐户以及一 (1) 个许可的软件实例。 GitHub Connect 可用于执行自动化任务。 此外，多个用户可通过 GitHub Connect 导向某些操作。 客户对通过其帐户执行的操作负责。 GitHub 可收集有关客户如何使用 GitHub Connect 的信息，以提供和改进功能。 只要使用 GitHub Connect，即表示客户授权 GitHub 从客户的 GitHub Enterprise Server 帐户收集受保护的数据，包括私人仓库数据和用户个人信息（如“GitHub 隐私声明”中定义）。 客户还授权将识别实例信息通过 GitHub Connect 传输到 GitHub，这些信息受“GitHub 隐私声明”管辖。

### 8. 赞助计划

要成为被赞助的开发者，必须同意 [GitHub 赞助计划附加条款](/github/site-policy/github-sponsors-additional-terms)。

### 9. GitHub Advanced Security

GitHub Advanced Security 帮助您通过可自定义的自动化语义学代码分析来识别安全漏洞。 GitHub Advanced Security 逐用户许可。 如果您将 GitHub Advanced Security 用作 GitHub Enterprise Cloud 的一部分，GitHub Advanced Security 的许多功能（包括对私有仓库的自动化代码扫描）还需要使用 GitHub 操作。 对 GitHub 操作使用情况的计费以使用为基础，必须遵守 [GitHub 操作条款](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages)。

### 10. Dependabot Preview

使用 Dependabot Preview 必须遵守单独的[服务条款](https://dependabot.com/terms)和[隐私政策](https://dependabot.com/privacy)。

### 11. Spectrum

使用 Spectrum 必须遵守 GitHub [服务条款](/github/site-policy/github-terms-of-service)和[隐私声明](/github/site-policy/github-privacy-statement)。

### 12. Advisory Database

#### a. 向我们授予许可

我们需要适当的法律权利，才能将您对 GitHub Advisory Database 的贡献提交到公共域数据集，例如[国家漏洞数据库](https://nvd.nist.gov/)，并在开放的条款下许可 GitHub Advisory Database，以供安全研究人员、开源社区、行业和公众使用。 您需要同意根据[知识共享零许可](https://creativecommons.org/publicdomain/zero/1.0/)原则发布您对 GitHub Advisory Database 的贡献。

#### b. GitHub Advisory Database 的许可

GitHub Advisory Database 的许可采用[知识共享署名 4.0 许可](https://creativecommons.org/licenses/by/4.0/)原则。 有关署名条款，请参阅 <https://github.com/advisories> 上的 GitHub Advisory Database，或者所使用的单独 GitHub Advisory Database 记录（以 <https://github.com/advisories> 为前缀）。

