---
title: About writing and formatting on GitHub
intro: GitHub combines a syntax for formatting text called GitHub Flavored Markdown with a few unique writing features.
redirect_from:
  - /articles/about-writing-and-formatting-on-github
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

[Markdown](http://daringfireball.net/projects/markdown/) is an easy-to-read, easy-to-write syntax for formatting plain text.

We've added some custom functionality to create {% data variables.product.prodname_dotcom %} Flavored Markdown, used to format prose and code across our site.

You can also interact with other users in pull requests and issues using features like [@mentions](/articles/basic-writing-and-formatting-syntax/#mentioning-people-and-teams), [issue and PR references](/articles/basic-writing-and-formatting-syntax/#referencing-issues-and-pull-requests), and [emoji](/articles/basic-writing-and-formatting-syntax/#using-emoji).

### Text formatting toolbar

Every comment field on {% data variables.product.product_name %} contains a text formatting toolbar, allowing you to format your text without learning Markdown syntax. In addition to Markdown formatting like bold and italic styles and creating headers, links, and lists, the toolbar includes {% data variables.product.product_name %}-specific features such as @mentions, task lists, and links to issues and pull requests.

![Markdown toolbar](/assets/images/help/writing/markdown-toolbar.gif)

### Дополнительная литература

- [{% data variables.product.prodname_dotcom %} Flavored Markdown Spec](https://github.github.com/gfm/)
- "[Basic writing and formatting syntax](/articles/basic-writing-and-formatting-syntax)"
- "[Working with advanced formatting](/articles/working-with-advanced-formatting)"
- "[Mastering Markdown](https://guides.github.com/features/mastering-markdown/)"
