---
title: GitHub Trademark Policy
redirect_from:
  - /articles/github-trademark-policy
versions:
  free-pro-team: '*'
---

### What is a GitHub Trademark Policy Violation?

Using a company or business name, logo, or other trademark-protected materials in a manner that may mislead or confuse others with regard to its brand or business affiliation may be considered a trademark policy violation.

### What is not a GitHub Trademark Policy Violation?

Using another's trademark in a way that has nothing to do with the product or service for which the trademark was granted is not a trademark policy violation. GitHub user names are available on a first come, first served basis and may not be reserved. A GitHub account with a user name that happens to be the same as a registered trademark is not, by itself, necessarily a violation of our trademark policy.

### How Does GitHub Respond To Reported Trademark Policy Violations?

When we receive reports of trademark policy violations from holders of federal or international trademark registrations, we review the account and may take the following actions:

* When there is a clear intent to mislead others through the unauthorized use of a trademark, GitHub will suspend the account and notify the account holder.
* When we determine that an account appears to be confusing users, but is not purposefully passing itself off as the trademarked good or service, we give the account holder an opportunity to clear up any potential confusion. We may also release a username for the trademark holder's active use.

### How Do I Report a Trademark Policy Violation?

Holders of registered trademarks can report possible trademark policy violations to GitHub via our [contact form](https://support.github.com/contact). Please submit trademark-related requests using your company email address and include all the information requested below to help expedite our response. Also be sure to clearly describe to us why the account may cause confusion with your mark or how the account may dilute or tarnish your mark.

### What Information is Required When Reporting Trademark Policy Violations?

In order to investigate trademark policy violations, please provide all of the following information:

* Username of the reported account
* Your company name
* Your company GitHub account (if there is one)
* Company website
* Your trademarked word, symbol, etc.
* Trademark registration number
* Trademark registration office (e.g., USPTO)
* Description of confusion (e.g., passing off as your company, including specific descriptions of content or behavior)
* Requested Action (e.g., removal of violating account or transfer of trademarked username to an existing company account)
* Include the following statement: "I have a good faith belief that use of the trademark described above is not authorized by the trademark owner, or its agent, or the law. I have taken nominative and other fair uses into consideration."
* Also include the following statement: "I swear, under penalty of perjury, that the information in this notification is accurate and that I am the trademark owner, or am authorized to act on behalf of the owner, of an exclusive right that is allegedly infringed."
* Include your physical or electronic signature.

* Note: A federal or international trademark registration number is required. If the name you are reporting is **not** a registered mark (e.g., a government agency or non-profit organization), please let us know:
    * Your first and last name
    * Title
    * Address
    * Phone
    * Email (must be from company domain)
