---
title: GitHub Supplemental Terms for Microsoft Volume Licensing
redirect_from:
  - /articles/GitHub-Supplemental-Terms-for-Microsoft-Volume-Licensing/
  - /articles/github-supplemental-terms-for-microsoft-volume-licensing
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

The following GitHub Supplemental Terms (including any applicable Order Forms) supplement Customer's Microsoft volume licensing agreement ("**Microsoft Customer Agreement**") and, together with the Microsoft Customer Agreement, govern Customer's use of the Products (as defined below). The Microsoft Customer Agreement is incorporated herein by this reference.  Capitalized terms used but not defined in these supplemental terms have the meanings assigned to them in the Microsoft Customer Agreement.

These Supplemental Terms apply to the following GitHub Offerings, as further defined below (collectively, the "**Products**"):

-   GitHub Enterprise (comprised of GitHub Enterprise Server, which may include Add-on Software, and GitHub Enterprise Cloud) and GitHub One;

-   Any related Support; and

-   Any related Professional Services.

These GitHub Supplemental Terms include the following Sections and Exhibits, each of which is incorporated by reference herein:

* SECTION 1: GitHub Enterprise Server License Terms;

* SECTION 2: GitHub Enterprise Cloud Terms of Service;

* SECTION 3: General Provisions; and

* EXHIBIT A: Definitions.



## SECTION 1: GITHUB ENTERPRISE SERVER LICENSE TERMS

This Section 1 details terms applicable to Customer’s use of the Software.

### 1.1 License Grant.

GitHub grants to Customer a non-exclusive, non-transferable, worldwide, royalty-free, limited-term license to install and use the Software for Customer’s internal business purposes during the applicable Subscription Term, in accordance with the Documentation, and only for the number of Subscription Licenses stated in Customer’s Order Form. The Software includes components licensed to GitHub by third parties, including software whose licenses require GitHub to make the source code for those components available. The source code for such components will be provided upon request. Without limiting the foregoing, this license permits Customer to download and run Microsoft SQL Server Standard Edition container image for Linux files (“**SQL Server Images**”), which may be used only with the Software as documented. Customer’s right to use the SQL Server Images ends when Customer no longer has rights to use the Software, and Customer must uninstall the SQL Server Images when its right to use them ends. Microsoft Corporation may disable SQL Server Images at any time.

### 1.2 Restrictions.

Except as expressly permitted by law or by applicable third-party license, Customer and its Affiliates must not and must not allow any third party to: (i) sublicense, sell, rent, lease, transfer, assign, or redistribute the Software; (ii) host the Software for the benefit of third parties; (iii) disclose or permit any third party to access the Software, except as expressly permitted in this Section 1; (iv) hack or modify the License Key, or avoid or change any license registration process; (v) except for Customer Modifications, modify or create derivative works of the Software, or merge the Software with other software; (vi) disassemble, decompile, bypass any code obfuscation, or otherwise reverse engineer the Software or attempt to derive any of its source code, in whole or in part; (vii) modify, obscure, or delete any proprietary rights notices included in or on the Software or Documentation; or (viii) otherwise use or copy the Software or Documentation in a manner not expressly permitted by these GitHub Supplemental Terms.

### 1.3 Delivery.

GitHub will make the License Key available for Customer to download on a secure, password-protected website. All deliveries under this Section 1 will be electronic. For the avoidance of doubt, Customer is responsible for installation of any Software and acknowledge that GitHub has no further delivery obligation with respect to the Software after delivery of the License Key. As Updates become available, GitHub will make those available for download on the same website. Customer must Update the Software on a commercially reasonable basis but no less than one (1) time per year. Customer is responsible for maintaining the confidentiality of Customer’s usernames and passwords.

### 1.4 Verification.

At GitHub's request, Customer will promptly provide GitHub with a Software-generated report verifying that Customer is using the Software in accordance with these GitHub Supplemental Terms. GitHub will invoice Customer for any additional use, effective from the date its use first exceeded the terms of these GitHub Supplemental Terms.

### 1.5 Support

GitHub will provide technical support for the Software as further described in the Microsoft Customer Agreement. GitHub may provide enhanced Support offerings for the Software and Service (including the Premium, Premium Plus, and Engineering Direct Support offerings) in accordance with the [Support terms](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), and at the Support level, Fees, and Subscription Term specified in an Order Form or SOW. Notwithstanding anything to the contrary in the Microsoft Customer Agreement, (i) GitHub will use reasonable efforts to correct any material, reproducible errors in the Software upon Customer's notification of an error but will not be responsible for providing Support where (a) someone (other than GitHub) modifies the Software; (b) Customer changes its operating system or environment in a way that adversely affects the Software or its performance; (c) Customer uses the Software in a manner other than as authorized under the Microsoft Customer Agreement, this Section 1 or the Documentation; or (d) there is a Customer accident or negligence, or misuse of the Software; and (ii) GitHub will only Support a given Release for one (1) year from the original Release date, or six (6) months from the last Update of the Release, whichever is longer.

### 1.6 Updates; Releases.

#### 1.6.1 Generally.

GitHub will make Updates and Releases to the Software available to Customer on the same secure website where Customer downloaded the Software and the License Key.

#### 1.6.2 Supported Releases.

GitHub will only Support a given Release of the Software for one (1) year from the original Release date, or six (6) months from the last Update of the Release, whichever is longer. If Customer requires Support for earlier Releases of the Software, then Customer must pay for that Support in accordance with the terms of a mutually agreed upon Order Form or SOW.

### 1.7 Add-On Software.

Add-On Software is licensed on a per User basis. For the avoidance of doubt, and unless otherwise set forth in an Order Form, the number of Subscription Licenses Customer has at any given time for Add-On Software must equal the number of Subscription Licenses Customer has for the Products under this Agreement. For example, if Customer wishes to purchase a subscription to Insights and already holds Subscription Licenses for 100 Users for the Products, it must purchase Subscription Licenses for 100 Users for Insights.

### 1.8 Data Protection Considerations for Use of GitHub Insights and Learning Lab for Enterprise Server.

If Customer’s planned use of GitHub Insights or Learning Lab for Enterprise Server involves processing personal data, Customer is solely responsible for determining whether or not to complete a data protection impact assessment or otherwise secure formal legal analysis of Customer’s planned use. It is in Customer’s sole discretion whether to use GitHub Insights or Learning Lab for Enterprise Server to process Customer’s employees’ and/or users’ data, and if Customer does so, Customer is solely responsible for conducting such processing in compliance with applicable law.

### 1.9 Limited Software Warranty.

GitHub warrants that, for ninety (90) days from the date it is made available for initial download, the unmodified Software will substantially conform to its Documentation. GitHub does not warrant that Customer's use of the Software will be uninterrupted, or that the operation of the Software will be error-free. This warranty will not apply if Customer modifies or uses the Software in any way that is not expressly permitted by this Section 1 and the Documentation. GitHub's only obligation, and Customer's only remedy, for any breach of this limited warranty will be as set forth in the Microsoft Customer Agreement.

## SECTION 2: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 2 details terms applicable to Customer’s use of the Service.

### 2.1 Account Terms.

#### 2.1.1 Account Controls.

  **(i) Users.** Customer acknowledges that Users retain ultimate administrative control over their individual accounts and the Content within them. [GitHub's Standard Terms of Service](/github/site-policy/github-terms-of-service) govern Users' use of the Service, except with respect to Users' activities under this Section 2.

  **(ii) Organizations.** Customer retains ultimate administrative control over any Organization created on Customer’s behalf and User-Generated Content posted to the repositories within its Organization(s), subject to this Section 2. This Section 2 will govern the use of Customer’s Organization(s).

#### 2.1.2 Account Requirements.

In order to create an account, Customer must adhere to the following:

**(i)** Customer must not create an account for use of any person under the age of 13. If GitHub learns of any User under the age of 13, it will terminate that User's account immediately. If Customer or its User(s) are located in a country outside the United States, that country's minimum age may be older; in such a case, Customer is responsible for complying with that country's laws.

**(ii)** A User’s login may not be shared by multiple people.

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. For more information, please see [GitHub’s Trade Controls policy](/github/site-policy/github-and-trade-controls).

#### 2.1.3 Account Security.

Customer is responsible for: (i) all Content posted and activity that occurs under its Corporate Account; (ii) maintaining the security of its account login credentials; and (iii) promptly [notifying GitHub](https://support.github.com/contact) upon becoming aware of any unauthorized use of, or access to, the Service through its account.  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 2.1.3.

#### 2.1.4 Additional Terms.

In some situations, third parties' terms may apply to Customer’s use of the Service. For example, Customer may be a member of an Organization with its own terms or license agreements; Customer may download an application that integrates with the Service; or Customer may use the Service to authenticate to another service. While the Microsoft Customer Agreement, including these GitHub Supplemental Terms, are GitHub's full agreement with Customer, other parties' terms govern their relationships with Customer.

#### 2.1.5 U.S. Federal Government Terms.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/github/site-policy/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 2.2 Compliance with Laws; Acceptable Use; Privacy.

#### 2.2.1 Compliance with Laws and Regulations.

Customer’s use of the Service must not violate any applicable laws, including copyright or trademark laws, export control laws, or regulations in its jurisdiction.

#### 2.2.2 Acceptable Use.

Customer’s use of the Service must comply with [GitHub's Acceptable Use Policies](/github/site-policy/github-acceptable-use-policies) and [GitHub’s Community Guidelines](/github/site-policy/github-community-guidelines). Customer must not use the Service in any jurisdiction for unlawful, obscene, offensive or fraudulent Content or activity, such as advocating or causing harm, interfering with or violating the integrity or security of a network or system, evading filters, sending unsolicited, abusive, or deceptive messages, viruses or harmful code, or violating third party rights.

#### 2.2.3 Privacy.
[The GitHub Privacy Statement](/github/site-policy/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement), particularly in regards to the collection of Users' Personal Information (as defined in the GitHub Privacy Statement). If Customer collects any User Personal Information from GitHub, Customer will only use it for the purpose for which the External User has authorized it. Customer will reasonably secure any such Personal Information, and Customer will respond promptly to complaints, removal requests, and "do not contact" requests from GitHub or External Users.

### 2.3 Content Responsibility; Ownership; License Rights.

#### 2.3.1 Responsibility for User-Generated Content.
Customer may create or upload User-Generated Content while using the Service. Customer is solely responsible for any User-Generated Content that it posts, uploads, links to or otherwise makes available via the Service, regardless of the form of that User-Generated Content. GitHub is not responsible for any public display or misuse of User-Generated Content.

#### 2.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** Customer retains ownership of Customer Content that Customer creates or owns. Customer acknowledges that it: (a) is responsible for Customer Content, (b) will only submit Customer Content that Customer has the right to post (including third party or User-Generated Content), and (c) Customer will fully comply with any third-party licenses relating to Customer Content that Customer posts.

**(ii)** Customer grants the rights set forth in Sections 2.3.3 through 2.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. If Customer uploads Customer Content that already comes with a license granting GitHub the permissions it needs to run the Service, no additional license is required.

#### 2.3.3 License Grant to GitHub.
Customer grants to GitHub the right to store, parse, and display Customer Content, and make incidental copies only as necessary to provide the Service. This includes the right to copy Customer Content to GitHub's database and make backups; display Customer Content to Customer and those to whom Customer chooses to show it; parse Customer Content into a search index or otherwise analyze it on GitHub's servers; share Customer Content with External Users with whom Customer chooses to share it; and perform Customer Content, in case it is something like music or video. These rights apply to both public and Private Repositories. This license does not grant GitHub the right to sell Customer Content or otherwise distribute or use it outside of the Service. Customer grants to GitHub the rights it needs to use Customer Content without attribution and to make reasonable adaptations of Customer Content as necessary to provide the Service.

#### 2.3.4 License Grant to External Users.
**(i)** Any Content that Customer posts publicly, including issues, comments, and contributions to External Users' repositories, may be viewed by others. By setting its repositories to be viewed publicly, Customer agree to allow External Users to view and Fork Customer’s repositories.

**(ii)** If Customer sets its pages and repositories to be viewed publicly, Customer grants to External Users a nonexclusive, worldwide license to use, display, and perform Customer Content through the Service and to reproduce Customer Content solely on the Service as permitted through functionality provided by GitHub (for example, through Forking). Customer may grant further rights to Customer Content if Customer [adopts a license](/github/building-a-strong-community/adding-a-license-to-a-repository#including-an-open-source-license-in-your-repository). If Customer is uploading Customer Content that it did not create or own, Customer is responsible for ensuring that the Customer Content it uploads is licensed under terms that grant these permissions to External Users.

#### 2.3.5 Contributions Under Repository License.
Whenever Customer makes a contribution to a repository containing notice of a license, Customer licenses such contribution under the same terms and agrees that it has the right to license such contribution under those terms. If Customer has a separate agreement to license its contributions under different terms, such as a contributor license agreement, that agreement will supersede.

#### 2.3.6 Moral Rights.
Customer retains all moral rights to Customer Content that it uploads, publishes, or submits to any part of the Service, including the rights of integrity and attribution. However, Customer waives these rights and agrees not to assert them against GitHub, solely to enable GitHub to reasonably exercise the rights granted in Section 2.3, but not otherwise.

### 2.4 Private Repositories.

#### 2.4.1 Control.

Customer is responsible for managing access to its Private Repositories, including invitations, administrative control of Organizations and teams, and termination of access.

#### 2.4.2 Confidentiality.

GitHub considers Customer Content in Customer’s Private Repositories to be Customer’s Confidential Information. GitHub will protect and keep strictly confidential the Customer Content of Private Repositories in accordance with the applicable confidentiality provision in the Microsoft Customer Agreement.

#### 2.4.3 Access.

GitHub may only access Customer’s Private Repositories (i) with Customer’s consent and knowledge, for support reasons, or (ii) when access is required for security reasons.  Customer may choose to enable additional access to its Private Repositories. For example, Customer may enable various GitHub services or features that require additional rights to Customer Content in Private Repositories. These rights may vary depending on the service or feature, but GitHub will continue to treat Customer Content in Customer’s Private Repositories as Customer’s Confidential Information. If those services or features require rights in addition to those it needs to provide the Service, GitHub will provide an explanation of those rights.

#### 2.4.4 Exclusions.

If GitHub has reason to believe the Content of a Private Repository is in violation of the law or of these GitHub Supplemental Terms, GitHub has the right to access, review, and remove that Content. Additionally, GitHub may be compelled by law to disclose the Content of Customer’s Private Repositories. Unless otherwise bound by requirements under law or if in response to a security threat or other risk to security, GitHub will provide notice of such actions.

### 2.5. Intellectual Property Notices.

#### 2.5.1 GitHub's Rights to Content.

The look and feel of the Service is copyright © GitHub, Inc. All rights reserved. Customer may not duplicate, copy, or reuse any portion of the HTML/CSS, Javascript, or visual design elements or concepts without express written permission from GitHub.

#### 2.5.2 Copyright Infringement and DMCA Policy.

If Customer is a copyright owner and believes that Content on the Service violates Customer’s copyright, Customer may contact GitHub in accordance with GitHub's [Digital Millenium Copyright Act Policy](https://github.com/contact/dmca) by notifying GitHub via its [DMCA Form](https://github.com/contact/dmca-notice) or by emailing copyright@github.com.

#### 2.5.3 GitHub Trademarks and Logos.

If Customer would like to use GitHub's trademarks, Customer must follow all of GitHub's trademark guidelines, including those on the [GitHub Logos and Usage page](https://github.com/logos).

### 2.6 Suspension.

GitHub has the right to suspend access to all or any part of the Service, including removing Content, at any time for violation of the Microsoft Customer Agreement, including these GitHub Supplemental Terms, or to protect the integrity, operability, and security of the Service, effective immediately, with or without notice. Unless prohibited by law or legal process or to prevent imminent harm to the Service or any third party, GitHub typically provides notice in the form of a banner or email on or before such suspension. GitHub will, in its discretion and using good faith, tailor any suspension as needed to preserve the integrity, operability, and security of the Service.

### 2.7 Communications with GitHub.

For contractual purposes, Customer (1) consents to receive communications in an electronic form via the email address it submitted or via the Service; and (2) agrees that all Terms of Service, agreements, notices, disclosures, and other communications that GitHub provides electronically satisfies any legal requirement that those communications would satisfy if they were on paper. This section does not affect Customer's non-waivable rights.

### 2.8 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 2.9 Service Changes.

GitHub changes the Service via Updates and addition of new features. Subject to Section 2.8, GitHub reserves the right at any time to modify or discontinue, temporarily or permanently, the Service (or any part of it) with or without notice.

### 2.10 Additional Service Features.

Some Service features may be subject to additional terms as set forth in the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms). By accessing or using these features, Customer agrees to the GitHub Additional Product Terms.

## SECTION 3: GENERAL PROVISIONS.

This Section 3 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products.

### 3.1 Term; Termination; Effect of Termination.

#### 3.1.1 Term.
These GitHub Supplemental Terms will continue in effect until terminated by a Party in accordance with this Section 3.1.

#### 3.1.2 Termination for Convenience; Account Cancellation.
Either Party may terminate an Order Form or these GitHub Supplemental Terms, without cause, upon at least thirty (30) days' prior written notice before the end of the then-current Subscription Term. If Customer elects to terminate an Order Form or these GitHub Supplemental Terms, it is Customer's responsibility to properly cancel its account with GitHub by going into Settings in the global navigation bar at the top of the screen. GitHub cannot cancel accounts in response to an email or phone request.

#### 3.1.3 Termination for Material Breach.
Either Party may terminate these GitHub Supplemental Terms immediately upon notice if the other Party breaches a material obligation under these GitHub Supplemental Terms and fails to cure the breach within thirty (30) days from the date it receives notification.  GitHub may terminate these GitHub Supplemental Terms if Customer's Account has been suspended for more than 90 days.

#### 3.1.4 Effect of Termination.
Upon termination of these GitHub Supplemental Terms, Customer may not execute additional Order Forms; however, these GitHub Supplemental Terms will remain in effect for the remainder of any active Order Forms. When an Order Form terminates or expires, as to that Order Form: (i) the Subscription Term will immediately end; (ii) any Subscription Licenses in the Order Form will automatically terminate, and Customer will no longer have the right to use the Products; (iii) if any Fees were owed prior to termination, Customer must pay those Fees immediately; (iv) Customer must destroy all copies of the Software in Customer’s possession or control, and certify in writing to GitHub that Customer has done so; (v) each Party will promptly return (or, if the other party requests it, destroy) all Confidential Information belonging to the other to the extent permitted by the Service. Notwithstanding the foregoing, Customer may continue to access the Software to migrate Customer’s data and may request migration of the data in its repositories for up to ninety (90) days after termination or expiration of this Agreement or an Order Form; however, Customer may not use the Software or Service on a production basis during that time. Any provisions which by their nature should reasonably survive will survive the termination or expiration of this Agreement or an Order Form.

### 3.2 Feedback.
Customer may provide Feedback to GitHub regarding the Products. Feedback is voluntary and is not Customer Confidential Information, even if designated as such. GitHub may fully exercise and exploit such Feedback for the purpose of (i) improving the operation, functionality and use of GitHub’s existing and future product offerings and commercializing such offerings; and (ii) publishing aggregated statistics about the quality of the Products, provided that no data in any such publication will be used to specifically identify Customer, its employees or Customer’s proprietary software code.

### 3.3 Compliance with Laws and Regulations.
Customer will comply with all applicable laws and regulations, including, but not limited to, data protection and employment laws and regulations, in its use of the Products.

### 3.4 Order of Precedence
In the event of a conflict between the Supplemental Terms, on one hand, and an Order Form, on the other, the Order Form will govern with respect to that order only. In the event of a conflict between the Supplemental Terms (including any Order Form) and the Microsoft Customer Agreement, the Supplemental Terms will govern with respect to the subject matter only.

## EXHIBIT A: DEFINITIONS

**"Active User"** means a User trying to access the Service at the time of an Outage.

**”Add-On Software”** means Advanced Security, Insights, Learning Lab for Enterprise Server, and other additional Software add-on products that GitHub may offer from time to time.

**“Advanced Security”** means the Software feature which enables Customer to identify security vulnerabilities through customizable and automated semantic code analysis.

**"Affiliate"** means any entity that directly or indirectly controls, is controlled by, or is under common control with a party where "control" means having more than fifty percent (50%) ownership or the right to direct the management of the entity.

**“All Users”** means, collectively, Customer’s Users and External Users who use the Service.

**“Connect”** or **“GitHub Connect”** means a feature included in the Software that enables Customer to connect the Software with the Service. Use of GitHub Connect is subject to the GitHub Connect terms set forth in the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

**"Content"** means, without limitation, text, data, articles, images, photographs, graphics, software, applications, designs, features, and other materials that are featured, displayed, or otherwise made available through the Service.

**"Corporate Account"** means an account created by a User on behalf of an entity.

**"Customer"** means, collectively, the company or organization that has entered into these GitHub Supplemental Terms with GitHub by clicking on the "I AGREE" or similar button or by accessing the Products, and Customer's Affiliates and Representatives.

**"Customer Content"** means Content that Customer creates, owns, or to which Customer holds the rights.

**“Customer Modifications”** means Software modifications Customer may make solely for the purpose of developing bug fixes, customizations, or additional features to any libraries licensed under open source licenses that may be included with or linked to by the Software.

**"Documentation"** means any manuals, documentation and other supporting materials relating to the Software or Service that GitHub provides or makes available to Customer.

**"Effective Date"** is the earlier of the date on which Customer (i) agrees to the terms and conditions of these GitHub Supplemental Terms as described above, or (ii) first places an order for the Products.

**"Essential Services"** means the services essential to GitHub's core version control functionality, including creating, Forking, and cloning repositories; creating, committing, and merging branches; creating, reviewing, and merging pull requests; and, web, API, and Git client interfaces to the core Git workflows. The following are examples of peripheral features and services not included: webhooks, Gists, Pages, and email notifications.

**"External User"** means an individual, not including Customer’s Users, who visit or use the Service.

**"Fees"** means the fees Customer is required to pay GitHub to (i) use the Products during the applicable Subscription Term or (ii) receive Professional Services, as such fees are reflected on an Order Form or SOW.

**“Feedback”** means any ideas, know-how, algorithms, code contributions, suggestions, enhancement requests, recommendations or any other feedback on GitHub products or services.

**“Fork”** means to copy the Content of one repository into another repository.

**"GitHub"** means, collectively, GitHub, Inc., its Affiliates and Representatives.

**"GitHub Content"** means Content that GitHub creates, owns, or to which it holds the rights.

**"GitHub Insights"** or **“Insights”** means the Software feature which provides Customer with metrics, analytics, and recommendations relating to their use of the Software. GitHub Insights does not include legacy features of GitHub including organization insights and repository insights.

**“GitHub One”** means the Product bundle which includes GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server, and Premium Plus or Engineering Direct Support.

**"Learning Lab for Enterprise Server"** means the Software feature that enables Users to learn about GitHub functionality, including associated Documentation.

**"License Key"** means the data file used by the Software's access control mechanism that allows Customer to install, operate, and use the Software.

**“Machine Account”** means an account registered by an individual human who accepts the applicable terms of service on behalf of the Machine Account, provides a valid email address, and is responsible for its actions. A Machine Account is used exclusively for performing automated tasks. Multiple Users may direct the actions of a Machine Account, but the owner of the account is ultimately responsible for the machine's actions.

**"Order Form"** means written or electronic documentation (including a quote) that the Parties use to order the Products.

**“Organization”** means a shared workspace that may be associated with a single entity or with one or more Users where multiple Users can collaborate across many projects at once. A User can be a member of more than one Organization.

**"Outage"** means the interruption of an Essential Service that affects more than 50% of Active Users.

**“Private Repository”** means a repository which allows a User to control access to Content.

**"Professional Services"** means training, consulting, or implementation services that GitHub provides pursuant to a mutually executed SOW. Professional Services do not include Support.

**“Public Repository”** means a repository whose Content is visible to All Users.

**"Release"** means a Software release that GitHub makes generally available to its customers, along with any corresponding changes to Documentation, that contains enhancements, new features, or new functionality, generally indicated by a change in the digit to the right of the first decimal point (e.g., x.x.x to x.y.x) or to the left of the first decimal point (e.g., x.x.x to y.x.x).

**"Representatives"** means a Party’s employees, agents, independent contractors, consultants, and legal and financial advisors.

**“Scraping”** means extracting data from the Service via an automated process, such as a bot or webcrawler, and does not include the collection of information through GitHub's API.

**"Service"** means the hosted GitHub Enterprise Cloud service. The Service includes:  Organization account(s), SAML single sign-on, access provisioning, and any applicable Documentation. This list of features and services is non-exhaustive and may be updated from time to time.

**"Service Credit"** means a dollar credit, calculated as set forth below, that GitHub may credit back to an eligible account.

**"Software"** means GitHub Enterprise Server on-premises software. Software includes the GitHub Connect feature, any applicable Documentation, any Updates to the Software that GitHub provides to Customer or that it can access under these GitHub Supplemental Terms, and, if included in Customer’s subscription, Add-On Software.

**"SOW"** means a mutually executed statement of work detailing the Professional Services GitHub will perform, any related Fees, and each Party's related obligations.

**“Subscription License”** means the license assigned to each User to install, operate, access, and use the Products on Customer’s behalf. Customer may only assign one Subscription License per User across its GitHub Enterprise Server instances and GitHub Enterprise Cloud Organizations. Each User will have access to as many of Customer’s Enterprise Server instances or Enterprise Cloud Organizations, as Customer permits. For clarity, however, once Customer assigns a Subscription License to a User, Customer will not be authorized to bifurcate the Subscription License so that one User can use a Subscription License on Enterprise Server while another User uses the same Subscription License on another instance of GitHub Enterprise Server or on an Organization on GitHub Enterprise Cloud. Subscription Licenses are granted on a per User basis and multiple Users may not use the same Subscription License. Customer may reassign a Subscription License to a new User only after ninety (90) days from the last reassignment of that same Subscription License, unless the reassignment is due to (i) permanent hardware failure or loss, (ii) termination of the User’s employment or contract, or (iii) temporary reallocation of Subscription Licenses to cover a User’s absence. When Customer reassigns a Subscription License from one User to another, Customer must block the former User’s access to the Subscription License and Customer’s Organizations.

**“Subscription Term”** means one (1) year from the applicable effective date of an order or as otherwise stated in the Order Form.

**“Support”** means technical support for the Software or Service that GitHub may provide.

**“Update”** means a Software release that GitHub makes generally available to its customers, along with any corresponding changes to Documentation, that contains error corrections or bug fixes, generally indicated by a change in the digit to the right of the second decimal point (e.g., x.x.x to x.x.y).

**“Uptime”** means the percentage of time in a given quarter where GitHub's Essential Services will not be interrupted by an Outage affecting more than 50% of Active Users

**“User”** means (i) with respect to the Software, a single person or Machine Account that initiates the execution of the Software or interacts with or directs the Software in the performance of its functions; and (ii) with respect to the Service, an individual or Machine Account who (a) accesses or uses the Service, (b) accesses or uses any part of Customer’s account, or (c) directs the use of Customer’s account in the performance of functions, in each case on Customer’s behalf. The number of Users should not exceed the number of Subscription Licenses that Customer has purchased.

**“User-Generated Content”** means Content created or owned by a third party or External User.
