---
title: GitHub Subprocessors and Cookies
redirect_from:
  - /subprocessors/
  - /github-subprocessors/
  - /github-tracking/
  - /github-cookies/
  - /articles/github-subprocessors-and-cookies
versions:
  free-pro-team: '*'
---

Effective date: **August 12, 2020**

GitHub provides a great deal of transparency regarding how we use your data, how we collect your data, and with whom we share your data. To that end, we provide this page, which details [our subprocessors](#github-subprocessors), how we use [cookies](#cookies-on-github), and where and how we perform any [tracking on GitHub](#tracking-on-github).

### GitHub Subprocessors

When we share your information with third party subprocessors, such as our vendors and service providers, we remain responsible for it. We work very hard to maintain your trust when we bring on new vendors, and we require all vendors to enter into data protection agreements with us that restrict their processing of Users' Personal Information (as defined in the [Privacy Statement](/articles/github-privacy-statement/)).

| Name of Subprocessor | Description of Processing                          | Location of Processing | Corporate Location |
| -------------------- | -------------------------------------------------- | ---------------------- | ------------------ |
| Automattic           | Blogging service                                   | United States          | United States      |
| AWS Amazon           | Data hosting                                       | United States          | United States      |
| Braintree (PayPal)   | Subscription credit card payment processor         | United States          | United States      |
| Clearbit             | Marketing data enrichment service                  | United States          | United States      |
| Discourse            | Community forum software provider                  | United States          | United States      |
| DiscoverOrg          | Marketing data enrichment service                  | United States          | United States      |
| Eloqua               | Marketing campaign automation                      | United States          | United States      |
| Google Apps          | Internal company infrastructure                    | United States          | United States      |
| Google Analytics     | Website analytics and performance                  | United States          | United States      |
| LinkedIn Navigator   | Marketing data enrichment service                  | United States          | United States      |
| Magic Robot          | Campaign reporting (Salesforce Add-on)             | United States          | United States      |
| MailChimp            | Customer ticketing mail services provider          | United States          | United States      |
| Mailgun              | Transactional mail services provider               | United States          | United States      |
| Microsoft            | Microsoft Services                                 | United States          | United States      |
| Monday.com           | Team collaboration and project management platform | United States          | Israel             |
| Nexmo                | SMS notification provider                          | United States          | United States      |
| Oracle               | Corporate financial system                         | United States          | United States      |
| Salesforce.com       | Customer relations management                      | United States          | United States      |
| Sendgrid             | Transactional mail services provider               | United States          | United States      |
| Sentry.io            | Application monitoring provider                    | United States          | United States      |
| Stripe               | Payment provider                                   | United States          | United States      |
| Twilio               | SMS notification provider                          | United States          | United States      |
| Zendesk              | Customer support ticketing system                  | United States          | United States      |
| Zuora                | Corporate billing system                           | United States          | United States      |

When we bring on a new subprocessor who handles our Users' Personal Information, or remove a subprocessor, or we change how we use a subprocessor, we will update this page. If you have questions or concerns about a new subprocessor, we'd be happy to help. Please contact us via {% data variables.contact.contact_privacy %}.

### Cookies on GitHub

GitHub uses cookies to make interactions with our service easy and meaningful. We use cookies (and similar technologies, like HTML5 localStorage) to keep you logged in, remember your preferences, provide information for future development of GitHub, and to advertise GitHub's products and services to you on third party sites.

A cookie is a small piece of text that our web server stores on your computer or mobile device, which your browser sends to us when you return to our site. Cookies do not necessarily identify you if you are merely visiting GitHub; however, a cookie may store a unique identifier for each logged in user. We use cookies to keep you logged in, remember your preferences, and provide information for future development of GitHub. For security reasons, we use cookies to identify a device. By using our website, you agree that we can place these types of cookies on your computer or device. If you disable your browser or device’s ability to accept these cookies, you will not be able to log in or use GitHub’s services. On certain areas of the website, we may also use cookies to identify you and/or your device to advertise GitHub products and services to you on third party sites.

GitHub sets the following cookies on our users for the following reasons:

| Name of Cookie                       | Reason                                                                                                                                 |
| ------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------- |
| `user_session`                       | This cookie is used to log you in.                                                                                                     |
| `logged_in`                          | This cookie is used to signal to us that the user is already logged in.                                                                |
| `dotcom_user`                        | This cookie is used to signal to us that the user is already logged in.                                                                |
| `_gh_sess`                           | This cookie is used for temporary application and framework state between pages like what step the user is on in a multiple step form. |
| `tz`                                 | This cookie allows your browser to tell us what time zone you're in.                                                                   |
| `gist_user_session`                  | This cookie is used by Gist when running on a separate host.                                                                           |
| `saml_csrf_token`                    | This cookie is set by SAML auth path method to associate a token with the client.                                                      |
| `saml_return_to`                     | This cookie is set by the SAML auth path method to maintain state during the SAML authentication loop.                                 |
| `gist_oauth_csrf`                    | This cookie is set by Gist to ensure the user that started the oauth flow is the same user that completes it.                          |
| `__Host-user_session_same_site`      | This cookie is set to ensure that browsers that support SameSite cookies can check to see if a request originates from GitHub.         |
| `__Host-gist_user_session_same_site` | This cookie is set to ensure that browsers that support SameSite cookies can check to see if a request originates from GitHub.         |
| `_ga`                                | This cookie is used by Google Analytics.                                                                                               |
| `_gat`                               | This cookie is used by Google Analytics.                                                                                               |
| `_gid`                               | This cookie is used by Google Analytics.                                                                                               |
| `_octo`                              | This cookie is used by Octolytics, our internal analytics service, to distinguish unique users and clients.                            |
| `tracker`                            | This cookie tracks the referring source for signup analytics.                                                                          |

Certain pages on our site may set other third party cookies. For example, we may embed content, such as videos, from another site that sets a cookie. While we try to minimize these third party cookies, we can’t always control what cookies this third party content sets.

### Tracking on GitHub

"[Do Not Track](https://www.eff.org/issues/do-not-track)" (DNT) is a privacy preference you can set in your browser if you do not want online services — specifically ad networks — to collect and share certain kinds of information about your online activity from third party tracking services. GitHub responds to browser DNT signals and follows the [W3C standard for responding to DNT signals](https://www.w3.org/TR/tracking-dnt/). If you would like to set your browser to signal that you would not like to be tracked, please check your browser's documentation for how to enable that signal. There are also good applications that block online tracking, such as [Privacy Badger](https://www.eff.org/privacybadger).

If you have not enabled DNT on a browser that supports it, cookies on some parts of our website will track your online browsing activity on other online services over time, though we do not permit third parties other than our analytics and service providers to track GitHub users' activity over time on GitHub. We use these cookies to allow us to advertise GitHub products and services to you on third party websites and services. We also have agreements with certain vendors, such as analytics providers, who help us track visitors' movements on certain pages on our site. Only our vendors, who are collecting personal information on our behalf, may collect data on our pages, and we have signed data protection agreements with every vendor who collects this data on our behalf. We use the data we receive from these vendors to better understand our visitors' interests, to understand our website's performance, and to improve our content. Any analytics vendor will be listed in our Subprocessor List above, and you may see a list of every page where we collect this kind of data below.

#### Google Analytics

We use Google Analytics as a third party analytics service, and to track our advertising campaigns on third party websites and services. We use Google Analytics to collect information about how our website performs and how our users, in general, navigate through and use GitHub. This helps us evaluate our users' use of GitHub; compile statistical reports on activity; and improve our content and website performance. Google provides further information about its own privacy practices and [offers a browser add-on to opt out of Google Analytics tracking](https://tools.google.com/dlpage/gaoptout).

#### Pages on GitHub where analytics may be enabled

Pages at URLs that contain any of the following domains and paths (including any subdomains or subpaths) on our sites may have analytics or other tracking code enabled. If you would like to prevent us from collecting information about your browsing activity on GitHub, you may use a tracking blocker such as [Privacy Badger](https://www.eff.org/privacybadger) or opt out of Google Analytics tracking.

- github.com/home (if you are logged out or do not have an account, this is the page you will see when you go to github.com)
- github.com/about
- github.blog
- github.com/enterprise
- github.com/collections
- github.com/developer-stories
- github.com/events
- github.com/explore
- github.com/features
- github.com/logos
- github.com/nonprofit
- github.com/open-source
- github.com/personal
- github.com/pricing
- github.com/ten
- github.com/trending
- resources.github.com
- de.github.com
- fr.github.com
