---
title: About organization membership
intro: You can become a member of an organization to collaborate with coworkers or open-source contributors across many repositories at once.
redirect_from:
  - /articles/about-organization-membership
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

An organization owner can invite you to join their organization as a member, billing manager, or owner. An organization owner or member with admin privileges for a repository can invite you to collaborate in one or more repositories as an outside collaborator. For more information, see "[Permission levels for an organization](/articles/permission-levels-for-an-organization)."

You can access organizations you're a member of on your profile page. For more information, see "[Accessing an organization](/articles/accessing-an-organization)."

When you accept an invitation to join an organization, the organization owners may be able to see:

- Your public profile information
- Your email address
- If you have two-factor authorization enabled
- Repositories you have access to within the organization, and your access level
- Certain activity within the organization
- Country of request origin
- Your IP address

For more information, see the <a href="/articles/github-privacy-statement/" class="dotcom-only">{% data variables.product.prodname_dotcom %} Privacy Statement</a>.

  {% note %}

  **Note:** Owners are not able to view member IP addresses in the organization's audit log. In the event of a security incident, such as an account compromise or inadvertent sharing of sensitive data, organization owners may request details of access to private repositories. The information we return may include your IP address.

  {% endnote %}

By default, your organization membership visibility is set to private. You can choose to publicize individual organization memberships on your profile. For more information, see "[Publicizing or hiding organization membership](/articles/publicizing-or-hiding-organization-membership)."

{% if currentVersion == "free-pro-team@latest" %}

If your organization belongs to an enterprise account, you are automatically a member of the enterprise account and visible to enterprise account owners. For more information, see "[About enterprise accounts](/articles/about-enterprise-accounts)."

{% endif %}

You can leave an organization at any time. For more information, see "[Removing yourself from an organization](/articles/removing-yourself-from-an-organization)."

### Дополнительная литература

- "[About organizations](/articles/about-organizations)"
- "[Managing your membership in organizations](/articles/managing-your-membership-in-organizations)"
