---
title: Triaging a single notification
intro: 'When you review and investigate a single notification, you have several triaging options that are optimized for the detailed notification view.'
versions:
  free-pro-team: '*'
  enterprise-server: '>=2.21'
---

### Saving a single notification

To save a single notification to review later, to the right of the notification, click {% octicon "bookmark" aria-label="The bookmark icon" %}. You can only save one notification at a time.

Saved notifications are kept indefinitely and can be viewed by clicking **Saved** in the sidebar or with the `is:saved` query. If your saved notification is older than 5 months and becomes unsaved, the notification will disappear from your inbox within a day.

  ![Save triaging option](/assets/images/help/notifications-v2/save-triaging-option.png)

### Investigating a notification

When you click an individual notification from your inbox, you're directed to the conversation that prompted the notification. From the top of the page, you can:
- Mark the individual notification as done
- Unsubscribe from future notifications
- Mark the notification as read
- Save the notification for later
- Return to your notifications inbox

For more information about your triage options, see "[Managing notifications from your inbox](/github/managing-subscriptions-and-notifications-on-github/managing-notifications-from-your-inbox#triaging-options)."

### Customizing when to receive future updates for an issue or pull request

You can choose how you want to receive future notifications for a specific issue or pull request.

1. In the right column of the issue or pull request, next to "Notifications", click **Customize**.

  ![Customize option under "Notifications"](/assets/images/help/notifications-v2/customize-notifications-for-specific-thread.png)

2. Select **Custom** and choose when you'd like to receive a notification update for this thread. For example, you can choose to receive an update when the pull request has been merged, closed, or reopened. You will be subscribed again if you participate in the thread, your username is @mentioned, or a team you're a member of is @mentioned.

  ![Options for customizing notifications](/assets/images/help/notifications-v2/custom-options-for-customizing-notification-thread-updates.png)

3. Click **Save**.
