---
title: About conversations on GitHub
intro: 'You can discuss specific projects and changes, as well as broader projects or team goals, using different types of discussions on {% data variables.product.product_name %}.'
redirect_from:
  - /articles/about-discussions-in-issues-and-pull-requests/
  - /articles/about-conversations-on-github
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Discussions on {% data variables.product.product_name %}

You can create and participate in issues, pull requests, and team discussions, depending on the type of conversation you'd like to have.

Issues are useful for discussing specific details of a project such as bug reports and planned improvements. For more information, see "[About issues](/articles/about-issues)." Pull requests allow you to comment directly on proposed changes. For more information, see "[About pull requests](/articles/about-pull-requests)" and "[Commenting on a pull request](/articles/commenting-on-a-pull-request)."

{% data reusables.organizations.team-discussions-purpose %} For more information, see "[About team discussions](/articles/about-team-discussions)."

### Reacting to ideas in comments

You can show your support or dissent for an idea in a conversation. When you add a reaction to a comment or the body of a team discussion, issue, or pull request, people subscribed to the conversation won't receive a notification. For more information about subscriptions, see {% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}"[About notifications](/github/managing-subscriptions-and-notifications-on-github/about-notifications){% else %}"[Subscribing to and unsubscribing from notifications](/github/receiving-notifications-about-activity-on-github/subscribing-to-and-unsubscribing-from-notifications){% endif %}."

![Example of an issue with reactions](/assets/images/help/repository/issue-reactions.png)

{% if currentVersion == "free-pro-team@latest" %}

{% tip %}

**Tip:** You can also add reactions using your mobile device.

{% endtip %}

{% endif %}
### Following contribution guidelines

Before you open an issue or pull request, check to see if the repository has contributing guidelines. The *CONTRIBUTING.md* file includes information about how the repository maintainer would like you to contribute ideas to the project.

Similar to contributing guidelines, the repository maintainer may have included a template for information to include in an issue or pull request. Completing the prompts from the template may help you get a better response from maintainers.

### Дополнительная литература

- "[Setting up your project for healthy contributions](/articles/setting-up-your-project-for-healthy-contributions)"
- "[Using templates to encourage useful issues and pull requests](/github/building-a-strong-community/using-templates-to-encourage-useful-issues-and-pull-requests)"
- "[Moderating comments and conversations](/articles/moderating-comments-and-conversations)"
- "[Writing on {% data variables.product.prodname_dotcom %}](/articles/writing-on-github)"
