---
title: About community profiles for public repositories
intro: Repository maintainers can review their public repository's community profile to learn how they can help grow their community and support contributors. Contributors can view a public repository's community profile to see if they want to contribute to the project.
redirect_from:
  - /articles/viewing-your-community-profile/
  - /articles/about-community-profiles-for-public-repositories
versions:
  free-pro-team: '*'
---

The community profile checklist checks to see if a project includes recommended community health files, such as README, CODE_OF_CONDUCT, LICENSE, or CONTRIBUTING, in a supported location. For more information, see "[Accessing a project's community profile](/articles/accessing-a-project-s-community-profile)."

### Using the community profile checklist as a repository maintainer

As a repository maintainer, use the community profile checklist to see if your project meets the recommended community standards to help people use and contribute to your project. For more information, see "[Building community](https://opensource.guide/building-community/)" in the Open Source Guides.

If a project doesn't have a recommended file, you can click **Add** to draft and submit a file.

{% data reusables.repositories.valid-community-issues %} For more information, see "[About issue and pull request templates](/articles/about-issue-and-pull-request-templates)."

![Community profile checklist with recommended community standards for maintainers](/assets/images/help/repository/add-button-community-profile.png)

{% data reusables.repositories.security-guidelines %}

### Using the community profile checklist as a community member or collaborator

As a potential contributor, use the community profile checklist to see if a project meets the recommended community standards and decide if you'd like to contribute. For more information, see "[How to contribute](https://opensource.guide/how-to-contribute/#anatomy-of-an-open-source-project)" in the Open Source Guides.

If a project doesn't have a recommended file, you can click **Propose** to draft and submit a file to the repository maintainer for approval.

![Community profile checklist with recommended community standards for contributors](/assets/images/help/repository/propose-button-community-profile.png)

### Дополнительная литература

- "[Adding a code of conduct to your project](/articles/adding-a-code-of-conduct-to-your-project)"
- "[Setting guidelines for repository contributors](/articles/setting-guidelines-for-repository-contributors)"
- "[Adding a license to a repository](/articles/adding-a-license-to-a-repository)"
- "[About issue and pull request templates](/articles/about-issue-and-pull-request-templates)"
- "[Open Source Guides](https://opensource.guide/)"
- [{% data variables.product.prodname_learning %}]({% data variables.product.prodname_learning_link %})
