---
title: Managing access to self-hosted runners using groups
intro: You can use policies to limit access to self-hosted runners that have been added to an organization or enterprise.
redirect_from:
  - /actions/hosting-your-own-runners/managing-access-to-self-hosted-runners
versions:
  free-pro-team: '*'
  enterprise-server: '>=2.22'
---

{% data reusables.actions.enterprise-beta %}
{% data reusables.actions.enterprise-github-hosted-runners %}

### About self-hosted runner groups

{% if currentVersion == "free-pro-team@latest" %}
{% note %}

**Note:** All organizations have a single default self-hosted runner group. Creating and managing additional self-hosted runner groups is only available to enterprise accounts, and for organizations owned by an enterprise account.

{% endnote %}
{% endif %}

Self-hosted runner groups are used to control access to self-hosted runners at the organization and enterprise level. Enterprise admins can configure access policies that control which organizations in an enterprise have access to the runner group. Organization admins can configure access policies that control which repositories in an organization have access to the runner group.

When an enterprise admin grants an organization access to a runner group, organization admins can see the runner group listed in the organization's self-hosted runner settings. The organizations admins can then assign additional granular repository access policies to the enterprise runner group.

When new runners are created, they are automatically assigned to the default group. Runners can only be in one group at a time. You can move runners from the default group to another group. For more information, see "[Moving a self-hosted runner to a group](#moving-a-self-hosted-runner-to-a-group)."

### Creating a self-hosted runner group for an organization

All organizations have a single default self-hosted runner group. Organizations within an enterprise account can create additional self-hosted groups. Organization admins can allow individual repositories access to a runner group.

Self-hosted runners are automatically assigned to the default group when created, and can only be members of one group at a time. You can move a runner from the default group to any group you create.

When creating a group, you must choose a policy that defines which repositories have access to the runner group. You can configure a runner group to be accessible to a specific list of repositories, all private repositories, or all repositories in the organization.

{% data reusables.organizations.navigate-to-org %}
{% data reusables.organizations.org_settings %}
{% data reusables.organizations.settings-sidebar-actions %}
1. In the **Self-hosted runners** section, click **Add new**, and then **New group**.

    ![Add runner group](/assets/images/help/settings/actions-org-add-runner-group.png)
1. Enter a name for your runner group, and select an access policy from the **Repository access** dropdown list.

    ![Add runner group options](/assets/images/help/settings/actions-org-add-runner-group-options.png)
1. Click **Save group** to create the group and apply the policy.

### Creating a self-hosted runner group for an enterprise

Enterprises can add their self-hosted runners to groups for access management. Enterprises can create groups of self-hosted runners that are accessible to specific organizations in the enterprise account. Organization admins can then assign additional granular repository access policies to the enterprise runner groups.

Self-hosted runners are automatically assigned to the default group when created, and can only be members of one group at a time. You can assign the runner to a specific group during the registration process, or you can later move the runner from the default group to a custom group.

When creating a group, you must choose a policy that grants access to all organizations in the enterprise or choose specific organizations.

{% if currentVersion == "free-pro-team@latest" %}
{% data reusables.enterprise-accounts.access-enterprise %}
{% else if currentVersion != "free-pro-team@latest" and currentVersion ver_gt "enterprise-server@2.21"%}
{% data reusables.enterprise_site_admin_settings.access-settings %}
{% data reusables.enterprise_site_admin_settings.business %}
{% endif %}
{% data reusables.enterprise-accounts.policies-tab %}
{% data reusables.enterprise-accounts.actions-tab %}
1. Click the **Self-hosted runners** tab.
1. Click **Add new**, and then **New group**.

    ![Add runner group](/assets/images/help/settings/actions-enterprise-account-add-runner-group.png)
1. Enter a name for your runner group, and select an access policy from the **Organization access** dropdown list.

    ![Add runner group options](/assets/images/help/settings/actions-enterprise-account-add-runner-group-options.png)
1. Click **Save group** to create the group and apply the policy.

### Changing the access policy of a self-hosted runner group

You can update the access policy of a runner group, or rename a runner group.

{% data reusables.github-actions.self-hosted-runner-configure-runner-group-access %}

### Moving a self-hosted runner to a group

New self-hosted runners are automatically assigned to the default group, and can then be moved to another group.

1. In the **Self-hosted runners** section of the settings page, locate the current group of the runner you want to move group and expand the list of group members. ![View runner group members](/assets/images/help/settings/actions-org-runner-group-members.png)
1. Select the checkbox next to the self-hosted runner, and then click **Move to group** to see the available destinations. ![Runner group member move](/assets/images/help/settings/actions-org-runner-group-member-move.png)
1. To move the runner, click on the destination group. ![Runner group member move](/assets/images/help/settings/actions-org-runner-group-member-move-destination.png)

### Removing a self-hosted runner group

Self-hosted runners are automatically returned to the default group when their group is removed.

1. In the **Self-hosted runners** section of the settings page, locate the group you want to delete, and click the {% octicon "kebab-horizontal" aria-label="The horizontal kebab icon" %} button. ![View runner group settings](/assets/images/help/settings/actions-org-runner-group-kebab.png)

1. To remove the group, click **Remove group**. ![View runner group settings](/assets/images/help/settings/actions-org-runner-group-remove.png)

1. Review the confirmation prompts, and click **Remove this runner group**.
