---
title: Bibliotecas
intro: 'Você pode usar a biblioteca oficial do Octokit e outras bibliotecas de terceiros para estender e simplificar a forma como você usa a API de {% data variables.product.prodname_dotcom %}.'
redirect_from:
  - /libraries/
  - /v3/libraries
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

<div class="jumbotron libraries-jumbotron">
  <img src="/assets/images/gundamcat.png" class="gundamcat" alt="O Gundamcat" />
  <h1>Octokit comes in<br />
  many flavors</h1>
  <p class="lead">Use a biblioteca oficial do Octokit ou escolha entre qualquer uma das bibliotecas de terceiros disponíveis.</p>
  <div class="octokit-links">
    <div class="octokit-language"><span>Ruby</span> <a href="https://github.com/octokit/octokit.rb">octokit.rb</a></div>
    <div class="octokit-language"><span>.NET</span> <a href="https://github.com/octokit/octokit.net">octokit.net</a></div>
    <div class="octokit-language"><span>JavaScript</span> <a href="https://github.com/octokit/rest.js">octokit/rest.js</a></div>
  </div>
</div>

# Bibliotecas de terceiros

### Clojure

* [Tentacles][tentacles]

### Dart

* [github.dart][github.dart]

### Emacs Lisp

* [gh.el][gh.el]

### Erlang

* [octo.erl][octo-erl]

### Go

* [go-github][]

### Haskell

* [github][haskell-github]

### Java

* A biblioteca [API do Java do GitHub (org.eclipse.egit.github. min.)](https://github.com/eclipse/egit-github/tree/master/org.eclipse.egit.github.core) faz parte do [GitHub Mylyn Connector](https://github.com/eclipse/egit-github) e visa a suportar toda a API do GitHub v3.  As construções estão disponíveis em [Maven Central](http://search.maven.org/#search%7Cga%7C1%7Ca%3A%22org.eclipse.egit.github.core%22).
* A [API do GitHub para Java (org.kohsuke.github)](http://github-api.kohsuke.org/) define uma representação orientada para objetos da API do GitHub.
* [A API do JCabi do GitHub](http://github.jcabi.com) é baseada na API do JSON do Java7 (JSR-353), simplifica testes com o stub, em tempo de execução, e abrange toda a API.

### JavaScript

* [NodeJS GitHub library][octonode]
* [gh3 client-side API v3 wrapper][gh3]
* [GitHub.js wrapper ao redor da GitHub API][github]
* [Biblioteca CoffeeScript baseada em pomessa para o navegador ou NodeJS][github-client]

### Julia

* [GitHub.jl][github.jl]

### OCaml

* [ocaml-github][ocaml-github]

### Perl

* [Pithub][pithub-github] ([CPAN][pithub-cpan])
* [Net::GitHub][net-github-github] ([CPAN][net-github-cpan])

### PHP

* [GitHub PHP Client][github-php-client]
* [PHP GitHub API][php-github-api]
* [GitHub API][github-api]
* [GitHub Joomla! Package][joomla]
* [Github Nette Extension][kdyby-github]
* [GitHub API Easy Access][milo-github-api]
* [GitHub bridge para Laravel][github-laravel]
* [PHP5.6|PHP7 Client & WebHook wrapper][flexyproject-githubapi]

### Python

* [PyGithub][jacquev6_pygithub]
* [libsaas][libsaas]
* [github3.py][github3py]
* [sanction][sanction]
* [agithub][agithub]
* [octohub][octohub]
* [Github-Flask][github-flask]
* [torngithub][torngithub]

### Ruby

* [GitHub API Gem][ghapi]
* [Ghee][ghee]

### Scala

* [Hubcat][hubcat]
* [Github4s][github4s]

### Shell

* [ok.sh][ok.sh]

[tentacles]: https://github.com/Raynes/tentacles

[github.dart]: https://github.com/DirectMyFile/github.dart

[gh.el]: https://github.com/sigma/gh.el

[octo-erl]: https://github.com/sdepold/octo.erl

[go-github]: https://github.com/google/go-github

[haskell-github]: https://github.com/fpco/GitHub

[octonode]: https://github.com/pksunkara/octonode
[gh3]: https://github.com/k33g/gh3
[github]: https://github.com/michael/github
[github-client]: https://github.com/philschatz/github-client

[github.jl]: https://github.com/WestleyArgentum/GitHub.jl

[ocaml-github]: https://github.com/mirage/ocaml-github

[net-github-github]: https://github.com/fayland/perl-net-github
[net-github-cpan]: https://metacpan.org/pod/Net::GitHub
[pithub-github]: https://github.com/plu/Pithub
[pithub-cpan]: http://metacpan.org/module/Pithub

[github-php-client]: https://github.com/tan-tan-kanarek/github-php-client
[php-github-api]: https://github.com/KnpLabs/php-github-api
[github-api]: https://github.com/yiiext/github-api
[joomla]: https://github.com/joomla-framework/github-api
[kdyby-github]: https://github.com/kdyby/github
[milo-github-api]: https://github.com/milo/github-api
[github-laravel]: https://github.com/GrahamCampbell/Laravel-GitHub
[flexyproject-githubapi]: https://github.com/FlexyProject/GitHubAPI

[jacquev6_pygithub]: https://github.com/PyGithub/PyGithub
[libsaas]: https://github.com/ducksboard/libsaas
[github3py]: https://github.com/sigmavirus24/github3.py
[sanction]: https://github.com/demianbrecht/sanction
[agithub]: https://github.com/jpaugh/agithub "Agnostic GitHub"
[octohub]: https://github.com/turnkeylinux/octohub
[github-flask]: http://github-flask.readthedocs.org
[torngithub]: https://github.com/jkeylu/torngithub

[ghapi]: https://github.com/peter-murach/github
[ghee]: https://github.com/rauhryan/ghee

[hubcat]: https://github.com/softprops/hubcat
[github4s]: https://github.com/47deg/github4s

[ok.sh]: https://github.com/whiteinge/ok.sh
