---
title: Guia de envio do aviso de retirada DMCA
redirect_from:
  - /dmca-notice-how-to/
  - /articles/dmca-notice-how-to/
  - /articles/guide-to-submitting-a-dmca-takedown-notice
versions:
  free-pro-team: '*'
---

Este guia descreve as informações de que o GitHub precisa para processar uma solicitação de retirada DMCA. Se você tiver dúvidas mais gerais sobre o que é a DMCA ou como o GitHub processa solicitações de retirada DMCA, por favor, reveja nossa [Política de Aviso de Retirada DMCA](/articles/dmca-takedown-policy).

Devido ao tipo de conteúdo que o GitHub hospeda (principalmente código de software) e a forma como o conteúdo é gerenciado (com o Git), precisamos que as queixas sejam as mais específicas possíveis. Essas diretrizes destinam-se a tornar o processamento dos alegados avisos de infração o mais simples possível. A nossa forma de aviso descrita abaixo é consistente com o formulário sugerido pelo estatuto DMCA, que pode ser encontrado no site oficial do Escritório de Direitos Autorais dos Estados Unidos: <https://www.copyright.gov>. Copyright Office's official website: <https://www.copyright.gov>.

Como em todas as questões jurídicas, é sempre melhor consultar um profissional sobre suas dúvidas ou situação específica. Incentivamos a fazê-lo antes de tomar quaisquer medidas que possam impactar seus direitos. Este guia não é um aconselhamento jurídico e não deve ser tomado como tal.

### Antes de começar

***Diga a verdade.*** A DMCA requer que você jure pelos fatos relatados na reclamação dos direitos autorais, *sob pena de perjúrio*. Nos Estados Unidos, é crime federal mentir intencionalmente numa declaração juramentada. (*Veja* [Código dos EUA, Título 18, Seção 1621](https://www.gpo.gov/fdsys/pkg/USCODE-2011-title18/html/USCODE-2011-title18-partI-chap79-sec1621.htm). Code, Title 18, Section 1621</a>.) O envio de informações falsas também poderia resultar em responsabilidade civil — ou seja, você poderia ser processado por danos financeiros. A própria DMCA [prevê danos](https://en.wikipedia.org/wiki/Online_Copyright_Infringement_Liability_Limitation_Act#%C2%A7_512(f)_Misrepresentations) contra qualquer pessoa que, intencionalmente, deturpe materialmente o material ou a atividade que está sendo alvo de denúncia de violação de direitos autorais.

***Investigue.*** Milhões de usuários e organizações dedicam seus corações e mentes aos projetos para os quais eles contribuem e criam no GitHub. Apresentar uma queixa DMCA contra um projeto deste tipo é uma acusação jurídica grave que acarreta consequências reais para pessoas reais. Por causa disso, solicitamos que procedam a uma investigação minuciosa e consultem um advogado antes de apresentar um requerimento para se certificar de que tal uso não seja realmente permitido.

***Primeiro, peça gentilmente.*** Um ótimo primeiro passo antes de nos enviar um aviso é tentar entrar em contato diretamente com o usuário. Ele pode ter listado informações de contato na página de perfil público dele ou no LEIAME do repositório, ou você pode obter um contato abrindo um problema ou uma pull request no repositório. Isso não é estritamente necessário, mas é educado.

***Envie a solicitação correta.*** Só podemos aceitar avisos de DMCA para trabalhos protegidos por direitos autorais e que identifiquem um trabalho específico com direitos autorais. Se você tem uma reclamação sobre abuso de uso de marcas comerciais, por favor, veja nossa [Política de Marcas Registradas](/articles/github-trademark-policy/). Se você deseja remover dados confidenciais, como as senhas, consulte nossa [Política de Dados Confidenciais](/articles/github-sensitive-data-removal-policy/). Se estiver lidando com difamações ou outros comportamentos abusivos, veja as nossas [Diretrizes da Comunidade](/articles/github-community-guidelines/).

***Códigos são diferentes de outros conteúdos criativos.*** O GitHub foi projetado para a colaboração em código de softwares. Isto torna a identificação de uma violação válida dos direitos autorais mais complicada do que poderia ser, por exemplo, para fotos, música ou vídeos.

Há uma série de razões pelas quais códigos são diferentes de outros conteúdos criativos. Por exemplo:

- Um repositório pode incluir bits e pedaços de código de muitas pessoas diferentes, mas apenas um arquivo ou até mesmo uma subrotina dentro de um arquivo viola seus direitos autorais.
- Códigos misturam funcionalidade com expressão criativa, mas os direitos autorais protegem apenas os elementos expressivos, não as partes funcionais.
- Muitas vezes há licenças a considerar. O fato de uma peça de código ter um aviso de direitos autorais não significa, necessariamente, que esteja violando direitos. É possível que o código esteja sendo utilizado de acordo com uma licença de código aberto.
- Um determinado uso pode ser considerado [justo](https://www.lumendatabase.org/topics/22) se utilizar apenas uma pequena quantidade de conteúdo com direitos autorais, se utilizar esse conteúdo de forma transformada, se usá-lo para fins educacionais, ou alguma combinação do exposto acima. Como o código se presta naturalmente a tais usos, cada caso de utilização é diferente, e deve ser considerado separadamente.
- Códigos podem ser alegadamente violadores de direitos autorais de muitas maneiras diferentes, exigindo explicações pormenorizadas e identificações de trabalho.

Esta lista não é exaustiva, e é por isso que falar com um advogado sobre a queixa proposta é duplamente importante quando se trata de código.

***Sem bots.*** Você precisa contar com a avaliação de um profissional treinado a respeito dos fatos de cada aviso de retirada que você envia. Se você estiver terceirizando seus esforços para terceiros, certifique-se de saber como eles operam, e certifique-se de que eles não estão usando bots automatizados para enviar reclamações em massa. Essas queixas são, muitas vezes, inválidas e o seu processamento resulta em projetos desnecessariamente retirados!

***Questões de direitos autorais são difíceis.*** Pode ser muito difícil determinar se um trabalho específico está protegido por direitos de autor. Por exemplo, fatos (incluindo dados), geralmente, não são protegidos por direitos autorais. Palavras e frases curtas, geralmente, não são protegidas por direitos autorais. URLs e nomes de domínio, geralmente, não são protegidos por direitos autorais. Considerando que você só pode usar o processo DMCA direcionado a conteúdos protegidos por direitos autorais, se tiver dúvidas sobre se o seu conteúdo é ou não protegido, consulte um advogado.

***Você pode receber um contra-aviso de retirada.*** Qualquer usuário afetado por seu aviso de retidada pode decidir enviar um [contra-aviso de retirada](/articles/guide-to-submitting-a-dmca-counter-notice). Se isso acontecer, reativaremos o conteúdo dele dentro de 10-14 dias, a menos que você nos notifique de que iniciou uma ação na justiça procurando impedir que o usuário se envolva em atividades infratoras relacionadas ao conteúdo no GitHub.

***Sua reclamação será publicada.*** Conforme observado em nossa [Política de retirada DMCA](/articles/dmca-takedown-policy#d-transparency), depois de excluir as informações pessoais, publicaremos em <https://github.com/github/dmca>, na íntegra, todos os avisos de retirada válidos recebidos.

***O GitHub não é juiz.*** O GitHub se envolve pouco no processo, limitando-se a determinar se os avisos atendem aos requisitos mínimos da DMCA. Cabe às partes (e aos seus advogados) avaliar o mérito das suas reivindicações, tendo em conta que os avisos devem ser feitos corretamente sob pena de perjúrio.

### Sua reclamação deve...

1. **Incluir a seguinte declaração: "Eu li e compreendi o Guia do GitHub para o Preenchimento de um Aviso DMCA".** Não nos recusaremos a processar um aviso, caso você não inclua essa declaração. Mas saberemos que você não leu essas diretrizes e poderemos pedir para que o faça.

2. **Identificar o trabalho protegido por direitos autorais que você acredita ter sido violado.** Essa informação é importante porque ajuda o usuário afetado a avaliar sua reivindicação e a dar a ele a capacidade de comparar seu trabalho com o dele. A especificidade da sua identificação dependerá da natureza do trabalho que você acredita ter sido violado. Se você publicou seu trabalho, talvez consiga fornecer um link para a página web onde ele está hospedado. Se você for proprietário e não tiver publicado, poderá descrevê-lo e explicar que detém a propriedade. Se você o registrou no Escritório de Direitos Autorais, inclua o número de registro. Se você está alegando que o conteúdo hospedado é uma cópia direta e literal do seu trabalho, também pode explicar esse fato.

3. **Identificar o material que você alega estar violnado o trabalho protegido por direitos autorais listado no item #2 acima.** É importante ser o mais específico possível em sua identificação. Essa identificação precisa ser razoavelmente suficiente para permitir que o GitHub localize o material. No mínimo, isso significa que você deve incluir a URL do material que alegadamente viola seus direitos autorais. Se você alegar que um repositório não infringe os direitos autorais como um todo, identifique o(s) arquivo(s) específico(s) ou números de linhas dentro de um arquivo que você alega infringir. Se você alegar que todo o conteúdo de uma URL infringe os direitos, por favor, seja explícito a respeito disso também. Finalmente, note que o GitHub *não* desativará automaticamente [bifurcações](/articles/dmca-takedown-policy#b-what-about-forks-or-whats-a-fork) ao desabilitar um repositório principal. Se você investigou e analisou as bifurcações de um repositório e acredita que elas também estão infringindo direitos, por favor, identifique explicitamente cada bifurcação supostamente violadora. Por favor, confirme também que você investigou cada caso individual e que suas declarações juramentadas se aplicam a cada bifurcação identificada.

4. **Explicar o que o usuário afetado precisa fazer para corrigir a infração.** Novamente, ser específico é importante. Ao passarmos sua reclamação para o usuário, ela precisa mostrar claramente o que ele precisa fazer para evitar que o resto do conteúdo seja desabilitado. O usuário precisa apenas adicionar uma declaração de atribuição? Ele precisa excluir determinadas linhas dentro do código deles, ou arquivos inteiros? Compreendemos que, em alguns casos, todo o conteúdo de um usuário pode supostamente estar infringido direitos e não há nada que ele possa fazer a não ser deletar tudo. Se esse for o caso, por favor, deixe isso claro.

5. **Fornecer suas informações de contato.** Inclua seu endereço de e-mail, nome, número de telefone e endereço físico.

6. **Fornecer informações de contato do infrator, caso conheça.** Geralmente, será suficiente fornecer o nome de usuário do GitHub associado ao conteúdo supostamente violador de direitos. Mas pode haver casos em que você tenha conhecimento adicional sobre o suposto infrator. Em caso afirmativo, compartilhe conosco essa informação.

7. **Incluir a afirmação a seguir: "Acredito, de boa fé, que o uso dos materiais protegidos por direitos autorais descritos acima, nas páginas infratoras, não foi autorizado pelo proprietário dos direitos autorais ou por seu agente ou pela lei. Levei em consideração o uso justo."**

8. **Incluir também a seguinte declaração: "Juro, sob pena de perjúrio, que a informação neste aviso é correta, e que sou o proprietário dos direitos autorais, ou estou autorizado a agir em nome do proprietário de um direito exclusivo que alegadamente foi violado."**

9. **Incluir sua assinatura física ou eletrônica.**

### Queixas sobre Tecnologia Anticircunvenção

A Lei de Direitos Autorais proíbe, igualmente, que se burle medidas tecnológicas que controlem efetivamente o acesso às obras protegidas pelos direitos de autor. Se você acredita que o conteúdo hospedado no GitHub viola esta proibição, envie-nos um relatório através de nosso {% data variables.contact.contact_dmca %}, e inclua informações específicas sobre o conteúdo que viola essa proibição, quais as medidas tecnológicas em vigor e por que razão o conteúdo viola a proibição.

### Como enviar sua reclamação

A maneira mais rápida de obter uma resposta é inserir suas informações e responder todas as perguntas em nosso {% data variables.contact.contact_dmca %}.

Você também pode enviar notificações de e-mail para <copyright@github.com>. Você pode incluir um anexo, se quiser, mas inclua também uma versão em texto simples da sua carta no corpo da sua mensagem.

Se você precisa enviar o aviso por correio físico, você também pode fazer isso, mas vai demorar *substancialmente* para que possamos receber e responder. Avisos que recebemos por e-mail em texto simples têm um tempo de resposta muito mais rápido do que por PDF anexado ou mensagem física. Se você ainda assim deseja nos enviar seu aviso por correio, nosso endereço físico é:

```
GitHub, Inc Attn: DMCA Agent
88 Colin P Kelly Jr St San Francisco, CA. 94107
```
