---
title: Práticas de privacidade global
redirect_from:
  - /eu-safe-harbor/
  - /articles/global-privacy-practices
versions:
  free-pro-team: '*'
---

Data de entrada em vigor: 22 de Julho de 2020

O GitHub fornece o mesmo padrão alto de proteção de privacidade — conforme descrito na [Declaração de privacidade](/github/site-policy/github-privacy-statement#githubs-global-privacy-practices)do GitHub — para todos os nossos usuários e clientes em todo o mundo, independentemente do seu país de origem ou local. Além disso, o GitHub orgulha-se do nível de aviso prévio, escolha, responsabilidade, segurança, integridade de dados, acesso e recursos que fornecemos.

O GitHub também está em conformidade com certos quadros jurídicos relacionados à transferência de dados do Espaço Econômico Europeu, Reino Unido, e Suíça (coletivamente, denominada “UE”) para os Estados Unidos. Quando o GitHub se envolve em tais transferências, ele conta com as Cláusulas Contratuais Padrão como mecanismo legal para ajudar a garantir que seus direitos e proteções acompanhem as suas informações pessoais. Além disso, a GitHub é certificado nos Quadros de Proteção à Privacidade entre UE e EUA e Suíça e EUA. Para saber mais sobre as decisões da Comissão Europeia sobre a transferência internacional de dados, veja este artigo no [site da Comissão Europeia](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection_en).

### Cláusulas Contratuais Padrão

O GitHub conta com as Cláusulas Contratuais Padrão aprovadas pela Comissão Europeia (“SCCs”) como um mecanismo legal para transferências de dados da UE. Os SCCs são compromissos contratuais entre empresas que transferem dados pessoais, vinculando-as a proteger a privacidade e a segurança desses dados. O GitHub adotou as SCCs para que os fluxos de dados necessários possam ser protegidos quando transferidos para fora da UE para países cuja proteção de dados não é considerada adequada pela Comissão Europeia, incluindo a proteção de transferências de dados para os Estados Unidos.

Para saber mais sobre as SCCs, consulte este artigo no [site da Comissão Europeia](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en).

### Estrutura de Defesa da Privacidade

O GitHub é certificado nas estruturas do Escudo de Privacidade Privacidade entre a UE e os EUA e entre a Suíça e os EUA e nos compromissos que implicam, embora o GitHub não dependa da Estrutura do Escudo de Privacidade entre a UE e os EUA como base jurídica para transferências de informações pessoais à luz da decisão do Tribunal de Justiça da UE no processo C-311/18.

Os Estruturas do Escudo de Privacidade entre a UE e os EU e entre a Suíça e os EUA são estabelecidas pelo Departamento do Comércio dos EUA no que se refere à coleta, uso, e retenção de Informações Pessoais do Usuário transferidas da União Europeia, Reino Unido e Suíça para os Estados Unidos. O GitHub certificou ao Departamento do Comércio que cumpre com os princípios de Defesa da Privacidade. Se nossos fornecedores ou afiliados processarem as Informações Pessoais do Usuário em nosso nome, de forma inconsistente com os princípios do Escudo de Proteção de Privacidade, o GitHub permanecerá responsável, a menos que provemos que não somos responsáveis por este evento causador do dano.

Para fins das nossas certificações nos termos das Estruturas do Escudo de Privacidade, se houver qualquer conflito entre os termos nestas Práticas Globais de Privacidade e os Princípios da Proteção à Privacidade, prevalecerão os Princípios da Proteção à Privacidade. Para saber mais sobre o programa do Escudo de Proteção da Privacidade e consultar nossa certificação, acesse o site do [Escudo de Proteção da Privacidade](https://www.privacyshield.gov/).

As Estruturas do Escudo de Privacidade têm por base sete princípios e o GitHub cumpre-os das seguintes maneiras:

- **Aviso**
  - Nós informamos quando estamos coletando suas informações pessoais.
  - Nós deixamos você saber, em nossa [Declaração de Privacidade](/articles/github-privacy-statement/), que objetivos temos ao coletar e usar suas informações, com quem compartilhamos essas informações e sob quais restrições e quais acessos você tem aos seus dados.
  - Nós deixamos você saber que estamos participando da Estrutura de Defesa da Privacidade, e o que isso significa para você.
  - Nós temos um {% data variables.contact.contact_privacy %} onde você pode entrar em contato conosco com perguntas sobre sua privacidade.
  - Nós o deixamos consciente de seu direito de invocar arbitragem vinculante, desde que sem nenhum custo para você, no caso improvável de uma disputa.
  - Nós o informamos de que estamos sujeitos à jurisdição da Comissão Federal de Comércio.
- **Escolha**
  - Deixamos você escolher o que acontece com seus dados. Antes de usarmos seus dados para um propósito diferente daquele para o qual você os concedeu, nós o avisaremos e obteremos sua permissão.
  - Forneceremos a você mecanismos razoáveis para fazer as suas escolhas.
- **Responsabilidade por Transferência Subsequente**
  - Quando transferimos suas informações para fornecedores terceirizados que estão processando-as em nosso nome, estamos apenas enviando seus dados para terceiros, sob contrato conosco, que irá protegê-las consistentemente com nossa Declaração de Privacidade. Quando transferimos seus dados para nossos fornecedores sob a Defesa da Privacidade, continuamos responsáveis por eles.
  - Compartilhamos apenas a quantidade necessária de dados com nossos fornecedores terceirizados para concluir sua transação.
- **Segurança**
  - Protegeremos suas informações pessoais com [todas as medidas de segurança razoáveis e apropriadas](https://github.com/security).
- **Integridade de dados e Limitação de propósito**
  - Nós coletamos seus dados apenas para os fins relevantes para fornecermos nossos serviços a você.
  - Coletamos o mínimo de informações sobre você que pudermos, a menos que você escolha nos fornecer mais informações.
  - Tomamos medidas razoáveis para garantir que os dados que temos sobre você sejam precisos, atuais e confiáveis para o seu uso pretendido.
- **Access**
  - Você sempre poderá acessar os dados que temos sobre você em seu [perfil do usuário](https://github.com/settings/profile). Você pode acessar, atualizar, alterar ou excluir suas informações lá.
- **Recurso, Lei aplicável e Responsabilidade**
  - Se você tem dúvidas sobre nossas práticas de privacidade, você pode nos contatar com o nosso {% data variables.contact.contact_privacy %} e responderemos dentro de 45 dias, no máximo.
  - No caso improvável de uma disputa que não podemos resolver, você tem acesso à arbitragem vinculativa sem nenhum custo para você. Por favor, consulte nossa [Declaração de Privacidade](/articles/github-privacy-statement/) para obter mais informações.
  - Realizaremos auditorias regulares de nossas práticas de privacidade relevantes para verificar o cumprimento das promessas que fizemos.
  - Exigimos que nossos funcionários respeitem compromissos de privacidade, e a violação de nossas políticas de privacidade está sujeita a ações disciplinares, incluindo até mesmo a rescisão do contrato de emprego.


#### Processo de resolução de conflitos

Conforme explicado na seção [Resolver reclamações](/github/site-policy/github-privacy-statement#resolving-complaints) da nossa [Declaração de privacidade](/github/site-policy/github-privacy-statement), nós o incentivamos a entrar em contato conosco, caso tenha uma reclamação relacionada ao Escudo de Privacidade (ou alguma reclamação relacionada à privacidade em geral). Para quaisquer reclamações que não possam ser resolvidas com o GitHub diretamente, selecionamos cooperar com a Autoridade de Proteção de Dados relevante da UE ou com o conselho criado pelas autoridades europeias de proteção de dados para a resolução de conflitos com indivíduos da UE, e com o Comissário Federal de Proteção e Informação de Dados (FDPIC) para a resolução de conflitos com indivíduos da Suíça. Se você precisar de direcionamento quanto aos contatos da sua autoridade de proteção de dados, entre em contato conosco.

Se for residente de um estado-membro da UE, você terá o direito de apresentar queixa junto à autoridade de supervisão local.

#### Arbitragem independente

Em determinadas circunstâncias, indivíduos da UE, da Área Econômica Europeia (AEE), da Suíça e do Reino Unido podem convocar arbitragem vinculativa para o Escudo de Proteção da Privacidade como último recurso, caso nenhuma das outras formas de resolução de conflitos tenha êxito. Para saber mais sobre esse método de resolução e sua disponibilidade para você, leia mais sobre o [Escudo de Proteção da Privacidade](https://www.privacyshield.gov/article?id=ANNEX-I-introduction). A arbitragem não é obrigatória; trata-se de uma ferramenta disponível para seu uso.

Estamos sujeitos à jurisdição da Comissão Federal do Comércio dos EUA (FTC).

Por favor, consulte nossa [Declaração de Privacidade](/articles/github-privacy-statement/) para obter mais informações.
