---
title: Termos de serviço do GitHub
redirect_from:
  - /tos/
  - /terms/
  - /terms-of-service/
  - /github-terms-of-service-draft/
  - /articles/github-terms-of-service
versions:
  free-pro-team: '*'
---

Obrigado por usar o GitHub! Estamos felizes por você estar aqui. Por favor, leia estes Termos de Serviço com cuidado antes de acessar ou usar o GitHub. Por se tratar de um contrato tão importante entre nós e os usuários, tentamos torná-lo o mais claro possível. Para sua conveniência, apresentamos estes termos num breve resumo não vinculativo, seguido da totalidade dos termos jurídicos.

### Sumário

| Seção                                                                     | Conteúdo                                                                                                                                                                                                                                                    |
| ------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [A. Definições](#a-definitions)                                           | Alguns termos básicos estão definidos de forma a lhe ajudar a compreender este contrato. Consulte novamente esta seção para quaisquer esclarecimentos.                                                                                                      |
| [B. Termos da conta](#b-account-terms)                                    | Estes são os requisitos básicos para ter uma Conta no GitHub.                                                                                                                                                                                               |
| [C. Uso Aceitável](#c-acceptable-use)                                     | Estas são as regras básicas que você deve seguir ao usar sua Conta no GitHub.                                                                                                                                                                               |
| [D. Conteúdo gerado pelo usuário](#d-user-generated-content)              | Você é o proprietário do conteúdo que posta no GitHub. No entanto, você tem algumas responsabilidades relativamente a esta questão, e nós pedimos que você nos conceda alguns direitos para que possamos fornecer-lhe serviços.                             |
| [E. Repositórios privados](#e-private-repositories)                       | Esta seção fala como o GitHub tratará o conteúdo que você publicar em repositórios privados.                                                                                                                                                                |
| [F. Copyright & Política DMCA](#f-copyright-infringement-and-dmca-policy) | Esta seção fala sobre como o GitHub irá responder se você acredita que alguém esteja violando seus direitos autorais no GitHub.                                                                                                                             |
| [G. Avisos de Propriedade Intelectual](#g-intellectual-property-notice)   | Isto descreve os direitos do GitHub no site e no serviço.                                                                                                                                                                                                   |
| [H. Termos da API](#h-api-terms)                                          | Estas são as regras para usar as APIs do GitHub, quer você esteja usando a API para desenvolvimento ou coleta de dados.                                                                                                                                     |
| [I. Termos Adicionais do Produto](#i-github-additional-product-terms)     | Temos algumas regras específicas para os produtos e recursos do GitHub.                                                                                                                                                                                     |
| [J. Visualizações Beta](#j-beta-previews)                                 | Estes são alguns dos termos adicionais que se aplicam aos recursos do GitHub que ainda estão em desenvolvimento.                                                                                                                                            |
| [K. Pagamento](#k-payment)                                                | Você é responsável pelo pagamento. Somos responsáveis pela sua cobrança com precisão.                                                                                                                                                                       |
| [L. Cancelamento e Rescisão](#l-cancellation-and-termination)             | Você pode cancelar este contrato e fechar sua Conta a qualquer momento.                                                                                                                                                                                     |
| [M. Comunicações com o GitHub](#m-communications-with-github)             | Usamos apenas o e-mail e outros meios eletrônicos para nos mantermos em contato com nossos usuários. Não fornecemos suporte telefônico.                                                                                                                     |
| [N. Isenção de Garantias](#n-disclaimer-of-warranties)                    | Fornecemos nosso serviço tal como está, e não fazemos promessas nem damos garantias sobre este serviço. **Por favor, leia esta seção cuidadosamente; você deve entender o que esperar.**                                                                    |
| [O. Limitação de responsabilidade](#o-limitation-of-liability)            | Não seremos responsáveis por danos ou prejuízos resultantes da sua utilização ou incapacidade de utilizar o serviço ou de outra forma decorrente deste contrato. **Por favor, leia esta seção cuidadosamente; ela limita nossas obrigações para com você.** |
| [P. Versão e Indenização](#p-release-and-indemnification)                 | Você é totalmente responsável pelo uso do serviço.                                                                                                                                                                                                          |
| [Q. Eu concordo com estes Termos de Serviço](#q-changes-to-these-terms)   | Podemos modificar este contrato, mas vamos dar a você um aviso de 30 dias sobre as alterações que afetem seus direitos.                                                                                                                                     |
| [R. Disposições Gerais](#r-miscellaneous)                                 | Por favor, veja esta seção para detalhes legais, incluindo a nossa escolha de legislação.                                                                                                                                                                   |

### Termos de Serviço do GitHub
Data de vigência: 2 de abril de 2020


### A. Definições
**Versão reduzida:** *Nós usamos esses termos básicos em todo o contrato, e eles têm significados específicos. Você deve saber o que queremos dizer quando usamos cada um dos termos. Não vamos aplicar um teste sobre isso, mas ainda assim, são informações úteis.*

1. Uma "Conta" representa seu vínculo legal com o GitHub. Uma "Conta de Usuário" representa uma autorização individual de Usuário para entrar e usar o Serviço e serve como identidade do Usuário no GitHub. “Organizações” são espaços de trabalho compartilhados que podem estar associados a uma única entidade ou a um ou mais Usuários em que vários Usuários podem colaborar em vários projetos de uma só vez. Uma Conta de Usuário pode ser um integrante de um número qualquer de Organizações.
2. O "Contrato" refere-se, coletivamente, a todos os termos, condições, avisos contidos ou referenciados neste documento (os “Termos de Serviço” ou os "Termos") e todas as outras regras operacionais, políticas (incluindo a Declaração de Privacidade do GitHub, disponível em [github.com/site/privacy](https://github.com/site/privacy)) e procedimentos que podemos publicar de vez em quando no Site. A maioria das nossas políticas de site está disponível em [docs.github.com/categories/site-policy](/categories/site-policy).
3. "Visualizações Beta" significa software, serviços ou recursos identificados como alfa, beta, visualização, acesso antecipado ou avaliação, ou palavras e frases com significados semelhantes.
4. "Conteúdo" refere-se ao conteúdo em destaque ou exibido através do Site, incluindo sem código de limitação, texto, dados, artigos, imagens, fotografias, gráficos, software, aplicativos, pacotes, designs, recursos e outros materiais que estão disponíveis no Site ou disponíveis através do Serviço. "Conteúdo" também inclui Serviços. O "Conteúdo Gerado pelo Usuário" é Conteúdo, escrito ou não, criado ou carregado pelos nossos Usuários. "Seu conteúdo" é o Conteúdo que você cria ou possui.
5. "GitHub" e "nós" referem-se ao GitHub, Inc., bem como nossas filiais, diretores, subsidiárias, contratantes, licenciadores, executivos, agentes e funcionários.
6. O "Serviço" refere-se aos aplicativos, software, produtos e serviços fornecidos pelo GitHub, incluindo todas as Visualizações Beta.
7. "O Usuário", "Você", e "Seu", referem-se à pessoa individual, empresa ou organização que tenha visitado ou esteja usando o Site ou Serviço; que acessa ou utiliza qualquer parte da Conta; ou que gerencia o uso da Conta no desempenho de suas funções. O Usuário deve ter pelo menos 13 anos de idade. Termos especiais podem se aplicar para Contas de empresa ou do governo (Veja [Seção B(5): Termos Adicionais](#5-additional-terms)).
8. O "Site" refere-se ao site do GitHub localizado em [github.com](https://github.com/) e todo o conteúdo, serviços e produtos fornecidos pelo GitHub no ou através do Site. Ele também se refere a subdomínios do GitHub, do github.com, como [education.github.com](https://education.github.com/) e [pages.github.com](https://pages.github.com/). Estes Termos também regem os sites de conferência do GitHub, como [githubuniverse.com](https://githubuniverse.com/) e sites de produtos, como [atom.io](https://atom.io/). Ocasionalmente, sites pertencentes ao GitHub podem fornecer termos de serviço diferentes ou adicionais. Se esses termos adicionais entram em conflito com este Contrato, os termos mais específicos se aplicam à página ou serviço relevante.

### B. Termos da conta
**Versão curta:** *Contas e Organizações do Usuário têm controles administrativos diferentes; uma pessoa precisa criar sua Conta; você deve ter 13 anos ou mais; deve fornecer um endereço de e-mail válido e não pode ter mais de uma Conta gratuita. Você é o único responsável por sua Conta e tudo o que acontece enquanto você estiver logado ou usando sua Conta. Você é responsável por manter sua Conta segura.*

#### 1. Account Controls
- Usuários. Sujeito a estes Termos, você mantém o controle administrativo final sobre sua Conta de Usuário e o Conteúdo dentro dela.

- Organizações. O "proprietário" de uma Organização que foi criada sob estes Termos tem o controle administrativo supremo sobre essa Organização e sobre o Conteúdo dentro dela. No Serviço, um proprietário pode gerenciar acesso de Usuário aos dados e projetos da Organização. Uma Organização pode ter vários proprietários, mas deve haver pelo menos uma Conta de Usuário designada como proprietário de uma Organização. Se você é o proprietário de uma Organização sob estes Termos, nós consideramos que você é responsável pelas ações que são executadas naquela Organização ou através dela.

#### 2. Informações obrigatórias
Você deve fornecer um endereço de e-mail válido para concluir o processo de inscrição. Qualquer outra informação solicitada, como seu nome real, é opcional, a menos que você esteja aceitando estes termos em nome de uma entidade legal (caso em que precisamos de mais informações sobre a entidade legal) ou se você optar por uma [Conta paga](#k-payment), nesse caso, serão necessárias informações adicionais para fins de faturamento.

#### 3. Requisitos da conta
Temos algumas regras simples para Contas de Usuário no Serviço do GitHub.
- Você deve ser uma pessoa para criar uma Conta. Contas registradas por "bots" ou outros métodos automatizados não são permitidas. Nós permitimos contas de máquina:
- Conta de máquina significa uma Conta registrada por um indivíduo que aceita os Termos aplicáveis à Conta, fornece um endereço de e-mail válido e é responsável por suas ações. Uma conta de máquina é usada exclusivamente para executar tarefas automatizadas. Múltiplos usuários podem direcionar as ações de uma conta de máquina, mas o proprietário da Conta é, em última análise, responsável pelas ações da máquina. Você pode manter não mais de uma conta gratuita de máquina, além de sua Conta de Usuário gratuita.
- Uma pessoa ou entidade legal não pode manter mais de uma Conta gratuita (se você optar por controlar uma conta de máquina também, sem problemas, mas só pode ser usada para executar uma máquina).
- Você deve ter 13 anos ou mais. Embora nos sintamos felizes ao vermos os brilhantes codificadores se entusiasmarem ao aprender a programar, temos de cumprir a legislação dos Estados Unidos. O GitHub não direciona nosso Serviço para crianças com menos de 13 anos, e nós não permitimos quaisquer Usuários com menos de 13 anos no nosso Serviço. Se soubermos de qualquer Usuário menor de 13 anos, vamos [encerrar a Conta de Usuário imediatamente](#l-cancellation-and-termination). Se você for residente de um país fora dos Estados Unidos, a idade mínima do seu país pode ser maior; num caso destes, você é responsável por cumprir as leis do seu país.
- Seu login pode ser usado apenas por uma pessoa — ou seja, um único login não pode ser compartilhado por várias pessoas. Uma organização paga só pode fornecer acesso ao número de Contas de Usuário que sua assinatura permite.
- Você não pode usar o GitHub em violação do controle de exportação ou das leis de sanções dos Estados Unidos ou de qualquer outra jurisdição aplicável. Você não pode usar o GitHub se você é ou está trabalhando em nome de um [Nacional Especialmente Designado (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) ou uma pessoa sujeita a bloqueios semelhantes ou proibições de parte negada administradas por uma agência do governo dos EUA. government agency.  O GitHub pode permitir que pessoas em certos países ou territórios sancionados acessem certos serviços do GitHub de acordo com as autorizações do governo dos Estados Unidos. government authorizations.  Para obter mais informações, por favor veja nossa [política de Controles de Exportação](/articles/github-and-export-controls).

#### 4. Segurança da Conta de Usuário
Você é responsável por manter sua Conta segura enquanto usa nosso Serviço. Nós oferecemos ferramentas como a autenticação de dois fatores para ajudá-lo a manter a segurança de sua Conta, mas o conteúdo de sua Conta e sua segurança são de sua responsabilidade.
- Você é responsável por todos os conteúdos postados e atividades que ocorrem em sua Conta (mesmo quando o conteúdo é postado por outros que têm Contas em sua Conta).
- Você é responsável por manter a segurança de sua Conta e senha. O GitHub não pode e não será responsabilizado por qualquer perda ou dano causado por sua falha em cumprir com esta obrigação de segurança.
- Você irá rapidamente [notificar o GitHub](https://support.github.com/contact) se estiver ciente de qualquer uso não autorizado de, ou acesso a, nosso Serviço através de sua Conta, incluindo qualquer uso não autorizado de sua senha ou Conta.

#### 5. Additional Terms
Em algumas situações, os termos de terceiros podem ser aplicados ao seu uso do GitHub.  Por exemplo, você pode ser integrante de uma organização no GitHub com seus próprios termos ou contratos de licença. Você poderá baixar um aplicativo que se integra ao GitHub; ou utilizar o GitHub para autenticar em outro serviço. Por favor, esteja ciente de que, embora esses Termos representem nosso acordo total com você, os termos de terceiros governam suas relações com você.

Se você é um Usuário do governo ou, de outro modo, acessar ou usar qualquer Serviço GitHub em uma competência do governo, esta [Emenda do Governo aos Termos de Serviço do GitHub](/articles/amendment-to-github-terms-of-service-applicable-to-u-s-federal-government-users/) se aplica a você, e você concorda com as suas disposições.

Se você se inscreveu para o GitHub Enterprise Cloud, o [Adendo Enterprise Cloud](/articles/github-enterprise-cloud-addendum/) aplica-se a você, e você concorda com suas provisões.

### C. Uso Aceitável
**Versão curta:** *GitHub hospeda uma grande variedade de projetos colaborativos de todo o mundo, e essa colaboração só funciona quando nossos usuários são capazes de trabalhar em conjunto de boa fé. Ao usar o serviço, você deve estar de acordo com os termos desta seção, que inclui algumas restrições sobre o conteúdo que você pode publicar, conduta no serviço e outras limitações. Em resumo, sejam excelentes uns com os outros.*

O seu uso do Site e Serviço não deve violar nenhuma lei aplicável, incluindo leis de direitos autorais ou de marcas registradas, controle de exportação ou leis de sanções, ou outras leis em sua jurisdição. Você é responsável por se certificar de que o uso do Serviço está em conformidade com as leis e quaisquer regulamentos aplicáveis.

Você concorda que, em nenhuma circunstância, violará nossas [Políticas de Uso Aceitáveis](/articles/github-acceptable-use-policies) ou [Diretrizes Comunitárias](/articles/github-community-guidelines).

### D. Conteúdo gerado pelo usuário
**Versão curta:** *Você possui o conteúdo que você cria, mas nos concede determinados direitos a ele, para que possamos exibir e compartilhar o conteúdo que você publicar. Você ainda tem controle sobre seu conteúdo e responsabilidade por ele, e os direitos que você nos concede são limitados àqueles que precisamos para fornecer o serviço. Temos o direito de remover conteúdo ou fechar Contas se precisarmos.*

#### 1. Responsabilidade pelo conteúdo gerado pelo usuário
Você pode criar ou fazer upload do conteúdo gerado pelo usuário usando o Serviço. Você é o único responsável pelo conteúdo e por qualquer dano resultante de qualquer conteúdo gerado pelo usuário que você publicar, fizer upload, linkar para ou deixar disponível através do Serviço, independentemente da forma desse Conteúdo. Não somos responsáveis por nenhuma exibição pública ou uso indevido do seu Conteúdo Gerado pelo Usuário.

#### 2. O GitHub pode remover conteúdo
Não pré-avaliamos o Conteúdo Gerado pelo Usuário, mas temos o direito (embora não tenhamos a obrigação) de recusar ou remover qualquer Conteúdo Gerado pelo Usuário que, em nosso exclusivo critério, viole quaisquer [termos ou políticas no GitHub](/github/site-policy).

#### 3. Ownership of Content, Right to Post, and License Grants
Você mantém a propriedade e a responsabilidade pelo seu conteúdo. Se você está postando qualquer coisa que você não criou ou não possui os direitos, você concorda que é responsável por qualquer conteúdo que você publique; que você só enviará Conteúdo que você tem o direito de publicar; e que você esteja em total conformidade com licenças de terceiros relacionadas ao Conteúdo que você publicar.

Porque você retem a propriedade e a responsabilidade do seu conteúdo, precisamos que você nos conceda — e outros usuários do GitHub — certas permissões legais, listadas nas Seções D.4 — D.7. Estas concessões de licença se aplicam ao Seu Conteúdo. Se você fizer upload de Conteúdo que já vem com uma licença que concede ao GitHub as permissões que precisamos para executar nosso Serviço, nenhuma licença adicional é necessária. Você compreende que não receberá nenhum pagamento por qualquer um dos direitos concedidos nas Seções D.4 — D.7. As licenças que você nos concede terminarão quando você remover Seu Conteúdo de nossos servidores, a menos que outros Usuários o tenham bifurcado.

#### 4. Concessão de licença para nós
Precisamos do direito legal para fazer coisas como hospedar Seu Conteúdo, publicá-lo, e compartilhá-lo. Você concede a nós e aos nossos sucessores legais o direito de armazenar, analisar e exibir Seu Conteúdo, e fazer cópias acessórias conforme necessário para renderizar o Site e fornecer o Serviço. Isto inclui o direito de fazer coisas como copiá-lo para a nossa base de dados e fazer backups; mostrá-lo para você e para outros usuários; analisá-lo em um índice de pesquisa ou analisá-lo em nossos servidores; compartilhá-lo com outros usuários; e executá-lo, no caso de Seu Conteúdo ser algo como música ou vídeo.

Esta licença não concede ao GitHub o direito de vender Seu Conteúdo ou, de outra forma, distribuí-lo ou usá-lo fora de nossa provisão do Serviço.

#### 5. Concessão de licença a outros usuários
Qualquer Conteúdo gerado pelo Usuário que você publicar publicamente, incluindo problemas, comentários e contribuições para repositórios de outros Usuários, pode ser visto por outros. Definindo seus repositórios para serem vistos publicamente, você concorda em permitir que outros vejam e "bifurquem" seus repositórios (isso significa que outros podem fazer suas próprias cópias do Conteúdo de seus repositórios em repositórios que eles controlam).

Se você definir suas páginas e repositórios para serem vistos publicamente, você concede a cada Usuário do GitHub uma licença mundial não exclusiva para uso, exibição e execução de Seu Conteúdo através do Serviço GitHub e para reproduzir Seu Conteúdo exclusivamente no GitHub, conforme permitido através da funcionalidade do GitHub (por exemplo, através da bifurcação). Você poderá conceder direitos adicionais se [adotar uma licença](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository). Se você está fazendo upload do Conteúdo que você não criou ou possui, você é responsável por garantir que o Conteúdo que você faz o upload é licenciado em termos que concedem essas permissões a outros Usuários do GitHub.

#### 6. Contribuições na licença de repositório
Sempre que você fizer uma contribuição a um repositório que contém notificação de uma licença, você licencia sua contribuição nos mesmos termos e concorda que tem o direito de licenciar sua contribuição nesses termos. Se possui um contrato separado para licenciar suas contribuições em termos diferentes, como um contrato de licença de colaborador, esse contrato será substituído.

Não é assim que as coisas já funcionam? Sim. Isso é amplamente aceito como a norma na comunidade de código aberto; é comumente referido pela abreviatura "entrada=saída". Estamos apenas tornando isso explícito.

#### 7. Moral Rights
Você mantém todos os direitos morais do Seu Conteúdo que você faz upload, publica ou envia em qualquer parte do Serviço, incluindo os direitos de integridade e atribuição. No entanto, você renuncia a esses direitos e concorda em não fazê-los valer contra nós, no intuito de permitir que exerçamos razoavelmente os direitos concedidos na Seção D.4, mas não de outra maneira.

Na medida em que este contrato não é aplicável pela legislação aplicável, você concede ao GitHub os direitos que precisamos para usar Seu Conteúdo sem atribuição e fazer adaptações razoáveis do Seu Conteúdo conforme necessário para renderizar o Site e fornecer o Serviço.

### E. Repositórios privados
**Versão curta:** *Você pode ter acesso a repositórios privados. Nós tratamos o conteúdo de repositórios privados como confidencial, e só acessamos por razões de suporte, com seu consentimento, ou se necessário, por razões de segurança.*

#### 1. Controle de Repositórios Privados
Algumas Contas podem ter repositórios privados, que permitem ao Usuário controlar o acesso ao Conteúdo.

#### 2. Confidencialidade dos Repositórios Privados
O GitHub considera o conteúdo de repositórios privados como confidencial para você. O GitHub protegerá o conteúdo de repositórios privados de uso, acesso ou divulgação não autorizados da mesma forma que utilizaríamos para proteger nossas próprias informações confidenciais de natureza semelhante e, em todo caso, com um grau de cuidado razoável.

#### 3. Access
Os funcionários do GitHub somente podem acessar o conteúdo de seus repositórios privados nas seguintes situações:
- Com o seu consentimento e conhecimento, por motivo de suporte. Se o GitHub acessar um repositório privado por motivo de suporte, nós faremos isso somente com o consentimento e conhecimento do proprietário.
- Quando o acesso é necessário por razões de segurança, incluindo quando o acesso é necessário para manter a confidencialidade, integridade, disponibilidade e resiliência contínuas dos sistemas e Serviço do GitHub.

Você pode optar por habilitar acesso adicional a seus repositórios privados. Por exemplo:
- Você pode habilitar vários serviços do GitHub ou recursos que requerem direitos adicionais ao Seu Conteúdo em repositórios privados. Estes direitos podem variar, dependendo do serviço ou recurso, mas o GitHub continuará a tratar seu Conteúdo do repositório privado como confidencial. Se esses serviços ou recursos exigem direitos além daqueles que precisamos fornecer no Serviço GitHub, forneceremos uma explicação desses direitos.

#### 4. Exclusions
Se tivermos razões para acreditar que os conteúdos de um repositório privado estão violando a lei ou estes Termos, temos o direito de acessar, revisar e removê-los. Além disso, podemos ser [obrigados, por lei,](/github/site-policy/github-privacy-statement#for-legal-disclosure) a divulgar o conteúdo de seus repositórios privados.

### F. Copyright Infringement and DMCA Policy
Se você acredita que o conteúdo em nosso site viola seus direitos autorais, por favor, entre em contato conosco de acordo com nossa [Política Digital Millennium Copyright Act](/articles/dmca-takedown-policy/). Se você é um proprietário de direitos autorais e acredita que o conteúdo no GitHub viola seus direitos, por favor, entre em contato conosco via [formulário DMCA](https://github.com/contact/dmca) ou envie e-mail para copyright@github.com. Poderá haver consequências jurídicas para o envio de um aviso de remoção falso ou leviano. Antes de enviar uma solicitação de remoção, você deve considerar usos legais, tais como uso justo e usos licenciados.

Nós encerraremos as Contas de [infratores reiterados](/articles/dmca-takedown-policy/#e-repeated-infringement) desta política.

### G. Avisos de Propriedade Intelectual
**Versão curta:** *Nós somos proprietários do serviço e de todo o nosso conteúdo. Para que você use nosso conteúdo, nós lhe damos certos direitos relativos a ele, mas você só pode usar nosso conteúdo da forma que permitimos.*

#### 1. GitHub's Rights to Content
GitHub e nossos licenciadores, fornecedores, agentes, e/ou nossos provedores de conteúdo detêm a propriedade de todos os direitos de propriedade intelectual de qualquer tipo relacionados ao Site e Serviço. Reservamo-nos todos os direitos que não lhe são expressamente concedidos neste Contrato ou por lei. O visual e a impressão do Site e do Serviço estão protegidos sob direitos autorais de  © GitHub, Inc. Todos os direitos reservados. Você não pode duplicar, copiar ou reutilizar qualquer parte do HTML/CSS, Javascript ou conceitos e elementos de design visual sem permissão escrita expressa do GitHub.

#### 2. GitHub Trademarks and Logos
Se você gostaria de usar as marcas registradas do GitHub, você deve seguir todas as nossas diretrizes sobre a marca registrada, incluindo as da nossa página de logomarcas: https://github.com/logos.

#### 3. Licença para as Políticas GitHub
Este Contrato é licenciado sob esta [Licença Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/). Para ver os detalhes, consulte nosso [repositório da Política do Site](https://github.com/github/site-policy#license).

### H. Termos da API
**Versão curta:** *Você concorda com estes Termos de Serviço, mais esta Seção H, ao usar qualquer uma das APIs (Interface do Provedor de Aplicativos) do GitHub, incluindo o uso da API através de um produto de terceiros que acesse o GitHub.*

Solicitações abusivas ou excessivamente frequentes para o GitHub através da API podem resultar na suspensão temporária ou permanente do acesso da sua Conta à API. O GitHub, a nosso exclusivo critério, determinará o uso abusivo ou excessivo da API. Nós faremos uma tentativa razoável de avisá-lo por e-mail antes da suspensão.

Você não pode compartilhar tokens da API para exceder as limitações de taxa do GitHub.

Você não pode usar a API para baixar dados ou Conteúdo do GitHub para fins de spamming, incluindo para fins de venda de informações pessoais de usuários do GitHub, tais como recrutadores, headhunters e sites de emprego.

Todo o uso da API do GitHub está sujeito a estes Termos de Serviço e à [Declaração de Privacidade do GitHub](https://github.com/site/privacy).

O GitHub pode oferecer acesso baseado em assinaturas à nossa API para os Usuários que necessitam de acesso de alto desempenho ou acesso que resultariam na revenda do Serviço do GitHub.

### I. Termos Adicionais do Produto GitHub
**Versão curta:** *Você precisa seguir certos termos e condições específicos para os vários recursos e produtos do GitHub, e você concorda com os Termos e Condições Suplementares ao concordar com este Contrato.*

Alguns recursos do Serviço podem estar sujeitos a termos adicionais específicos para aquele recurso ou produto, conforme definido nos Termos de Produto Adicionais no GitHub. Ao acessar ou utilizar os Serviços, você também concorda com os [Termos de Produto Adicionais do GitHub](/github/site-policy/github-additional-product-terms).

### J. Visualizações Beta
**Versão curta:** *Visualizações Beta podem não ser suportadas ou podem mudar a qualquer momento, você pode receber informações confidenciais através desses programas que devem permanecer confidenciais enquanto o programa for privado, e nós adoraríamos receber seus comentários para tornar melhores nossas Visualizações Beta.*

#### 1. Sujeito a alterações

As Visualizações Beta podem não ser compatíveis, podem ser alteradas a qualquer momento sem aviso prévio Além disso, as Visualizações Beta não estão sujeitas às mesmas medidas de segurança e auditorias a que o Serviço tem sido e está sujeito. **Ao usar uma Visualização Beta, você a utiliza por sua conta e risco.**

#### 2. Confidencialidade

Como um usuário de Visualizações Beta, você pode obter acesso a informações especiais que não estão disponíveis para o resto do mundo. Devido à natureza sensível desta informação, é importante que nos certifiquemos de que você mantém em segredo essa informação.

**Obrigações de Confidencialidade.** Você concorda que qualquer informação de Visualização Beta não pública que lhe demos, como informações sobre uma Visualização Beta privada, serão consideradas informações confidenciais do GitHub (coletivamente, "Informações Confidenciais"), independentemente de serem marcadas ou identificadas como tais. Você concorda em apenas utilizar essas Informações Confidenciais para o propósito expresso de testar e avaliar a Visualização Beta (o "Objetivo"), e não para qualquer outro fim. Você deve usar o mesmo grau de cuidado que usa com as suas próprias informações confidenciais, mas nada menos do que precauções razoáveis para evitar qualquer uso não autorizado, divulgação, publicação ou difusão de nossas informações Confidenciais. Você prometeu não divulgar, publicar ou difundir qualquer Informação Confidencial para terceiros, a menos que não proibamos ou restrinjamos tal divulgação (por exemplo, você pode fazer parte de uma discussão em grupo no GitHub-organizado sobre uma função de Visualização Beta privada).

**Exceções.** Informações Confidenciais não incluirão informações que: (a) ou se tornam publicamente disponíveis sem violação deste Contrato através de nenhuma ação ou inação da sua parte (tais como quando uma Visualização Beta privada se torna uma Visualização Beta pública); (b) são conhecidas por você antes de a divulgarmos para você; (c) são desenvolvidas de forma independente por você sem violação de qualquer obrigação de confidencialidade para nós ou para qualquer terceiro; ou (d) forem divulgadas com permissão do GitHub. Você não violará os termos deste Contrato se for obrigado a divulgar informações Confidenciais de acordo com a operação do direito, desde que o GitHub tenha sido avisado com razoável antecedência por escrito para o objeto, a menos que seja proibido por lei.

#### 3. Feedback

Estamos sempre tentando melhorar os produtos e serviços, e seu feedback como um usuário de Visualização Beta nos ajudará a fazer isso. Se você optar por fornecer qualquer ideia, conhecimento, algoritmos, contribuições de código, sugestões, solicitações de aprimoramento, recomendações ou qualquer outro feedback de nossos produtos ou serviços (coletivamente, "Feedback"), você reconhece e concorda que o GitHub terá uma licença livre de royalties, totalmente paga, mundial, transferível, sublicenciável, irrevogável e perpétua para implementar, usar, modificar, explorar comercialmente e/ou incorporar o Feedback em nossos produtos, serviços e documentação.

### K. Pagamento
**Versão curta:** *Você é responsável por quaisquer taxas associadas ao uso do GitHub. Somos responsáveis por comunicar-lhe essas taxas de forma clara e precisa, e deixá-lo saber com bastante antecedência se esses preços mudarem.*

#### 1. Preços
Nossos termos de preços e pagamento estão disponíveis em [github.com/pricing](https://github.com/pricing). Se você concordar com um preço de assinatura, esse permanecerá sendo o valor durante o período de pagamento. No entanto, os preços estão sujeitos a alterações no final de um prazo de pagamento.

#### 2. Atualizações, Downgrade e Alterações
- Vamos imediatamente faturar para você quando você atualizar do plano grátis para qualquer plano de pagamento.
- Se você mudar de um plano de cobrança mensal para um plano de cobrança anual, o GitHub vai faturar para você por um ano inteiro na próxima data de faturamento mensal.
- Se você atualizar para um nível mais alto de serviço, iremos faturá-lo imediatamente pelo plano atualizado.
- Você pode mudar o seu nível de serviço a qualquer momento ao [escolher uma opção de plano](https://github.com/pricing) ou indo em suas [Configurações de faturamento](https://github.com/settings/billing). Se você optar por fazer o downgrade de sua Conta, você pode perder acesso ao Conteúdo, recursos ou capacidade de sua Conta. Por favor, veja nossa seção em [Cancelamento](#l-cancellation-and-termination) para obter informações sobre como obter uma cópia deste Conteúdo.

#### 3. Agendamento de Cobrança; Sem Reembolsos
**Pagamento com base no Plano** Para planos de pagamento mensais ou anuais, o Serviço é cobrado antecipadamente de forma mensal ou anual, respectivamente, e não é reembolsável. Não haverá reembolsos ou créditos para meses parciais de serviço, reembolsos de downgrade ou reembolsos por meses não utilizados com uma Conta aberta. No entanto, o serviço permanecerá ativo durante o período de cobrança pago. A fim de tratar todos igualmente, não serão feitas exceções.

**Pagamento com Base no Uso** Alguns recursos de Serviço são cobrados com base no seu uso. Uma quantidade limitada destes recursos de Serviço pode ser incluída no seu plano por um termo limitado sem custos adicionais. Se você optar por comprar recursos de Serviço pagos além da quantidade incluída no seu plano, você paga por esses recursos de Serviço com base no seu uso real no mês anterior. O pagamento mensal destas compras será cobrado periodicamente em atraso. Veja [Termos do Produto Adicionais GitHub para mais detalhes](/github/site-policy/github-additional-product-terms).

**Faturamento** Para Usuários faturados, o Usuário concorda em pagar integralmente as taxas, antecipadamente, sem desconto ou compensação de qualquer tipo, em dólares americanos. Dólar. O Usuário deve pagar as taxas dentro de trinta (30) dias da data da fatura no GitHub. Os montantes a pagar ao abrigo deste Contrato não podem ser reembolsados, exceto se for o caso previsto neste Contrato. Se o Usuário não pagar nenhuma taxa dentro do vencimento, o GitHub reserva o direito, para além de qualquer outra ação ou medida prevista em lei, a (i) cobrar juros sobre os montantes vencidos a 1.0% por mês ou a taxa de juros mais alta permitida por lei, a que for menor, e cobrar todas as despesas de cobrança, e (ii) encerrar o formulário de compra aplicável. O Usuário é o único responsável por todos os impostos, taxas, obrigações e avaliações governamentais (exceto impostos baseados na renda líquida do GitHub) que são impostos ou se tornam devidos em relação a este Contrato.

#### 4. Autorização
Ao concordar com estes Termos, você está nos dando permissão para cobrar seu cartão de crédito registrado, sua conta do PayPal, ou outros métodos de pagamento aprovados para as taxas que você autorizou para o GitHub.

#### 5. Responsabilidade do pagamento
Você é responsável por todas as taxas, incluindo impostos associados com seu uso do Serviço. Ao usar o Serviço, você concorda em pagar ao GitHub qualquer cobrança incorrida em relação ao seu uso do Serviço.  Se você não concorda com a cobrança, entre em contato com [Suporte do GitHub](https://support.github.com/contact). Você é responsável por nos fornecer um meio de pagamento válido para Contas pagas. Contas Grátis não são precisam fornecer informações de pagamento.

### L. Cancelamento e Rescisão
**Versão curta:** *Você pode encerrar sua Conta a qualquer momento. Se o fizer, trataremos suas informações de forma responsável.*

#### 1. Cancelamento de conta
É sua responsabilidade cancelar corretamente sua Conta com o GitHub. Você pode [cancelar sua Conta a qualquer momento](/articles/how-do-i-cancel-my-account/) indo em suas Configurações na barra global de navegação no topo da tela. A tela da Conta fornece um link simples, sem questionamentos, para você efetuar o cancelamento. Não cancelamos Contas por solicitações via e-mail ou telefone.

#### 2. Após Cancelamento
Vamos reter e usar suas informações conforme necessário para cumprir nossas obrigações legais, resolver conflitos e fazer valer nossos contratos; salvo em casos de requisitos legais, apagaremos seu perfil por completo  e o Conteúdo de seus repositórios dentro de 90 dias do cancelamento ou encerramento (embora algumas informações possam permanecer em backups encriptados). Estas informações não podem ser recuperadas depois que sua Conta for cancelada.

Não vamos apagar o Conteúdo que você tenha contribuído para os repositórios de outros Usuários ou que outros Usuários tenham bifurcado.

Mediante solicitação, faremos um esforço razoável para fornecer a um proprietário de Conta uma cópia dos seus conteúdos da Conta que sejam legítimos e não violadores após cancelamento, exclusão ou downgrade da Conta. Você deve fazer este pedido no prazo de 90 dias a partir do cancelamento, exclusão ou downgrade.

#### 3. O GitHub pode rescindir
O GitHub tem o direito de suspender ou cancelar seu acesso a todos ou a qualquer parte do Site a qualquer momento, com ou sem causa, com ou sem aviso prévio, imediatamente. O GitHub reserva-se o direito de recusar serviço a qualquer pessoa por qualquer razão a qualquer momento.

#### 4. Sobrevivência
Todas as disposições deste Contrato que, por sua natureza, devem permanecer diante da rescisão*irão* permanecer diante da rescisão — incluindo, sem limitação: as disposições relativas à propriedade, as isenções de garantias, a indenização e as limitações de responsabilidade.

### M. Comunicações com o GitHub
**Versão curta:** *Usamos e-mail e outros meios eletrônicos para nos mantermos em contato com nossos usuários*

#### 1. Comunicação eletrônica obrigatória
Para fins contratuais, você (1) consente em receber mensagens nossas a partir de um formulário eletrônico através do endereço de e-mail que você enviou ou através do Serviço; e (2) concorda que todos os Termos de Serviço, acordos, avisos, divulgações e outras mensagens que lhe fornecemos eletronicamente satisfazem qualquer requisito legal que satisfariam se estivessem no papel. Esta seção não afeta seus direitos inalienáveis.

#### 2. Notificações legais ao GitHub devem estar por escrito
Comunicações feitas através de e-mail ou sistema de mensagens do Suporte GitHub não constituirão notificação legal para o GitHub ou qualquer um de seus administradores, funcionários, agentes ou representantes em qualquer situação em que a notificação no GitHub seja exigida por contrato ou por qualquer lei ou regulamento. Notificações legais para o GitHub devem ser feitas por escrito e [enviadas ao responsável legal do GitHub](/articles/guidelines-for-legal-requests-of-user-data/#submitting-requests).

#### 3. Não há Suporte por telefone
O GitHub oferece suporte apenas por e-mail, mensagens em Serviço e mensagens eletrônicas. Não fornecemos suporte telefônico.

### N. Isenção de Garantias
**Versão curta:** *Fornecemos nosso serviço como está, e não fazemos promessas nem damos garantias sobre este serviço. Por favor, leia esta seção com cuidado; você deve entender o que esperar.*

GitHub fornece o Site e o Serviço "como está" e "conforme disponível", sem nenhuma garantia de qualquer tipo. Sem limitar a isso, rejeitamos expressamente todas as garantias, sejam elas expressas, implícitas ou estatutárias, relativamente ao Site e ao Serviço, incluindo, sem limitação, qualquer garantia de comercialização, aptidão para uma determinada finalidade, título, segurança, precisão e não infração.

O GitHub não garante que o Serviço atenderá seus requisitos; que o Serviço será ininterrupto, pontual, seguro ou sem erros; que as informações fornecidas através do Serviço serão precisas, confiáveis ou corretas; que quaisquer defeitos ou erros serão corrigidos; que o Serviço estará disponível a qualquer momento ou local; ou que o Serviço estará livre de vírus ou de outros componentes nocivos. Você assume total responsabilidade e risco de perda resultante do seu download e/ou uso de arquivos, informações, conteúdo ou outro material obtido do Serviço.

### O. Limitação de responsabilidade
**Versão curta:** *Nós não seremos responsáveis por danos ou perdas decorrentes do seu uso ou incapacidade de usar o serviço ou que resultem de outra forma ao abrigo deste contrato. Por favor, leia esta seção com cuidado; ela limita nossas obrigações para com você.*

Você entende e concorda que não seremos responsáveis perante você ou terceiros por qualquer perda de lucros, uso, ágios ou dados, ou por qualquer dano acidental, indireto, especial, consequente ou danos exemplar, independentemente do seu surgimento, que resulte de

- uso, divulgação ou exibição do seu Conteúdo Gerado pelo Usuário;
- seu uso ou incapacidade de usar o Serviço;
- qualquer modificação, mudança de preço, suspensão ou descontinuidade do Serviço;
- o Serviço, em geral, ou o software ou sistemas que tornam o Serviço disponível;
- acesso não autorizado ou alterações de suas transmissões ou dados;
- declarações ou conduta de terceiros no Serviço;
- quaisquer outras interações que você insira ou receba através do seu uso do Serviço; ou
- qualquer outra questão relacionada com o Serviço.

Nossa responsabilidade está limitada ao fato de termos ou não sido informados da possibilidade de tais danos, e mesmo que se encontre uma solução neste Contrato que não tenha falhado em seu propósito essencial. Não teremos qualquer responsabilidade por qualquer falha ou atraso devido a questões que não sejam passíveis de um controle razoável.

### P. Versão e Indenização
**Versão curta:** *Você é responsável pelo uso do serviço. Se você prejudicar outra pessoa ou entrar em disputa com outra pessoa, nós não seremos envolvidos.*

Se você tiver uma disputa com um ou mais Usuários, você concorda em liberar o GitHub de qualquer reivindicação, exigências e danos (reais e consequentes) de todos os tipos e natureza, conhecidos e desconhecidos, resultantes de ou de qualquer outra forma relacionada com esses tipos de litígios.

Você concorda em nos indenizar, defender-nos e nos manter a parte de e contra quaisquer reivindicações, responsabilidades e despesas, incluindo honorários de advogados, resultantes do seu uso do Site e do Serviço, incluindo, mas não limitado, a sua violação deste Contrato, desde que o GitHub (1) forneça prontamente a você notificação por escrito com a reivindicação, demanda, fato ou procedimento; (2) dê a você o controle exclusivo da defesa e atendimento da reivindicação, demanda, fato ou procedimento (desde que você não possa resolver qualquer reivindicação, demanda, fato ou procedimento, a menos que a resolução libere incondicionalmente o GitHub de toda responsabilidade); e (3) forneça a você assistência razoável, às suas custas.

### Q. Alterações nestes termos
**Versão curta:** *Queremos que nossos usuários sejam informados de alterações importantes em nossos termos, mas algumas alterações não são tão importantes — não queremos lhe incomodar toda vez que consertamos um erro de digitação. Portanto, embora possamos modificar este contrato a qualquer momento, notificaremos os usuários de quaisquer alterações que afetem seus direitos e lhe daremos tempo para se ajustar a elas.*

Nós nos reservamos o direito, a nosso exclusivo critério, de alterar estes Termos de Serviço a qualquer momento e atualizar estes Termos de Serviço no caso de tais alterações. Nós notificaremos nossos Usuários sobre mudanças materiais neste Contrato, como alterações de preços, pelo menos 30 dias antes da mudança ter efeito, publicando um aviso em nosso Site. Para modificações não materiais, seu uso contínuo do Site constitui acordo para nossas revisões destes Termos de Serviço. Você pode ver todas as alterações nestes Termos Adicionais em nosso repositório [Política do Site](https://github.com/github/site-policy).

Nós nos reservamos o direito de, a qualquer momento e de vez em quando, modificar ou descontinuar, temporariamente ou permanentemente, o Site (ou qualquer parte dele) com ou sem aviso prévio.

### R. Disposições Gerais

#### 1. Lei Governamental
Exceto se a lei aplicável prever o contrário, este Contrato entre você e o GitHub e qualquer acesso ou uso do Site ou do Serviço são regidos pelas leis federais dos Estados Unidos da América e pelas leis do Estado da Califórnia, sem ter em conta as disposições em matéria de conflito de leis. Você e o GitHub aceitam submeterem-se à jurisdição exclusiva e aos tribunais localizados na Cidade e no Condado de São Francisco, Califórnia.

#### 2. Não cessão
O GitHub pode ceder ou delegar esses Termos de Serviço e/ou a [Declaração de Privacidade do GitHub](https://github.com/site/privacy), no todo ou em parte, para qualquer pessoa ou entidade em qualquer momento com ou sem seu consentimento, incluindo a concessão de licença na seção D.4. Você não pode ceder ou delegar quaisquer direitos ou obrigações nos Termos de Serviço ou Declaração de Privacidade sem nosso consentimento prévio por escrito, e qualquer atribuição e delegação não autorizada por você é nula.

#### 3. Cabeçalhos e Resumos da Seção
Ao longo deste Contrato, cada seção inclui títulos e resumos breves dos seguintes termos e condições. Estes títulos das seções e resumos breves não são juridicamente vinculativos.

#### 4. Independência das disposições contratuais, Irrenunciabilidade e Sobrevivência
Se alguma parte deste Contrato for considerada inválida ou inaplicável, essa parte do Contrato será interpretada para refletir a intenção original das partes. As partes restantes permanecerão em pleno vigor e efeito. Qualquer falha da parte do GitHub em aplicar qualquer disposição deste Contrato não será considerada uma derrogação do nosso direito de impor tal disposição. Nossos direitos ao abrigo deste Contrato sobreviverão a qualquer rescisão deste Contrato.

#### 5. Alterações; Contrato integral
Este Contrato só pode ser modificado por uma alteração escrita assinada por um representante autorizado do GitHub, ou pela postagem pelo GitHub de uma versão revisada de acordo com [Seção Q. Alterações nestes Termos](#q-changes-to-these-terms). Estes Termos de Serviço, juntamente com a Declaração de Privacidade do GitHub, representam a declaração completa e exclusiva do acordo entre você e nós. Este Contrato substitui qualquer proposta ou acordo prévio oral ou escrito, e quaisquer outras comunicações entre você e o GitHub relacionadas com o assunto desses termos, incluindo quaisquer acordos de confidencialidade ou de não divulgação.

#### 6. Perguntas
Perguntas sobre os Termos de Serviço? [Fale conosco](https://support.github.com/contact).
