---
title: Termos complementares do GitHub para o licenciamento por volume da Microsoft
redirect_from:
  - /articles/GitHub-Supplemental-Terms-for-Microsoft-Volume-Licensing/
  - /articles/github-supplemental-terms-for-microsoft-volume-licensing
versions:
  free-pro-team: '*'
---

Data efetiva da versão: 20 de julho de 2020

Os seguintes Termos Suplementares do GitHub (incluindo quaisquer Formulários de Pedido aplicáveis) complementam o contrato de licenciamento do volume Microsoft do cliente ("**Contrato com o Cliente Microsoft**") e, juntamente com o Contrato com o Cliente Microsoft, regem o uso dos Produtos pelo Cliente (conforme definido abaixo). O Contrato com o Cliente Microsoft é incorporado pelo presente documento por esta referência.  Os termos em maiúsculas usados, mas não definidos nestes termos suplementares, têm os significados atribuídos a eles no Contrato com o Cliente Microsoft.

Esses Termos Suplementares aplicam-se às seguintes ofertas do GitHub, conforme definido a seguir (ofertas coletivamente chamadas de **"Produtos"**"):

-   GitHub Enterprise (composto pelo GitHub Enterprise Server, que pode incluir Software de complemento e GitHub Enterprise Cloud) e GitHub One;

-   Qualquer Suporte relacionado; e

-   Qualquer Serviço profissional relacionado.

Estes Termos Suplementares do GitHub incluem as seguintes Seções e Exposições, cada uma das quais é incorporada por referência aqui:

* SEÇÃO 1: Termos de licença do GitHub Enterprise Server;

* SEÇÃO 2: Termos de serviço do GitHub Enterprise Cloud;

* SEÇÃO 3: Disposições Gerais; e

* ANEXO A: Definições.



## SEÇÃO 1: TERMOS DE LICENÇA DO GITHUB ENTERPRISE SERVER

Esta Seção 1 detalha os termos aplicáveis ao uso do Software pelo Cliente.

### 1.1 Concessão de licença.

O GitHub concede ao Cliente uma licença não exclusiva, não transferível, mundial, de prazo limitado e isenta de royalties para instalar e usar o Software para finalidades comerciais internas do Cliente durante o Período de assinatura aplicável, de acordo com a Documentação e apenas para o número de Licenças de assinatura indicadas no Formulário de pedido do Cliente. O Software inclui componentes licenciados para o GitHub por terceiros, como programas de software cujas licenças exigem que o GitHub disponibilize o código-fonte desses componentes, que será fornecido mediante solicitação. Sem limitar o precedente, esta licença permite que o Cliente baixe e execute a imagem do contêiner Microsoft SQL Server Standard Edition para arquivos Linux ("**Imagens do servidor SQL**"), que só pode ser usado com o Software como documentado. O direito do cliente de usar as imagens do servidor SQL termina quando o Cliente não tem mais o direito de usar o Software, e o Cliente deve desinstalar as Imagens do Servidor SQL quando seu direito de usá-las terminar. A Microsoft Corporation pode desativar o SQL Server Images a qualquer momento.

### 1.2 Restrições.

Exceto quando expressamente permitido por lei ou por licença de terceiros aplicável, o Cliente e suas Afiliadas não deve (nem permitir que algum terceiro o faça): (i) sublicenciar, vender, alugar, arrendar, transferir, ceder ou redistribuir o Software; (ii) hospedar o Software em benefício de terceiros; (iii) divulgar ou permitir que terceiros acessem o Software, exceto conforme expressamente permitido nesta Seção 1; (iv) hackear ou modificar a Chave de licença, ou evitar ou alterar qualquer processo de registro de licença; (v) exceto no caso de Modificações do cliente, modificar ou criar trabalhos derivados do Software ou mesclar o Software com outro software; (vi) desmontar, descompilar, ignorar qualquer ofuscação de código ou, de outra forma, fazer engenharia reversa do Software ou tentar derivar seu código-fonte, parcial ou totalmente; (vii) modificar, obscurecer ou excluir avisos de direitos de propriedade incluídos no Software ou na Documentação; ou (viii) usar ou copiar o Software ou a Documentação de alguma forma não expressamente permitida por esses Termos Suplementares do GitHub.

### 1.3 Delivery.

O GitHub disponibilizará a Chave de licença ser baixada pelo Cliente em um site seguro e protegido por senha. All deliveries under this Section 1 will be electronic. Para evitar dúvidas, o Cliente é responsável pela instalação de qualquer Software e reconhece que o GitHub não tem mais nenhuma obrigação de entrega em relação ao Software após o recebimento da Chave de licença pelo Cliente. À medida que as Atualizações forem sendo emitidas, o GitHub as disponibilizará para download no mesmo site. O Cliente deve atualizar o Software em uma base comercialmente razoável, mas não menos de 01 (uma) vez por ano. O Cliente é responsável por manter a confidencialidade dos nomes de usuário e das senhas do Cliente.

### 1.4 Verification.

A pedido do GitHub, o Cliente fornecerá prontamente ao GitHub um relatório gerado pelo Software verificando se o cliente está usando o Software de acordo com esses Termos Complementares do GitHub. O GitHub cobrará do Cliente por qualquer uso adicional, a partir da data em que o uso excedeu os termos desses Termos Complementares do GitHub

### 1.5 Support

O GitHub fornecerá suporte técnico para o Software, conforme descrito no Contrato de Clientes da Microsoft. O GitHub pode fornecer ofertas de Suporte aprimorado para o Software e o Serviço (incluindo as ofertas Premium, Premium Plus e Suporte Direto de Engenharia) de acordo com os [termos de Suporte](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise)e no nível de Suporte, Taxas e Termo de Assinatura especificados em um Formulário de Pedido ou SOW. Não obstante qualquer coisa em contrário no Contrato com o Cliente Microsoft, (i) o GitHub aplicará esforços razoáveis para corrigir qualquer material, erros reproduzíveis no Software após a notificação ao Cliente de um erro, mas não será responsável por fornecer Suporte quando (a) alguém (além do GitHub) modifique o Software; (b) o Cliente altere seu sistema operacional ou ambiente de forma a afetar negativamente o Software ou seu desempenho; (c) o Cliente usa o Software de uma maneira diferente da autorizada sob o Contrato com o Cliente Microsoft, nesta Seção 1 ou na Documentação; ou (d) haja um acidente ou negligência do Cliente, ou uso indevido do Software; e (ii) o GitHub só dará suporte  a uma determinada versão por um (1) ano a partir da data de lançamento original, ou seis (6) meses da última Atualização da Versão, o que for mais longo.

### 1.6 Updates; Releases.

#### 1.6.1 Generally.

O GitHub disponibilizará atualizações e versões do Software ao Cliente no mesmo site seguro em que o Cliente baixou o Software e a Chave de licença.

#### 1.6.2 Supported Releases.

O GitHub só dará Suporte a uma determinada Versão do Software por 01 (um) ano a partir da data da Versão original ou 06 (seis) meses a partir da última Atualização da Versão, o que for mais longo. Se o Cliente necessitar de Suporte para Versões anteriores do Software, deverá pagar por esse Suporte de acordo com os termos de um Formulário de pedido ou uma SOW acordados mutuamente.

### 1.7. Software de complemento.

Software de complemento é licenciado numa base por Usuário. Para evitar dúvidas e, salvo disposição em contrário, em um Formulário de Pedido, o número de Licenças de Assinatura que o Cliente tem em qualquer momento para o complemento de Software deve ser igual ao número de Licenças de Assinatura que o Cliente tem para os Produtos sob este Contrato. Por exemplo, se o Cliente deseja comprar uma assinatura para o Insights e já possui Licenças de Assinatura para 100 Usuários para os Produtos, ele deve comprar Licenças de Assinatura para 100 Usuários para o Insights.

### 1.8 Considerações de Proteção de Dados para uso do GitHub Insights e Learning Lab for Enterprise Server.

Se o uso planejado do GitHub Insights ou do Learning Lab for Enterprise Server envolve o processamento de dados pessoais, o Cliente é o único responsável por determinar se deve ou não concluir uma avaliação de impacto de proteção de dados ou proteger a análise legal formal do uso planejado pelo Cliente. Fica a critério exclusivo do Cliente usar o GitHub Insights ou o Learning Lab for Enterprise Server para processar os dados dos funcionários e/ou usuários do Cliente e, se o Cliente fizer isso, o Cliente é o único responsável por realizar esse processamento em conformidade com a lei aplicável.

### 1.9 Garantia limitada de software.

O GitHub garante que, por noventa (90) dias a partir da data em que for disponibilizado para download inicial, o Software não modificado estará substancialmente em conformidade com sua Documentação. O GitHub não garante que o uso do Software pelo Cliente será ininterrupto ou que a operação do Software será isenta de erros. Esta garantia não se aplicará se o Cliente modificar ou usar o Software de qualquer forma que não seja expressamente permitida por esta Seção 1 e pela Documentação. A única obrigação do GitHub, e o único remédio do Cliente, para qualquer violação desta garantia limitada será conforme estabelecido no Contrato com o Cliente da Microsoft.

## SECTION 2: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 2 details terms applicable to Customer’s use of the Service.

### 2.1 Account Terms.

#### 2.1.1 Account Controls.

  **(i) Usuários**. O Cliente reconhece que os Usuários mantêm o controle administrativo final sobre suas contas individuais e o Conteúdo dentro delas. [Termos de Serviço Padrão do GitHub](/github/site-policy/github-terms-of-service) rege o uso do Serviço pelos Usuários, exceto no que diz respeito às atividades dos Usuários, sob esta Seção 2.

  **(ii) Organizations.** Customer retains ultimate administrative control over any Organization created on Customer’s behalf and User-Generated Content posted to the repositories within its Organization(s), subject to this Section 2. This Section 2 will govern the use of Customer’s Organization(s).

#### 2.1.2 Account Requirements.

Para criar uma conta, o Cliente deve atender às seguintes condições:

**(i)** O Cliente não deve criar uma conta para ser usada por qualquer pessoa com menos de 13 anos de idade. Se isso chegar ao conhecimento do GitHub, ele encerrará a conta do Usuário imediatamente. Se o Cliente ou seus Usuários estiverem localizados em um país fora dos Estados Unidos, a idade mínima desse país poderá ser maior. Nesse caso, o Cliente é responsável por cumprir as leis desse país.

**(ii)** O login de um Usuário não pode ser compartilhado por várias pessoas.

**(iii)** O Cliente não deverá usar o Serviço (a) se isso violar o controle de exportação ou as leis de sanções dos Estados Unidos ou de qualquer outra jurisdição aplicável; (b) se ele estiver localizado ou residir normalmente em um país ou território sujeito a sanções abrangentes administradas pelo Escritório de Controle de Ativos Estrangeiros (OFAC – Office of Foreign Assets Control) do Departamento do Tesouro Americano ou (c) se o Cliente é ou representa um [cidadão designado especialmente](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) (SDN – Specially Designated National) ou uma pessoa sujeita a bloqueio semelhante ou a proibições partidárias negadas. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. Para obter mais informações, consulte a [Política de Controles Comerciais do GitHub](/github/site-policy/github-and-trade-controls).

#### 2.1.3 Account Security.

O cliente é responsável por: (i) todo o Conteúdo postado e pela atividade que ocorre na Conta corporativa dele; (ii) manter a segurança de suas credenciais de login de conta; e (iii) [notificar o GitHub](https://support.github.com/contact) prontamente ao tomar conhecimento de qualquer uso não autorizado ou acesso ao Serviço por meio de sua conta.  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 2.1.3.

#### 2.1.4 Additional Terms.

Em algumas situações, os termos de terceiros podem ser aplicados ao uso do serviço pelo Cliente.  Por exemplo, o Cliente pode ser integrante de uma Organização com seus próprios termos ou contratos de licença. O cliente poderá baixar um aplicativo que se integra ao Serviço ou utilizar o Serviço para autenticar em outro serviço. Embora o Contrato com o Cliente Microsoft, incluindo esses Termos Complementares do GitHub, sejam o contrato completo do GitHub com o Cliente, os termos de outras partes regem seus relacionamentos com o Cliente.

#### 2.1.5 Termos do Governo Federal do EUA. Federal Government Terms.

Se o cliente é dos EUA. Se o Cliente for uma agência do Governo Federal dos EUA ou que acessa ou usa qualquer parte do Serviço em instalações governamentais, a [Emenda do Governo Federal dos EUA](https://help.github.com/github/site-policy/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) se aplicará e o cliente concordará com as disposições dela. Aplica-se a alteração do Governo Federal</a> e o Cliente concorda com suas disposições.

### 2.2 Compliance with Laws; Acceptable Use; Privacy.

#### 2.2.1 Compliance with Laws and Regulations.

O uso do Serviço pelo Cliente não deve violar os regulamentos ou as leis aplicáveis na sua jurisdição, como leis de direitos autorais ou de marcas registradas e leis de controle de exportação.

#### 2.2.2 Acceptable Use.

O uso do Serviço pelo Cliente deve estar em conformidade com as [Políticas de Uso Aceitável do GitHub](/github/site-policy/github-acceptable-use-policies) e as [Diretrizes da Comunidade do GitHub](/github/site-policy/github-community-guidelines). O Cliente não deve usar o Serviço em qualquer jurisdição para atividade ou Conteúdo ilegal, obsceno, ofensivo ou fraudulento, como defender ou causar danos, interferir ou violar a integridade ou a segurança de uma rede ou um sistema, enganar os filtros, enviar vírus ou código nocivo e mensagens não solicitadas, abusivas ou enganosas ou violar direitos de terceiros.

#### 2.2.3 Privacy.
A [Declaração de Privacidade do GitHub](/github/site-policy/github-privacy-statement) e o [Adendo de Proteção de Dados do GitHub](/github/site-policy/github-data-protection-addendum) fornecem aviso detalhado das práticas de privacidade e uso de dados do GitHub, bem como do processamento e das obrigações de segurança do GitHub no que diz respeito aos Dados Pessoais do Cliente. Qualquer pessoa, entidade ou serviço que colete dados do Serviço deve estar em conformidade com a [Declaração de Privacidade do GitHub](/github/site-policy/github-privacy-statement), especialmente no que diz respeito à coleta de Informações Pessoais dos Usuários (conforme definido na Declaração de Privacidade do GitHub). Se o Cliente coletar qualquer Informação pessoal do usuário no GitHub, só a utilizará para a finalidade para a qual o Usuário externo o autorizou. O Cliente protegerá essas Informações pessoais, e o Cliente responderá prontamente a reclamações, solicitações de remoção e pedidos para "não contatar" do GitHub ou de Usuários externos.

### 2.3 Content Responsibility; Ownership; License Rights.

#### 2.3.1 Responsibility for User-Generated Content.
O Cliente pode criar ou fazer upload do Conteúdo gerado pelo usuário ao usar o Serviço. O Cliente é o único responsável por qualquer Conteúdo gerado pelo usuário que ele poste, faça upload, vincule ou disponibilize por meio do Serviço, independentemente da forma desse Conteúdo gerado pelo usuário. O GitHub não é responsável por qualquer exibição ao público ou uso indevido de Conteúdo gerado pelo usuário.

#### 2.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** O Cliente mantém a propriedade do Conteúdo que o Cliente cria ou possui. O Cliente reconhece que: (a) é responsável pelo Conteúdo do cliente, (b) só enviará o Conteúdo que o Cliente tem direito de postar (como Conteúdo de terceiros ou gerados pelo Usuário), e (c) o Cliente cumprirá integralmente todas as licenças de terceiros relacionadas ao Conteúdo que o Cliente posta.

**(ii)** Customer grants the rights set forth in Sections 2.3.3 through 2.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. Se o Cliente fizer upload do Conteúdo do cliente que já vem com uma licença que concede ao GitHub as permissões necessárias para executar o Serviço, nenhuma licença adicional será necessária.

#### 2.3.3 License Grant to GitHub.
O Cliente concede ao GitHub o direito de armazenar, analisar e exibir o Conteúdo do cliente e fazer cópias acessórias somente conforme necessário para fornecer o Serviço. Isso inclui o direito de copiar o Conteúdo do cliente para o banco de dados do GitHub e fazer backups; exibir o Conteúdo do cliente para ele e para quem o Cliente resolver mostrá-lo; analisar o Conteúdo do cliente em um índice de pesquisa ou analisá-lo nos servidores do GitHub; compartilhar o Conteúdo do cliente com Usuários externos com os quais o Cliente opte por compartilhá-lo; e executar o Conteúdo do cliente caso seja algo como música ou vídeo. Esses direitos se aplicam a Repositórios públicos e privados. Esta licença não concede ao GitHub o direito de vender o Conteúdo do cliente, distribuí-lo ou utilizá-lo fora do Serviço. O Cliente concede ao GitHub os direitos de que precisa para usar o Conteúdo do cliente sem atribuição e fazer adaptações razoáveis dele, conforme necessário, para fornecer o Serviço.

#### 2.3.4 License Grant to External Users.
**(i)** Qualquer Conteúdo que o Cliente posta publicamente, como problemas, comentários e contribuições a repositórios de Usuários externos, pode ser visualizado por outras pessoas. Ao definir quais repositórios serão visualizados publicamente, o Cliente concorda em permitir que Usuários externos visualizem e bifurquem os repositórios do Cliente.

**(ii)** Se o cliente define páginas e repositórios para serem visualizados publicamente, ele concede a Usuários externos uma licença mundial e não exclusiva para usar, exibir e executar o Conteúdo do cliente por meio do Serviço e reproduzi-lo exclusivamente no Serviço conforme permitido através da funcionalidade fornecida pelo GitHub (por exemplo, através de bifurcando). O Cliente poderá conceder direitos adicionais ao Conteúdo do Cliente se o Cliente [adotar uma licença](/github/building-a-strong-community/adding-a-license-to-a-repository#including-an-open-source-license-in-your-repository). Se o cliente estiver fazendo upload de um Conteúdo do cliente que ele não criou nem possuiu, será responsável por garantir que o Conteúdo do cliente carregado seja licenciado sob os termos que concedem essas permissões a Usuários externos.

#### 2.3.5 Contributions Under Repository License.
Sempre que o Cliente faz uma contribuição a um repositório que contém notificação de uma licença, o Cliente licencia essa contribuição nos mesmos termos e concorda que tem o direito de licenciá-la nesses termos. Se o Cliente tiver um contrato separado para licenciar as contribuições em termos diferentes, como um contrato de licença de colaborador, esse contrato será substituído.

#### 2.3.6 Moral Rights.
O Cliente detém todos os direitos morais ao Conteúdo do cliente que ele carrega, publica ou envia para qualquer parte do Serviço, inclusive os direitos de integridade e atribuição. No entanto, o Cliente renuncia a esses direitos e concorda em não fazê-los valer contra o GitHub somente no intuito de permitir que o GitHub exerça razoavelmente os direitos concedidos na Seção 2.3, mas não o contrário.

### 2.4 Repositórios privados.

#### 2.4.1 Control.

O Cliente é responsável por gerenciar o acesso a seus Repositórios privados, incluindo convites, encerramento do acesso e controle administrativo de Organizações e equipes.

#### 2.4.2 Confidentiality.

O GitHub considera o Conteúdo do cliente nos Repositórios privados do Cliente como Informações confidenciais do Cliente. O GitHub protegerá e manterá estritamente confidencial o Conteúdo do Cliente dos Repositórios Privados de acordo com a disposição de confidencialidade aplicável no Contrato com o Cliente Microsoft.

#### 2.4.3 Access.

O GitHub só pode acessar os Repositórios privados do Cliente (i) com o consentimento e o conhecimento do Cliente, para fins de suporte, ou (ii) quando o acesso for exigido por motivos de segurança.  O Cliente pode optar por permitir o acesso adicional a seus Repositórios privados. Por exemplo, o Cliente pode habilitar vários serviços ou recursos do GitHub que exigem direitos adicionais ao Conteúdo do cliente em Repositórios privados. Esses direitos podem variar de acordo com o serviço ou recurso, mas o GitHub continuará a tratar o Conteúdo do cliente nos Repositórios privados do Cliente como Informações confidenciais do Cliente. Se esses serviços ou recursos exigirem direitos além dos necessários para oferecer o Serviço, o GitHub apresentará uma explicação sobre esses direitos.

#### 2.4.4 Exclusions.

Se o GitHub tiver motivos para acreditar que o Conteúdo de um Repositório privado viola a lei ou desses Termos Complementares do GitHub, o GitHub tem o direito de acessar, revisar e remover esse Conteúdo. Além disso, o GitHub pode ser obrigado por lei a divulgar o Conteúdo de Repositórios privados do Cliente. A menos que estipulado de outra forma por requisitos dispostos na lei ou em resposta a uma ameaça à segurança ou outro risco para a segurança, o GitHub avisará sobre tais ações.

### 2.5. Avisos de propriedade intelectual.

#### 2.5.1 GitHub's Rights to Content.

A aparência do Serviço é Copyright © GitHub, Inc. Todos os direitos reservados. O Cliente não pode duplicar, copiar ou reutilizar qualquer parte dos elementos ou conceitos de design visual, JavaScript ou HTML/CSS sem a permissão expressa por escrito do GitHub.

#### 2.5.2 Copyright Infringement and DMCA Policy.

Se o Cliente for proprietário de direitos autorais e acreditar que o Conteúdo no Serviço viola seus direitos autorais, ele poderá notificar o GitHub de acordo com a [Lei dos Direitos Autorais do Milênio Digital](https://github.com/contact/dmca) (DMCA – Digital Millenium Copyright Act Policy) usando o [Formulário DMCA](https://github.com/contact/dmca-notice) ou pelo e-mail copyright@github.com.

#### 2.5.3 GitHub Trademarks and Logos.

Se o Cliente quiser usar as marcas registradas do GitHub, deverá seguir todas as diretrizes de marca registrada do GitHub, inclusive aquelas na [página Uso e logotipos do GitHub](https://github.com/logos).

### 2.6 Suspension.

O GitHub tem o direito de suspender o acesso a toda ou qualquer parte do Serviço, incluindo a remoção do Conteúdo a qualquer momento por violação do Contrato com o Cliente Microsoft, incluindo esses Termos Complementares do GitHub, ou para proteger a integridade, operacionalidade e segurança do Serviço, em vigor imediatamente, com ou sem aviso prévio. A menos que seja proibido por lei ou por processo legal ou para evitar danos iminentes ao Serviço ou a terceiros, o GitHub geralmente emite um aviso na forma de banner ou por e-mail no momento ou antes de tal suspensão. A seu critério e com boa fé, o GitHub ajustará qualquer suspensão conforme necessário para preservar a integridade, a operacionalidade e a segurança do Serviço.

### 2.7 Comunicações com o GitHub.

Para fins contratuais, o Cliente (1) consente em receber comunicados em forma eletrônica através do endereço de e-mail que enviou ou através do Serviço; e (2) concorda que todos os Termos de Serviço, contratos, avisos, divulgações, e outras comunicações que o GitHub efetua eletronicamente atendem a qualquer requisito legal que essas mesmas comunicações atenderiam se escritas em papel. Esta seção não afeta os direitos inalienáveis do Cliente.

### 2.8 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 2.9 Service Changes.

O GitHub altera o Serviço através de Atualizações e adição de novos recursos. Sujeito à Seção 2.8, o GitHub se reserva o direito de, a qualquer momento, modificar ou interromper, temporária ou permanentemente, o Serviço (ou qualquer parte dele), com ou sem aviso prévio.

### 2.10 Recursos de Serviço Adicional.

Alguns recursos do Serviço podem estar sujeitos a termos adicionais definidos nos [Termos do Produto Adicional do GitHub](/github/site-policy/github-additional-product-terms). Ao acessar ou usar esses recursos, o Cliente concorda com os Termos do Produto Adicional do GitHub.

## SEÇÃO 3: DISPOSIÇÕES GERAIS.

This Section 3 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products.

### 3.1 Termo; Rescisão; Efeito da Rescisão.

#### 3.1.1 Term.
Esses Termos Complementares do GitHub continuarão vigentes até serem rescindidos por uma das Partes, de acordo com esta Seção 3.1.

#### 3.1.2 Rescisão por Conveniência; Cancelamento de Conta.
Qualquer uma das Partes pode rescindir um Formulário de Pedido ou estes Termos Complementares do GitHub, sem motivo, com pelo menos 30 (trinta) dias de aviso prévio por escrito antes do término do Período de Assinatura atual. Se o Cliente optar por rescindir um Formulário de pedido ou os Termos Complementares do GitHub, é responsabilidade do Cliente cancelar corretamente a respectiva conta com o GitHub acessando Configurações na barra de navegação global, na parte superior da tela. O GitHub não cancela contas em resposta a solicitações por telefone ou e-mail.

#### 3.1.3 Termination for Material Breach.
Qualquer das Partes poderá rescindir estes Termos Complementares do GitHub imediatamente, mediante notificação, se a outra Parte descumprir uma obrigação material sob esses Termos Complementares do GitHub e não conseguir corrigir a violação no prazo de trinta (30) dias a partir da data em que receber a notificação.  O GitHub pode rescindir estes Termos Complementares do GitHub se a Conta do Cliente for suspensa por mais de 90 dias.

#### 3.1.4 Efeito da rescisão.
Após a rescisão destes Termos Complementares do GitHub, o Cliente não poderá executar Formulários de Pedido adicionais. No entanto, estes Termos Complementares do GitHub permanecerão em vigor durante o restante do período de qualquer Formulário de Pedido ativo. Quando um Formulário de Pedido é rescindido ou expira, em relação ao Formulário de Pedido: (i) o Período de assinatura terminará imediatamente; (ii) qualquer Licença de Assinatura no Formulário de Pedido será automaticamente rescindida, e o Cliente perderá o direito de utilizar os Produtos; (iii) se alguma Taxa for devida antes da rescisão, o Cliente deverá pagá-la imediatamente; (iv) o Cliente deve destruir todas as cópias do Software que estejam em sua posse ou sob seu controle e atestar por escrito ao GitHub que fez isso; (v) cada Parte devolverá prontamente (ou destruirá, se a outra Parte assim solicitar) todas as Informações confidenciais pertencentes à outra Parte, na medida permitida pelo Serviço. Não obstante o exposto acima, o Cliente poderá continuar acessando o Software para migrar os dados do Cliente e poderá solicitar a migração dos dados em seus repositórios por até 90 (noventa) dias após a rescisão ou a expiração deste Contrato ou de um Formulário de pedido. No entanto, o Cliente não poderá usar o Software ou o Serviço para produção durante esse período. As disposições que, pela própria natureza, devam sobreviver razoavelmente sobreviverão à rescisão ou à expiração deste Contrato ou de um Formulário de pedido.

### 3.2 Feedback.
O Cliente pode fornecer feedback ao GitHub sobre os Produtos. O feedback é voluntário e não é uma Informação Confidencial do Cliente, mesmo se designado como tal. O GitHub pode se exercitar e explorar completamente tal Feedback com o objetivo de (i) melhorar a operação, funcionalidade e uso das ofertas de produtos atuais e futuras do GitHub e a comercialização de tais ofertas; e (ii) publicar estatísticas agregadas sobre a qualidade dos Produtos, desde que nenhum dado em tal publicação seja usado para identificar especificamente o Cliente, seus funcionários ou o código de software proprietário do Cliente.

### 3.3. Cumprimento de leis e regulamentos.
O cliente estará em conformidade com todas as leis e regulamentos aplicáveis, incluindo, mas não se limitando a, legislação e regulamentos em matéria de proteção de dados e trabalhistas, na sua utilização dos Produtos.

### 3.4 - Ordem de Precedência
No caso de um conflito entre estes Termos Complementares de um lado e um Formulário de Pedido, de outro, o Formulário de Pedido regerá apenas esse formulário específico. No caso de um conflito entre os Termos Complementares (incluindo qualquer Formulário de Pedido) e o Contrato com o Cliente da Microsoft, os Termos Complementares regerão apenas no que diz respeito ao assunto.

## ANEXO A: DEFINIÇÕES

**"Usuário ativo"** significa um Usuário que tenta acessar o Serviço no momento de uma Pane.

"**Software de complemento**" significa Segurança Avançada, Insights, Learning Lab for Enterprise Server e outros produtos complementares de software que o GitHub pode oferecer de tempos em tempos.

**"Segurança Avançada"** significa o recurso de Software que permite ao Cliente identificar vulnerabilidades de segurança através de análise de código semântica personalizável e automatizada.

**"Afiliada"** significa qualquer entidade que controle direta ou indiretamente, seja controlada por ou esteja no controle comum com uma parte em que "controle" significa ter mais de 50% de propriedade ou o direito de direcionar a administração da entidade.

**"Todos os usuários"** significa, coletivamente, Usuários e Usuários externos do Cliente que utilizam o Serviço.

**"Connect"** ou **"GitHub Connect"** significa um recurso incluído no Software que permite que o Cliente conecte o Software ao Serviço. O uso do GitHub Connect pode estar sujeito a termos do GitHub Connect definidos nos [Termos de Produto Adicional do GitHub](/github/site-policy/github-additional-product-terms).

**"Conteúdo"** significa, sem limitação, texto, dados, artigos, imagens, fotografias, gráficos, softwares, aplicativos, designs, recursos e outros materiais que são apresentados, exibidos ou disponibilizados por meio do Serviço.

**"Conta corporativa"** significa uma conta criada por um Usuário em nome de uma entidade.

**"Cliente"** significa, coletivamente, a empresa ou organização que celebrou estes Termos Complementares do GitHub com o GitHub clicando no botão "CONCORDO" ou similar ou acessando os Produtos, e suas Afiliadas e seus Representantes.

**"Conteúdo do cliente"** significa Conteúdo que o cliente cria, possui ou para o qual o cliente detém os direitos.

**"Modificações feitas pelo Cliente"** significa modificações no Software que o Cliente pode fazer unicamente com a finalidade de desenvolver correções de erros, personalizações ou recursos adicionais para bibliotecas com licenças de código aberto que podem ser incluídas ao Software ou vinculadas por ele.

**"Documentação"** significa qualquer manual, documentação e outros materiais de suporte relacionados ao Software ou ao Serviço que o GitHub fornece ou disponibiliza ao Cliente.

**"Data de vigência"** é a data em que o Cliente (i) concorda com os termos e condições destes Termos Complementares do GitHub, conforme descrito acima, ou (ii) faz um pedido dos Produtos.

**"Serviços essenciais"** significa os serviços essenciais para a funcionalidade de controle da versão principal do GitHub, como criação, bifurcação e clonagem de repositórios; criação, commit e merge de branches; criação, revisão e merge de pull requests; e interfaces de cliente Git, API e web para os fluxos de trabalho principais do Git. Estes são exemplos de serviços e recursos periféricos não incluídos: webhooks, Gists, Pages e notificações por e-mail.

**"Usuário externo"** significa um indivíduo, com exceção de Usuários do Cliente, que visitam ou usam o Serviço.

**"Taxas"** significa as taxas que o Cliente deve pagar ao GitHub para (i) usar os Produtos durante o Termo de Assinatura aplicável ou (ii) receber Serviços Profissionais, pois essas taxas estão refletidas em um Formulário de Pedido ou Declaração de Trabalho (SOW).

**"Feedback"** significa ideias, conhecimento, algoritmos, contribuições de código, sugestões, solicitações de aprimoramento, recomendações ou qualquer outro feedback sobre produtos ou serviços do GitHub.

**"Bifurcação"** significa copiar o Conteúdo de um repositório para outro.

**"GitHub"** significa, coletivamente, GitHub, Inc., suas Afiliadas e seus Representantes.

**"Conteúdo do GitHub"** significa Conteúdo que o GitHub cria, possui ou para o qual detém os direitos.

**"GitHub Insights"**" ou **"Insights"** significa o recurso de software que fornece métricas ao Cliente, análises e recomendações relacionadas ao uso do Software. O GitHub Insights não inclui recursos legados do GitHub, incluindo insights da organização e insights de repositórios.

**"GitHub One"** significa o pacote de Produtos que inclui GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server e Premium Plus ou Suporte Direto de Engenharia.

**"Learning Lab for Enterprise Server"**" significa o recurso de Software que permite que os Usuários aprendam sobre a funcionalidade do GitHub, incluindo Documentação associada.

**"Chave de licença"** significa o arquivo de dados usado pelo mecanismo de controle de acesso do Software que permite que o Cliente instale, opere e use o Software.

**"Conta de máquina"** significa uma conta registrada por um indivíduo que aceita os termos de serviço aplicáveis em nome da Conta da máquina, fornece um endereço de e-mail válido e é responsável por suas ações. Uma Conta de máquina é usada exclusivamente para executar tarefas automatizadas. Vários Usuários podem direcionar as ações de uma Conta de máquina, mas o proprietário da conta é o responsável final pelas ações da máquina.

**"Formulário de pedido"** significa documentação escrita ou eletrônica (inclusive citação) que as Partes utilizam para encomendar os Produtos.

**“Organização”** significa um espaço de trabalho compartilhado que pode estar associado a uma única entidade ou a um ou mais Usuários em que vários Usuários podem colaborar em vários projetos de uma só vez. Um Usuário pode ser integrante de mais de uma Organização.

**"Pane"** significa a interrupção de um Serviço essencial que afeta mais de 50% dos Usuários ativos.

**"Repositório privado"** significa um repositório que permite que um Usuário controle o acesso ao Conteúdo.

**"Serviços profissionais"** significa serviços de implementação, consultoria ou treinamento que o GitHub fornece de acordo com uma SOW executada mutuamente. Os Serviços profissionais não incluem Suporte.

**"Repositório público"** significa um repositório cujo Conteúdo é visível para Todos os usuários.

**"Versão"** significa uma versão de Software que o GitHub disponibiliza aos clientes, juntamente com as alterações correspondentes na Documentação, e que contém aprimoramentos, novos recursos ou novas funcionalidade, geralmente indicados por uma alteração no dígito à direita do primeiro ponto decimal por exemplo, x.x.x para x.y.x) ou à esquerda do primeiro ponto decimal (por exemplo, x.x.x para y.x.x).

**"Representantes"** significa funcionários, agentes, contratados independentes, consultores, advogados e consultores financeiros da Parte.

**"Scraping"** (raspagem) significa extrair dados do Serviço por meio de um processo automatizado, como um bot ou  rastreador web (webcrawler), e não inclui a coleta de informações por meio da API do GitHub.

**"Serviço"** significa o serviço GitHub Enterprise Cloud hospedado. O Serviço inclui: contas da Organização, logon único SAML, provisionamento de acesso e qualquer Documentação aplicável. Esta lista de recursos e serviços não é completa e pode ser atualizada de tempos em tempos.

**"Crédito de serviço"** significa um crédito em dólar, calculado conforme estabelecido abaixo, que o GitHub pode creditar de volta em uma conta qualificada.

**"Software"** significa o software GitHub Enterprise Server local. O Software inclui o recurso GitHub Connect, qualquer Documentação aplicável, quaisquer atualizações para o Software que o GitHub fornece ao Cliente ou que o Cliente pode acessar sob estes Termos Complementares do GitHub e, se incluído na assinatura do Cliente, o Software de complemento.

**"SOW"** significa uma declaração de trabalho mutuamente executada detalhando os Serviços profissionais que o GitHub executará, as taxas associadas e as obrigações relacionadas de cada Parte.

**"Licença de assinatura"** significa a licença atribuída a cada Usuário para instalar, operar, acessar e utilizar os Produtos em nome do Cliente. O Cliente só pode atribuir uma Licença de assinatura por Usuário nas instâncias do GitHub Enterprise Server e nas Organizações do GitHub Enterprise Cloud. Cada Usuário terá acesso ao máximo possível de instâncias do Enterprise Server ou de Organizações do Enterprise Cloud, conforme o Cliente permitir. No entanto, depois que o cliente atribuir uma Licença de assinatura a um Usuário, o Cliente não estará autorizado a bifurcar a Licença de assinatura para que um Usuário possa utilizá-la no Enterprise Server enquanto outro Usuário a utiliza em outra instância do GitHub Enterprise Server ou em uma Organização no GitHub Enterprise Cloud. As Licenças de assinatura são concedidas por Usuário, e vários Usuários não podem usar a mesma Licença de assinatura. O Cliente só pode reatribuir uma Licença de assinatura a um novo Usuário após 90 (noventa) dias da última reatribuição dessa licença, a menos que a reatribuição se deva a (i) perda ou falha de hardware permanente; (ii) rescisão do contrato ou demissão do Usuário; ou (iii) realocação temporária de Licenças de assinatura para cobrir a ausência de um Usuário. Quando o Cliente reatribui uma Licença de assinatura de um Usuário para outro, deve bloquear o acesso do Usuário anterior à Licença de assinatura e às Organizações do Cliente.

**"Período de assinatura"** significa 01 (um) ano a partir da data efetiva aplicável de um pedido ou indicado de outra forma no Formulário de pedido.

**"Suporte"** significa o suporte técnico ao Software ou ao Serviço que o GitHub pode oferecer.

**"Atualização"** significa uma versão de Software que o GitHub disponibiliza em geral aos seus clientes, juntamente com quaisquer alterações correspondentes na Documentação, que contenha correções de erros, geralmente indicadas por uma alteração no dígito à direita do segundo ponto decimal (por exemplo, x. x. x para x. x. y).

**"Tempo de atividade"** significa o percentual de tempo em um determinado trimestre em que os Serviços essenciais do GitHub não serão interrompidos por uma Pane que afete mais de 50% dos Usuários ativos

**"Usuário"** significa (i) em relação ao Software, uma única pessoa ou Conta de máquina que inicia a execução do Software, interage com ele ou o direciona no desempenho de suas funções; e (ii) no que diz respeito ao Serviço, uma Conta de máquina ou individual que (a) acessa ou usa o Serviço, (b) acessa ou usa qualquer parte da conta do Cliente, ou (c) direciona o uso da conta do Cliente no desempenho das funções, em todos os casos em nome do Cliente. O número de Usuários não deve exceder o número de Licenças de assinatura que o Cliente adquiriu.

**"Conteúdo gerado pelo usuário"** significa conteúdo criado ou pertencente a um terceiro ou Usuário externo.
