---
title: Subprocessadores e cookies do GitHub
redirect_from:
  - /subprocessors/
  - /github-subprocessors/
  - /github-tracking/
  - /github-cookies/
  - /articles/github-subprocessors-and-cookies
versions:
  free-pro-team: '*'
---

Entrada em vigor: **12 de agosto de 2020**

O GitHub fornece um grande acordo de transparência em relação à forma como usamos seus dados, como os coletamos e com quem compartilhamos. Para tanto, nós fornecemos esta página, que detalha [nossos subprocessadores](#github-subprocessors), como usamos [cookies](#cookies-on-github), e onde e como executamos qualquer [rastreamento no GitHub](#tracking-on-github).

### Subprocessadores GitHub

Quando compartilhamos suas informações com terceiros subprocessadores, tais como nossos fornecedores e provedores de serviços, permanecemos responsáveis por elas. Trabalhamos muito duro para manter sua confiança quando trazemos novos fornecedores, e exigimos que todos os fornecedores se submetam a contratos de proteção de dados conosco que restringem seu processamento de Informações Pessoais dos Usuários (conforme definido na [Declaração de Privacidade](/articles/github-privacy-statement/)).

| Nome do subprocessador | Descrição do processamento                                            | Local do Processamento | Localização corporativa |
| ---------------------- | --------------------------------------------------------------------- | ---------------------- | ----------------------- |
| Automattic             | Serviço de blogs                                                      | Estados Unidos         | Estados Unidos          |
| AWS Amazon             | Hospedagem de dados                                                   | Estados Unidos         | Estados Unidos          |
| Braintree (PayPal)     | Processador de pagamento de assinatura com cartão de crédito          | Estados Unidos         | Estados Unidos          |
| Clearbit               | Serviço de enriquecimento de dados de marketing                       | Estados Unidos         | Estados Unidos          |
| Discourse              | Provedor de software do fórum comunitário                             | Estados Unidos         | Estados Unidos          |
| DiscoverOrg            | Serviço de enriquecimento de dados de marketing                       | Estados Unidos         | Estados Unidos          |
| Eloqua                 | Automatização da campanha marketing                                   | Estados Unidos         | Estados Unidos          |
| Google Apps            | Infraestrutura interna da empresa                                     | Estados Unidos         | Estados Unidos          |
| Google Analytics       | Análise e desempenho de sites                                         | Estados Unidos         | Estados Unidos          |
| LinkedIn Navigator     | Serviço de enriquecimento de dados de marketing                       | Estados Unidos         | Estados Unidos          |
| Magic Robot            | Relatórios de campanha (Complemento para Vendas)                      | Estados Unidos         | Estados Unidos          |
| MailChimp              | Fornecedor de serviços de correio para emissão de bilhetes a clientes | Estados Unidos         | Estados Unidos          |
| Mailgun                | Provedor de serviços de correio transacional                          | Estados Unidos         | Estados Unidos          |
| Microsoft              | Microsoft Services                                                    | Estados Unidos         | Estados Unidos          |
| Monday.com             | Colaboração da equipe e plataforma de gerenciamento de projetos       | Estados Unidos         | Israel                  |
| Nexmo                  | Provedor de notificação de SMS                                        | Estados Unidos         | Estados Unidos          |
| Oracle                 | Sistema financeiro corporativo                                        | Estados Unidos         | Estados Unidos          |
| Salesforce.com         | Gerenciamento de relacionamento com clientes                          | Estados Unidos         | Estados Unidos          |
| Sendgrid               | Provedor de serviços de correio transacional                          | Estados Unidos         | Estados Unidos          |
| Sentry.io              | Provedor de monitoramento de aplicativo                               | Estados Unidos         | Estados Unidos          |
| Stripe                 | Provedor de pagamentos                                                | Estados Unidos         | Estados Unidos          |
| Twilio                 | Provedor de notificação de SMS                                        | Estados Unidos         | Estados Unidos          |
| Zendesk                | Sistema de bilhetagem de suporte ao cliente                           | Estados Unidos         | Estados Unidos          |
| Zuora                  | Sistema de faturamento corporativo                                    | Estados Unidos         | Estados Unidos          |

Quando trouxermos um novo subprocessador que lida com as Informações Pessoais de nossos Usuários, ou removermos um subprocessador, ou mudarmos a forma como usamos um subprocessador, atualizaremos esta página. Se você tiver dúvidas ou preocupações sobre um novo subprocessador, ficaremos felizes em ajudar. Entre em contato conosco via {% data variables.contact.contact_privacy %}.

### Cookies no GitHub

O GitHub usa cookies para tornar as interações com nosso serviço fáceis e significativas. Usamos cookies (e tecnologias similares, como HTML5 localStorage) para mantê-lo conectado, lembrar de suas preferências, fornecer informações para o desenvolvimento futuro do GitHub e anunciar os produtos e serviços do GitHub para você em sites de terceiros.

Um cookie é um pequeno pedaço de texto que nosso servidor web armazena em seu computador ou dispositivo móvel, que seu navegador nos envia quando você retorna ao nosso site. Os cookies não necessariamente o identificam se você está apenas visitando o GitHub; no entanto, um cookie pode armazenar um identificador exclusivo para cada usuário conectado. Usamos cookies para mantermos você logado, lembrarmos de suas preferências e fornecermos informações para o desenvolvimento futuro do GitHub. Por motivos de segurança, usamos cookies para identificar um dispositivo. Ao usar o nosso site, você concorda que podemos inserir esses tipos de cookies no seu computador ou dispositivo. Se você desativar o navegador ou a capacidade de o seu dispositivo aceitar cookies, não será possível fazer login nem usar os serviços do GitHub. Em determinadas áreas do site, também podemos usar cookies para identificar você e/ou seu dispositivo a fim de anunciar produtos e serviços no GitHub para você em sites de terceiros.

O GitHub define os seguintes cookies para os nossos usuários pelos seguintes motivos:

| Nome do Cookie                       | Motivo                                                                                                                                                                      |
| ------------------------------------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `user_session`                       | Este cookie é usado para fazer seu login.                                                                                                                                   |
| `logged_in`                          | Este cookie é usado para sinalizar que o usuário já está logado.                                                                                                            |
| `dotcom_user`                        | Este cookie é usado para sinalizar que o usuário já está logado.                                                                                                            |
| `_gh_sess`                           | Este cookie é usado para aplicação temporária e para o estado do framework entre páginas, como por exemplo, em qual etapa o usuário está em um formulário de várias etapas. |
| `tz`                                 | Este cookie permite que seu navegador nos diga em que fuso horário você está.                                                                                               |
| `gist_user_session`                  | Este cookie é usado pelo Gist ao ser executado em um host separado.                                                                                                         |
| `saml_csrf_token`                    | Este cookie é definido pelo método de caminho de autenticação SAML para associar um token ao cliente.                                                                       |
| `saml_return_to`                     | Este cookie é definido pelo método de caminho de autenticação SAML para manter o estado durante o loop de autenticação SAML.                                                |
| `gist_oauth_csrf`                    | Este cookie é definido pelo Gist para garantir que o usuário que iniciou o fluxo de autenticação seja o mesmo usuário que o completa.                                       |
| `__Host-user_session_same_site`      | Este cookie foi definido para garantir que os navegadores que suportam cookies do SameSite possam verificar se uma solicitação é originária do GitHub.                      |
| `__Host-gist_user_session_same_site` | Este cookie foi definido para garantir que os navegadores que suportam cookies do SameSite possam verificar se uma solicitação é originária do GitHub.                      |
| `_ga`                                | Este cookie é usado pelo Google Analytics.                                                                                                                                  |
| `_gat`                               | Este cookie é usado pelo Google Analytics.                                                                                                                                  |
| `_gid`                               | Este cookie é usado pelo Google Analytics.                                                                                                                                  |
| `_octo`                              | Este cookie é usado pela Octolytics, nosso serviço de análise interna, para distinguir usuários e clientes únicos.                                                          |
| `tracker`                            | Este cookie rastreia a fonte de referência para análise de inscrição.                                                                                                       |

Algumas páginas em nosso site podem definir cookies de terceiros. Por exemplo, podemos incorporar conteúdo, como vídeos, de outro site que define um cookie. Embora tentemos minimizar esses cookies de terceiros, nem sempre podemos controlar quais cookies esse conteúdo de terceiros define.

### Rastreamento no GitHub

"[Não rastreie](https://www.eff.org/issues/do-not-track)" (DNT) é uma preferência de privacidade que você pode definir em seu navegador se você não quiser que serviços online - especificamente redes de anúncios - coletem e compartilhem certos tipos de informações sobre sua atividade online a partir de serviços de rastreamento de terceiros. O GitHub responde aos sinais de DNT dos navegadores e segue o [padrão do W3C de resposta aos sinais de DNT](https://www.w3.org/TR/tracking-dnt/). Se você deseja configurar seu navegador para sinalizar que não gostaria de ser rastreado, verifique a documentação do seu navegador para saber como ativar essa sinalização. Há também bons aplicativos que bloqueiam o rastreamento online, como [Badger de Privacidade](https://www.eff.org/privacybadger).

Caso você não tenha habilitado o DNT em um navegador compatível com esse recurso, os cookies de algumas partes do nosso site rastrearão sua atividade de navegação online em outros serviços online ao longo do tempo, embora não permitamos que terceiros além de nossos provedores de análise e serviços monitorem a atividade dos usuários do GitHub ao longo do tempo no GitHub. Usamos esses cookies para nos permitir anunciar produtos e serviços do GitHub a você em sites e serviços de terceiros. Também temos contratos com certos fornecedores, como provedores de análise, que nos ajudam a rastrear os movimentos dos visitantes em determinadas páginas do nosso site. Apenas nossos fornecedores, que estão coletando informações pessoais em nosso nome, podem coletar dados em nossas páginas, e assinamos contratos de proteção de dados com cada fornecedor que recolhe esses dados em nosso nome. Usamos os dados que recebemos desses fornecedores para entender melhor os interesses de nossos visitantes, entender o desempenho de nosso site e melhorar nosso conteúdo. Qualquer fornecedor de análise será listado em nossa Lista de Subprocessadores acima, e você pode ver uma lista de cada página onde coletamos esse tipo de dados abaixo.

#### Google Analytics

Usamos o Google Analytics como um serviço de análise terceirizado e para rastrear nossas campanhas de publicidade em sites e serviços de terceiros. Usamos o Google Analytics para coletar informações sobre o desempenho do nosso site e como nossos usuários, em geral, navegam e usam o GitHub. Isso nos ajuda a avaliar o uso do GitHub por nossos usuários; compilar relatórios estatísticos sobre a atividade; e melhorar o conteúdo e desempenho do nosso site. O Google fornece mais informações sobre suas próprias práticas de privacidade e [oferece um complemento do navegador para desativar o rastreamento do Google Analytics](https://tools.google.com/dlpage/gaoptout).

#### Páginas no GitHub onde o analytics pode estar ativado

Páginas em URLs que contenham qualquer um dos seguintes domínios e caminhos (incluindo quaisquer subdomínios ou subcaminhos) em nossos sites podem ter o analytics ou outro código de rastreamento ativado. Se quiser nos impedir de coletar informações sobre sua atividade de navegação no GitHub, você pode usar um bloqueador de rastreamento, como o [Badger de Privacidade](https://www.eff.org/privacybadger) ou desativar o rastreamento do Google Analytics.

- github.com/home (se você está desconectado ou não tem uma conta, esta é a página que você verá quando visitar github.com)
- github.com/about
- github.blog
- github.com/enterprise
- github.com/collections
- github.com/developer-stories
- github.com/events
- github.com/explore
- github.com/features
- github.com/logos
- github.com/nonprofit
- github.com/open-source
- github.com/personal
- github.com/pricing
- github.com/ten
- github.com/trending
- resources.github.com
- de.github.com
- fr.github.com
