---
title: Declaração do GitHub contra a escravidão moderna e o trabalho infantil
redirect_from:
  - /articles/github-statement-against-modern-slavery-and-child-labor
versions:
  free-pro-team: '*'
---

*Declaração de 2018*

De acordo com a Organização Internacional do Trabalho (OIT), [40 milhões de pessoas foram vítimas de escravatura moderna e 152 milhões de crianças estavam sujeitas a trabalho infantil](https://www.ilo.org/global/about-the-ilo/newsroom/news/WCMS_574717/lang--en/index.htm), globalmente, em 2016. Conforme a [ OIT relata](https://www.ilo.org/global/topics/forced-labour/lang--en/index.htm):
   - 1 em cada 4 vítimas de escravatura moderna são crianças.
   - Dentre as 24,9 milhões de pessoas encurraladas em trabalhos forçados, 16 milhões são exploradas no setor privado, como no trabalho doméstico, na construção ou na agricultura; 4,8 milhões de pessoas em exploração sexual forçada e 4 milhões de pessoas em trabalho forçado impostos pelas autoridades estatais.
   -    As mulheres e meninas são desproporcionalmente afetadas pelo trabalho forçado, representando 99% das vítimas na indústria comercial do sexo e 58% em outros setores.

O GitHub lamenta a presença e persistência da escravatura moderna e do trabalho infantil, e leva a sério a sua responsabilidade de garantir que nem a escravatura moderna, nem o trabalho infantil se realizem na sua cadeia de fornecedores ou em qualquer parte do seu negócio. ("Escravidão moderna", nesta declaração, refere-se à escravatura, ao trabalho forçado ou obrigatório, ao tráfico, à servidão e aos trabalhadores que são presos, coagidos ou obrigados. "Trabalho infantil" refere-se ao trabalho realizado por alguém menor de 16 anos de idade, ou menor de 14 anos, para trabalho leve, desde que não se limite a períodos que interfiram na escolaridade da criança nem em condições que interfiram na saúde ou o bem-estar da criança.)

De acordo com a [Lei da Escravidão Moderna do Reino Unido](http://www.legislation.gov.uk/ukpga/2015/30/section/54/enacted), e em consonância com o [Protocolo da OIT de 2014 à Convenção do Trabalho Forçado](http://www.ilo.org/dyn/normlex/en/f?p=NORMLEXPUB:12100:0::NO::P12100_ILO_CODE:P029), a [Declaração da OIT sobre os Princípios Fundamentais e os Direitos do Trabalho](http://www.ilo.org/declaration/thedeclaration/textdeclaration/lang--en/index.htm), e os [Objetivos das Nações Unidas para o Desenvolvimento Sustentável 8.7](https://sustainabledevelopment.un.org/sdg8), esta declaração contra a Escravidão Moderna e o Trabalho Infantil de 2018 ("a Declaração") descreve as etapas tomadas pelo GitHub para evitar que a escravatura moderna e o trabalho infantil ocorram em seus negócios ou cadeia de fornecedores.

### Estrutura, negócios e cadeias de fornecedores do GitHub

O GitHub é uma plataforma de desenvolvimento de software com sede em São Francisco, e funcionários e fornecedores que trabalham em vários países.

Todos os funcionários da GitHub e fornecedores independentes são voluntários e espontâneos. O GitHub tem uma força de trabalho amplamente descentralizada e procura oferecer compensações competitivas e benefícios aos seus funcionários e fornecedores, independentemente da localização. Isto vale tanto quando contratamos fornecedores independentes diretamente quanto por intermediários.

O GitHub não fabrica ou produz hardware, nem utiliza agências de recrutamento para os tipos de serviços frequentemente executados por trabalhadores migrantes. A natureza do negócio do GitHub não o submete a mudanças súbitas na carga de trabalho ou em pressões sob preços, que frequentemente conduzem a práticas que aumentam o risco de trabalho forçado nas cadeias de fornecedores, como horas extras forçadas.

O GitHub oferece software gratuito e pago e software baseado na web como um serviço a clientes em todo o mundo. Os produtos do GitHub incluem:
   - GitHub.com: plataforma de colaboração e hospedagem de códigos baseada na web
   - GitHub Enterprise: colaboração local e software de hospedagem de código
   - Atom: editor de texto
   - Electron: estrutura para escrever aplicativos de desktop multiplataforma
   - GitHub Desktop: aplicativo de desktop para acessar o GitHub.com e o GitHub Enterprise

A cadeia de fornecedores do GitHub consiste em bens e serviços para nossos produtos e operações, incluindo serviços de computação, planejamento de eventos, compra de varejo e itens promocionais, itens de escritório, aluguel de instalações como espaço de escritório e central de dados.

### Políticas relativas à escravatura moderna e ao trabalho infantil

#### Escravidão moderna e trabalho infantil

**O Código de Ética do GitHub** proíbe a utilização, participação ou tolerância consciente à escravidão moderna (escravidão, trabalho forçado ou obrigatório, tráfico, servidão ou trabalhadores que estão presos, coagidos ou obrigados) ou trabalho infantil em suas operações comerciais. Qualquer funcionário ou contratante do GitHub que violar esta proibição estará sujeito à rescisão do emprego ou do relacionamento comercial.

**O Padrão de Conduta do GitHub** proíbe condutas inseguras e ilegais, incluindo o uso consciente, a participação, o apoio ou a tolerância à escravidão moderna (escravidão, trabalho forçado ou obrigatório, tráfico, servidão ou trabalhadores presos, coagidos ou obrigados) ou ao trabalho infantil.

O GitHub está em conformidade com as leis que proíbem o tráfico e o trabalho infantil nas jurisdições em que opera, incluindo o [Regulamento Federal de Aquisição dos EUA 22.17 sobre a luta contra o tráfico de seres humanos](https://www.govinfo.gov/content/pkg/CFR-2009-title48-vol1/pdf/CFR-2009-title48-vol1-part22-subpart22-17.pdf). Federal Acquisition Regulation 22.17 on combatting human trafficking</a>.

Além disso, o GitHub estabeleceu uma parceria com o Programa FairHotel, o que significa que o GitHub encoraja os seus funcionários a escolherem os hotéis endossados pelo FairHotel, certificando que os trabalhadores têm salários justos, benefícios adequados e têm suas opiniões ouvidas no ambiente de trabalho. Ser um parceiro do FairHotel também significa que o GitHub oferece negócios para hotéis como um empregador justo.

Além disso, o GitHub comunicará esta Declaração a todos os funcionários, contratados e fornecedores, incluindo recrutadores e agências de emprego. O GitHub também está desenvolvendo treinamento para todos os funcionários do GitHub sobre escravidão moderna e trabalho infantil. O GitHub [disponibiliza sua Declaração contra a Escravidão Moderna e o Trabalho Infantil publicamente](/articles/github-statement-against-modern-slavery-and-child-labor).

O GitHub tem uma política de não retaliação para reportar questões relacionadas ao local de trabalho. Consistente com esta Declaração, o GitHub permite que funcionários e fornecedores relatem questões relativas à escravatura moderna e ao trabalho infantil, sem medo de retaliação.

### Leis e práticas trabalhistas

As práticas trabalhistas do GitHub são:

**justas**:
   - O GitHub paga aos seus funcionários e fornecedores um salário justo, de acordo com os valores salariais legais aplicáveis
   - O GitHub mantém condições de trabalho humanas
   - O GitHub não exige que os funcionários excedam o tempo máximo de horas diárias de trabalho definidas pelas leis ou regulamentos locais e nacionais
   - O GitHub paga aos seus funcionários e fornecedores pontualmente, com a documentação (holerite) demonstrando a base em que se baseiam os pagamentos, e mantém registros de funcionários de acordo com as leis locais e nacionais

**humanas e éticas**:
   - O GitHub usa apenas mão de obra voluntária/não forçada
   - O GitHub proíbe o trabalho infantil
   - O GitHub não se envolve em castigos físicos ou abusos
   - O GitHub não tolera assédio ou discriminação ilegal da mão de obra ou no local de trabalho

**respeitosas**:
   - O GitHub protege os direitos dos seus funcionários à liberdade de associação e negociação coletiva, de acordo com os requisitos legais, incluindo publicação de avisos legais sobre os direitos dos funcionários ao abrigo da Lei Nacional de Relações de Trabalho dos Estados Unidos
   - O GitHub oferece benefícios aos funcionários nos níveis esperados para o setor ou acima desses
   - O GitHub encoraja os funcionários a denunciar qualquer reclamação no local de trabalho e não tolera retaliação

### Processos de due diligence em relação à escravidão moderna e ao trabalho infantil em seus negócios e cadeias de fornecedores

O GitHub avalia seus negócios e cadeia de fornecedores em relação a riscos relacionados à escravidão moderna e ao trabalho infantil. Baseando-se na expertise interna e externa em direitos humanos, o GitHub se engajou em uma análise multifuncional (incluindo áreas como Política, Jurídico, Compras, Finanças e Operacional e, especialmente, Recursos Humanos) para determinar onde existem serviços trabalhistas em sua cadeia de negócios e fornecimento e identificar potenciais riscos relacionados à escravidão moderna e ao trabalho infantil. O GitHub prioriza áreas onde esses riscos podem ser mais significativos em termos de gravidade, escala ou probabilidade para maior due diligence, monitoramento e verificação. O GitHub continua a avaliar onde podem ocorrer riscos e como lidar com eles. Além disso, o GitHub agora obtém as garantias dos seus fornecedores de que têm práticas compatíveis com esta Declaração, incluindo o cumprimento das leis relacionadas com a escravatura moderna ou o trabalho infantil.

### Lugares nas cadeias de negócios e suprimentos do GitHub onde há um risco de escravidão moderna e trabalho infantil, e medidas que o GitHub tomou para avaliar e gerenciar esse risco

O GitHub não identificou nenhum fornecedor de alto risco; no entanto, a escravatura moderna ou o trabalho infantil teriam mais probabilidade de ocorrer com fornecedores para serviços envolvendo trabalho manual, como apoio a eventos, construção, serviços de facilities e alimentação. O GitHub auditará os seus fornecedores atuais e exigirá que os que estão em áreas de risco mais altas confirmem que fornecem serviços de acordo com este Declaração.

Embora o GitHub não saiba de nenhuma escravidão moderna ou suposto trabalho infantil em seus negócios ou cadeia de fornecedores, e não tenha nenhuma base crível para acreditar que estejam ocorrendo, o GitHub está comprometido em fornecer remédios se o próprio GitHub causar diretamente a escravidão moderna ou o trabalho infantil e a reparação de padrões mais amplos de não conformidade com esta Declaração causada por deficiências nos sistemas ou processos do GitHub. A reparação do GitHub para vítimas individuais incluiria protocolos para ações imediatas apropriadas para eliminar as práticas modernas de escravidão e trabalho infantil, juntamente com recursos para serviços razoáveis e apropriados às vítimas projetados para compensar os danos experimentados.

### A eficácia em garantir que nem a escravidão moderna nem o trabalho infantil estão ocorrendo nos negócios ou cadeias de fornecedores do GitHub

O GitHub está em conformidade e continuará agindo conforme as leis relacionadas à escravidão moderna e ao trabalho infantil.

De agora em diante, o GitHub passa a exigir que seus fornecedores cumpram esta Declaração, bem como leis relacionadas à escravidão moderna e ao trabalho infantil. O GitHub agora também exige que seus fornecedores:
   - não utilizem, participem, apoiem ou tolerem a escravidão moderna ou o trabalho infantil
   - não utilizem práticas de recrutamento ou engajamento enganosas ou fraudulentas para funcionários ou trabalhadores contratados
   - não cobrem taxas de recrutamento ou engajamento a funcionários ou contratados
   - não destruam, ocultem, confisquem ou neguem o acesso de um funcionário ou qualquer trabalhador contratado ao seu próprio passaporte, carteira de motorista ou outros documentos de identidade;
   - permitam-nos rescindir nossos contratos com eles por qualquer violação de suas obrigações relacionadas à escravidão moderna ou ao trabalho infantil; e
   - reparem quaisquer danos causados a qualquer trabalhador considerado sujeito a qualquer forma de escravidão moderna ou trabalho infantil, se exigido por lei.

Além disso, o GitHub encoraja fortemente seus fornecedores a:
   - conduzir processos de due diligence anti-escravidão e trabalho infantil, incluindo avaliações de risco, para seus fornecedores;
   - tomar medidas para enfrentar os riscos identificados; e
   - usar uma linguagem anti-moderna e de trabalho infantil semelhante com seus fornecedores.

As instruções relativas às compras do GitHub para os funcionários responsáveis pelo setor de compras da empresa agora incluem uma referência à exigência de que os fornecedores cumpram o Código de Conduta do Fornecedor da Microsoft ou esta Declaração.

### Treinamento para funcionários do GitHub sobre escravidão moderna e tráfico humano

O GitHub está desenvolvendo um treinamento de escravidão moderna e trabalho infantil que será obrigatório para todos os funcionários, com vistas aos negócios e à cadeia de fornecimento do GitHub. O GitHub dará ênfase aos fornecedores de serviços que envolvem mão de obra manual, como suporte a eventos, construção, serviços de facilities e alimentação, que são as áreas de maior risco potencial.

**O Conselho de Administração do GitHub aprovou [esta Declaração](/assets/images/help/site-policy/github-statement-against-modern-slavery-and-child-labor.pdf).**
