---
title: Declaração de Privacidade do GitHub
redirect_from:
  - /privacy/
  - /privacy-policy/
  - /privacy-statement/
  - /github-privacy-policy/
  - /articles/github-privacy-policy/
  - /articles/github-privacy-statement/
versions:
  free-pro-team: '*'
---

Data de entrada em vigor: 22 de Julho de 2020

Agradecemos por confiar seu código-fonte, seus projetos e suas informações pessoais à GitHub Inc. (“GitHub” ou “nós”). Manter suas informações pessoais em segurança é uma responsabilidade que levamos a sério, e queremos mostrar como fazemos esse trabalho.

Todos os termos em maiúsculas estão definidos nos [Termos de Serviço do GitHub](/github/site-policy/github-terms-of-service), salvo observações em contrário.


### Resumo

Usamos suas informações pessoais conforme descrito nesta Declaração de Privacidade. Não importa onde estiver, onde morar, ou qual for a sua cidadania, fornecemos os mesmos elevados padrões de proteção da privacidade a todos os nossos usuários em todo o mundo, independentemente do seu país de origem ou localização.

Esta é uma versão resumida das nossas diretrizes. Para obter as informações completas, continue a leitura desta página.

### Sumário

| Seção                                                                                                                   | Conteúdo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| ----------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| [Que tipo de informação o GitHub coleta](#what-information-github-collects)                                             | O GitHub coleta informações diretamente de você para fins de registro, pagamento, transações e perfil de usuário. Também coletamos automaticamente suas informações de uso, cookies e tecnologias similares, bem como informações do dispositivo, sujeitas ao seu consentimento, quando necessário. O GitHub também pode coletar Informações Pessoais de Usuário de terceiros. Coletamos somente a quantidade mínima de informações pessoais necessárias de você, a menos que você decida compartilhar mais informações. |
| [Que tipo de informação o GitHub _não_ coleta](#what-information-github-does-not-collect)                               | Não coletamos informações de crianças com menos de 13 anos nem coletamos [Informações Pessoais Confidenciais](https://gdpr-info.eu/art-9-gdpr/).                                                                                                                                                                                                                                                                                                                                                                         |
| [Como o GitHub usa suas informações](#how-github-uses-your-information)                                                 | Nesta seção, descrevemos as formas como usamos suas informações, inclusive para fornecer o Serviço, para nos comunicarmos com você, para fins de segurança e conformidade, e para melhorar nosso Serviço. A seção também descreve a base jurídica na qual processamos suas informações quando tal processamento for exigido por lei.                                                                                                                                                                                     |
| [Como compartilhamos as informações obtidas](#how-we-share-the-information-we-collect)                                  | Podemos compartilhar suas informações com terceiros diante de uma das seguintes circunstâncias: com seu consentimento, com nossos prestadores de serviços para fins de segurança, para cumprir as nossas obrigações legais, ou quando houver mudança de controle ou venda de entidades corporativas ou unidades de negócios. Não vendemos suas informações pessoais e não hospedamos anúncios no GitHub. Consulte uma lista de prestadores de serviços que acessam suas informações.                                     |
| [Outras informações importantes](#other-important-information)                                                          | Oferecemos informações adicionais específicas relacionadas a conteúdo de repositórios, informações públicas e Organizações no GitHub.                                                                                                                                                                                                                                                                                                                                                                                    |
| [Serviços adicionais](#additional-services)                                                                             | Oferecemos informações sobre ofertas de serviço adicionais, inclusive aplicativos de terceiros, GitHub Pages e aplicativos do GitHub.                                                                                                                                                                                                                                                                                                                                                                                    |
| [Como você pode acessar e controlar as informações obtidas](#how-you-can-access-and-control-the-information-we-collect) | Propomos algumas medidas para você acessar, alterar ou excluir suas informações pessoais.                                                                                                                                                                                                                                                                                                                                                                                                                                |
| [Uso de cookies e rastreamento](#our-use-of-cookies-and-tracking)                                                       | Usamos cookies para fins de funcionalidade geral do site, e usamos alguns poucos serviços de rastreamento e análise em determinadas partes do site. Temos uma página que torna o processo bastante transparente. Veja mais detalhes nesta seção.                                                                                                                                                                                                                                                                         |
| [Como o GitHub protege suas informações](#how-github-secures-your-information)                                          | Tomamos todas as medidas razoavelmente necessárias para proteger a confidencialidade, a integridade e a disponibilidade das suas informações pessoais no GitHub e para proteger a resiliência dos nossos servidores.                                                                                                                                                                                                                                                                                                     |
| [Práticas globais de privacidade do GitHub](#githubs-global-privacy-practices)                                          | Fornecemos os mesmos altos padrões de proteção de privacidade a todos os nossos usuários em todo o mundo.                                                                                                                                                                                                                                                                                                                                                                                                                |
| [Nossa comunicação com você](#how-we-communicate-with-you)                                                              | Nossa comunicação com você ocorrerá por e-mail. É possível controlar os nossos meios de contato com você nas configurações da sua conta.                                                                                                                                                                                                                                                                                                                                                                                 |
| [Resolução de conflitos](#resolving-complaints)                                                                         | Na hipótese improvável de sermos incapazes de resolver um problema de privacidade de dados de forma rápida e detalhada, indicaremos um caminho para a resolução de litígios.                                                                                                                                                                                                                                                                                                                                             |
| [Mudanças nesta Declaração de Privacidade](#changes-to-our-privacy-statement)                                           | Você receberá notificações sobre mudanças concretas nesta Declaração de Privacidade 30 dias antes de tais mudanças entrarem em vigor. Também é possível acompanhar as mudanças no nosso repositório da Política do Site.                                                                                                                                                                                                                                                                                                 |
| [Licença](#license)                                                                                                     | Esta Declaração de Privacidade é licenciada sob a [licença Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/).                                                                                                                                                                                                                                                                                                                                                                                   |
| [Contato com a GitHub](#contacting-github)                                                                              | Entre em contato em caso de dúvidas sobre a nossa Declaração de Privacidade.                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| [Traduções](#translations)                                                                                              | Acesse os links para consultar algumas traduções da Declaração de Privacidade.                                                                                                                                                                                                                                                                                                                                                                                                                                           |

## Declaração de Privacidade do GitHub

### Que tipo de informação o GitHub coleta

"**Informações Pessoais de Usuário**" consistem em qualquer informação pessoal sobre um dos nossos Usuários, podendo identificá-los pessoalmente ou estarem vinculadas a eles. Informações como nome de usuário e senha, endereço de e-mail, nome real, protocolo Internet (endereço IP) e foto são exemplos de "Informações Pessoais de Usuário".

As Informações Pessoais de Usuário não incluem informações agregadas nem informações não pessoais identificáveis que não identifiquem o Usuário ou que não possam ser razoavelmente vinculadas ou relacionadas ao Usuário. Podemos usar tais informações agregadas e não pessoais identificáveis para fins de pesquisa e para operar, analisar, melhorar e otimizar nossos Site e Serviços.

#### Informações enviadas pelos usuários diretamente ao GitHub

##### Informações de registro
Solicitaremos algumas informações básicas no momento de criação da conta. Quando você criar seu próprio nome de usuário e senha, solicitaremos um endereço de e-mail válido.

##### Informações de pagamento
Se você fizer um registro de Conta paga conosco, enviar fundos pelo Programa de Patrocinadores do GitHub ou comprar um aplicativo no GitHub Marketplace, coletaremos seu nome completo, endereço e informações do PayPal ou do cartão de crédito. Observe que o GitHub não processa ou armazena suas informações de cartão de crédito ou do PayPal, mas nosso processador de pagamento de terceiros o fará.

Se você listar e vender um aplicativo no [GitHub Marketplace](https://github.com/marketplace), precisaremos das suas informações bancárias. Se você angariar fundos pelo [Programa de Patrocinadores do GitHub](https://github.com/sponsors), solicitaremos algumas [informações adicionais](/github/supporting-the-open-source-community-with-github-sponsors/becoming-a-sponsored-developer#submitting-your-bank-information) no processo de registro para você participar e receber fundos através desses serviços e para fins de compliance.

##### Informações do perfil
Você pode optar por nos enviar mais informações para o perfil da sua Conta, como nome completo, avatar com foto, biografia, localidade, empresa e URL para um site de terceiros. Essas informações podem incluir Informações Pessoais de Usuário. Observe que as suas informações de perfil podem ficar visíveis para outros Usuários do nosso Serviço.

#### Informações que o GitHub coleta automaticamente do seu uso do Serviço

##### Informações da transação
Se você tiver uma Conta paga conosco, se vender um aplicativo no [GitHub Marketplace](https://github.com/marketplace) ou se angariar fundos pelo [Programa de Patrocinadores do GitHub](https://github.com/sponsors), coletaremos automaticamente determinadas informações sobre suas transações no Serviço, como data, hora e quantia cobrada.

##### Informações de uso
Se você acessar nosso Serviço ou Site, coletaremos automaticamente as mesmas informações básicas coletadas pela maioria dos serviços, sujeitando-nos ao seu consentimento, quando necessário. A coleta inclui informações sobre o seu uso do Serviço, como as páginas que você visualiza, o site referenciado, seu endereço IP, informações da sessão, e a data e hora de cada solicitação. Essas informações são obtidas igualmente de todos os visitantes do Site, independentemente de terem Conta ou não. Esses dados podem incluir Informações Pessoais de Usuário.

##### Cookies e informações de tecnologias semelhantes
Conforme descrito em mais detalhes a seguir e sujeitos ao seu seu consentimento, quando necessário, coletaremos informações automaticamente de cookies e tecnologias afins (como ID de cookie e configurações) para manter a sua conexão, lembrar suas preferências e identificar você e seu dispositivo.

##### Informações do dispositivo
Podemos coletar determinadas informações sobre o seu dispositivo, como endereço IP, dados de navegador ou aplicativo cliente, preferências de idioma, sistema operacional, versão de aplicativo, tipo e ID de dispositivo, e modelo e fabricante de dispositivo. Esses dados podem incluir Informações Pessoais de Usuário.

#### Informações coletadas de terceiros

O GitHub pode coletar Informações Pessoais de Usuário de terceiros. Por exemplo, isso pode acontecer caso você se inscreva em treinamentos ou solicite informações sobre o GitHub via um de nossos fornecedores, parceiros ou afiliados. GitHub não compra Informações Pessoais de Usuário de agenciadores de terceiros.

### Que tipo de informação o GitHub não coleta

Não coletamos "**[Informações Pessoais Confidenciais](https://gdpr-info.eu/art-9-gdpr/)**", como dados pessoais que revelem origem racial ou étnica; opiniões políticas, crenças religiosas ou filosóficas, ou filiação sindical; processamento de dados genéticos ou biométricos para identificar uma pessoa física de forma inequívoca; dados relativos à saúde, à orientação ou à vida sexual de uma pessoa física. Se decidir armazenar quaisquer Informações Pessoais Confidenciais em nossos servidores, você será responsável pela conformidade com quaisquer controles regulamentares sobre tais informações.

Se você é criança e tem menos de 13 anos de idade, talvez você não tenha uma Conta no GitHub. O GitHub não coleta informações nem direciona qualquer conteúdo especificamente a crianças com menos de 13 anos. Se descobrirmos ou tivermos motivos para suspeitar de que você é Usuário e tem menos de 13 anos de idade, teremos que encerrar a sua Conta. Não pretendemos desmotivar o seu aprendizado na área de programação, mas devemos cumprir as regras. Consulte nossos [Termos de Serviço](/github/site-policy/github-terms-of-service) para mais informações sobre o encerramento da Conta. Outros países podem ter limites de idade diferentes. Se estiver abaixo da idade mínima necessária para dar consentimento sobre a coleta de dados no seu país, você não poderá ter uma Conta no GitHub.

Não coletamos intencionalmente as Informações Pessoais de Usuário **armazenadas em seus repositórios** ou em outros métodos de entrada de conteúdo de forma livre. Toda e qualquer informação pessoal que conste no repositório do usuário é de responsabilidade do proprietário do repositório.

### Como o GitHub usa suas informações

- Podemos usar as suas informações das seguintes maneiras:
- Usamos suas [Informações de Registro](#registration-information) para criar sua conta e prestar o Serviço a você.
- Usamos suas [Informações de Pagamento](#payment-information) para prestar o serviço de Conta Paga, o serviço do Marketplace, o Programa de Patrocinadores ou qualquer outro serviço pago que você solicitar no GitHub.
- Usamos suas Informações Pessoais de Usuário, especificamente seu nome de usuário, para identificar você no GitHub.
- Usamos suas [Informações de Perfil](#profile-information) para preencher o perfil da sua Conta e compartilhar esse perfil com outros usuários, se você nos solicitar.
- Usaremos seu endereço de e-mail para nos comunicar com você, mediante o seu consentimento, e **somente para os fins que você especificar**. Consulte a seção sobre [comunicação por e-mail](#how-we-communicate-with-you) para saber mais.
- Usamos Informações Pessoais de Usuário para responder a solicitações de suporte.
- Usamos Informações Pessoais de Usuário e outros dados para fazer recomendações a você, como sugestões de projetos que talvez você queira acompanhar ou contribuir. Usamos o seu comportamento público no GitHub (como os projetos que você marca como favoritos) para determinar seus interesses de programação e recomendar projetos afins. Essas recomendações são decisões automatizadas, mas não têm qualquer impacto jurídico nos seus direitos.
- Podemos usar Informações Pessoais de Usuário para convidar você a participar de pesquisas, programas beta ou outros projetos de pesquisa, sujeitos ao seu consentimento, quando necessário.
- Usamos as [Informações de Uso](#usage-information) e as [Informações do Dispositivo](#device-information) para entender como nossos usuários aproveitam o GitHub e para melhorar nossos Site e Serviços.
- Se necessário, podemos usar suas Informações Pessoais de Usuário para fins de segurança ou para investigar possíveis fraudes ou tentativas de violar o GitHub ou nossos Usuários.
- Podemos usar suas Informações Pessoais de Usuário para cumprir com nossas obrigações legais, proteger nossa propriedade intelectual e impor nossos [Termos de Serviço](/github/site-policy/github-terms-of-service).
- Limitamos o nosso uso das Informações Pessoais de Usuário aos propósitos listados nesta Declaração de Privacidade. Se precisarmos usar suas Informações Pessoais de Usuário para outros fins, pediremos sua permissão com antecedência. No seu [perfil de usuário](https://github.com/settings/admin), você sempre poderá ver quais informações coletamos, o uso que fazemos delas e as permissões concedidas.

#### Bases jurídicas para o processamento de informações

Na medida em que nosso processamento das suas Informações Pessoais de Usuário está sujeito a determinadas leis internacionais, inclusive, entre outras, o Regulamento Geral de Proteção de Dados (RGPD/GDPR) da União Europeia, o GitHub é obrigado a informar você sobre a base jurídica em que processamos Informações Pessoais de Usuário. O GitHub processa as Informações Pessoais de Usuário conforme as seguintes bases legais:

- Execução contratual:
  * Ao criar uma conta no GitHub, você envia suas [Informações de Registro](#registration-information). Solicitamos esses dados para que você celebre o contrato dos Termos de Serviço conosco e processamos tais dados com base na execução desse contrato. Também usamos outras bases para processar seu nome de usuário e endereço de e-mail, conforme descrito a seguir.
  * Se você tiver uma conta paga conosco, coletaremos e processaremos [Informações de Pagamento](#payment-information) com base na execução desse contrato.
  * Quando você comprar ou vender um aplicativo do nosso Marketplace, ou quando enviar ou receber fundos pelo Programa de Patrocinadores do GitHub, processaremos suas [Informações de Pagamento](#payment-information) e outros elementos adicionais para fins de execução do contrato referente a esses serviços.
- Consentimento:
  * Recorreremos ao seu consentimento para usar suas Informações Pessoais de Usuário nas seguintes circunstâncias: quando você preencher as informações do seu [perfil de usuário](https://github.com/settings/admin); quando você decidir participar de um treinamento, projeto de pesquisa, programa beta ou pesquisa do GitHub; para fins de marketing, quando aplicável. Todas essas Informações Pessoais de Usuário são inteiramente opcionais, e você poderá acessar, modificar e excluir tais informações a qualquer momento. Embora não possa excluir totalmente seu endereço de e-mail, você pode torná-lo privado e poderá retirar seu consentimento a qualquer momento.
- Interesses legítimos:
  * Em geral, nossos outros tipos de processamento de Informações Pessoais de Usuário são necessários para os nossos interesses legítimos, como para fins de conformidade jurídica, segurança ou manutenção contínua de confidencialidade, integridade, disponibilidade e resiliência dos sistemas, Site e Serviços do GitHub.
- Para solicitar a exclusão dos dados que processamos com base em consentimento ou para se objetar ao nosso processamento de informações pessoais, use o nosso [formulário de contato de Privacidade](https://support.github.com/contact/privacy).

### Como compartilhamos as informações obtidas

Podemos compartilhar suas Informações Pessoais de Usuário com terceiros em uma das seguintes circunstâncias:

#### Com o seu consentimento
Com o seu consentimento, compartilhamos suas Informações Pessoais de Usuário, após deixarmos você ciente de quais informações serão compartilhadas, com quem e por quê. Por exemplo, se você comprar um aplicativo do nosso Marketplace, compartilharemos seu nome de usuário para permitir que o desenvolvedor do aplicativo preste os serviços. Além disso, por meio de suas ações no GitHub, você poderá indicar a sua disposição em compartilhar suas Informações Pessoais de Usuário. Por exemplo, ao ingressar em uma Organização, você indica que o proprietário da Organização poderá visualizar a sua atividade no log de acesso da Organização.

#### Com prestadores de serviço
Nós compartilhamos Informações Pessoais de Usuário com um número limitado de prestadores de serviços que processam tais informações em nosso nome para prestar (ou melhorar) nosso serviço. Ao assinarem contratos de proteção de dados, esses prestadores concordam com restrições de privacidade semelhantes às determinadas na presente Declaração de Privacidade. Nossos prestadores de serviços desempenham vários serviços, como processamento de pagamento, geração de tíquetes de atendimento ao cliente, transmissão de dados de rede, segurança e outros serviços afins. Embora o GitHub processe todas as Informações Pessoais de Usuário nos Estados Unidos, nossos prestadores de serviços podem processar dados fora dos Estados Unidos ou da União Europeia. Para saber quem são nossos prestadores de serviços, consulte nossa página em [Subprocessadores](/github/site-policy/github-subprocessors-and-cookies).

#### Por motivos de segurança
Se você é integrante de uma Organização, o GitHub pode compartilhar seu nome de usuário, [Informações de uso](#usage-information) e [Informações do dispositivo](#device-information) associado a essa organização com um proprietário e/ou administrador na medida em que essas informações são fornecidas apenas para investigar ou responder a um incidente de segurança que afeta ou compromete a segurança dessa organização em particular.

#### Para divulgação legal
O GitHub luta pela transparência no cumprimento do processo legal e das obrigações legais. A menos que sejamos impedidos de fazê-lo por lei ou ordem judicial, ou em circunstâncias raras e exigentes, fazemos esforço razoável para notificar os usuários de quaisquer informações legalmente solicitadas ou exigidas. O GitHub pode revelar Informações Pessoais de Usuário ou outras informações coletadas sobre você para fins de cumprimento da lei em resposta a intimação, ordem judicial, garantia ou ordem governamental similar, ou quando acreditarmos de boa-fé que a divulgação se faz necessária para cumprir com nossas obrigações legais, proteger nossa propriedade ou nossos direitos, ou de terceiros ou do público geral.

Para obter mais informações sobre a nossa transparência em resposta a solicitações legais, consulte nossas [Diretrizes para Solicitações Legais de Dados do Usuário](/github/site-policy/guidelines-for-legal-requests-of-user-data).

#### Mudança de controle ou venda
Podemos compartilhar Informações Pessoais do Usuário se estivermos envolvidos em uma fusão, venda ou aquisição de entidades corporativas ou unidades de negócios. Diante de qualquer mudança de propriedade, garantiremos que a mudança ocorra de maneira a preservar a confidencialidade das Informações Pessoais de Usuário. Ademais, antes de qualquer transferência das suas Informações Pessoais de Usuário, enviaremos uma notificação a você pelo nosso Site ou por e-mail. A organização que receber nossas Informações Pessoais de Usuário terá que honrar toda e qualquer promessa que tenhamos feito em nossa Declaração de Privacidade ou em nossos Termos de Serviço.

#### Informações de identificação não pessoal agregadas
Nós compartilhamos com terceiros determinadas informações não pessoais agregadas sobre como nossos usuários, coletivamente, usam o GitHub, ou como nossos usuários reagem às nossas outras ofertas, tais como conferências ou eventos. Por exemplo, podemos [compilar estatísticas sobre a atividade de licenças de código aberto no GitHub](https://octoverse.github.com/).

Nós **não** vendemos suas Informações Pessoais de Usuário para obtenção de lucro ou considerações afins.

Observação: a Lei de Privacidade do Consumidor da Califórnia de 2018 (“CCPA”) exige que as empresas informem em suas respectivas políticas de privacidade se divulgam ou não informações pessoais para obtenção de lucro ou considerações afins. Enquanto a CCPA cobre apenas residentes da Califórnia, nós voluntariamente estendemos seus principais direitos para as pessoas controlarem seus dados a _todos_ os nossos usuários e não apenas àqueles que residem na Califórnia. Saiba mais sobre a CCPA e sobre como a cumprimos [aqui](/github/site-policy/githubs-notice-about-the-california-consumer-privacy-act).

### Outras informações importantes

#### Conteúdo do repositório

Funcionários do GitHub [não acessam repositórios privados, a menos que haja solicitação](/github/site-policy/github-terms-of-service#e-private-repositories) por questões de segurança, para fins de suporte ao proprietário do repositório com um problema, para manter a integridade do Serviço ou para cumprirmos com nossas obrigações legais.  No entanto, embora geralmente não procuremos conteúdo em seus repositórios, podemos varrer nossos servidores e conteúdo para detectar determinados tokens ou assinaturas de segurança, malware ativo conhecido ou outro conteúdo conhecido por violar nossos Termos, como conteúdo extremista violento ou terrorista ou imagens de exploração infantil, com base em técnicas algorítmicas de impressão digital. Nossos Termos de Serviço fornecem [mais detalhes](/github/site-policy/github-terms-of-service#e-private-repositories).

Se o seu repositório for público, qualquer pessoa poderá ver o conteúdo do repositório em questão. Se você incluiu informações privadas ou [Informações Pessoais Confidenciais](https://gdpr-info.eu/art-9-gdpr/) no seu repositório público, como endereços de e-mail ou senhas, tais informações poderão ser indexadas por mecanismos de pesquisa ou usadas por terceiros.

Saiba mais sobre [Informações Pessoais de Usuário em repositórios públicos](/github/site-policy/github-privacy-statement#public-information-on-github).

#### Informações públicas no GitHub

Vários recursos e serviços do GitHub são voltados para o público. Se o seu conteúdo for voltado para o público, ele poderá ser acessado e usado por terceiros em conformidade com nossos Termos de Serviço. Por exemplo, os terceiros podem visualizar seu perfil ou repositórios, ou fazer pull de dados pela nossa API. Não vendemos esse conteúdo; ele é seu. Entretanto, permitimos que terceiros (como organizações de pesquisa ou arquivos) compilem as informações públicas do GitHub. Outros terceiros, como agentes de dados, são conhecidos também por fazer scraping do GitHub e compilar dados.

Suas Informações Pessoais de Usuário, associadas ao seu conteúdo, podem ser coletadas por terceiros nessas compilações de dados do GitHub. Se você não quiser que suas Informações Pessoais de Usuário apareçam em compilações de dados do GitHub de terceiros, não disponibilize as Informações Pessoais de Usuário publicamente e certifique-se de [configurar seu endereço de e-mail como privado no seu perfil de usuário](https://github.com/settings/emails) e em suas [configurações de commit do Git](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Definimos o endereço de e-mail dos Usuários como privado por padrão, mas alguns Usuários do GitHub podem ter que atualizar suas configurações.

Se quiser compilar dados do GitHub, você deverá aceitar nossos Termos de Serviço quanto a [scraping](/github/site-policy/github-acceptable-use-policies#5-scraping-and-api-usage-restrictions) e [privacidade](/github/site-policy/github-acceptable-use-policies#6-privacy), e poderá usar apenas as Informações Pessoais de Usuário públicas que coletar para os fins autorizados pelos nossos usuários. Por exemplo, se o usuário do GitHub deixou um endereço de e-mail público para fins de identificação e atribuição, não use o endereço de e-mail para fins de publicidade comercial. Esperamos que você proteja, de forma razoável, qualquer Informação Pessoal de Usuário que coletar do GitHub e que responda prontamente a reclamações, solicitações de remoção e solicitações de "não contatar" de nossa parte e de outros usuários.

De modo semelhante, os projetos no GitHub podem incluir Informações Pessoais de Usuário publicamente disponíveis e coletadas como parte do processo colaborativo. Em caso de problemas relacionados a quaisquer Informações Pessoais de Usuário no GitHub, consulte nossa seção sobre [resolução de conflitos](/github/site-policy/github-privacy-statement#resolving-complaints).


#### Organizações

Por meio de suas ações no GitHub, você poderá indicar a sua disposição em compartilhar suas Informações Pessoais de Usuário. Se você colaborar com ou se tornar integrante de uma Organização, os proprietários da Conta poderão receber suas Informações Pessoais de Usuário. Ao aceitar um convite para uma Organização, você receberá uma notificação sobre os tipos de informações que os proprietários poderão ver (para mais informações, consulteorganização <[Sobre Associação à Organização](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)). Se você aceitar um convite para uma Organização com um [domínio verificado](/github/setting-up-and-managing-organizations-and-teams/verifying-your-organizations-domain), os proprietários da Organização poderão ver seu(s) endereço(s) de e-mail completo(s) no(s) domínio(s) verificado(s) da Organização.

Observe que o GitHub poderá compartilhar seu nome de usuário, suas [Informações de Uso](#usage-information) e as [Informações do Dispositivo](#device-information) com a organização da qual você é integrante na medida que as suas informações pessoais sejam fornecidas apenas para investigar ou responder a um incidente de segurança que afeta ou compromete a segurança dessa organização em particular.

Se você colaborar com ou se tornar integrante de uma Conta que concordou com os [Termos de Serviço Corporativos](/github/site-policy/github-corporate-terms-of-service) e com um Adendo de Proteção de Dados (DPA) nesta Declaração de Privacidade, o DPA prevalecerá em caso de quaisquer conflitos entre a presente Declaração de Privacidade e o DPA no que tange à sua atividade na Conta.

Entre em contato com os proprietários da conta para obter mais informações sobre como eles processam suas Informações Pessoais de Usuário na Organização e sobre as suas formas de acesso, atualização, alteração ou exclusão das Informações Pessoais de Usuário armazenadas na Conta.

### Serviços adicionais

#### Aplicativos de terceiros

Você pode habilitar ou adicionar aplicativos de terceiros, conhecidos como "Produtos de Desenvolvedor", na sua Conta. Esses Produtos de Desenvolvedor não são necessários para o uso do GitHub. Compartilharemos suas Informações Pessoais de Usuário com terceiros quando você nos solicitar, por exemplo, ao comprar um Produto de Desenvolvedor no Marketplace. No entanto, você será responsável pelo uso do Produto de Desenvolvedor de terceiro e pela quantidade de Informações Pessoais de Usuário que decidir compartilhar. Consulte nossa [documentação de API](/v3/users/) para saber quais informações são fornecidas quando você se autentica em um Produto de Desenvolvedor usando seu perfil no GitHub.

#### GitHub Pages

Se você criar um site no GitHub Pages, é de sua responsabilidade publicar uma declaração de privacidade que descreva precisamente a sua forma de coletar, usar e compartilhar informações pessoais e outras informações dos visitantes, bem como de que maneira você cumpre as leis, regras e regulamentos aplicáveis de privacidade de dados. Observe que o GitHub pode coletar Informações Pessoais de Usuário de visitantes do seu site do GitHub Pages, inclusive logs de endereços IP dos visitantes, para fins de obrigações legais e de manutenção de segurança e integridade do Site e do Serviço.

#### Aplicativos do GitHub

Você também pode adicionar aplicativos do GitHub, como nosso aplicativo Desktop, nosso aplicativo Atom ou outros aplicativos e recursos de conta à sua conta. Cada um desses aplicativos tem seus próprios termos e pode coletar diferentes tipos de Informações Pessoais de Usuário. No entanto, todos os aplicativos do GitHub estão sujeitos a esta Declaração de Privacidade, e sempre coletaremos a quantidade mínima necessária de Informações Pessoais de Usuário somente para os fins que você nos autorizou.

### Como você pode acessar e controlar as informações obtidas

Se já for usuário do GitHub, você poderá acessar, atualizar, alterar ou excluir suas informações básicas de perfil de usuário ao [editar seu perfil de usuário](https://github.com/settings/profile) ou entrar em contato com o [Suporte do GitHub](https://support.github.com/contact) ou o [Suporte Premium do GitHub](https://enterprise.githubsupport.com/hc/en-us).  Você pode controlar as informações que coletamos sobre você ao limitar as informações do seu perfil, manter suas informações atualizadas ou entrar em contato com o [Suporte do GitHub](https://support.github.com/contact) ou o [Suporte Premium do GitHub](https://enterprise.githubsupport.com/hc/en-us).

Se o GitHub processar informações sobre você sem que você tenha uma conta, como informações que [o GitHub recebe de terceiros](#information-we-collect-from-third-parties), você poderá acessar, atualizar, alterar, excluir ou objetar-se ao processamento de suas informações pessoais entrando em contato com o [Suporte do GitHub](https://support.github.com/contact) ou o [Suporte Premium do GitHub](https://enterprise.githubsupport.com/hc/en-us).

#### Portabilidade de dados

Como usuário do GitHub, você sempre pode levar seus dados com você. Por exemplo, você pode [clonar seus repositórios para o seu desktop](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop) ou pode usar nossas [ferramentas de Portabilidade de Dados](https://developer.github.com/changes/2018-05-24-user-migration-api/) para baixar os dados que temos sobre você.

#### Retenção e exclusão de dados

Em geral, o GitHub retém as Informações Pessoais de Usuário enquanto a sua conta está ativa ou sempre que for necessário para prestar serviços a você.

Para cancelar sua conta ou excluir suas Informações Pessoais de Usuário, acesse o seu [perfil de usuário](https://github.com/settings/admin). Vamos reter e usar suas informações conforme o necessário para cumprir nossas obrigações legais, resolver conflitos e fazer valer nossos acordos; salvo em casos de requisitos legais, apagaremos seu perfil por completo (se razoável) dentro de 90 dias. Entre em contato com o [Suporte do GitHub](https://support.github.com/contact) ou o [Suporte Premium do GitHub](https://enterprise.githubsupport.com/hc/en-us) para solicitar a exclusão em 30 dias dos dados que processamos com base em consentimento.

Alguns dados permanecerão após a exclusão de uma conta, como contribuições em repositórios de outros Usuários e comentários em problemas de outrem. Todavia, vamos excluir ou remover a identificação das suas Informações Pessoais de Usuário (inclusive nome de usuário e endereço de e-mail) do campo de autoria de problemas, pull requests e comentários, que serão associados a um [usuário fantasma](https://github.com/ghost).

Com isso, o endereço de e-mail que você informou [nas suas configurações de commit do Git](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address) sempre será associado aos seus commits no sistema Git. Se decidir tornar seu endereço de e-mail privado, você também deverá atualizar suas configurações de commit do Git. Não podemos alterar ou excluir dados no histórico de commit do Git; o software Git foi desenvolvido para manter um registro, mas você pode controlar as informações que insere nesse registro.

### Uso de cookies e rastreamento

#### Cookies

O GitHub usa cookies para tornar as interações com nosso serviço fáceis e significativas. Cookies são pequenos arquivos de texto que os sites costumam armazenar nos discos rígidos de computadores ou dispositivos móveis de visitantes. Usamos cookies (e tecnologias afins, como HTML5 localStorage) para manter a sua conexão ativa, lembrar de suas preferências e dar informações para o desenvolvimento futuro do GitHub. Por motivos de segurança, usamos cookies para identificar um dispositivo. Ao usar o nosso Site, você concorda que podemos inserir esses tipos de cookies no seu computador ou dispositivo. Se você desativar o navegador ou a capacidade de o seu dispositivo aceitar cookies, não será possível fazer login nem usar os serviços do GitHub.

Mantemos uma página na internet sobre [cookies e rastreamento](/github/site-policy/github-subprocessors-and-cookies) que descreve nossos cookies, as necessidades que temos para criar esses cookies e quais são os tipos de cookies mantemos (temporários ou permanentes). A página também lista nossos provedores de análise de terceiros e provedores de outros serviços, detalhando exatamente em quais partes do nosso Site eles têm permissão de monitoramento.

#### Rastreamento e análise

Usamos vários provedores de análise e de serviços de terceiros para ajudar a avaliar o uso dos nossos Usuários do GitHub, compilar relatórios estatísticos sobre a atividade e melhorar nosso conteúdo e o desempenho do nosso Site. Usamos esses provedores de análise de terceiros somente em determinadas áreas do nosso Site, e todos eles celebraram acordos de proteção de dados conosco que definem o tipo de Informações Pessoais de Usuário que podem coletar e os fins do processamento de informações. Ademais, usamos nosso próprio software interno de análise para oferecer recursos e melhorar nosso conteúdo e desempenho.

Alguns navegadores integraram recursos de "Não Rastrear" (DNT) que podem enviar um sinal aos sites que você acessa indicando que você não concorda com o rastreamento. O GitHub responde aos sinais de DNT dos navegadores e segue o [padrão do W3C de resposta aos sinais de DNT](https://www.w3.org/TR/tracking-dnt/). Caso você não tenha habilitado o DNT em um navegador compatível com esse recurso, os cookies de algumas partes do nosso Site rastrearão sua atividade de navegação online em outros serviços online ao longo do tempo, embora não permitamos que terceiros além de nossos provedores de análise e serviços monitorem a atividade dos Usuários do GitHub ao longo do tempo no GitHub.

### Como o GitHub protege suas informações

O GitHub toma todas as medidas razoavelmente necessárias para proteger as Informações Pessoais de Usuário contra acesso não autorizado, alteração ou destruição, para manter a precisão dos dados e ajudar a garantir o uso adequado das Informações Pessoais de Usuário.

O GitHub impõe um programa gravado de informações de segurança. O nosso programa:
- é alinhado a estruturas reconhecidas pelo setor;
- inclui proteções de segurança razoavelmente desenvolvidas para proteger a confidencialidade, a integridade, a disponibilidade e a resiliência dos dados dos nossos Usuários;
- é adequado a natureza, tamanho e complexidade das operações de negócios do GitHub;
- inclui processos de resposta a incidentes e notificação de violação de dados;
- cumpre as leis e regulamentos aplicáveis de segurança da informação nas regiões geográficas onde o GitHub atua.

Em caso de uma violação de dados que afete as suas Informações Pessoais de Usuário, agiremos prontamente para mitigar o impacto da violação e notificar quaisquer Usuários afetados em tempo hábil.

A transmissão de dados no GitHub é criptografada usando SSH e HTTPS (TLS), e o conteúdo do repositório git é criptografado em repouso. Gerenciamos nossos compartimentos e racks em datacenters com alto nível de segurança física e de rede. Quando armazenados em provedores de armazenamento de terceiros, os dados são criptografados.

Nenhum método de transmissão ou método de armazenamento eletrônico é 100% seguro. Portanto, não podemos garantir segurança absoluta. Para obter mais informações, consulte nossa [divulgação sobre segurança](https://github.com/security).

### Práticas globais de privacidade do GitHub

GitHub, Inc. and, for those in the European Economic Area, the United Kingdom, and Switzerland, GitHub B.V. are the controllers responsible for the processing of your personal information in connection with the Service, except (a) with respect to personal information that was added to a repository by its contributors, in which case the owner of that repository is the controller and GitHub is the processor (or, if the owner acts as a processor, GitHub will be the subprocessor); or (b) when you and GitHub have entered into a separate agreement that covers data privacy (such as a Data Processing Agreement).

Nossos endereços são:

- GitHub, Inc., 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107.
- GitHub B.V., Vijzelstraat 68-72, 1017 HL Amsterdã, Holanda.

Armazenamos e processamos nos Estados Unidos as informações que coletamos de acordo com esta Declaração de Privacidade, mas nossos prestadores de serviço podem armazenar e processar dados fora dos Estados Unidos. No entanto, entendemos que temos Usuários de vários países e regiões com diferentes expectativas de privacidade e tentamos atender a essas expectativas, mesmo quando os Estados Unidos não têm a mesma estrutura de privacidade dos outros países.

Oferecemos o mesmo alto nível de proteção de privacidade (conforme descrito nesta Declaração de Privacidade) para todos os nossos usuários do mundo, independentemente de país de origem ou localidade, e temos orgulho dos níveis de aviso, escolha, responsabilidade, segurança, integridade de dados, acesso e recursos que fornecemos. Não medimos esforços para respeitar as leis aplicáveis de privacidade de dados em todas as regiões onde fazemos negócios, usando nosso Departamento de Proteção de Dados como parte de uma equipe multifuncional que supervisiona nossos esforços de conformidade com a privacidade. Ainda, nossos fornecedores ou afiliados que têm acesso às Informações Pessoais de Usuário devem assinar acordos que exigem o cumprimento das nossas políticas de privacidade e das leis aplicáveis de privacidade de dados.

Em particular:

 - O GitHub fornece métodos claros de consentimento inequívoco, específico e informado no momento da coleta de dados, quando coletamos suas Informações Pessoais de Usuário com base em consentimento.
 - Coletamos somente a quantidade mínima de Informações Pessoais de Usuário necessárias para nossos fins, a menos que você decida compartilhar mais informações. Recomendamos que você nos informe somente a quantidade de dados que estiver confortável para compartilhar.
 - Oferecemos métodos simples de acesso, correção, alteração ou exclusão das Informações Pessoais de Usuário que coletamos, desde que permitidos por lei.
 - Oferecemos meios de notificação, escolha, responsabilidade, segurança e acesso aos nossos Usuários quanto às suas respectivas Informações Pessoais de Usuário, e limitamos os fins de processamento. Também oferecemos um método de recurso e imposição aos nossos Usuários.

#### Transferência internacional de dados

O GitHub processa informações pessoais dentro e fora dos Estados Unidos e depende das Cláusulas Contratuais Padrão como um mecanismo legalmente fornecido para transferir, de modo legal, os dados do Espaço Econômico Europeu, Reino Unido e Suíça para os Estados Unidos. Além disso, a GitHub é certificado nos Quadros de Proteção à Privacidade entre UE e EUA e Suíça e EUA. Para saber mais sobre nossas transferências de dados transfronteiriças, consulte nossas [Práticas de Privacidade Globais](/github/site-policy/global-privacy-practices).

### Nossa comunicação com você

Usaremos seu endereço de e-mail para nos comunicar com você, mediante o seu consentimento, e **somente para os fins que você especificar**. Por exemplo, se você comunicar alguma solicitação à nossa equipe de Suporte, responderemos por e-mail. Você terá alto nível de controle sobre as formas de uso e compartilhamento do seu endereço de e-mail no GitHub. Você poderá gerenciar suas preferências de comunicação no seu [perfil de usuário](https://github.com/settings/emails).

Pela natureza de seu design, o sistema de controle de versões do Git associa várias ações ao endereço de e-mail do Usuário, como mensagens de commit. Não podemos mudar vários aspectos do sistema Git. Se quiser que seu endereço de e-mail continue privado, mesmo quando estiver comentando em repositórios públicos, [você pode criar um endereço de e-mail privado no seu perfil de usuário](https://github.com/settings/emails). Você também deve [atualizar sua configuração local do Git para usar seu endereço de e-mail privado](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Fazer isso não mudará a nossa forma de entrar em contato com você, mas afetará a forma como outras pessoas visualizam você. Definimos o endereço de e-mail dos Usuários como privado por padrão, mas alguns Usuários do GitHub podem ter que atualizar suas configurações. Saiba mais sobre endereços de e-mail em mensagens de commit [aqui](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address).

Dependendo das suas [configurações de e-mail](https://github.com/settings/emails), o GitHub pode ocasionalmente enviar e-mails de notificação sobre mudanças no repositório que você está acompanhando, novos recursos, solicitações de feedback, atualizações importantes da política ou atendimento ao cliente. Também enviamos e-mails de marketing com base nas suas escolhas e conforme as leis e regulamentos aplicáveis. Na parte inferior de cada e-mail de marketing que enviamos, há um link de cancelamento do recebimento desse tipo de mensagem. Observe que você não pode deixar de receber nossas comunicações importantes, como mensagens da nossa equipe de suporte ou mensagens do sistema, mas é possível definir suas configurações de notificação no seu perfil para cancelar o recebimento de outras mensagens.

Nossos e-mails podem conter uma tag de pixel, isto é, uma imagem pequena que pode nos mostrar se você abriu uma mensagem e nos informar o seu endereço IP. Usamos a tag de pixel para aumentar a eficácia de nossas comunicações por e-mail e garantir que não estamos enviando mensagens indesejadas.

### Resolução de conflitos

Em caso de dúvidas sobre a forma como o GitHub manipula suas Informações Pessoais de Usuário, entre em contato conosco imediatamente. Estamos à sua disposição para ajudar no que for necessário. Entre em contato conosco preenchendo o [formulário de contato de Privacidade](https://support.github.com/contact/privacy). ou escrevendo diretamente para privacy@github.com, especificando a linha de assunto "Privacidade". Responderemos sua solicitação o quanto antes, no máximo em 45 dias.

Você também pode entrar em contato diretamente com o nosso Departamento de Proteção de Dados.

| Sede nos Estados Unidos                     | Filial na UE       |
| ------------------------------------------- | ------------------ |
| Departamento de Proteção de dados do GitHub | GitHub BV          |
| 88 Colin P. Kelly Jr. St.                   | Vijzelstraat 68-72 |
| San Francisco, CA 94107                     | 1017 HL Amsterdam  |
| Estados Unidos                              | Holanda            |
| privacy@github.com                          | privacy@github.com |

#### Processo de resolução de conflitos

No caso improvável de conflito entre você e o GitHub sobre a manipulação das suas Informações Pessoais de Usuário, não mediremos esforços para resolver a situação. Além disso, se você for residente de um estado-membro da UE, você tem o direito de apresentar uma reclamação junto às suas autoridades locais de supervisão, e poderá ter mais [opções](/github/site-policy/global-privacy-practices#dispute-resolution-process).

### Mudanças nesta Declaração de Privacidade

Embora grande parte das alterações sejam secundárias, o GitHub pode alterar esta Declaração de Privacidade ocasionalmente. Publicaremos uma notificação para os usuários no site sobre mudanças concretas feitas nesta Declaração de Privacidade pelo menos 30 dias antes de sua entrada em vigor. A notificação será exibida em nossa página inicial ou enviada por e-mail para o endereço de e-mail principal especificado na sua conta do GitHub. Também atualizaremos nosso [repositório da Política do Site](https://github.com/github/site-policy/), que registra e monitora todas as alterações feitas a esta política. Para consultar as alterações a esta Declaração de Privacidade que não configuram mudanças concretas nem afetam seus direitos, recomendamos que os visitantes verifiquem frequentemente o nosso repositório da Política do Site.

### Licença

Esta Declaração de Privacidade é licenciada sob a [licença Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/). Para ver os detalhes, consulte nosso [repositório da Política do Site](https://github.com/github/site-policy#license).

### Contato com a GitHub
Envie suas perguntas sobre nossas práticas de coleta de informações ou a Declaração de Privacidade do GitHub pelo [formulário de contato de Privacidade](https://support.github.com/contact/privacy).

### Traduções

Consulte abaixo este documento traduzido para outros idiomas. Em caso de conflito, incerteza ou aparente incoerência entre quaisquer versões traduzidas e a versão original em inglês, o documento em inglês prevalecerá.

#### French
Clique aqui para consultar a versão em francês: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(12.20.19)(FR).pdf)

#### Outras traduções

Para traduções desta declaração para outros idiomas, acesse [https://docs.github.com/](/) e selecione um idioma no menu suspenso abaixo de "Inglês".
