---
title: Contrato de assinatura do GitHub Enterprise
redirect_from:
  - /articles/github-enterprise-agreement/
  - /articles/github-enterprise-subscription-agreement
versions:
  free-pro-team: '*'
---

Data efetiva da versão: 20 de julho de 2020

AO CLICAR NO BOTÃO "CONCORDO" OU SEMELHANTE OU USAR QUALQUER UM DOS PRODUTOS (DEFINIDOS ABAIXO), O CLIENTE ACEITA OS TERMOS E CONDIÇÕES DESTE CONTRATO. SE O CLIENTE ESTÁ FIRMANDO ESTE CONTRATO EM NOME DE UMA ENTIDADE LEGAL, O CLIENTE CONFIRMA QUE TEM AUTORIDADE LEGAL PARA VINCULAR A ENTIDADE LEGAL A ESTE CONTRATO.

Este Contrato aplica-se às seguintes ofertas do GitHub, conforme definido a seguir (ofertas coletivamente chamadas de **"Produtos"**):

-   GitHub Enterprise (composto pelo GitHub Enterprise Server, que pode incluir Software de complemento e GitHub Enterprise Cloud) e GitHub One;

-   Qualquer visualização beta;

-   Qualquer Suporte relacionado; e

-   Qualquer Serviço profissional relacionado.

Este Contrato inclui os seguintes Anexos e Seções, incorporados na íntegra a este documento como referência:

* SEÇÃO 1: Termos gerais e condições;

* SEÇÃO 2: Termos de licença do GitHub Enterprise Server;

* SEÇÃO 3: Termos de serviço do GitHub Enterprise Cloud;

* ANEXO A: Definições.

Se o Cliente tiver adquirido Produtos de um revendedor autorizado do GitHub, as Seções a seguir deste Contrato serão substituídas pelos termos acordados pelo Cliente com o revendedor do GitHub: Seção 1.1 (Vigência e rescisão); 1.2 (Pagamento); Seção 2.3 (Entrega); e Seção 2.4 (Verificação).

## SEÇÃO 1: TERMOS GERAIS E CONDIÇÕES

Esta Seção 1 estabelece os termos e as condições aplicáveis à compra e à utilização de qualquer um dos Produtos pelo Cliente. Termos em maiúsculas usados, mas não definidos no corpo deste Contrato, são definidos no Anexo A.

### 1.1 Vigência e rescisão.

#### 1.1.1 Vigência.

Este Contrato tem início na Data efetiva e continuará em vigor até ser rescindido por uma das Partes, de acordo com esta Seção 1.1.

#### 1.1.2 Rescisão por conveniência. Cancelamento de conta.

Qualquer uma das Partes pode rescindir um Formulário de pedido ou este Contrato, sem motivo, com pelo menos 30 (trinta) dias de aviso prévio por escrito antes do término do Período de assinatura atual. Se o Cliente optar por rescindir um Formulário de pedido ou o Contrato, é responsabilidade do Cliente cancelar corretamente a respectiva conta com o GitHub acessando Configurações na barra de navegação global, na parte superior da tela. O GitHub não cancela contas em resposta a solicitações por telefone ou e-mail.

#### 1.1.3 Rescisão por quebra de contrato.

Qualquer das Partes poderá rescindir este Contrato imediatamente, mediante notificação, se a outra Parte descumprir alguma clásula deste Contrato e não conseguir corrigir a violação no prazo de trinta (30) dias a partir da data em que receber a notificação. Cada uma das Partes também se reserva o direito de rescindir este Contrato imediatamente, mediante aviso prévio por escrito, sem dar à outra Parte um período de reparação, conforme disposto a seguir: pelo GitHub, se o Cliente violar os termos deste Contrato relacionados à propriedade intelectual do GitHub ( incluindo a não conformidade do Cliente com a concessão de licença ou qualquer restrição de licença), ou se a conta do Cliente tiver sido suspensa por mais de 90 (noventa) dias; ou por qualquer uma das Partes, se a outra descumprir as obrigações de confidencialidade descritas na Seção 1.4.

#### 1.1.4 Efeito da rescisão; Sobrevivência.

Após a rescisão deste contrato, o Cliente não poderá executar outros Formulários de pedido. No entanto, este Contrato permanecerá em vigor durante o restante do período de qualquer Formulário de pedido ativo. Quando um Formulário de Pedido é rescindido ou expira, em relação ao Formulário de Pedido: (i) o Período de assinatura do Software e/ou do Serviço terminará imediatamente; (ii) qualquer Licença de Assinatura no Formulário de Pedido será automaticamente rescindida, e o Cliente perderá o direito de utilizar os Produtos; (iii) se alguma Taxa for devida antes da rescisão, o Cliente deverá pagá-la imediatamente; (iv) o Cliente deve destruir todas as cópias do Software que estejam em sua posse ou sob seu controle e atestar por escrito ao GitHub que fez isso; e (v) cada Parte devolverá prontamente (ou destruirá, se a outra Parte assim solicitar) todas as Informações confidenciais pertencentes à outra Parte, na medida permitida pelo Serviço. Não obstante o exposto acima, o Cliente poderá continuar acessando o Software para migrar os dados do Cliente e poderá solicitar a migração dos dados em seus repositórios por até 90 (noventa) dias após a rescisão ou a expiração deste Contrato ou de um Formulário de pedido. No entanto, o Cliente não poderá usar o Software ou o Serviço para produção durante esse período. As disposições que, pela própria natureza, devam sobreviver razoavelmente sobreviverão à rescisão ou à expiração deste Contrato ou de um Formulário de pedido.

### 1.2 Pagamento.

#### 1.2.1 Taxas.

O Cliente concorda em pagar as Taxas na íntegra, antecipadamente e sem dedução ou compensação de qualquer tipo, em dólares americanos. Dólar. O Cliente deve pagar as Taxas dentro de 30 (trinta) dias da data da fatura do GitHub. Os montantes a pagar no presente Contrato não são reembolsáveis, exceto conforme previsto nas Seções 1.5.1 e 1.6.2. Se o Cliente não pagar alguma Taxa dentro do prazo, o GitHub se reserva o direito de, além de tomar qualquer outra providência na lei ou na justiça, (i) cobrar juros sobre os montantes devidos de 1,0% ao mês ou a maior taxa de juros permitida por lei, o que for menor, e cobrar todas as despesas de recuperação, e (II) rescindir o Formulário de pedido ou a SOW (Statement of Work, Proposta de Serviço) aplicável. O Cliente é o único responsável por todos os impostos, taxas, deveres e avaliações governamentais (exceto impostos baseados no lucro líquido do GitHub) que sejam instituídos ou passem a ser devidos em relação a este Contrato.

#### 1.2.2 Compra de licenças de assinatura adicionais.

O Cliente poderá obter Licenças de assinatura adicionais neste Contrato enviando uma solicitação pelo site do GitHub ou por meio da equipe de vendas. Se o Cliente comprar as Licenças de assinatura adicionais, terá de pagar as Taxas em vigor no momento da compra, divididas pelo saldo do Período de assinatura aplicável. Após a renovação das Licenças de assinatura do Cliente por outro Período de assinatura, o GitHub faturará todas as Licenças de assinatura de uma só vez anualmente, a menos que especificado de outra forma em um Formulário de pedido.

#### 1.2.3 Software de complemento.

Software de complemento é licenciado numa base por Usuário. Para evitar dúvidas e, salvo disposição em contrário, em um Formulário de Pedido, o número de Licenças de Assinatura que o Cliente tem em qualquer momento para o complemento de Software deve ser igual ao número de Licenças de Assinatura que o Cliente tem para os Produtos sob este Contrato. Por exemplo, se o Cliente deseja comprar uma assinatura para o Segurança Avançada e já possui Licenças de Assinatura para 100 Usuários para os Produtos, ele deve comprar Licenças de Assinatura para 100 Usuários para Segurança Avançada.

### 1.3  Serviços profissionais.

O GitHub fornecerá uma SOW detalhando os Serviços profissionais que tenham sido solicitados pelo Cliente. O GitHub executará os Serviços profissionais descritos em cada SOW. O GitHub controlará a forma e os meios pelos quais os Serviços Profissionais são executados e reserva-se o direito de determinar os funcionários designados. O GitHub pode usar terceiros para executar os Serviços profissionais, desde que o GitHub permaneça responsável pelos atos e omissões deles. O Cliente reconhece e concorda que o GitHub detém todos os direitos, títulos e interesses referentes a tudo o que for usado ou desenvolvido em relação à execução dos Serviços profissionais, inclusive software, ferramentas, especificações, ideias, conceitos, invenções, processos, técnicas e know-how. Quando o GitHub entrega algo ao Cliente durante a execução dos Serviços profissionais, o GitHub concede ao Cliente uma licença não exclusiva, não transferível, mundial, de prazo limitado e isenta de royalties para usar esses itens entregues durante o prazo deste Contrato, exclusivamente em conjunto com o uso que o Cliente faz do Software ou do Serviço.

### 1.4 Confidencialidade.

Nenhuma das Partes usará as Informações confidenciais da outra Parte, exceto conforme permitido neste Contrato. Cada Parte concorda em manter a confiança e proteger as Informações confidenciais da outra Parte usando pelo menos o mesmo nível de cuidado que ela utiliza para suas próprias informações de natureza semelhante, mas em qualquer caso, pelo menos um grau razoável de cuidado. Nenhuma das Partes usará as Informações confidenciais da outra Parte, exceto conforme permitido neste Contrato. Cada Parte é responsável por todos os atos e omissões de seus Representantes. As obrigações precedentes não restringirão qualquer uma das Partes de divulgar Informações confidenciais da outra Parte se ordenado ou requisitado por um tribunal, uma agência administrativa ou outro órgão governamental, desde que a Parte obrigada a fazer tal divulgação avise à outra Parte com antecedência razoável para permitir que essa Parte conteste tal ordem ou requisito, a menos que esse aviso seja proibido por lei. As restrições estabelecidas nesta Seção 1.4 sobreviverão à rescisão ou à expiração deste Contrato.

### 1.5 Defesa de reivindicações.

As Partes se defenderão mutuamente contra reivindicações de terceiros, como estipulado nesta Seção 1.5, e pagarão a quantia relativa a qualquer julgamento final adverso ou acordo aprovado, mas somente se a Parte defensora for prontamente notificada por escrito da reivindicação e tiver o direito de controlar a defesa e qualquer acordo dela. A Parte que está sendo defendida deve fornecer à Parte defensora todas as informações, assistência e autoridade solicitadas. A Parte defensora reembolsará à outra Parte por despesas adicionais razoáveis que ela tenha ao fornecer assistência e não concordará nem admitirá que nenhuma reivindicação de terceiros sem o consentimento prévio por escrito da outra Parte seja retida ou postergada sem motivo. Esta Seção 1.5 descreve os únicos recursos das Partes e a total responsabilidade delas por tais reivindicações.

#### 1.5.1 GitHub.

O GitHub defenderá o Cliente contra qualquer reivindicação de um terceiro não afiliado em que ele alegue que o uso autorizado do Software ou do Serviço pelo Cliente viola um direito autoral, uma patente ou uma marca registrada ou se apropria de um segredo comercial do terceiro não afiliado. Se o GitHub não conseguir resolver essa reivindicação em termos comercialmente razoáveis, ele poderá, a seu critério: (i) modificar, reparar ou substituir o Software ou o Serviço (conforme aplicável); ou (ii) rescindir a assinatura do Cliente e reembolsar as taxas de assinatura pré-pagas e não utilizadas. O GitHub não terá nenhuma obrigação nesta Seção 1.5.1 por qualquer reivindicação resultante de: (a) modificação do Software ou do Serviço ou combinação, operação ou uso do Software ou do Serviço com equipamentos, dispositivos, software, sistemas ou dados diferentes dos expressamente autorizados por este Contrato (inclusive a Documentação); (b) incapacidade do Cliente de interromper o uso do Software ou do Serviço após o recebimento do aviso; (c) obrigações do Cliente nos termos da Seção 1.5.2; (d) produtos ou serviços (incluindo o uso do Software ou do Serviço) fornecidos gratuitamente pelo GitHub; ou (e) acesso ou uso de Visualizações Beta. Para a finalidade da obrigação do GitHub nesta Seção 1.5.1, o Software e o Serviço incluem componentes de código aberto incorporados pelo GitHub.

#### 1.5.2 Cliente.

O Cliente defenderá o GitHub contra qualquer reivindicação de um terceiro não afiliado resultante de: (i) Conteúdo do cliente que o Cliente envie ao Software ou ao Serviço; (ii) descumprimento deste Contrato pelo Cliente, incluindo quebra de confidencialidade do Cliente ou violação de termos de uso aceitáveis do GitHub; (iii) Modificações feitas pelo Cliente no Software; ou (iv) quaisquer equipamentos, dispositivos, programas de software, sistemas ou dados com marca de terceiros que o Cliente combine, opere ou utilize com o Software ou o Serviço.

### 1.6  Representações e garantias; Isenção de responsabilidade; Limitações de responsabilidade.

#### 1.6.1 Garantia geral.

Cada Parte declara e garante à outra que tem autoridade de poder legal para firmar este Contrato e que este Contrato e cada Formulário de pedido e SOW serão firmados por um funcionário ou agente dessa Parte com toda a autoridade necessária para vincular tal Parte aos termos e condições deste Contrato.

#### 1.6.2 Garantias limitadas.

**(i) Software**. O GitHub garante que: (1) o Software não modificado, no momento em que for disponibilizado ao Cliente para download, não conterá nem transmitirá malware, vírus ou worm (também conhecidos como código de computador ou outra tecnologia especificamente projetada para interromper, desabilitar ou prejudicar software, hardware, rede ou sistema de computador do Cliente); e (2) o Software não modificado estará em conformidade com a respectiva Documentação durante noventa (90) dias a partir da data em que for disponibilizado para download inicial. O GitHub não garante que o uso do Software pelo cliente será ininterrupto ou que a operação do Software será isenta de erros. A garantia nesta Seção 1.6.2(i) não se aplicará se o Cliente modificar ou usar o Software de qualquer forma que não seja expressamente permitida pela Seção 2 e pela Documentação. A única obrigação do GitHub, e o único recurso do Cliente, para qualquer violação desta garantia será, ao critério e às custas do GitHub, (a) reparar o Software; (b) substituir o Software; ou (c) rescindir este Contrato no que diz respeito ao Software defeituoso e reembolsar as Taxas pré-pagas não utilizadas para o Software defeituoso durante o Período de assinatura atual.

**(ii) Serviços profissionais.** O GitHub garante ao Cliente que quaisquer Serviços profissionais executados sob este Contrato serão realizados de forma profissional e com perfeição, por pessoal devidamente qualificado. A única obrigação do GitHub, e o único recurso do Cliente, para uma violação desta garantia será, ao critério e às custas do GitHub, (1) reexecutar prontamente quaisquer Serviços Profissionais que não estejam de acordo com esta garantia; ou (2) se a violação não puder ser corrigida, rescindir o SOW e reembolsar as Taxas pré-pagas não utilizadas.

#### 1.6.3  Isenção de responsabilidade.

**(i) De forma geral.** Exceto conforme expressamente previsto neste Contrato, o GitHub não faz outras garantias e representações de qualquer tipo e, por este documento, se isenta especificamente de quaisquer outras garantias (expressas, implícitas ou estatutárias), incluindo, sem limitação, garantias de comercialização, adequação a uma finalidade específica, não violação ou quaisquer garantias ou condições decorrentes de curso de negócios ou uso comercial. Nenhuma recomendação ou informação, seja oral ou escrita, fornecida pelo GitHub ou em qualquer outro lugar criará qualquer garantia ou condição que não esteja expressamente indicada neste Contrato.

**(ii) Serviço**. O GitHub fornece o Serviço **"COMO ESTÁ"** e **" CONFORME A DISPONIBILIDADE"**, sem qualquer tipo de garantia. Sem limitar isso, o GitHub se isenta expressamente de todas as garantias (expressas, implícitas ou estatutárias), relativas ao Serviço, incluindo, sem limitação, qualquer garantia de comercialização, adequação a uma finalidade específica, título, segurança, precisão e não violação. O GitHub não garante que o Serviço atenderá aos requisitos do Cliente; que o Serviço será ininterrupto, pontual, seguro ou isento de erros; que qualquer defeito ou erro será corrigido; que o Serviço estará disponível em um momento ou local específico; que as informações fornecidas por meio do Serviço sejam exatas, confiáveis ou corretas; ou que o serviço esteja isento de vírus ou outros componentes nocivos. O GitHub não será responsável por qualquer risco de perda resultante do download do Cliente e/ou do uso de arquivos, informações, conteúdo ou outro material obtido com o Serviço.

**(iii) Visualizações Beta.** O Cliente pode optar por usar visualizações Beta a seu critério exclusivo. As Visualizações Beta podem não ser compatíveis, podem ser alteradas a qualquer momento sem aviso prévio e podem não ser tão confiáveis ou disponíveis como o Serviço. As Visualizações Beta não estão sujeitas às mesmas medidas de segurança e auditoria a que o Serviço esteve e está sujeito. O GitHub não terá nenhuma responsabilidade decorrentes das Visualizações Beta ou relacionadas a elas. **O Cliente usa Visualizações Beta por sua própria conta e risco.**

#### 1.6.4 Limitações de responsabilidade.

**(i)   Danos indiretos. Até o máximo alcance permitido pela lei aplicável, em nenhuma hipótese qualquer uma das partes será responsável perante a outra parte ou terceiros por quaisquer danos indiretos, especiais, incidentais, punitivos ou consequenciais (incluindo perda de lucros, receitas ou dados) ou pelo custo de obtenção de produtos substitutos resultantes deste Contrato ou relacionados a ele, independemente da causa, mesmo que tal responsabilidade seja decorrente de qualquer reivindicação baseada em contrato, garantia, delito (inclusve negligência), responsabilidade objetiva ou de outra forma e mesmo que uma parte tenha sido avisada sobre a possibilidade de tais danos.**

**(ii) Limitação de responsabilidade total. Até o máximo alcance permitido pela lei aplicável, em nenhuma hipótese a responsabilide cumulativa total de qualquer das partes neste Contrato por todas as causas de ação e todas as teorias de responsabilidade excederá as Taxas que o Cliente pagou ao GitHub durante os 12 (doze) meses anteriores à reivindicação que deu origem a tal responsabilidade. No caso de produtos e serviços (incluindo o uso dos Produtos) que são fornecidos gratuitamente, a responsabilidade do GitHub é limitada a danos diretos até US$ 5.000. Para Visualizações Beta, a responsabilidade do GitHub é limitada a danos diretos de até US$ 500.**

**(iii) Exceções. As exclusões e limitações estabelecidas nesta Seção 1.6.4 não se aplicarão à responsabilidade decorrente de (1) violação por uma das Partes de suas obrigações de confidencialidade na Seção 1.4, exceto toda a responsabilidade relacionada a Conteúdo (excluindo Conteúdo do GitHub), que permanecerá sujeita às limitações e exclusões acima; (2) obrigações de defesa de uma das Partes na Seção 1.5; ou (3) não conformidade do Cliente com concessão ou restrições de licença nas Seções 2.1 e 2.2.**

### 1.7 Licenças de assinatura.

As Licenças de assinatura são concedidas por Usuário, e vários Usuários não podem usar a mesma Licença de assinatura. O Cliente só pode reatribuir uma Licença de assinatura a um novo Usuário após 90 (noventa) dias da última reatribuição dessa licença, a menos que a reatribuição se deva a (i) perda ou falha de hardware permanente; (ii) rescisão do contrato ou demissão do Usuário; ou (iii) realocação temporária de Licenças de assinatura para cobrir a ausência de um Usuário. Quando o Cliente reatribui uma Licença de assinatura de um Usuário para outro, deve bloquear o acesso do Usuário anterior à Licença de assinatura e às Organizações do Cliente.

### 1.8 Afiliados.

Os Afiliados do Cliente estão autorizados a utilizar o Software e o Serviço de acordo com este Contrato, desde que o Cliente permaneça plenamente responsável pelo acesso e pela utilização do Software e do Serviço.

### 1.9 Suporte.

O GitHub fornecerá Suporte para o Software e o Serviço da seguinte maneira:

#### 1.9.1 Suporte padrão.

O GitHub fornecerá Suporte técnico padrão para o Software e o Serviço, sem custo adicional, 24 (vinte e quatro) horas por dia, 5 (cinco) dias por semana, exceto fins de semana e feriados nacionais nos EUA. feriados. O Suporte padrão só é oferecido por meio de tíquetes na Web pelo Suporte do GitHub, e as solicitações de Suporte devem ser iniciadas a partir de um Usuário com o qual a equipe de Suporte do GitHub possa interagir.

#### 1.9.2 Ofertas de suporte aprimorado.

O GitHub pode fornecer ofertas de Suporte aprimorado para o Software e o Serviço (incluindo as ofertas Premium, Premium Plus e Suporte Direto de Engenharia) de acordo com os [termos de Suporte](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise)e no nível de Suporte, Taxas e Termo de Assinatura especificados em um Formulário de Pedido ou SOW.

#### 1.9.3 Exclusões.

O GitHub envidará os esforços razoáveis para corrigir quaisquer erros materiais e reprodutíveis no Software do qual o Cliente notifica o GitHub. No entanto, o GitHub não será responsável por fornecer Suporte onde (i) alguém (que não seja o GitHub) modifica o Software; (ii) o Cliente altera o sistema operacional ou o ambiente de forma que afete negativamente o Software ou o desempenho dele; (iii) o Cliente utiliza o Software de uma forma diferente da autorizada neste Contrato ou na Documentação; ou (iv) há negligência ou uso indevido pelo Cliente do Software.

### 1.10 Direitos de propriedade intelectual.

Como acordado entre as Partes, o GitHub possui todos os direitos, títulos e interesses, inclusive todos os direitos de propriedade intelectual, relacionados aos Produtos. O GitHub se reserva todos os direitos em relação aos Produtos que não sejam expressamente concedidos ao Cliente neste Contrato. O GitHub pode usar, modificar e incorporar em seus Produtos qualquer Feedback, comentário ou sugestão que o cliente forneça ou poste em fóruns, sem qualquer obrigação para com o Cliente.

### 1.11 Feedback.

O Cliente pode fornecer feedback ao GitHub sobre os Produtos. O feedback é voluntário e não é uma Informação Confidencial do Cliente, mesmo se designado como tal. O GitHub pode se exercitar e explorar completamente tal Feedback com o objetivo de (i) melhorar a operação, funcionalidade e uso das ofertas de produtos atuais e futuras do GitHub e a comercialização de tais ofertas; e (ii) publicar estatísticas agregadas sobre a qualidade dos Produtos, desde que nenhum dado em tal publicação seja usado para identificar especificamente o Cliente, seus funcionários ou o código de software proprietário do Cliente.

### 1.12. Cumprimento de leis e regulamentos.

O cliente estará em conformidade com todas as leis e regulamentos aplicáveis, incluindo, mas não se limitando a, legislação e regulamentos em matéria de proteção de dados e trabalhistas, na sua utilização dos Produtos.

### 1.13 Disposições gerais.

#### 1.13.1 Lei vigente; Foro.

Se o escritório principal do cliente estiver localizado nas Américas, este Contrato será regido e interpretado pelas leis do Estado da Califórnia, sem acionar os princípios de conflito da lei, qualquer processo ou ação judicial decorrente do presente Contrato será levado exclusivamente aos tribunais localizados na comarca do Norte da Califórnia e as Partes concordam com a jurisdição e o foro nesse local. Se o escritório principal do cliente estiver localizado fora das Américas, este Contrato será regido pelas leis da Irlanda, qualquer ação judicial ou processo decorrente do presente Contrato será levado exclusivamente aos tribunais localizados em Dublin e as Partes concordam com a jurisdição e o foro nesse local. As Partes concordam expressamente que a Convenção das Nações Unidas para a Venda Internacional de Mercadorias e a Lei Uniforme Para Transação de Informações no Computador não se aplicarão a este Contrato. Não obstante qualquer disposição em contrário no acima exposto, o GitHub pode apresentar um pedido de recurso em equidade em qualquer tribunal com jurisdição adequada.

#### 1.13.2 Usuários do Governo dos EUA. Usuários do Governo.

Os Produtos foram desenvolvidos exclusivamente com fundos privados e são considerados "Software comercial para computador" e "Documentação de software comercial para computador", como descrito nos Federal Acquisitions Regulations (FAR – Regulamentos de Aquisições Federais) 12.212 e 27.405-3 e no Defense Federal Acquisition Regulation Supplement (DFARS – Suplemento do Regulamento de Aquisição Federal para a Defesa) 227.7202-3. Os Produtos são licenciados para os EUA Os Produtos são licenciados para o usuário final do Governo dos EUA como software de computador de uso restrito e dados de direitos limitados. Nenhum dado técnico ou software de computador é desenvolvido neste Contrato. Qualquer uso, divulgação, modificação, distribuição ou reprodução dos Produtos ou da Documentação pelo Governo dos EUA ou por seus contratados está sujeito às restrições estabelecidas neste Contrato. O governo ou os seus contratantes estão sujeitos às restrições estabelecidas neste Contrato. Todos os outros usos são proibidos.

#### 1.13.3 Exportação.

Os Produtos estão sujeitos a restrições de exportação por parte dos EUA. Os Produtos estão sujeitos a restrições de exportação pelo Governo dos EUA e a restrições de importação por determinados governos estrangeiros, e o Cliente cumprirá todas as leis e regulamentações de exportação e importação aplicáveis ao fazer uso dos Produtos. O cliente não deve remover ou exportar dos Estados Unidos (nem permitir que algum terceiro o faça) ou permitir a exportação ou reexportação de qualquer parte dos Produtos ou de qualquer produto direto deles: (i) para qualquer país sob embargo ou que apoie terroristas (ou para cidadãos ou residentes nessa categoria de país); (ii) para qualquer pessoa na lista de cidadãos designados especialmente (SDN – Specially Designated Nationals) do Departamento do Tesouro dos Estados Unidos ou da tabela de negação de ordens (Table of Deny Orders) do Departamento de Comércio dos Estados Unidos; (iii) para qualquer país em que essa exportação ou reexportação seja restrita ou proibida ou no qual o Governo dos EUA ou qualquer órgão do mesmo exija uma licença de exportação ou outra aprovação governamental no momento da exportação ou reexportação sem que ela seja obtida primeiro; ou (iv) que, de qualquer outra forma, violem quaisquer regulamentos, leis ou restrições de exportação ou importação de qualquer autoridade ou órgão internacional ou norte-americano. Commerce Department's Table of Denial Orders or U.S. Treasury Department's list of Specially Designated Nationals; (iii) to any country to which such export or re-export is restricted or prohibited, or as to which the U.S. government or any agency thereof requires an export license or other governmental approval at the time of export or re-export without first obtaining such license or approval; or (iv) otherwise in violation of any export or import restrictions, laws or regulations of any United States or foreign agency or authority. O Cliente declara e garante que (a) não está não está localizado em, não está sob o controle de ou não é cidadão nem residente de nenhum desses países proibidos nem consta de nenhuma dessas listas proibidas e que (b) nenhum dos dados do Cliente são controlados pelas normas para o tráfico internacional de armas (ITAR – International Traffic in Arms Regulations) dos EUA. International Traffic in Arms Regulations. O cliente reconhece e concorda que os Produtos não podem ser usados para o projeto ou o desenvolvimento de armas nucleares, químicas ou biológicas ou tecnologia de mísseis sem a permissão prévia do Governo dos EUA. Government.

#### 1.13.4 Nenhuma publicidade sem permissão.

O GitHub poderá identificar o Cliente como cliente para clientes atuais e potenciais. No entanto, o GitHub não poderá usar o nome ou o logotipo do Cliente em qualquer material publicitário ou de marketing sem a permissão do Cliente.

#### 1.13.5 Cessão.

Nenhuma das Partes poderá ceder ou transferir este Contrato, integral ou parcialmente, sem o consentimento prévio por escrito da outra Parte. Esse consentimento não será mantido sem motivo e qualquer tentativa de fazê-lo será considerada nula e sem efeito. A exceção é que o GitHub poderá ceder este Contrato na íntegra, mediante notificação à outra Parte, mas sem o consentimento dela, em uma fusão, aquisição, reorganização societária ou venda de todos ou quase todos os negócios ou ativos da Parte cedente.

#### 1.13.6 Avisos.

Salvo indicação em contrário neste documento, qualquer aviso, solicitação, demanda ou outra comunicação neste Contrato deve ser por escrito (e-mail é aceitável), deve fazer referência a este Contrato e será considerado como devidamente dado: (i) após o recebimento, se for entregue pessoalmente; (ii) 01 (um) dia útil após a confirmação de recebimento pelo destinatário pretendido, se for enviado por e-mail; (iii) 05 (cinco) dias úteis depois de ser enviado por correspondência registrada ou certificada, com confirmação por escrito de recebimento e e-mail; ou (iv) 03 (três) dias úteis após a entrega a um serviço de correio expresso reconhecido internacionalmente e e-mail, com confirmação de recebimento por escrito. Os avisos podem ser enviados para os endereços definidos neste Contrato, a menos que uma das Partes notifique alguma alteração neles à outra.

#### 1.13.7 Força maior.

O GitHub será dispensado da responsabilidade quando não for possível cumprir qualquer obrigação deste Contrato devido a causas extraordinárias além do controle razoável, como fenômenos da natureza, desastres naturais, greves, bloqueios, tumultos, atos de guerra, epidemias ou falhas de energia, telecomunicações ou rede.

#### 1.13.8 Contratados independentes.

Cada Parte é um contratado independente no que diz respeito ao objeto deste Contrato. Nada do presente Contrato será considerado ou interpretado de forma a criar uma associação jurídica, parceria, joint venture, emprego, agência, relação fiduciária ou qualquer outra semelhante entre as Partes, e nenhuma Parte poderá vincular a outra contratualmente.

#### 1.13.9 Renúncia.

Uma das Partes neste Contrato só poderá renunciar a suas obrigações se o pedido for feito por escrito e assinado por um representante autorizado da outra Parte. Nenhuma falha ou atraso de uma das Partes deste Contrato no exercício de qualquer direito aqui descrito funcionará como renúncia do mesmo, nem qualquer exercício único ou parcial impedirá qualquer outro exercício do mesmo ou o exercício de qualquer direito disposto na lei ou na justiça.

#### 1.13.10 Integralidade do acordado.

Juntamente com os Anexos e cada Formulário de pedido e SOW, este Contrato constitui a integralidade do acordado entre as Partes e o entendimento delas no que diz respeito ao objeto do Contrato. Ele substitui todos os entendimentos e acordos anteriores ou contemporâneos, sejam orais ou escritos, entre as Partes no que diz respeito a esse assunto. Serão considerados nulos e sem efeito os termos de qualquer ordem de compra do Cliente, termos ou condições escritos ou outro documento que o Cliente envie ao GitHub contendo termos diferentes dos termos deste Contrato ou de qualquer Formulário de pedido ou SOW (ou adicionais a eles).

#### 1.13.11 Modificações; Ordem de precedência.

O GitHub se reserva o direito de, a seu exclusivo critério, modificar este Contrato a qualquer momento e o atualizará nesse caso. O GitHub publicará um aviso no Serviço para notificar o cliente sobre mudanças concretas feitas neste Contrato, como alterações de preço, pelo menos 30 dias antes de sua entrada em vigor. Em relação a modificações não materiais, o uso continuado do Serviço pelo cliente constitui a concordância de nossas revisões deste Contrato. O Cliente pode ver todas as alterações feitas neste Contrato em nosso repositório [Política do site](https://github.com/github/site-policy). No caso de conflito entre os termos deste Contrato e qualquer Formulário de pedido ou SOW, os termos do Formulário de pedido ou da SOW devem vigorar apenas em relação a esse Formulário de pedido ou essa SOW.

#### 1.13.12 Independência das disposições contratuais.

Se qualquer disposição deste Contrato for considerada ilegal, inválida ou inexequível por um tribunal competente, as Partes modificarão ou corrigirão o presente Contrato para dar o máximo de efeito possível a essa disposição. Qualquer disposição que não possa ser modificada ou corrigida desta forma será considerada excluída e as disposições remanescentes deste Contrato continuarão em pleno vigor e efeito.


## SEÇÃO 2: TERMOS DE LICENÇA DO GITHUB ENTERPRISE SERVER

Esta Seção 2 detalha os termos aplicáveis ao uso do Software pelo Cliente.

### 2.1 Concessão de licença.

O GitHub concede ao Cliente uma licença não exclusiva, não transferível, mundial, de prazo limitado e isenta de royalties para instalar e usar o Software para finalidades comerciais internas do Cliente durante o Período de assinatura aplicável, de acordo com a Documentação e apenas para o número de Licenças de assinatura indicadas no Formulário de pedido do Cliente. O Software inclui componentes licenciados para o GitHub por terceiros, como programas de software cujas licenças exigem que o GitHub disponibilize o código-fonte desses componentes, que será fornecido mediante solicitação. Sem limitar o precedente, esta licença permite que o Cliente baixe e execute a imagem do contêiner Microsoft SQL Server Standard Edition para arquivos Linux ("**Imagens do servidor SQL**"), que só pode ser usado com o Software como documentado. O direito do cliente de usar as imagens do servidor SQL termina quando o Cliente não tem mais o direito de usar o Software, e o Cliente deve desinstalar as Imagens do Servidor SQL quando seu direito de usá-las terminar. A Microsoft Corporation pode desativar o SQL Server Images a qualquer momento.

### 2.2 Restrições de licença.

Exceto quando expressamente permitido por lei ou por licença de terceiros aplicável, o Cliente e suas Afiliadas não deve (nem permitir que algum terceiro o faça): (i) sublicenciar, vender, alugar, arrendar, transferir, ceder ou redistribuir o Software; (ii) hospedar o Software em benefício de terceiros; (iii) divulgar ou permitir que terceiros acessem o Software, exceto conforme expressamente permitido nesta Seção 2; (iv) hackear ou modificar a Chave de licença, ou evitar ou alterar qualquer processo de registro de licença; (v) exceto no caso de Modificações do cliente, modificar ou criar trabalhos derivados do Software ou mesclar o Software com outro software; (vi) desmontar, descompilar, ignorar qualquer ofuscação de código ou, de outra forma, fazer engenharia reversa do Software ou tentar derivar seu código-fonte, parcial ou totalmente; (vii) modificar, obscurecer ou excluir avisos de direitos de propriedade incluídos no Software ou na Documentação; ou (viii) usar ou copiar o Software ou a Documentação de alguma forma não expressamente permitida por este Contrato.

### 2.3 Entrega.

O GitHub disponibilizará a Chave de licença ser baixada pelo Cliente em um site seguro e protegido por senha. Todas as entregas nesta Seção 2 serão eletrônicas. Para evitar dúvidas, o Cliente é responsável pela instalação de qualquer Software e reconhece que o GitHub não tem mais nenhuma obrigação de entrega em relação ao Software após o recebimento da Chave de licença pelo Cliente. À medida que as Atualizações forem sendo emitidas, o GitHub as disponibilizará para download no mesmo site. O Cliente deve atualizar o Software em uma base comercialmente razoável, mas não menos de 01 (uma) vez por ano. O Cliente é responsável por manter a confidencialidade dos nomes de usuário e das senhas do Cliente.

### 2.4 Verificação.

A pedido do GitHub, o Cliente fornecerá prontamente ao GitHub um relatório gerado pelo Software verificando se o cliente está usando o Software de acordo com este Contrato. O GitHub cobrará do Cliente por qualquer uso adicional, a partir da data em que o uso excedeu os termos do Contrato.

### 2.5 Atualizações; Versões.

#### 2.5.1 De forma geral.

O GitHub disponibilizará atualizações e versões do Software ao Cliente no mesmo site seguro em que o Cliente baixou o Software e a Chave de licença.

#### 2.5.2 Versões compatíveis.

O GitHub só dará Suporte a uma determinada Versão do Software por 01 (um) ano a partir da data da Versão original ou 06 (seis) meses a partir da última Atualização da Versão, o que for mais longo. Se o Cliente necessitar de Suporte para Versões anteriores do Software, deverá pagar por esse Suporte de acordo com os termos de um Formulário de pedido ou uma SOW acordados mutuamente.

### 2.6 Considerações de Proteção de Dados para uso do GitHub Insights e Learning Lab for Enterprise Server.

Se o uso planejado do GitHub Insights ou do Learning Lab for Enterprise Server envolve o processamento de dados pessoais, o Cliente é o único responsável por determinar se deve ou não concluir uma avaliação de impacto de proteção de dados ou proteger a análise legal formal do uso planejado pelo Cliente. Fica a critério exclusivo do Cliente usar o GitHub Insights ou o Learning Lab for Enterprise Server para processar os dados dos funcionários e/ou usuários do Cliente e, se o Cliente fizer isso, o Cliente é o único responsável por realizar esse processamento em conformidade com a lei aplicável.


### SEÇÃO 3: TERMOS DE SERVIÇO DO GITHUB ENTERPRISE CLOUD

Após a criação de uma Conta corporativa e/ou uma Organização no Serviço pelo Cliente ou pelo GitHub em nome do Cliente, esta Seção 3 detalha os termos aplicáveis ao uso do Serviço pelo Cliente.

### 3.1 Termos da conta.

#### 3.1.1 Controles da conta.

**(i) Usuários**. O Cliente reconhece que os Usuários mantêm o controle administrativo final sobre suas contas individuais e o Conteúdo dentro delas. [Termos de Serviço Padrão do GitHub](/github/site-policy/github-terms-of-service) rege o uso do Serviço pelos Usuários, exceto no que diz respeito às atividades dos Usuários, sob esta Seção 3.

**(ii) Organizações**. O Cliente mantém o controle administrativo definitivo sobre qualquer Organização criada em nome do Cliente e qualquer Conteúdo gerado pelo Usuário que seja postado nos repositórios dentro das Organizações, sujeitos a esta Seção 3. Esta Seção 3 regerá o uso das Organizações do Cliente.

#### 3.1.2 Requisitos da conta.

Para criar uma conta, o Cliente deve atender às seguintes condições:

**(i)** O Cliente não deve criar uma conta para ser usada por qualquer pessoa com menos de 13 anos de idade. Se isso chegar ao conhecimento do GitHub, ele encerrará a conta do Usuário imediatamente. Se o Cliente ou seus Usuários estiverem localizados em um país fora dos Estados Unidos, a idade mínima desse país poderá ser maior. Nesse caso, o Cliente é responsável por cumprir as leis desse país.

**(ii)** O login de um Usuário não pode ser compartilhado por várias pessoas.

**(iii)** O Cliente não deverá usar o Serviço (a) se isso violar o controle de exportação ou as leis de sanções dos Estados Unidos ou de qualquer outra jurisdição aplicável; (b) se ele estiver localizado ou residir normalmente em um país ou território sujeito a sanções abrangentes administradas pelo Escritório de Controle de Ativos Estrangeiros (OFAC – Office of Foreign Assets Control) do Departamento do Tesouro Americano ou (c) se o Cliente é ou representa um [cidadão designado especialmente](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) (SDN – Specially Designated National) ou uma pessoa sujeita a bloqueio semelhante ou a proibições partidárias negadas. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. Para obter mais informações, consulte a [Política de controles de exportação do GitHub](/articles/github-and-export-controls).

#### 3.1.3 Segurança da conta.

O cliente é responsável por: (i) todo o Conteúdo postado e pela atividade que ocorre na Conta corporativa dele; (ii) manter a segurança de suas credenciais de login de conta; e (iii) [notificar o GitHub](https://support.github.com/contact) prontamente ao tomar conhecimento de qualquer uso não autorizado ou acesso ao Serviço por meio de sua conta.  O GitHub não será responsabilizado por qualquer perda ou dano causado se o Cliente não cumprir o disposto nesta Seção 3.1.3.

#### 3.1.4 Termos adicionais.

Em algumas situações, os termos de terceiros podem ser aplicados ao uso do serviço pelo Cliente.  Por exemplo, o Cliente pode ser integrante de uma Organização com seus próprios termos ou contratos de licença. O cliente poderá baixar um aplicativo que se integra ao Serviço ou utilizar o Serviço para autenticar em outro serviço. Embora este Contrato seja o acordo completo do GitHub com o Cliente, os termos de outras partes regem as relações dele com o Cliente.

#### 3.1.5 Termos do Governo Federal do EUA. Federal Government Terms.

Se o cliente é dos EUA. If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/articles/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions. Aplica-se a alteração do Governo Federal</a> e o Cliente concorda com suas disposições.

### 3.2 Cumprimento das leis; Uso aceitável; Privacidade.

#### 3.2.1 Cumprimento de leis e regulamentos.
O uso do Serviço pelo Cliente não deve violar os regulamentos ou as leis aplicáveis na sua jurisdição, como leis de direitos autorais ou de marcas registradas e leis de controle de exportação.

#### 3.2.2 Uso aceitável.
O uso do Serviço pelo Cliente deve estar em conformidade com a [Política de Uso Aceitável do GitHub](/articles/github-acceptable-use-policies) e as [Diretrizes da Comunidade do GitHub](/articles/github-community-guidelines). O Cliente não deve usar o Serviço em qualquer jurisdição para atividade ou Conteúdo ilegal, obsceno, ofensivo ou fraudulento, como defender ou causar danos, interferir ou violar a integridade ou a segurança de uma rede ou um sistema, enganar os filtros, enviar vírus ou código nocivo e mensagens não solicitadas, abusivas ou enganosas ou violar direitos de terceiros.

#### 3.2.3 Privacidade.
A [Declaração de Privacidade do GitHub](/articles/github-privacy-statement) e o [Adendo de Proteção de Dados do GitHub](/github/site-policy/github-data-protection-addendum) fornecem aviso detalhado das práticas de privacidade e uso de dados do GitHub, bem como do processamento e das obrigações de segurança do GitHub no que diz respeito aos Dados Pessoais do Cliente. Qualquer pessoa, entidade ou serviço que colete dados do Serviço deve estar em conformidade com a [Declaração de privacidade do GitHub](/articles/github-privacy-statement), especialmente no que diz respeito à coleta de Informações pessoais dos Usuários (conforme definido na Declaração de privacidade do GitHub). Se o Cliente coletar qualquer Informação pessoal do usuário no GitHub, só a utilizará para a finalidade para a qual o Usuário externo o autorizou. O Cliente protegerá essas Informações pessoais, e o Cliente responderá prontamente a reclamações, solicitações de remoção e pedidos para "não contatar" do GitHub ou de Usuários externos.

### 3.3 Responsabilidade pelo conteúdo; Propriedade; Direitos de licença.

#### 3.3.1 Responsabilidade pelo conteúdo gerado pelo usuário
O Cliente pode criar ou fazer upload do Conteúdo gerado pelo usuário ao usar o Serviço. O Cliente é o único responsável por qualquer Conteúdo gerado pelo usuário que ele poste, faça upload, vincule ou disponibilize por meio do Serviço, independentemente da forma desse Conteúdo gerado pelo usuário. O GitHub não é responsável por qualquer exibição ao público ou uso indevido de Conteúdo gerado pelo usuário.

#### 3.3.2 Propriedade do conteúdo, Direito de postar; Concessões de licença.

**(i)** O Cliente mantém a propriedade do Conteúdo que o Cliente cria ou possui. O Cliente reconhece que: (a) é responsável pelo Conteúdo do cliente, (b) só enviará o Conteúdo que o Cliente tem direito de postar (como Conteúdo de terceiros ou gerados pelo Usuário), e (c) o Cliente cumprirá integralmente todas as licenças de terceiros relacionadas ao Conteúdo que o Cliente posta.

**(ii)** O Cliente concede os direitos estabelecidos nas Seções 3.3.3 a 3.3.6 gratuitamente e para as finalidades identificadas nessas seções até ao momento em que o Cliente remove o Conteúdo do cliente dos servidores do GitHub, exceto para Conteúdo que o Cliente tenha postado publicamente e que os Usuários externos tenham bifurcado. Nesse caso, a licença será perpétua até que todas as Bifurcações do Conteúdo do cliente tenham sido removidas dos servidores do GitHub. Se o Cliente fizer upload do Conteúdo do cliente que já vem com uma licença que concede ao GitHub as permissões necessárias para executar o Serviço, nenhuma licença adicional será necessária.

#### 3.3.3 Concessão de licença ao GitHub.
O Cliente concede ao GitHub o direito de armazenar, analisar e exibir o Conteúdo do cliente e fazer cópias acessórias somente conforme necessário para fornecer o Serviço. Isso inclui o direito de copiar o Conteúdo do cliente para o banco de dados do GitHub e fazer backups; exibir o Conteúdo do cliente para ele e para quem o Cliente resolver mostrá-lo; analisar o Conteúdo do cliente em um índice de pesquisa ou analisá-lo nos servidores do GitHub; compartilhar o Conteúdo do cliente com Usuários externos com os quais o Cliente opte por compartilhá-lo; e executar o Conteúdo do cliente caso seja algo como música ou vídeo. Esses direitos se aplicam a Repositórios públicos e privados. Esta licença não concede ao GitHub o direito de vender o Conteúdo do cliente, distribuí-lo ou utilizá-lo fora do Serviço. O Cliente concede ao GitHub os direitos de que precisa para usar o Conteúdo do cliente sem atribuição e fazer adaptações razoáveis dele, conforme necessário, para fornecer o Serviço.

#### 3.3.4 Concessão de licença a usuários externos.
**(i)** Qualquer Conteúdo que o Cliente posta publicamente, como problemas, comentários e contribuições a repositórios de Usuários externos, pode ser visualizado por outras pessoas. Ao definir quais repositórios serão visualizados publicamente, o Cliente concorda em permitir que Usuários externos visualizem e bifurquem os repositórios do Cliente.

**(ii)** Se o cliente define páginas e repositórios para serem visualizados publicamente, ele concede a Usuários externos uma licença mundial e não exclusiva para usar, exibir e executar o Conteúdo do cliente por meio do Serviço e reproduzi-lo exclusivamente no Serviço conforme permitido através da funcionalidade fornecida pelo GitHub (por exemplo, através de bifurcando). O Cliente poderá conceder direitos adicionais ao Conteúdo do Cliente se o Cliente [adotar uma licença](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository). Se o cliente estiver fazendo upload de um Conteúdo do cliente que ele não criou nem possuiu, será responsável por garantir que o Conteúdo do cliente carregado seja licenciado sob os termos que concedem essas permissões a Usuários externos.

#### 3.3.5 Contribuições na licença de repositório.
Sempre que o Cliente faz uma contribuição a um repositório que contém notificação de uma licença, o Cliente licencia essa contribuição nos mesmos termos e concorda que tem o direito de licenciá-la nesses termos. Se o Cliente tiver um contrato separado para licenciar as contribuições em termos diferentes, como um contrato de licença de colaborador, esse contrato será substituído.

#### 3.3.6 Direitos morais.
O Cliente detém todos os direitos morais ao Conteúdo do cliente que ele carrega, publica ou envia para qualquer parte do Serviço, inclusive os direitos de integridade e atribuição. No entanto, o Cliente renuncia a esses direitos e concorda em não fazê-los valer contra o GitHub somente no intuito de permitir que o GitHub exerça razoavelmente os direitos concedidos na Seção 3,3, mas não o contrário.

### 3.4. Repositórios privados.

#### 3.4.1 Controle.
O Cliente é responsável por gerenciar o acesso a seus Repositórios privados, incluindo convites, encerramento do acesso e controle administrativo de Organizações e equipes.

#### 3.4.2 Confidencialidade.
O GitHub considera o Conteúdo do cliente nos Repositórios privados do Cliente como Informações confidenciais do Cliente. O GitHub protegerá e manterá estritamente confidencial o Conteúdo do cliente em Repositórios privados, conforme descrito na Seção 1.4.

#### 3.4.3 Acesso.
O GitHub só pode acessar os Repositórios privados do Cliente (i) com o consentimento e o conhecimento do Cliente, para fins de suporte, ou (ii) quando o acesso for exigido por motivos de segurança.  O Cliente pode optar por permitir o acesso adicional a seus Repositórios privados. Por exemplo, o Cliente pode habilitar vários serviços ou recursos do GitHub que exigem direitos adicionais ao Conteúdo do cliente em Repositórios privados. Esses direitos podem variar de acordo com o serviço ou recurso, mas o GitHub continuará a tratar o Conteúdo do cliente nos Repositórios privados do Cliente como Informações confidenciais do Cliente. Se esses serviços ou recursos exigirem direitos além dos necessários para oferecer o Serviço, o GitHub apresentará uma explicação sobre esses direitos.

#### 3.4.4 Exclusões.
Se o GitHub tiver motivos para acreditar que o Conteúdo de um Repositório privado viola a lei ou o presente Contrato, o GitHub tem o direito de acessar, analisar e remover esse Conteúdo. Além disso, o GitHub pode ser obrigado por lei a divulgar o Conteúdo de Repositórios privados do Cliente. A menos que estipulado de outra forma por requisitos dispostos na lei ou em resposta a uma ameaça à segurança ou outro risco para a segurança, o GitHub avisará sobre tais ações.

### 3.5. Avisos de propriedade intelectual.

#### 3.5.1 Direitos do GitHub ao conteúdo.
A aparência do Serviço é Copyright © GitHub, Inc. Todos os direitos reservados. O Cliente não pode duplicar, copiar ou reutilizar qualquer parte dos elementos ou conceitos de design visual, JavaScript ou HTML/CSS sem a permissão expressa por escrito do GitHub.

#### 3.5.2 Violação de direitos autorais e política DMCA.

Se o Cliente for proprietário de direitos autorais e acreditar que o Conteúdo no Serviço viola seus direitos autorais, ele poderá notificar o GitHub de acordo com a [Lei dos Direitos Autorais do Milênio Digital](https://github.com/contact/dmca) (DMCA – Digital Millenium Copyright Act Policy) usando o [Formulário DMCA](https://github.com/contact/dmca-notice) ou pelo e-mail copyright@github.com.

#### 3.5.3 Logotipos e marcas registradas do GitHub.

Se o Cliente quiser usar as marcas registradas do GitHub, deverá seguir todas as diretrizes de marca registrada do GitHub, inclusive aquelas na [página Uso e logotipos do GitHub](https://github.com/logos).

### 3.6 Suspensão.
O GitHub tem o direito de suspender a qualquer momento o acesso parcial ou total ao Serviço, incluindo remoção de Conteúdo, por violação deste Contrato ou para proteger a integridade, a operacionalidade e a segurança do Serviço. Essa suspensão tem efeito imediato e deve ser feita mediante aviso prévio, a menos que esse aviso seja proibido por lei ou processo legal ou impeça a prevenção de danos iminentes ao Serviço ou a terceiros. O GitHub normalmente envia um aviso na forma de banner ou e-mail antes ou no momento da suspensão. A seu critério e com boa fé, o GitHub ajustará qualquer suspensão conforme necessário para preservar a integridade, a operacionalidade e a segurança do Serviço.

### 3.7 Contrato de Nível de Serviço.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 3.8 Alterações no serviço.
O GitHub altera o Serviço através de Atualizações e adição de novos recursos. Sujeito à Seção 3,7, o GitHub se reserva o direito de, a qualquer momento, modificar ou interromper, temporária ou permanentemente, o Serviço (ou qualquer parte dele), com ou sem aviso prévio.

### 3.9 Funcionalidades de Serviço Adicional.

Alguns recursos do Serviço podem estar sujeitos a termos adicionais definidos nos [Termos do Produto Adicional do GitHub](/github/site-policy/github-additional-product-terms). Ao acessar ou usar esses recursos, o Cliente concorda com os Termos do Produto Adicional do GitHub.

## ANEXO A: DEFINIÇÕES

**"Usuário ativo"** significa um Usuário que tenta acessar o Serviço no momento de uma Pane.

"**Software de complemento**" significa Segurança Avançada, Insights, Learning Lab for Enterprise Server e outros produtos complementares de software que o GitHub pode oferecer de tempos em tempos.

**"Segurança Avançada"** significa o recurso de Software que permite ao Cliente identificar vulnerabilidades de segurança através de análise de código semântica personalizável e automatizada.

**"Afiliada"** significa qualquer entidade que controle direta ou indiretamente, seja controlada por ou esteja no controle comum com uma parte em que "controle" significa ter mais de 50% de propriedade ou o direito de direcionar a administração da entidade.

**"Todos os usuários"** significa, coletivamente, Usuários e Usuários externos do Cliente que utilizam o Serviço.

**"Américas"** significa Estados Unidos, Canadá, México o um país no Caribe, na América Central ou na América do Sul.

**"Visualizações Beta"** significa software, serviços ou recursos identificados como alfa, beta, visualização, acesso antecipado ou avaliação, ou palavras e frases com significados semelhantes.

**"Informações confidenciais"** significa todas as informações não públicas divulgadas por uma das Partes a terceiros (seja por escrito, por via oral ou por outros meios), designadas como confidenciais ou que a Parte receptora sabe ou deveria saber, nas circunstâncias em torno da divulgação e da natureza das informações, que é confidencial para a Parte divulgadora. Para evitar dúvidas, nenhum Conteúdo postado no Serviço será considerado como Informações Confidenciais, exceto o Conteúdo do Cliente armazenado exclusivamente nos Repositórios Privados do Cliente. As Informações confidenciais não incluem nenhuma informação que (i) era ou se torna publicamente conhecida sem que isso seja culpa da Parte receptora; (ii) era legitimamente conhecida ou se torna legitimamente conhecida para a Parte receptora sem restrição confidencial ou proprietária de uma fonte diferente da Parte divulgadora que tem o direito de divulgá-la; (iii) é aprovada pela Parte divulgadora para divulgação sem restrição em um documento escrito assinado por um oficial devidamente autorizado dessa Parte divulgadora; (iv) a Parte receptora desenvolve de forma independente, sem usar ou acessar as Informações confidenciais da outra Parte; ou (v) é ou foi armazenada ou postada no Serviço e fora dos Repositórios privados do Cliente.

**"Connect"** ou **"GitHub Connect"** significa um recurso incluído no Software que permite que o Cliente conecte o Software ao Serviço. O uso do GitHub Connect pode estar sujeito a termos do GitHub Connect definidos nos [Termos de Produto Adicional do GitHub](/github/site-policy/github-additional-product-terms).

**"Conteúdo"** significa, sem limitação, texto, dados, artigos, imagens, fotografias, gráficos, softwares, aplicativos, designs, recursos e outros materiais que são apresentados, exibidos ou disponibilizados por meio do Serviço.

**"Conta corporativa"** significa uma conta criada por um Usuário em nome de uma entidade.

**"Customer"** means, collectively, the company or organization that has entered into this Agreement with GitHub by clicking on the "I AGREE" or similar button or by accessing the Products, its Affiliates and Representatives.

**"Conteúdo do cliente"** significa Conteúdo que o cliente cria, possui ou para o qual o cliente detém os direitos.

**"Modificações feitas pelo Cliente"** significa modificações no Software que o Cliente pode fazer unicamente com a finalidade de desenvolver correções de erros, personalizações ou recursos adicionais para bibliotecas com licenças de código aberto que podem ser incluídas ao Software ou vinculadas por ele.

**"Documentação"** significa qualquer manual, documentação e outros materiais de suporte relacionados ao Software ou ao Serviço que o GitHub fornece ou disponibiliza ao Cliente.

**"Data efetiva"** é a data em que o Cliente (i) concorda com os termos e condições deste Contrato, conforme descrito acima, ou (ii) faz um pedido dos Produtos pela primeira vez.

**"Serviços essenciais"** significa os serviços essenciais para a funcionalidade de controle da versão principal do GitHub, como criação, bifurcação e clonagem de repositórios; criação, commit e merge de branches; criação, revisão e merge de pull requests; e interfaces de cliente Git, API e web para os fluxos de trabalho principais do Git. Estes são exemplos de serviços e recursos periféricos não incluídos: webhooks, Gists, Pages e notificações por e-mail.

**"Usuário externo"** significa um indivíduo, com exceção de Usuários do Cliente, que visitam ou usam o Serviço. "Taxas" significa as taxas que o Cliente deve pagar ao GitHub para (i) usar os Produtos durante o Período de assinatura aplicável ou (ii) receber Serviços profissionais, pois essas taxas estão refletidas em um Formulário de pedido ou SOW.

**"Feedback"** significa ideias, conhecimento, algoritmos, contribuições de código, sugestões, solicitações de aprimoramento, recomendações ou qualquer outro feedback sobre produtos ou serviços do GitHub.

**“Fees”** means the fees Customer is required to pay GitHub to (i) use the Products during the applicable Subscription Term or (ii) receive Professional Services, as such fees are reflected on an Order Form or SOW.

**"Bifurcação"** significa copiar o Conteúdo de um repositório para outro.

**"GitHub"** significa, coletivamente, GitHub, Inc., suas Afiliadas e seus Representantes.

**"Conteúdo do GitHub"** significa Conteúdo que o GitHub cria, possui ou para o qual detém os direitos.

**"GitHub Insights"**" ou **"Insights"** significa o recurso de software que fornece métricas ao Cliente, análises e recomendações relacionadas ao uso do Software. O GitHub Insights não inclui recursos legados do GitHub, incluindo insights da Organização e insights de repositórios.

**"GitHub One"** significa o pacote de Produtos que inclui GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server e Premium Plus ou Suporte Direto de Engenharia.

**"Learning Lab for Enterprise Server"**" significa o recurso de Software que permite que os Usuários aprendam sobre a funcionalidade do GitHub, incluindo Documentação associada.

**"Chave de licença"** significa o arquivo de dados usado pelo mecanismo de controle de acesso do Software que permite que o Cliente instale, opere e use o Software.

**"Conta de máquina"** significa uma conta registrada por um indivíduo que aceita os termos de serviço aplicáveis em nome da Conta da máquina, fornece um endereço de e-mail válido e é responsável por suas ações. Uma Conta de máquina é usada exclusivamente para executar tarefas automatizadas. Vários Usuários podem direcionar as ações de uma Conta de máquina, mas o proprietário da conta é o responsável final pelas ações da máquina.

**"Formulário de pedido"** significa documentação escrita ou eletrônica (inclusive citação) que as Partes utilizam para encomendar os Produtos.

**“Organização”** significa um espaço de trabalho compartilhado que pode estar associado a uma única entidade ou a um ou mais Usuários em que vários Usuários podem colaborar em vários projetos de uma só vez. Um Usuário pode ser integrante de mais de uma Organização.

**"Pane"** significa a interrupção de um Serviço essencial que afeta mais de 50% dos Usuários ativos.

**"Repositório privado"** significa um repositório que permite que um Usuário controle o acesso ao Conteúdo.

**"Serviços profissionais"** significa serviços de implementação, consultoria ou treinamento que o GitHub fornece de acordo com uma SOW executada mutuamente. Os Serviços profissionais não incluem Suporte.

**"Repositório público"** significa um repositório cujo Conteúdo é visível para Todos os usuários.

**"Versão"** significa uma versão de Software que o GitHub disponibiliza aos clientes, juntamente com as alterações correspondentes na Documentação, e que contém aprimoramentos, novos recursos ou novas funcionalidade, geralmente indicados por uma alteração no dígito à direita do primeiro ponto decimal por exemplo, x.x.x para x.y.x) ou à esquerda do primeiro ponto decimal (por exemplo, x.x.x para y.x.x).

**"Representantes"** significa funcionários, agentes, contratados independentes, consultores, advogados e consultores financeiros da Parte.

**"Scraping"** (raspagem) significa extrair dados do Serviço por meio de um processo automatizado, como um bot ou  rastreador web (webcrawler), e não inclui a coleta de informações por meio da API do GitHub.

**"Serviço"** significa o serviço GitHub Enterprise Cloud hospedado. O Serviço inclui: contas da Organização, logon único SAML, provisionamento de acesso e qualquer Documentação aplicável. Esta lista de recursos e serviços não é completa e pode ser atualizada de tempos em tempos.

**"Crédito de serviço"** significa um crédito em dólar, calculado conforme estabelecido abaixo, que o GitHub pode creditar de volta em uma conta qualificada.

**"Software"** significa o software GitHub Enterprise Server local. O software inclui o recurso do GitHub Connect, qualquer documentação aplicável, quaisquer atualizações do Software que o GitHub fornece ao Cliente ou que possa acessar nos termos deste Contrato, e, se incluído na assinatura do cliente, o Software adicional.

**"SOW"** significa uma declaração de trabalho mutuamente executada detalhando os Serviços profissionais que o GitHub executará, as taxas associadas e as obrigações relacionadas de cada Parte.

**"Licença de assinatura"** significa a licença atribuída a cada Usuário para instalar, operar, acessar e utilizar os Produtos em nome do Cliente. O Cliente só pode atribuir uma Licença de assinatura por Usuário nas instâncias do GitHub Enterprise Server e nas Organizações do GitHub Enterprise Cloud. Cada Usuário terá acesso ao máximo possível de instâncias do Enterprise Server ou de Organizações do Enterprise Cloud, conforme o Cliente permitir. No entanto, depois que o cliente atribuir uma Licença de assinatura a um Usuário, o Cliente não estará autorizado a bifurcar a Licença de assinatura para que um Usuário possa utilizá-la no Enterprise Server enquanto outro Usuário a utiliza em outra instância do GitHub Enterprise Server ou em uma Organização no GitHub Enterprise Cloud.

**"Período de assinatura"** significa 01 (um) ano a partir da data efetiva aplicável de um pedido ou indicado de outra forma no Formulário de pedido.

**"Suporte"** significa o suporte técnico ao Software ou ao Serviço que o GitHub pode oferecer.

**"Atualização"** significa uma versão de Software que o GitHub disponibiliza em geral aos seus clientes, juntamente com quaisquer alterações correspondentes na Documentação, que contenha correções de erros, geralmente indicadas por uma alteração no dígito à direita do segundo ponto decimal (por exemplo, x. x. x para x. x. y).

**"Tempo de atividade"** significa o percentual de tempo em um determinado trimestre em que os Serviços essenciais do GitHub não serão interrompidos por uma Pane que afete mais de 50% dos Usuários ativos.

**"Usuário"** significa (i) em relação ao Software, uma única pessoa ou Conta de máquina que inicia a execução do Software, interage com ele ou o direciona no desempenho de suas funções; e (ii) no que diz respeito ao Serviço, uma Conta de máquina ou individual que (a) acessa ou usa o Serviço, (b) acessa ou usa qualquer parte da conta do Cliente, ou (c) direciona o uso da conta do Cliente no desempenho das funções, em todos os casos em nome do Cliente. O número de Usuários não deve exceder o número de Licenças de assinatura que o Cliente adquiriu.

**"Conteúdo gerado pelo usuário"** significa conteúdo criado ou pertencente a um terceiro ou Usuário externo.
