---
title: Adendo à proteção de dados do GitHub
versions:
  free-pro-team: '*'
---

Data efetiva da versão: 20 de julho de 2020

## INTRODUÇÃO

As partes concordam que o Anexo de Proteção de Dados e Segurança do GitHub (coletivamente, o **"Adendo de Proteção de Dados"** ou **"DPA"**) define suas obrigações no que diz respeito ao processamento e segurança dos Dados Pessoais do cliente em conexão ao serviço hospedado pelo GitHub Enterprise Cloud (**"Serviço"**). O GitHub assume compromissos neste DPA perante todos os clientes que usam o Serviço. Os termos separados, incluindo diferentes termos de privacidade e segurança, regem o uso do cliente de produtos que não são do GitHub.

Na hipótese de qualquer conflito ou inconsistência entre o DPA e quaisquer outros termos nos acordos do Cliente com o GitHub, prevalecerá o DPA. As provisões do DPA substituem quaisquer disposições conflitantes da Declaração de Privacidade do GitHub que, de outra forma, possam aplicar-se ao processamento de Dados Pessoais do Cliente definidos no presente documento. Para clareza, consistente com a Cláusula 10 das Cláusulas Contratuais Padrão no Anexo 1, as Cláusulas Contratuais Padrão prevalecem sobre quaisquer outros termos no DPA.


## PROTEÇÃO DE DADOS DO GITHUB

### 1.  Definições.

1.1 "**Leis de proteção de dados aplicáveis**" significa leis, regulamentações, marcos regulatórios ou outras legislações relacionadas a processamento e uso de Dados Pessoais Do Cliente, conforme aplicável ao uso do GitHub e do Serviço do GitHub pelo Cliente, incluindo:

  a.  o Regulamento Geral sobre a Proteção de Dados 2016/679 da UE (**"GDPR"**), juntamente com quaisquer leis ou regulamentos nacionais equivalentes em implementação ou correspondentes, uma vez em vigor e se aplicáveis; e

  b.  A Lei de Privacidade do Consumidor da Califórnia de 2018, Cal. Civ. Código §§1798.100 et seq. (**"CCPA"**); e

  c.  A Lei de Proteção de Dados do Reino Unido de 2018 e a implementação do GDPR contida na mesma.

1.2 Os termos "**Controlador**", "**Titular de dados**", "**Estado-membro**", "**Dados pessoais**", "**Violação de dados pessoais**", "**Processamento**", "**Processador**" e "**Autoridade de supervisão**" têm os significados que são atribuídos a eles nas Leis de Proteção de Dados aplicáveis. Em caso de conflito, os significados atribuídos no GDPR serão substituídos.

1.3  O termo "**Dados pessoais do cliente**" significa quaisquer dados pessoais dos quais o Cliente seja Controlador, independentemente de serem fornecidos pelo Cliente para processamento pelo GitHub ou gerados pelo GitHub durante a execução de suas obrigações previstas no Contrato. Inclui dados como informações de cobrança, endereços IP, endereços de e-mail corporativos e quaisquer outros Dados pessoais dos quais o Cliente seja Controlador.

1.4  O termo "**Dados de repositório do cliente**" significa quaisquer dados ou informações que sejam carregados ou criados pelo Cliente em um dos respectivos Repositórios privados.

1.5  "**Violação de dados**" significa uma Violação de dados pessoais ou qualquer outra violação confirmada ou razoavelmente suspeita dos Dados Protegidos do Cliente.

1.6  O termo "**Usuário final**" significa um Titular de dados individual que controla uma conta do GitHub, concordou com os Termos de serviço do GitHub e cujos Dados pessoais estão sendo transferidos, armazenados ou processados pelo GitHub. Por exemplo, cada contratado ou funcionário do Cliente que tenha uma conta do GitHub também é um Usuário final do GitHub.

1.7  O termo "**Finalidades permitidas**" no processamento de dados significa as finalidades limitadas e específicas para fornecer o Serviço conforme estabelecido no Contrato, na Declaração de privacidade do GitHub e neste Anexo A ou as finalidades para as quais um Titular de dados autorizou o uso de Dados pessoais do cliente.

1.8  O termo "**Dados protegidos**" inclui Dados pessoais do cliente e Dados de repositório do cliente processados pelo GitHub em nome do Cliente neste Contrato.

1.9  O termo "**Dados confidenciais**" significa quaisquer Dados Pessoais de Clientes que revelem origem racial ou étnica; opiniões políticas, crenças religiosas ou filosóficas ou filiação sindical; processamento de dados genéticos ou biométricos para identificar uma pessoa física de forma inequívoca; dados relativos à saúde, à orientação ou à vida sexual de uma pessoa física e dados relativos a infrações, condenações penais ou medidas de segurança.

### 2. Status e conformidade.

#### 2.1 Processamento de dados.
O GitHub atua como um Processador com relação a Dados Pessoais do Cliente recebidos em conexão com o Contrato e os processará somente para as Finalidades Permitidas de acordo com as instruções do Cliente, conforme representado pelo Contrato e por outras comunicações escritas. Caso o GitHub não consiga cumprir as instruções do Cliente (por exemplo, devido a conflitos com as Leis de proteção de dados aplicáveis ou quando o processamento é exigido pelas Leis de proteção de dados aplicáveis ou outros requisitos legais), o GitHub notificará o Cliente desde que permitido. Embora o GitHub processe todos os Dados pessoais do cliente nos Estados Unidos ou na União Europeia, os subprocessadores do GitHub podem processar dados fora dos Estados Unidos ou da União Europeia. Além disso, o GitHub atua como Processador para Dados de repositório do cliente.

#### 2.2 Controladores de dados.
O GitHub recebe Dados pessoais tanto do cliente como diretamente dos titulares de dados que criam contas de usuário final. O Cliente é Controlador apenas dos Dados pessoais do cliente que ele transfere diretamente para o GitHub.

#### 2.3 Conformidade do GitHub; transferências de dados.
O GitHub cumprirá as leis de proteção de dados aplicáveis com relação ao processamento dos dados pessoais do cliente.

Todas as transferências de dados pessoais do cliente para fora da União Europeia, Espaço Econômico Europeu, Reino Unido e a Suíça para fornecer o Serviço serão regidas pelas Cláusulas Contratuais Padrão no Anexo 1 (Cláusulas Contratuais Padrão). O GitHub cumprirá os requisitos do Espaço Econômico Europeu e da legislação suíça de proteção de dados referente à coleta, uso, transferência, retenção e outro tipo de processamento de Dados Pessoais do Cliente do Espaço Econômico Europeu, Reino Unido e Suíça. Todas as transferências de Dados Pessoais do Cliente para um país terceiro ou uma organização internacional estarão sujeitas às salvaguardas apropriadas, conforme descrito no Artigo 46 do RGPD e tais transferências e salvaguardas serão documentadas de acordo com o Artigo 30(2) do RGPD.

Além disso, o GitHub é certificado na relação entre UE e EUA. e entre a Suíça e os EUA. In addition, GitHub is certified to the EU-U.S. and Swiss-U.S. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-U.S. Privacy Shield Framework as a legal basis for transfers of Personal Data in light of the judgment of the Court of Justice of the EU in Case C-311/18.  O GitHub concorda em notificar o Cliente se determinar que não pode mais cumprir sua obrigação de fornecer o mesmo nível de proteção exigido pelos princípios do Escudo de Privacidade.


### 3. Proteção de dados.

#### 3.1 Limitação de finalidade.
O GitHub processará e comunicará os Dados Protegidos apenas para as Finalidades Permitidas, a menos que as Partes concordem, por escrito, com uma finalidade expandida.

#### 3.2 Qualidade de Dados e Proporcionalidade.
O GitHub manterá os dados pessoais do Cliente precisos e atualizados, ou habilitará o Cliente a fazê-lo. O GitHub tomará medidas comercialmente razoáveis para garantir que os Dados protegidos que ele colete em nome do Cliente sejam adequados, relevantes e não excessivos em relação às finalidades para as quais são transferidos e processados. Em nenhuma hipótese, o GitHub coletará intencionalmente Dados confidenciais em nome do Cliente. O Cliente concorda que o Serviço do GitHub não se destina ao armazenamento de Dados confidenciais. Se o Cliente optar por fazer upload de Dados confidenciais para o Serviço, deverá cumprir o Artigo 9 do GDPR ou disposições equivalentes nas Leis de proteção de dados aplicáveis.

#### 3.3 Retenção e Exclusão de Dados.
Mediante solicitação razoável do Cliente, a menos que proibido por lei, o GitHub devolverá, destruirá ou desidentificará todos os Dados pessoais do cliente e dados relacionados em todos os locais onde estejam armazenados, depois que não forem mais necessários para as finalidades permitidas, no prazo de 30 (trinta dias) após a solicitação. O GitHub pode reter Dados pessoais do cliente e dados relacionados, apenas na medida exigida pelas Leis de proteção de dados aplicáveis e durante o período estipulado por elas, desde que assegure que os Dados pessoais do cliente serão processados somente conforme necessário para a finalidade especificada nas Leis de proteção de dados aplicáveis e que os Dados pessoais do cliente permaneçam protegidos pelas Leis de proteção de dados aplicáveis.

#### 3.4 Processamento de dados.
No que diz respeito ao processamento de Dados Protegidos do Cliente, o GitHub fornece as informações a seguir, exigidas pelo artigo 28(3) do RGPD:

a.  *O assunto e a duração do processamento* de Dados pessoais do cliente estão definidos no Contrato e neste Adendo.

b.  *A natureza e a finalidade do processamento* de Dados pessoais do cliente estão descritos na Seção 3.1 deste Adendo.

c.  *Os tipos de Dados pessoais do cliente a serem processados* estão descritos na Declaração de privacidade do GitHub e incluem Dados pessoais do cliente, como nomes de usuário, senhas, endereços de e-mail e endereços IP. O GitHub também processa as informações necessárias para efetuar a cobrança na conta do Cliente, mas não processa nem armazena informações de cartão de crédito. O Cliente pode optar por fornecer ao GitHub outros Dados pessoais do cliente; por exemplo, nas configurações de perfil do Cliente ou ao fazer upload de Dados pessoais do cliente para os repositórios do GitHub.

d.  *As categorias de Titular de dados aos quais estão relacionados os Dados pessoais do cliente* são o próprio Cliente e seus Usuários finais.

e.  *As obrigações e os direitos do Cliente* estão previstos no Contrato e neste Adendo.

### 4. Obrigações de auditoria e segurança.

#### 4.1 medidas de segurança técnicas e organizacionais.
Levando em consideração o que há de mais moderno, os custos de implementação e a natureza, o escopo, o contexto e as finalidades do processamento, bem como o risco de probabilidade e gravidade variadas para direitos e liberdades fundamentais das pessoas físicas, o GitHub implementará medidas técnicas e organizacionais para garantir um nível de segurança adequado contra os riscos (como destruição acidental ou ilegal, perda, alteração, divulgação ou acesso não autorizado) que se apresentam ao processar Dados Protegidos. O GitHub monitorará regularmente o cumprimento dessas medidas e continuará a tomar as providências apropriadas ao longo da vigência do Contrato. Consulte a Seção 1.1 do Anexo sobre segurança do GitHub para ler a respeito das responsabilidades do GitHub relacionadas a proteções de segurança.

#### 4.2 - Resposta de incidente e notificação de violação.
O GitHub cumprirá as obrigações de Segurança de Informações no Anexo sobre segurança do GitHub e nas Leis de Proteção de Dados aplicáveis, incluindo obrigações sobre notificação de Violação de Dados. Consulte a Seção 1.2 do Anexo sobre segurança do GitHub para ler a respeito das responsabilidades do GitHub relacionadas a notificação e resposta de Violação de dados.

#### 4.3 Equipe do GitHub.
O GitHub declara e garante que tomará medidas razoáveis para assegurar que todos os funcionários do GitHub que processam Dados protegidos tenham concordado em manter a confidencialidade dos Dados Protegidos e recebido treinamento adequado sobre o cumprimento deste Adendo e das Leis de Proteção de Dados aplicáveis.

#### 4.4 Registros.
O GitHub manterá registros escritos completos, precisos e atualizados de todas as categorias de atividades de processamento realizadas em nome do Cliente que contenham as informações exigidas nas Leis de Proteção de Dados aplicáveis. Desde que a assistência não arrisque a segurança do GitHub ou os direitos de privacidade de Titulares de dados individuais, o GitHub disponibilizará esses registros ao Cliente mediante solicitação conforme a necessidade; por exemplo, para ajudar o cliente a demonstrar conformidade com as Leis de proteção de dados aplicáveis. Para saber mais sobre os requisitos do GitHub para oferecer assistência no caso de um incidente de segurança, consulte a Seção 1.2 do Anexo sobre segurança do GitHub.

#### 4.5 Relatório de conformidade.
O GitHub fornecerá relatórios de conformidade com a seção 2.3 da segurança e privacidade do Anexo sobre segurança do GitHub. O Cliente concorda que quaisquer informações e direitos de auditoria concedidos pelas Leis de proteção de dados aplicáveis (inclusive, quando aplicável, o Artigo 28(3)(h) do GDPR) serão satisfeitos por esses relatórios de conformidade e só surgirão na medida em que o provisionamento de um relatório de conformidade pelo GitHub não forneça informações suficientes ou na medida em que o Cliente precise responder a uma auditoria de autoridade regulamentar ou da Autoridade de supervisão. A Seção 3.1 do Anexo sobre segurança do GitHub descreve as responsabilidades das Partes em relação a uma auditoria regulamentar ou da Autoridade de supervisão.

#### 4.6 Assistência.
O GitHub fornecerá a assistência cabível ao Cliente com preocupações como avaliações de impacto na privacidade de dados, solicitações de direitos de Titular de Dados, consultas com Autoridades de Supervisão e outros assuntos semelhantes, em todos os casos exclusivamente em relação ao processamento de Dados Pessoais do Cliente e levando em consideração a natureza do processamento.

### 5. Uso e divulgação de dados protegidos.

#### 5.1 Sem uso no Marketing.
O GitHub não usará os Dados Protegidos para fins de publicidade de conteúdo de terceiros nem os venderá a terceiros, exceto como parte de uma fusão ou aquisição.

#### 5.2 Declaração de Privacidade do GitHub.
A Declaração de Privacidade do GitHub, disponível publicamente em [https://help.github.com/articles/github-privacy-statement/](/articles/github-privacy-statement), fornece um aviso detalhado sobre as práticas de privacidade e uso de dados do GitHub, como o uso de cookies, o processo de resolução de disputas e mais informações sobre a conformidade do GitHub com a GDPR.

### 6. Transferência progressiva e subprocessamento.

#### 6.1 Proteção de Dados.
O GitHub é responsável por transferências progressivas de Dados Protegidos para seus subprocessadores, como o processador de pagamentos a terceiros. Na hipótese de o GitHub transferir os Dados Protegidos para um subprocessador de terceiros ou na hipótese de GitHub, usar, ou permitir que terceiros processem os Dados Protegidos em nome do GitHub, o GitHub garantirá que o subprocessador de terceiros seja vinculado pelo acordo escrito que exige que eles forneçam, pelo menos, o mesmo nível de confidencialidade, proteção de privacidade e segurança, conforme exigido por este DPA e pelas Leis de Proteção de Dados aplicáveis.

#### 6.2 - Aceitação de Subprocessadores do GitHub.
O Cliente autoriza o GitHub a nomear (e a permitir que cada subprocessador nomeado de acordo com esta Seção 6 também nomeie) subprocessadores de acordo com a Seção 6 e quaisquer outras restrições no Contrato. O GitHub pode continuar a usar esses subprocessadores utilizados atualmente a partir do início da vigência deste Adendo.

#### 6.3 Consentimento Geral para Subprocessamento progressivo.
O Cliente dá consentimento geral para que o GitHub utilize subprocessadores progressivos, condicionando à conformidade do GitHub com os seguintes requisitos:

a.  Qualquer subprocessador progressivo deve concordar por escrito em somente processar dados em países que a Comissão Europeia tenha declarado como tendo um nível "adequado" de proteção ou somente processar dados em termos equivalentes às Cláusulas Contratuais Padrão, de acordo com uma aprovação das Regras corporativas vinculativas concedidas pelas autoridades europeias competentes de proteção de dados ou de acordo com uma certificação vda álida do Escudo de Privacidade entre a UE e os EUA e entre a Suíça e os EUA. Certificações do Escudo de Privacidade; e

b.  b. O GitHub restringirá o acesso do subprocessador progressivo a Dados pessoais do cliente apenas ao estritamente necessário para executar os serviços e proibirá o subprocessador de processar os Dados pessoais do cliente para qualquer outra finalidade.

#### 6.4 - Divulgação de Acordos de Subprocessador.
O GitHub mantém uma lista de subprocessadores progressivos que utilizou para processar Dados Pessoais do Cliente em [https://help.github.com/articles/github-subprocessors-and-cookies/](/articles/github-subprocessors-and-cookies), incluindo as categorias de Dados Pessoais do Cliente processados, uma descrição do tipo de processamento que o subprocessador executa e a localização do seu processamento. Mediante solicitação por escrito do Cliente, o GitHub fornecerá esta lista de subprocessadores e os termos em que eles processarão os Dados pessoais do cliente. De acordo com as restrições de confidencialidade de subprocessadores, o GitHub pode remover informações confidenciais ou comercialmente confidenciais antes de fornecer a lista e os termos ao Cliente. Caso o GitHub não possa divulgar informações confidenciais ao Cliente, as Partes concordam que o GitHub fornecerá todas as informações razoavelmente possíveis relacionadas aos contratos de subprocessamento.

#### 6.5 Objeção para subprocessadores.
O GitHub fornecerá um aviso por escrito no prazo de 30 (trinta), além da remoção de qualquer subprocessador, incluindo as categorias listadas na Seção 6.4, anunciando mudanças no seu site <https://github.com/github/site-policy>. Se o Cliente tiver uma objeção razoável à utilização do GitHub em um novo subprocessador, deverá notificar o GitHub prontamente por escrito. Sempre que possível, o GitHub envidará esforços comercialmente razoáveis para fornecer uma solução alternativa ao Serviço afetado para evitar o processamento de dados pelo subprocessador questionável. Caso o GitHub não consiga oferecer uma solução alternativa e as Partes não resolvam o conflito em 90 (noventa) dias, o Cliente poderá rescindir o Contrato.

### 7. Rescisão.

#### 7.1 Suspensão.
Na hipótese de o GitHub violar suas obrigações de manter um nível adequado de proteção de segurança ou privacidade, o Cliente poderá suspender temporariamente a transferência de todos os Dados Pessoais ou proibir a coleta e o processamento dos seus Dados Pessoais em nome do Cliente até que a violação seja reparada ou o Contrato seja encerrado.

#### 7.2 - Rescisão com motivo.
Além dos direitos de rescisão que o Cliente tem previsto no Contrato, o Cliente poderá rescindir o Contrato sem prejuízo de qualquer outra reivindicação na lei ou na justiça caso:

a.  o GitHub notifique o cliente de que não pode mais cumprir suas obrigações de privacidade;

b.  a transferência, a coleta ou o processamento de todos os Dados pessoais do cliente tenha sido temporariamente suspenso por mais de um mês, de acordo com a Seção 7.1;

c.  o GitHub esteja em violação substancial ou persistente de quaisquer garantias ou representações neste Adendo;

d.  o GitHub não esteja mais em atividade, seja dissolvido, entre em liquidação ou tenha uma ordem de liquidação feita em seu nome; ou

e.  o Cliente faça objeção a um subprocessador de acordo com a Seção 6.5, e o GitHub não tenha conseguido fornecer uma solução alternativa em até 90 (noventa) dias.

#### 7.3 Violação.
A não observância das disposições materiais deste Adendo é considerada uma violação material ao disposto no Contrato.

#### 7.4 Não cumprimento.
Na hipótese de mudanças na lei ou na regulamentação tornarem o cumprimento deste Adendo impossível ou comercialmente impraticável, as Partes poderão renegociar o Adendo de boa-fé. Se a renegociação não corrigir a impossibilidade ou se as Partes não conseguirem chegar a um acordo, elas poderão rescindir o Contrato após 30 (trinta) dias.

#### 7.5 Notificação.
Caso o GitHub determine que não pode mais cumprir as obrigações de privacidade previstas neste Adendo, ele notificará o Cliente por escrito imediatamente.

#### 7.6 Modificações.
O GitHub pode modificar este Adendo de tempos em tempos, conforme exigido pelas Leis de Proteção de Dados aplicáveis, com aviso prévio de 30 (trinta) dias ao Cliente.

#### 7.7 Requisitos de rescisão.
Após a rescisão, o GitHub deverá:

a.  tomar medidas razoáveis e apropriadas para interromper o processamento dos Dados pessoais do cliente;

b.  dentro de 90 (noventa) dias após a rescisão, excluir ou desidentificar Dados pessoais do cliente que o GitHub armazene em nome do Cliente, de acordo com a Seção 3.3; e

c.  fornecer ao Cliente garantia razoável de que o GitHub cumpriu suas obrigações na Seção 7.7.

### 8. Responsabilidade pelo processamento de dados.

#### 8.1 Limitações.
Exceto quando limitado pelas Leis de Proteção de Dados aplicáveis, quaisquer reivindicações referentes a este Adendo estarão sujeitas aos termos do Contrato sobre Limitações de Responsabilidade.

## Anexo 1 – Cláusulas Contratuais Padrão (Processadores)
A execução do contrato aplicável pelo cliente inclui a execução deste Anexo 1 referente ao Adendo de Proteção de Dados ratificado pelo GitHub, Inc.

Em países onde a aprovação regulatória é necessária para o uso das Cláusulas Contratuais Padrão, estas não podem ser confiadas à Comissão Europeia 2010/87/UE (de fevereiro de 2010) para legitimar a exportação de dados do país, a menos que o Cliente tenha a aprovação regulatória necessária.

Para efeitos do artigo 46(2) do Regulamento Geral sobre a Proteção de Dados (UE 2016/679) referente à transferência de dados pessoais para processadores estabelecidos em países terceiros que não garantem um nível adequado de proteção de dados, o Cliente (como exportador de dados) e o GitHub (como importador de dados, cuja assinatura aparece abaixo), cada "parte" ou, coletivamente "as partes", concordaram com as seguintes Cláusulas Contratuais (as “Cláusulas” ou “Cláusulas Contratuais Padrão”) a fim de adjudicar salvaguardas adequadas no que diz respeito à proteção da privacidade e dos direitos e liberdades fundamentais dos indivíduos para a transferência por parte exportador para o importador de dados dos dados pessoais especificados no Apêndice 1.

#### Cláusula 1: Definições
(a) "dados pessoais", "categorias especiais de dados", "processo/processamento", "controlador", "processador", "titular dos dados" e "autoridade de supervisão" terão o mesmo significado do Regulamento Geral sobre a Proteção de Dados (UE 2016/679) referente à proteção dos indivíduos no que se refere ao tratamento de dados pessoais e à livre circulação desses dados;

(b) "o exportador de dados" significa o controlador que transfere os dados pessoais;

(c) "o importador de dados" significa o processador que aceita receber dos dados do exportador de dados pessoais destinados a processamento em seu nome após a transferência, de acordo com as suas instruções e os termos das Cláusulas e que não está sujeito a um sistema de um país terceiro, e garante uma proteção adequada no âmbito do artigo 45(2) do Regulamento Geral da Proteção de Dados (UE 2016/679);

(d) "subprocessador" significa qualquer processador envolvido pelo importador de dados ou por qualquer outro subprocessador do importador de dados que concorde em receber dados do importador de dados ou de qualquer outro subprocessador dos dados pessoais do importador destinados exclusivamente a atividades de processamento a serem realizadas em nome do exportador de dados após a transferência, de acordo com suas instruções, termos das Cláusulas e termos do subcontrato escrito;

(e) "A lei de proteção de dados aplicável" é a legislação que protege os direitos e liberdades fundamentais dos indivíduos, e, em particular, o direito à privacidade no que diz respeito ao processamento de dados pessoais aplicável a um controlador de dados do Estado-Membros onde o exportador de dados estiver estabelecido;

(f) "medidas de segurança técnicas e organizacionais" são as medidas que visam proteger os dados pessoais contra a destruição ilegal ou acidental, perda, alteração, divulgação ou acesso não autorizado, em particular quando o processamento envolve a transmissão de dados através de uma rede, e contra todas as formas ilegais de processamento.

#### Cláusula 2: Detalhes da transferência
Os detalhes da transferência e em particular as categorias especiais de dados pessoais quando aplicáveis estão especificadas no Apêndice 1 abaixo, que constitui parte integral das Cláusulas.

#### Cláusula 3: Cláusula de beneficiário de terceiros
1. O titular dos dados pode impor contra o exportador de dados esta Cláusula, a Cláusula 4(b) para (i), Cláusula 5(a) para (e), e (g) para (j), a Cláusula 6(1) e (2), a Cláusula 7, Cláusula 8(2), e as Cláusulas 9 a 12 como beneficiário de terceiros.

2. O titular dos dados pode aplicar contra o importador de dados esta Cláusula, a Cláusula 5(a) para (e) e (g), a Cláusula 6, a Cláusula 7, a Cláusula 8(2), e as Cláusulas 9 a 12, nos casos em que o exportador de dados desapareceu factualmente ou deixou de existir perante a lei, a menos que qualquer entidade sucessora tenha assumido todas as obrigações legais do exportador de dados por contrato ou por aplicação da lei. em resultado do qual assume os direitos e obrigações do exportador de dados. Nesse caso, a questão dos dados pode impô-los contra essa entidade.

3. O titular dos dados pode impor contra o subprocessador esta Cláusula, a Cláusula 5(a) para (e) e (g), a Cláusula 6, a Cláusula 7, a Cláusula 8(2), e as Cláusulas 9 a 12, nos casos em que tanto o exportador como o importador de dados desapareceram ou deixaram de existir perante a lei ou tornaram-se insolventes, a menos que qualquer entidade sucessora tenha assumido todas as obrigações legais do exportador de dados por contrato ou pelo funcionamento da lei, assumindo, como resultado, os direitos e obrigações do exportador de dados, em cujo caso, o titular dos dados pode impô-los contra essa entidade. Essa responsabilidade de terceiros do subprocessador estará limitada às suas próprias operações de processamento nos termos das Cláusulas.

4. As partes não se opõem, caso o titular dos dados seja representado por uma associação ou outro organismo se, expressamente, assim o desejar e a legislação nacional o permitir.

#### Cláusula 4: Obrigações do exportador de dados
O exportador de dados concorda e garante:

(a) que o processamento, incluindo a transferência em si, dos dados pessoais foi e continuará sendo executado de acordo com as provisões relevantes aplicáveis à lei de proteção de dados (e, quando aplicável, foi notificado às autoridades responsáveis do Estado-Membros onde o exportador de dados está estabelecido) e não viola as provisões relevantes deste Estado;

(b) que instruiu e que durante a duração dos serviços de processamento de dados pessoais irá instruir o importador de dados sobre o processamento de dados pessoais transferidos apenas no nome do exportador e em concordância com a legislação aplicável e as Cláusulas;

(c) que o importador de dados fornecerá garantias suficientes no que se refere às medidas de segurança técnicas e organizacionais especificadas no Anexo 2 abaixo;

(d) que, após a avaliação dos requerimentos da legislação de proteção aos dados aplicável, as medidas de segurança estejam apropriadas para proteger os dados pessoais contra a destruição ilegal ou acidental, ou a perca acidental, alteração, divulgação ou acesso não autorizado, em particular onde o processamento envolve a transmissão de dados através de uma rede, e contra todas as outras formas ilegais de processamento, e que estas medidas garantam um nível adequado de segurança aos riscos apresentados pelo processamento e pela natureza dos dados a serem protegidos, tendo em conta a conjuntura da questão e o custo de implementação;

(e) que garantirá o cumprimento das medidas de segurança;

(f) que, se a transferência envolver categorias especiais de dados, o titular dos dados foi informado ou será informado antes, ou o mais depressa possível após a transferência, de que os seus dados poderão ser transmitidos para um terceiro país que não garante um nível de proteção adequado no âmbito do Regulamento Geral sobre a Proteção de Dados (EU 2016/679);

(g) que encaminhará qualquer notificação recebida do importador de dados ou qualquer subprocessador em conformidade com a Cláusula 5(b) e a Cláusula 8(3) da proteção de dados para a autoridade de supervisão de proteção aos dados se o exportador de dados decidir continuar a transferência ou interromper a suspensão;

(h) em disponibilizar aos titulares dos dados, se assim requisitado, uma cópia das Cláusulas, com exceção do Apêndice 2 e uma descrição resumida das medidas de segurança, bem como uma cópia de qualquer contrato de serviços de subprocessamento que precisam ser feitos de acordo com as Cláusulas; a menos que as Cláusulas ou o contrato contenham informações comerciais, onde neste caso é possível remover tais informações comerciais;

(i) que, em caso de subprocessamento, a atividade de processamento seja realizada de acordo com a Cláusula 11 por um subprocessador, fornecendo, pelo menos, o mesmo nível de proteção dos dados pessoais e dos direitos do titular de dados como o importador de dados nos termos das Cláusulas; e

(j) que garantirá o cumprimento da Cláusula 4(a) para (i).

#### Cláusula 5: Obrigações do importador de dados
O importador de dados concorda e garante:

(a) processar somente dados pessoais em nome do exportador de dados e em conformidade com as suas instruções e cláusulas; se não puder assegurar tal conformidade por qualquer razão, concorda em informar prontamente o exportador de dados a inaptidão no cumprimento, que nessas circunstâncias, o exportador é autorizado a suspender a transferência de dados e/ou rescindir o contrato;

(b) que não tem qualquer razão para crer que a legislação que lhe é aplicável o impede de respeitar as instruções recebidas do exportador de dados e as obrigações que lhe incumbem por força do contrato e que, no caso de haver uma alteração nesta legislação que possa ter um efeito adverso substancial nas garantias e obrigações conferidas pelas cláusulas, notificará imediatamente essa alteração ao exportador de dados, assim que tiver conhecimento, tendo neste caso o exportador de dados o direito de suspender a transferência de dados e/ou de rescindir o contrato;

(c) que implementou as medidas de segurança técnicas e organizacionais especificadas no Apêndice 2 antes de processar os dados pessoais transferidos;

(d) que irá notificar rapidamente o exportador de dados sobre:

(i) qualquer pedido juridicamente vinculativo de divulgação dos dados pessoais por parte de uma autoridade competente para a aplicação da lei, a não ser que exista uma proibição em contrário, como uma proibição prevista no código penal para preservar a confidencialidade de uma investigação policial,

(ii) qualquer acesso acidental ou não autorizado; e

(iii) qualquer pedido recebido diretamente dos titulares de dados, sem responder a esse pedido, a não ser que tenha sido autorizado a fazê-lo;

(e) em lidar rápida e adequadamente com todos os inquéritos do exportador de dados em relação ao processamento dos dados pessoais na questão da transferência de dados, e em cumprir com o conselho da autoridade de supervisão em relação ao processamento dos dados transferidos;

(f) em caso de pedido por parte do exportador de dados para a submissão das instalações de processamento de dados a uma auditoria das atividades de processamento, em conformidade com as Cláusulas, que deve ser conduzida pelo exportador de dados ou um órgão de inspeção composto por membros independentes e em posse das requeridas qualificações profissionais vinculadas ao dever de confidencialidade, selecionado pelo exportador de dados, onde aplicável, e em concordância com a autoridade de supervisão;

(g) disponibilizar ao titular dos dados, mediante pedido, um exemplar das cláusulas ou de qualquer contrato existente de subprocessamento, a menos que as Cláusulas ou o contrato contenham informações comerciais, caso em que poderá suprimir as informações comerciais, com exceção do Apêndice 2, que deve ser substituído por uma descrição sumária das medidas de segurança, no caso de o titular dos dados não poder obter um exemplar do exportador de dados;

(h) que, em caso de subprocessamento, informou previamente o exportador de dados e obteve o seu consentimento escrito prévio;

(i) que os serviços de processamento pelo subprocessador serão realizados de acordo com a Cláusula 11; e

(j) enviar prontamente uma cópia de qualquer acordo de subprocessador concluído sob as Cláusulas para o exportador de dados.

#### Cláusula 6: Responsabilidade
1. As partes concordam que qualquer titular de dados que tenha sofrido danos em consequência de qualquer violação das obrigações referidas na Cláusula 3 ou na Cláusula 11 por qualquer parte ou subprocessador tem o direito de receber compensação do exportador de dados pelos danos sofridos.

2. Se um titular de dados não puder apresentar um pedido de indenização em conformidade com o parágrafo 1 contra o exportador de dados, decorrente de uma violação do importador de dados ou do seu subprocessador de qualquer uma de suas obrigações referidas na Cláusula 3 ou 11, porque o exportador de dados desapareceu ou deixou de existir perante a lei ou tornou-se insolvente, o importador de dados concorda que o titular dos dados poderá interpor uma reivindicação contra o importador de dados como se fosse o exportador de dados, a não ser que qualquer entidade sucessora tenha assumido todas as obrigações legais do exportador de dados por contrato de aplicação da lei. Nesse caso, o titular dos dados pode impor seus direitos contra essa entidade. O importador de dados não pode apoiar-se no descumprimento por um subprocessador das suas obrigações para se eximir de suas próprias responsabilidades.

3. Se um titular de dados não puder apresentar uma reivindicação contra o exportador ou o importador de dados referido nos parágrafos 1 e 2, decorrente de uma violação por parte do subprocessador de qualquer uma das suas obrigações referidas na Cláusula 3 ou 11, porque tanto o exportador como o importador de dados desapareceram ou deixaram de existir perante a lei ou tornaram-se insolventes, o subprocessador concorda que o titular dos dados poderá interpor uma reivindicação contra o subprocessador de dados no que diz respeito às suas próprias operações de processamento nos termos das Cláusulas como se fosse o exportador ou o importador de dados, salvo se qualquer entidade sucessora tenha assumido todas as obrigações legais do exportador ou do importador de dados por contrato ou por exercício da lei. Nesse caso, a o titular dos dados poderá impor seus direitos contra tal entidade. A responsabilidade do subprocessador é limitada às suas próprias atividades de processamento de dados nos termos previstas nas Cláusulas.

#### Cláusula 7: Mediação e jurisdição
1. O importador de dados concorda que, se o titular dos dados pode invocar contra ele direitos de terceiros beneficiários e/ou reivindicar compensação por dados de acordo com as Cláusulas, o importador de dados irá aceitar a decisão do titular de dados:

(a) a remeter o litígio à mediação, por uma pessoa independente ou, quando aplicável, pela autoridade supervisora;

(b) a remeter o litígio aos tribunais do Estado-Membro onde o exportador de dados está estabelecido.

2. As partes concordam que a escolha feita pelo titular dos dados não prejudicará os seus direitos substantivos ou processuais de procurar recursos de acordo com as disposições da lei nacional ou internacional.

#### Cláusula 8: Cooperação com as autoridades de supervisão
1. O exportador de dados concorda em depositar um exemplar deste contrato junto da autoridade de controle se esta assim requerer ou se a legislação de proteção de dados aplicável exigir.

2. As partes concordam que a autoridade de supervisão tem o direito de realizar auditorias no importador de dados ou a qualquer subprocessador, que tenha o mesmo escopo e as mesmas condições das auditorias executadas no exportador de dados, em conformidade com a legislação de proteção de dados aplicável.

3. O importador de dados deve prontamente informar o exportador de dados sobre a existência de legislação aplicável sobre tal ato, e de qualquer subprocessador que previna a condução de uma auditoria ao importador de dados, ou qualquer subprocessador, em conformidade com o parágrafo 2. Neste caso, o exportador de dados terá o direito de tomar as medidas previstas na Cláusula 5(b).

#### Cláusula 9: Lei regente.
As Cláusulas devem ser regidas pela lei do Estado-Membro onde o exportador de dados estiver estabelecido.

#### Cláusula 10: Variação do contrato
As partes comprometem-se a não alterar as Cláusulas. Isso não impede que as partes adicionem cláusulas de caráter comercial sempre que necessário, desde que as mesmas não contrariem a Cláusula.

#### Cláusula 11: Subprocessamento
1. O importador de dados não deve subcontratar nenhuma de suas operações de processamento em nome do exportador de dados sob as Cláusulas sem o consentimento prévio por escrito do exportador de dados. Quando o importador de dados subcontratar suas obrigações sob as Cláusulas, com o consentimento do exportador, ele deverá fazê-lo somente por meio de um contrato por escrito com o subprocessador, que imponha a este as mesmas obrigações impostas ao importador de dados nos termos das Cláusulas. Nos casos em que o subcontratante não cumprir as suas obrigações de proteção de dados nos termos de tal contrato por escrito, o importador de dados permanecerá totalmente responsável perante o exportador de dados pelo desempenho das obrigações do subprocessador nos termos desse contrato.

2. O contrato prévio por escrito entre o importador de dados e o subprocessador prevê também uma cláusula de beneficiário de terceiros, conforme estabelecido na Cláusula 3, para os casos em que o titular de dados não for capaz de interpor a reivindicação para a compensação referida no parágrafo 1 da Cláusula 6 contra o exportador ou o importador de dados porque eles desapareceram factualmente ou deixaram de existir perante lei ou tornaram-se insolventes, e nenhuma entidade sucessora assumiu todas as obrigações legais do exportador de dados ou importador de dados por contrato ou por operação da lei. Essa responsabilidade de terceiros do subprocessador estará limitada às suas próprias operações de processamento nos termos das Cláusulas.

3. As disposições relativas aos aspectos de proteção de dados para o subprocessamento do contrato referido no parágrafo 1 serão regidas pela lei do Estado-Membro onde o exportador de dados estiver estabelecido.

4. O exportador de dados deve manter uma lista dos acordos de subprocessamento concluídos sob as Cláusulas e notificados pelo importador de dados em conformidade com a Cláusula 5 (j), que deve ser atualizada pelo menos uma vez por ano. A lista deve estar disponível para a autoridade responsável pela supervisão da proteção de dados do exportador.

#### Cláusula 12: Obrigação após a rescisão dos serviços de processamento de dados pessoais
1. As partes estão de acordo quanto à rescisão da prestação de serviços de processamento de dados, o importador de dados e o subprocessador, mediante a escolha do exportador de dados, devolverão todos os dados pessoais transferidos e as suas cópias ao exportador de dados ou destruirão todos os dados pessoais, e informarão ao exportador de dados que o procedimento foi realizado, a menos que a legislação imposta ao importador de dados os impeça de devolver ou de destruir a totalidade ou parte dos dados pessoais transferidos. Nesse caso, o importador de dados irá garantir a confidencialidade dos dados pessoais transferidos e não processará mais ativamente os dados pessoais transferidos.

2. O importador de dados e o subprocessador garantem que, mediante solicitação do exportador de dados e/ou da autoridade supervisora, submeterão as suas instalações de processamento de dados a uma auditoria das medidas referidas no parágrafo 1.

### Apêndice 1 das Cláusulas Contratuais Padrão
Exportador de dados: Cliente é o exportador de dados.

**Importador de dados:** O importador de dados é o GitHub, Inc., produtor global de software e serviços.

**Titulares dos dados:** Os titulares de dados incluem os representantes e usuários finais do exportador, incluindo funcionários, contratados, colaboradores e clientes do exportador de dados. Os titulares de dados também podem incluir indivíduos que tentam comunicar-se ou transferir informações pessoais aos usuários dos serviços fornecidos pelo importador de dados. O GitHub reconhece que, dependendo do uso do Serviço pelo Cliente, este pode optar por incluir dados pessoais de qualquer um dos tipos a seguir de titulares de dados nos Dados Pessoais do Cliente:

-   Empregados, contratados e trabalhadores temporários (atual, anterior, potencial) do exportador de dados;
-   Dependentes do acima;
-   Os colaboradores/pontos de contato do exportador de dados (pessoas físicas) ou funcionários, contratados ou trabalhadores temporários de colaboradores de entidades legais colaboradores/contactar pessoas (atual, potencial, anterior);
-   Usuários (p. ex.: consumidores, clientes, pacientes, visitantes, etc.) e outros titulares de dados que são usuários dos serviços do exportador de dados;
-   Parceiros, partes interessadas ou indivíduos que colaboram ativamente, comunicam-se ou, de outra forma, interagem com os funcionários do exportador de dados e/ou usam ferramentas de comunicação como aplicativos e sites fornecidos pelo exportador de dados;
-   Partes interessadas ou indivíduos que interagem passivamente com o exportador de dados (por exemplo, porque são objeto de investigação, investigação ou mencionada em documentos ou correspondência de ou para o exportador de dados); ou
-   Profissionais com prestígio profissional (por exemplo, médicos, advogados, notários, trabalhadores religiosos, etc.).

**Categorias de dados:** Os dados pessoais transferidos incluídos em e-mails, documentos e outros dados de forma eletrônica no âmbito do Serviço.  O GitHub reconhece que, dependendo do uso do Serviço pelo Cliente, este pode optar por incluir dados pessoais de qualquer uma das seguintes categorias nos Dados Pessoais do Cliente:
-   Dados de autenticação (por exemplo, nome de usuário, e-mail, senha);
-   Informações de contato (por exemplo, e-mail);
-   Números de identificação únicos e assinaturas (endereços IP, identificador único em cookies de rastreamento ou tecnologia similar).
-   Outras informações únicas de identificação. Os titulares dos dados podem incluir mais informações, como, por exemplo, nomes reais, imagens de avatar e outras informações pessoais;

**Categorias especiais de dados (se apropriado):** O importador de dados não coleta ou processa intencionalmente nenhuma categoria especial de dados ao realizar seus serviços para o exportador de dados.

No entanto, uma vez que o importador de dados fornece serviços de armazenamento e não controla as categorias de dados que armazena, o exportador de dados pode optar por transferir as categorias especiais de dados. Consequentemente, o exportador de dados é o único responsável por assegurar que cumpre todas as obrigações impostas por leis e regulamentos aplicáveis relativos à coleta e processamento de quaisquer categorias especiais de dados, incluindo a obtenção do consentimento explícito dos dados sujeitos antes de processar dados pessoais confidenciais.

**Processamento de operações:** Os dados pessoais transferidos estarão sujeitos às seguintes atividades básicas de processamento: O GitHub usa dados pessoais para fins limitados definidos na Declaração de Privacidade do GitHub, disponível em [https://docs. ithub.com/articles/github-privacy-statement](/articles/github-privacy-statement), e a seção "Processamento de Dados" da DPA. Subcontratados: de acordo com o DPA, o importador de dados pode contratar outras empresas para prestar serviços limitados em nome do importador de dados, tais como fornecer suporte ao cliente. Esses subcontratantes terão a permissão de obter Dados Pessoais do Cliente apenas para fornecer os serviços que o importador de dados os manteve para fornecer, e são proibidos de usar os Dados Pessoais do Cliente para qualquer outra finalidade.

### Apêndice 2 das Cláusulas Contratuais Padrão
Descrição das medidas de segurança técnicas e organizacionais implementadas pelo importador de dados, de acordo com as Cláusulas 4(d) e 5(c):

**1. Equipe.** A equipe do importador de dados não processará os Dados Pessoais do Cliente sem autorização. A equipe é obrigada a manter a confidencialidade de quaisquer Dados Pessoais do Cliente e essa obrigação permanece mesmo após o fim do compromisso.

**2. Contato de privacidade de dados.** Você pode entrar em contato com o funcionário de privacidade do importador de dados no endereço abaixo: GitHub, Inc. Attn: Privacy 88 Colin P. Kelly Jr. Street San Francisco, CA 94107 USA

**3. Medidas técnicas e organizacionais.** O importador de dados implementou e manterá as medidas técnicas e organizacionais apropriadas, controles internos, rotinas de segurança de informações destinadas a proteger os Dados Pessoais do Cliente, conforme definido no Anexo de Segurança de segurança do GitHub, contra perdas acidentais, destruição ou alteração, divulgação ou acesso não autorizado; ou destruição ilegal da seguinte forma: medidas técnicas e organizacionais, controles internos, e as rotinas de segurança da informação estabelecidas no Anexo de Segurança do GitHub são incorporadas neste Apêndice 2 do presente documento a título de referência e são vinculadas ao importador de dados como se fossem definidas em inteiro teor neste Apêndice 2. A assinatura do GitHub, Inc. aparece abaixo.

Assinatura das Cláusulas Contratuais Padrão, Apêndice 1 e Apêndice 2 em nome do importador de dados

![Captura de tela 20/07/2020 às 14h20m29s](/assets/images/help/site-policy/docusign-signature.png)

Lynn Hashimoto, Chefe da área de Produtos & Departamento jurídico regulatório

GitHub, Inc.


## ANEXO DE SEGURANÇA

### 1. Programa de segurança das informações.

#### 1.1 Gerenciamento da segurança.

Durante a vigência do Contrato, o GitHub manterá e aplicará um programa de segurança das informações por escrito (**Programa de Segurança**") que se alinha com os frameworks reconhecidos pelo setor; inclui medidas de segurança elaboradas para resguardar a confidencialidade, a integridade, a disponibilidade e a resiliência dos Dados protegidos do Cliente; é apropriado para a natureza, o tamanho e a complexidade das operações comerciais do GitHub; e está em conformidade com as Leis de Proteção de Dados aplicáveis e outras leis e regulamentações específicas relacionadas à segurança das informações que sejam aplicáveis às regiões geográficas em que o GitHub atua.

a. Agente de segurança. O GitHub designou um funcionário sênior para ser responsável pela supervisão e execução do Programa de segurança e pela governança e comunicação interna em relação à segurança das informações.

b. Alterações no Programa de segurança. O GitHub não fará alterações no Programa de segurança que afetem negativamente a segurança dos Dados protegidos do Cliente em que seja exigida notificação de acordo com as leis e os regulamentos aplicáveis.

c. O GitHub manterá as práticas padrão do setor de segurança que incluem, mas não se limitam a:

- Programa de gerenciamento de vulnerabilidades
- Práticas seguras de codificação, revisão e treinamento de desenvolvimento
- Controles de acesso físico e lógico dos sistemas de produção
- Auditorias e avaliações técnicas externas
- Políticas de segurança, normas e procedimentos operacionais padrão
- Treinamento da conscientização de privacidade e segurança


#### 1.2 Gerenciamento de incidentes de segurança.
Durante a vigência do Contrato e, quando aplicável, o GitHub fornecerá um programa de gerenciamento de incidentes de segurança da seguinte forma:

a. a. Escalonamento e disponibilidade de segurança. O GitHub manterá os processos apropriados de escalonamento e contato de Segurança 24 horas por dia, 7 dias por semana, para garantir que clientes e funcionários possam enviar problemas para a equipe de Segurança do GitHub.

b. Resposta a incidentes. Se o GitHub tomar conhecimento de uma violação de segurança que leve a destruição acidental ou ilegal, perda, alteração, divulgação não autorizada ou acesso aos Dados Pessoais do Cliente (considerados individualmente como **"Incidente de Segurança"**), o GitHub irá, prontamente e sem demora indevida, (1) notificar o cliente sobre o Incidente de segurança; (2) investigar o Incidente de segurança e fornecer ao Cliente informações detalhadas sobre ele; (3) tomar medidas razoáveis para atenuar os efeitos e minimizar os danos resultantes do Incidente de Segurança.

c. Notificação. As notificações de Incidentes de segurança serão entregues a um ou mais administradores do Cliente por qualquer meio que o GitHub selecionar. É responsabilidade exclusiva do Cliente garantir que os administradores do Cliente monitorem e respondam a quaisquer notificações. O Cliente é o único responsável pelo cumprimento de suas obrigações perante as leis de notificação de incidentes aplicáveis ao Cliente e pelo cumprimento das obrigações de notificação de terceiros relacionadas a qualquer Incidente de segurança.

d. Assistência razoável. O GitHub fará tudo o que for possível comercialmente para ajudar o Cliente a cumprir suas obrigações nos termos da lei ou da regulamentação aplicável de notificar os titulares de dados e a autoridade de supervisão relevante sobre o Incidente de segurança.

#### 1.3 Devida diligência dos subcontratados e fornecedores.
O GitHub manterá a devida diligência apropriada ao utilizar subcontratados e fornecedores. O GitHub guardará os relatórios de avaliação de fornecedores e qualquer trabalho de avaliação por um período mínimo de três anos.

#### 1.4 Salvaguardas físicas do Centro de Dados.
Na medida em que o GitHub utilize fornecedores terceirizados para hospedar ambientes de produção, ele selecionará os fornecedores que estão em conformidade com os controles de segurança física descritos nos padrões do setor e que emitam um relatório anual de auditoria externa, como a certificação SOC 2 ou ISO 27001. Todo o acesso a áreas, armários ou racks que abriguem telecomunicações, dispositivos de rede e outras "linhas de transmissão de dados" ou equipamentos serão controlados da seguinte forma:

a. o acesso será controlado pelo leitor do crachá em um ou mais pontos de entrada;

b. portas usadas apenas como pontos de saída terão maçaneta de "mão única" ou barra de travamento;

c. todas as portas serão equipadas com contatos do alarme de porta;

d. todas as portas de saída terão capacidade de vigilância por vídeo; e

e. todos os sistemas de vídeo e acesso do cartão serão vinculados aos sistemas de backup do gerador ou UPS.

### 2. Pedidos de informação e relatórios de conformidade.

#### 2.1 Pedidos de informação.
Mediante solicitação por escrito do Cliente e não mais de uma vez por ano, o GitHub responderá a um pedido de informação para avaliar as informações relacionadas ao risco de segurança e conformidade. A resposta será fornecida por escrito no prazo de 30 (trinta) dias a partir do recebimento do pedido, à espera dos esclarecimentos necessários sobre qualquer solicitação.

#### 2.2 Conteúdo da resposta.
O GitHub incluirá em sua resposta anual alguns relatórios de auditoria relevantes para datacenter de produção, IaaS, PaaS ou provedores de hospedagem privados, conforme considerado relevante pelo GitHub, a seu exclusivo critério e com base em dados e serviços prestados.

#### 2.3 Relatório de auditoria de segurança do GitHub.
O GitHub executará auditorias externas para produzir um relatório de auditoria SOC1, tipo 2, e um relatório de auditoria SOC2, tipo 2. O GitHub continuará a executar auditorias e emitirá relatórios correspondentes durante a vigência do Contrato pelo menos uma vez por ano.

### 3. Cooperação com auditorias regulatórias.
Caso o Cliente realize uma auditoria regulatória ou uma auditoria em resposta a uma Autoridade Supervisora que exija a participação do GitHub, este cooperará plenamente com as solicitações relacionadas, fornecendo acesso a profissionais experientes, documentação e software do aplicativo. O cliente tem as seguintes responsabilidades em relação a tais auditorias regulatórias ou de Autoridade de supervisão:

a. O Cliente deve garantir o uso de um terceiro independente (ou seja, o regulador ou o delegado regulador) e que o acesso do Cliente a resultados e dados não relevantes para ele seja impedido.

b. A notificação de tal auditoria deve ser por escrito e fornecida ao GitHub em tempo hábil, aguardando notificação do regulador e de maneira a permitir que o pessoal adequado seja disponibilizado para ajudar. Quando os reguladores não avisarem com antecedência ao Cliente sobre a auditoria ou a investigação, o GitHub responderá no momento adequado, conforme exigido pelos reguladores.

c. Qualquer auditor terceirizado deve divulgar ao GitHub os resultados e as ações recomendadas, quando permitido pelo regulador.

d. No caso de auditoria regulamentar, o acesso será permitido apenas durante o horário comercial normal (Hora do Pacífico).

e. Na medida permitida por lei, o Cliente deve manter como confidencial qualquer informação obtida por meio de qualquer auditoria do GitHub que, por natureza, deva ser confidencial.
