---
title: Diretrizes da comunidade do GitHub
redirect_from:
  - /community-guidelines/
  - /articles/github-community-guidelines
versions:
  free-pro-team: '*'
---

Milhões de desenvolvedores hospedam milhões de projetos no GitHub — tanto código aberto quanto fechado — e temos orgulho de viabilizarmos a colaboração de toda a comunidade todos os dias. Juntos, temos uma empolgante oportunidade e a responsabilidade de tornar esta comunidade algo do qual podemos nos orgulhar.

Usuários do GitHub em todo o mundo trazem perspectivas, ideias e experiências extremamente diferentes, abrangendo desde pessoas que criaram seu primeiro projeto "Olá Mundo" na semana passada até os mais conhecidos desenvolvedores de software do mundo. Estamos empenhados em fazer do GitHub um ambiente acolhedor para todas as diferentes vozes e perspectivas da nossa comunidade, mantendo um espaço onde as pessoas são livres para se expressarem.

Contamos com os membros de nossa comunidade para comunicar expectativas, [moderar](#what-if-something-or-someone-offends-you) seus projetos e {% data variables.contact.report_abuse %} ou {% data variables.contact.report_content %}. Não procuramos ativamente conteúdo para moderar. Explicando o que esperamos ver em nossa comunidade, esperamos ajudá-lo a compreender como colaborar no GitHub, e que tipo de ações ou conteúdo podem violar nossos [Termos de Serviço](#legal-notices). Investigaremos quaisquer denúncias de abuso e podemos moderar o conteúdo público em nosso site que definirmos como violador de nossos Termos de Serviço.

### Criar uma comunidade integrada

A finalidade principal da comunidade do GitHub é colaborar em projetos de software. Queremos que as pessoas trabalhem melhor em conjunto. Embora mantenhamos o site, essa é uma comunidade que construímos *juntos*, e precisamos da sua ajuda para torná-la a melhor possível.

* **Seja bem-vindo e venha com a mente aberta!** - Outros colaboradores podem não ter o mesmo nível de experiência ou o mesmo histórico que você, mas isso não significa que eles não tenham boas ideias para contribuir. Nós o encorajamos a receber com boas-vindas os novos colaboradores e aqueles que acabaram de chegar.

* **Respeitem-se.**  Nada sabota tanto as conversas saudáveis quanto a grosseria. Seja cordial e profissional, e não publique nada que uma pessoa de bom senso considere como discurso ofensivo, abusivo ou de ódio. Não assedie ou constranja ninguém. Trate uns aos outros com dignidade e consideração em todas as interações.

  Você pode querer responder a algo discordando sobre o assunto. Tudo bem. Mas lembre-se de criticar ideias, não pessoas. Evite xingamentos, ataques diretos ad hominem, respondendo ao tom de um post em vez de seu conteúdo real, e reações impulsivas. Em vez disso, forneça contra-argumentos fundamentados que melhorem a conversa.

* **Comunique-se com a empatia** - Discordâncias ou diferenças de opinião são um fato da vida. Fazer parte de uma comunidade significa interagir com pessoas de diversas experiências e perspectivas, muitas das quais podem não ser as mesmas que as nossas. Se você discorda de alguém, tente se colocar no lugar da pessoa antes de se dirigir a ela. Isto promoverá uma atmosfera respeitosa e amigável, onde as pessoas se sentem confortáveis em fazer perguntas, participar de discussões e dar suas contribuições.

* **Seja claro e não fuja do assunto** - As pessoas usam o GitHub para trabalharem e serem mais produtivas. Comentários fora do assunto são uma distração (às vezes, bem-vinda, mas geralmente não) para o trabalho produtivo. Manter-se dentro do assunto ajuda a fomentar debates positivos e produtivos.

   Além disso, comunicar-se com estranhos na internet pode ser desafiador. É difícil comunicar ou ler no tom desejado, e o sarcasmo é frequentemente mal interpretado. Tente usar uma linguagem clara, e pense em como ela será recebida pela outra pessoa.

### E se algo ou alguém ofender você?

Contamos com a comunidade para nos informar quando um problema precisa ser resolvido. Não monitoramos ativamente o site para conteúdo ofensivo. Se você encontrar alguma coisa ou alguém no site que você considere censurável, aqui estão algumas ferramentas que o GitHub fornece para ajudá-lo a agir imediatamente:

* **Comunicar expectativas** - Se você participa de uma comunidade que não definiu as diretrizes específicas para a comunidade, incentive-os a fazê-lo no arquivo README ou [no arquivo CONTRIBUTING](/articles/setting-guidelines-for-repository-contributors/), ou em [um código de conduta dedicado](/articles/adding-a-code-of-conduct-to-your-project/), enviando um pull request.

* **Comentários moderados** - Se você tem [privilégios de acesso de gravação](/articles/repository-permission-levels-for-an-organization/) para um repositório, você pode editar, excluir ou ocultar comentários de qualquer pessoa em commits, pull requests e problemas. Qualquer pessoa com acesso de leitura em um repositório pode visualizar o histórico de edição do comentário. Autores do comentário e pessoas com acesso de gravação a um repositório podem excluir informações confidenciais do histórico de edição de um comentário. Para obter mais informações, consulte "[Rastreando alterações em um comentário](/articles/tracking-changes-in-a-comment)" e "[Gerenciando comentários inconvenientes](/articles/managing-disruptive-comments)".

* **Bloquear conversas** - Se uma discussão em um problema ou pull request fica fora de controle, você pode [bloquear a conversa](/articles/locking-conversations/).

* **Bloquear Usuários** - Se você encontrar um usuário que continua demonstrando um comportamento ruim, você pode [bloquear o usuário de sua conta pessoal](/articles/blocking-a-user-from-your-personal-account/) ou [bloquear o usuário da sua organização](/articles/blocking-a-user-from-your-organization/).

Claro, você sempre pode entrar em contato conosco em {% data variables.contact.report_abuse %} se precisar de mais ajuda para lidar com uma situação.

### O que não é permitido?

Estamos comprometidos em manter uma comunidade onde os usuários são livres para se expressarem e desafiarem as ideias uns dos outros, tanto ideias técnicas como outras. No entanto, essas discussões não promovem diálogos frutíferos quando as ideias são silenciadas porque membros da comunidade estão sendo constrangidos ou têm medo de falar. Isso significa que devemos ser sempre respeitosos e cordiais, e evitarmos atacar os outros com base no que eles são. Não toleramos comportamentos que cruzam os seguintes limites:

* **Ameaças de violência** - Você não pode ameaçar terceiros ou usar o site para organizar, promover ou incitar atos de violência ou terrorismo no mundo real. Pense cuidadosamente sobre as palavras que você usa, as imagens que você publica, e até mesmo o software que você escreve, e como podem ser interpretados pelos outros. Mesmo que pretenda fazer uma piada, isso poderá ser interpretado de outra forma. Se você acha que outra pessoa *pode* interpretar o conteúdo que você postou como uma ameaça, ou como uma promoção da violência ou como terrorismo, pare. Não publique isso no GitHub. Em casos excepcionais, podemos relatar ameaças de violência às autoridades competentes, se acreditarmos que pode haver um risco genuíno de danos físicos ou uma ameaça à segurança pública.

* **Discurso de ódio e discriminação** - embora não seja proibido abordar tópicos como idade, tamanho do corpo, deficiência física, etnia, identidade e expressão de gênero, nível de experiência, nacionalidade, aparência pessoal, raça, religião ou identidade e orientação sexual, não toleramos discursos que ataquem uma pessoa ou um grupo de pessoas com base em quem elas são. Perceba que quando abordados de forma agressiva ou insultante, estes (e outros) tópicos sensíveis podem fazer com que terceiros se sintam indesejados, ou até mesmo vulneráveis. Embora haja sempre o potencial para mal-entendidos, esperamos que os membros da nossa comunidade permaneçam respeitosos e cordiais quando discutirem temas sensíveis.

* **Bullying e assédio** - Não toleramos bullying ou assédio. Isto significa qualquer tipo de insulto ou intimidação habitual dirigida a uma pessoa ou grupo específico de pessoas. Em geral, se suas ações são indesejadas e você continua com o mesmo comportamento, há uma boa chance de você estar praticando bullying ou assédio.

* **Falsidade ideológica** - Você não pode tentar enganar terceiros mentindo sobre sua identidade copiando o avatar de outra pessoa, postando conteúdo com endereço de e-mail de terceiros, usando um nome de usuário semelhante ou apresentando-se como outra pessoa. A falsidade ideológica é uma forma de assédio.

* **Doxxing e invasão de privacidade** - Não publique informações pessoais de outras pessoas, como números de telefone, endereços de e-mail privados, endereços físicos, números de cartão de crédito, números de seguro social/identidade nacional ou senhas. Dependendo do contexto, como no caso de intimidação ou assédio, podemos considerar que outras informações, como fotos ou vídeos que foram tirados ou distribuídos sem o consentimento do indivíduo, constituem invasão da privacidade, especialmente quando esse material representa um risco para a segurança do indivíduo.

* **Conteúdo sexualmente obsceno** - Não publique conteúdo pornográfico. Isto não significa que seja proibida qualquer nudez, ou qualquer código ou conteúdo relacionados com sexualidade. Reconhecemos que a sexualidade faz parte da vida e que o conteúdo sexual não pornográfico pode fazer parte do seu projeto, ou que possa ser apresentado para fins educacionais ou artísticos. Não permitimos conteúdos sexuais obscenos ou conteúdos que possam envolver a exploração ou a sexualização de menores.

* **Conteúdo gratuitamente violento** - Não publique imagens, texto ou outro conteúdo violento sem um contexto razoável ou avisos. Embora muitas vezes não haja problema em incluir conteúdo violento em videogames, boletins e descrições de eventos históricos, não permitimos conteúdos violentos que sejam publicados indiscriminadamente, ou que sejam postados de uma forma que seja difícil evitar ter acesso a eles (como um avatar de perfil ou um comentário de problema). Um aviso claro ou uma declaração em outros contextos ajudam os usuários a tomarem uma decisão sobre se querem ou não se envolver com tal conteúdo.

* **Informação errada e desinformação** - Você não pode postar conteúdo que apresente uma visão distorcida da realidade, seja ela imprecisa ou falsa (informação errada) ou intencionalmente enganosa (desinformação) porque esse conteúdo provavelmente resultará em danos ao público ou interferirá em oportunidades justas e iguais para todos participarem da vida pública. Por exemplo, não permitimos conteúdo que possa colocar o bem-estar de grupos de pessoas em risco ou limitar sua capacidade de participar de uma sociedade livre e aberta. Incentivamos a participação ativa na expressão de ideias, perspectivas e experiências e não se pode estar em posição de disputar contas ou observações pessoais. Geralmente, permitimos paródias e sátiras alinhadas com nossas Políticas de Uso Aceitável, e consideramos o contexto importante na forma como as informações são recebidas e compreendidas; portanto, pode ser apropriado esclarecer suas intenções através de isenções de responsabilidade ou outros meios, bem como a fonte(s) de suas informações.

* **Malware ativo ou exploits** - Fazer parte de uma comunidade inclui não tirar proveito de outros integrantes dela. Não permitimos que ninguém use nossa plataforma para explorar entrega, como por exemplo, usando o GitHub como meio de fornecer maliciosos executáveis, ou como infraestrutura de ataques, ou ainda, organizando ataques de negação de serviço ou gerenciando servidores de comando e controle. No entanto, não proibimos a publicação de código-fonte que poderia ser utilizado para desenvolver malware ou exploits, já que a publicação e distribuição de tal código-fonte tem valor educacional e fornece benefícios para a comunidade de segurança.


### O que acontece se alguém violar as regras?

Há uma variedade de ações que podemos tomar quando um usuário reportar comportamento ou conteúdo inapropriado. Normalmente, depende das circunstâncias exatas de um caso específico. Reconhecemos que, por vezes, as pessoas podem dizer ou fazer coisas inapropriadas por várias razões. Talvez não tenha percebido a forma como suas palavras seriam entendidas. Ou talvez apenas deixam que suas emoções o conduzam. É claro que, muitas vezes, há pessoas que querem apenas fazer spam ou causar problemas.

Cada caso requer uma abordagem diferente e tentamos adaptar a nossa resposta às necessidades da situação que foi comunicada. Vamos avaliar denúncias de abuso caso a caso. Para cada situação, teremos uma equipe diversificada investigando o conteúdo e os fatos envolvidos e responderemos de forma apropriada utilizando estas orientações para guiar nossa decisão.

Ações que podemos fazer em resposta a uma denúncia de abuso incluem, mas não estão limitados a:

* Remoção de Conteúdo
* Bloqueio de Conteúdo
* Suspensão de Conta
* Encerramento da Conta

### Avisos Legais

Colocamos essas Diretrizes da Comunidade em domínio público para que qualquer pessoa use, reutilize, adapte, ou seja o que for, nos termos de [CC0-1.0](https://creativecommons.org/publicdomain/zero/1.0/).

Estas são apenas diretrizes; elas não modificam nossos [Termos de Serviço](/articles/github-terms-of-service/) e não pretendem ser uma lista completa. O GitHub detém total critério conforme os [Termos de Serviço](/articles/github-terms-of-service/#c-acceptable-use) para remover qualquer conteúdo ou cancelar quaisquer contas por atividade que viole os Termos de Uso Aceitável. Estas diretrizes descrevem quando iremos exercer esse critério.
