---
title: Termos Adicionais do Produto GitHub
versions:
  free-pro-team: '*'
---

Quando você cria uma Conta, tem acesso a vários recursos e produtos diferentes que fazem parte do Serviço. Como muitos desses recursos e produtos oferecem diferentes funcionalidades, eles podem exigir termos e condições adicionais específicos para esse recurso ou produto. Abaixo, listamos os recursos e produtos, juntamente com as regras adicionais correspondentes que se aplicam a essas partes do Serviço.

Sua utilização do GitHub está sujeita aos termos aplicáveis (o "Acordo"), bem como aos seguintes Termos Adicionais do Produto GitHub (os "Termos Adicionais"). Ao concordar com o Acordo e usar produtos e recursos adicionais, você também concorda com estes Termos Adicionais. Qualquer violação dos Termos Adicionais é uma violação do Acordo. Os termos em maiúscula não definidos nos Termos Adicionais terão o significado que lhes é atribuído no Acordo.

### 1. Marketplace

Se você listar um Produto do Desenvolvedor através do GitHub Marketplace, deverá concordar com o [Acordo com o Desenvolvedor GitHub Marketplace](/github/site-policy/github-marketplace-developer-agreement), antes de enviar o projeto a ser listado.

Se você comprar Produtos do Desenvolvedor através do GitHub Marketplace, os [Termos de Serviço GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service) controlam sua compra. O Acordo, assim como os [Termos de Serviço GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service), governarão seu uso do GitHub Marketplace.

### 2. Integrações com terceiros

#### a. Criar aplicativos
Se você criar um aplicativo de terceiros ou outro produto de desenvolvedor que colete Informações Pessoais do Usuário ou Conteúdo Gerado pelo Usuário e se integre ao Serviço através da API do GitHub, mecanismo OAuth ou outro ("Produto do Desenvolvedor"), e disponibilizá-lo para outros Usuários , você deve cumprir os seguintes requisitos:
- Você deve cumprir com este Acordo e a Declaração de Privacidade do GitHub.
- Exceto quando permitido de outra forma, como por lei ou por uma licença, você deve limitar o uso das Informações Pessoais do Usuário ou do Conteúdo Gerado pelo Usuário que você coleta para a finalidade para a qual o Usuário autorizou sua coleta.
- Você deve tomar todas as medidas de segurança razoáveis ​​e apropriadas aos riscos, tais como contra a destruição acidental ou ilegal ou perda acidental, alteração, divulgação ou acesso não autorizado, apresentados ao processar as Informações Pessoais do Usuário ou o Conteúdo Gerado pelo Usuário.
- Você não deve coletar Informações Pessoais do Usuário ou Conteúdo Gerado pelo Usuário em nome do GitHub e fornecer aviso suficiente de suas práticas de privacidade ao Usuário, como por exemplo, publicando uma política de privacidade.
- Você deve fornecer aos Usuários um método para excluir quaisquer Informações Pessoais do Usuário ou Conteúdo Gerado pelo Usuário que você coletou através do GitHub depois que elas não forem mais necessárias para os fins limitados e especificados para os quais o Usuário autorizou sua coleta, exceto onde a retenção for exigida por lei ou permitida de outra forma, como por meio de uma licença.

#### b. Usando aplicativos de terceiros
Você pode conceder uma autorização ao Produto do Desenvolvedor para usar, acessar e divulgar o conteúdo de seus repositórios, incluindo seus repositórios particulares. Alguns Produtos de Desenvolvedor estão disponíveis através do [GitHub Marketplace](https://github.com/marketplace). Certos Produtos de Desenvolvedor podem ser usados para executar tarefas automatizadas e, em alguns casos, vários Usuários podem direcionar as ações de um Produto de Desenvolvedor. No entanto, se você comprar e/ou configurar um Produto de Desenvolvedor na sua Conta, ou se você for o proprietário de uma Conta com um Produto de Desenvolvedor integrado, você será responsável pelas ações do Produto de Desenvolvedor que são executadas na ou por meio da sua Conta. Por favor, veja nossa [Declaração de Privacidade](/github/site-policy/github-privacy-statement#third-party-applications) para mais informações sobre como compartilhar dados com os Produtos de Desenvolvedor.

**O GitHub não dá nenhuma garantia de qualquer tipo em relação a Produtos de Desenvolvedor e não é responsável por divulgações a terceiros que você tenha autorizado a acessar Seu Conteúdo. Seu uso de qualquer aplicativo de terceiros é de inteira responsabilidade sua.**

### 3. Suporte Git LFS

Se você ativar o Git Large File Storage ("Git LFS") em sua Conta, poderá buscar, modificar e enviar arquivos grandes exatamente como seria de esperar com qualquer arquivo gerenciado pelo Git. Sua Conta vem com uma certa quantidade de largura de banda e armazenamento para uso com o Git LFS, que pode ser encontrado na [documentação Git LFS](/github/managing-large-files/about-storage-and-bandwidth-usage). O uso da largura de banda e do armazenamento Git LFS é exibido dentro de suas [configurações de conta](https://github.com/settings/billing). Se você deseja usar o Git LFS além da largura de banda e armazenamento alocados, você pode [comprar pacotes de dados adicionais](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage).

### 4. Pages

Cada Conta GitHub vem com acesso a [serviços de hospedagem estática do GitHub Pages](/github/working-with-github-pages/about-github-pages). Este serviço de hospedagem destina-se a hospedar páginas da web estáticas para todos os Usuários, mas principalmente, como uma vitrine para projetos pessoais e organizacionais. Alguns esforços de monetização são permitidos no Pages, como botões de doação e links para crowdfunding.

O GitHub Pages está sujeito a limites específicos de uso e largura de banda e pode não ser apropriado para alguns usos elevados de largura de banda ou outros usos proibidos. Consulte nossas [diretrizes do GitHub Pages](/github/working-with-github-pages/about-github-pages) para obter mais informações. O GitHub se reserva o direito de recuperar qualquer subdomínio GitHub sem responsabilidade.

### 5. Ações e Pacotes

#### a. Uso das Ações
As Ações GitHub permitem criar fluxos de trabalho personalizados do ciclo de vida de desenvolvimento de softwares diretamente no seu repositório GitHub. Cada Conta vem com quantidades de computação e armazenamento incluídas para uso com Ações, dependendo do seu plano de conta, que podem ser encontradas na [documentação de Ações](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions). O uso de computação de suas Ações está disponível em [suas configurações de Conta](https://github.com/settings/billing), e você será notificado por e-mail antes de atingir o limite das quantidades incluídas. Se você deseja usar ações além das quantidades incluídas, poderá [permitir excedentes](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions).

O uso da computação para quantidades incluídas e pagas é calculado em minutos, com base no tipo de Ações que você executa (por exemplo, Linux, Windows, macOS). Os minutos usados ​​para cada trabalho ou tarefa da Ação serão arredondados para o minuto mais próximo. Para quantidades incluídas e dependendo do tipo de Ação, um multiplicador pode ser aplicado à quantidade de tempo usada para executar cada tarefa ou trabalho, antes de ser arredondada para o minuto mais próximo. Minutos excedentes são cobrados na [base de preço por minuto](https://github.com/features/actions) nos tipos de Ações que você executa. Ações e Pacotes compartilham armazenamento e seu uso de armazenamento é mostrado nas [configurações de conta](https://github.com/settings/billing). Para obter detalhes adicionais sobre os cálculos de uso da quantidade, consulte a [documentação de Ações](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions).

Ações e quaisquer elementos do serviço de Ação não podem ser usados ​​em violação ao Acordo, à [Política de Uso Aceitável](/github/site-policy/github-acceptable-use-policies), ou às [limitações de serviço](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits) das Ações do GitHub. Além disso, as Ações não devem ser usadas para:
- mineração de criptomoedas;
- usar nossos servidores para interromper ou ganhar ou tentar ganhar acesso não autorizado a qualquer serviço, dispositivo, dados, conta ou rede (a menos que autorizado pelo [programa GitHub Bug Bounty](https://bounty.github.com))
- fornecimento de um aplicativo ou serviço independente ou integrado que ofereça Ações ou quaisquer elementos de Ações para fins comerciais;
- qualquer atividade que coloque um peso em nossos servidores, em que esse peso é desproporcional aos benefícios oferecidos aos usuários (por exemplo, não usar Ações como uma rede de entrega de conteúdo ou como parte de um aplicativo sem servidor, mas uma Ação de baixo benefício pode ser realizada se também tiver um peso baixo); ou
- qualquer outra atividade não relacionada à produção, teste, implantação ou publicação do projeto de software associado ao repositório onde as Ações do GitHub são usadas.

Para evitar violações dessas limitações e abuso de Ações do GitHub, o GitHub pode monitorar seu uso das Ações do GitHub. O uso indevido de Ações do GitHub pode resultar no encerramento de trabalhos ou restrições na sua capacidade de usar as Ações do GitHub.

#### b. Uso do pacotes
Os Pacotes GitHub podem ser usados ​​para baixar, publicar e gerenciar pacotes de Conteúdo. Cada plano de Conta vem com uma largura de banda e quantidade de armazenamento incluídos para o uso com Pacotes, que podem ser encontrados na [documentação dos Pacotes](/github/managing-packages-with-github-package-registry/about-github-package-registry). Ações e Pacotes compartilham o armazenamento entre dois recursos de Serviço. O armazenamento e o uso da largura de banda são exibidos dentro de suas [configurações de conta](https://github.com/settings/billing), e você será notificado por e-mail antes de atingir o limite de suas quantidades incluídas. Se você quiser usar Pacotes além de suas quantidades de largura de banda e armazenamento incluídos, então você pode [permitir excedentes](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages).

O uso da largura de banda é calculado com base na quantidade de dados transferidos de seus repositórios por meio de Pacotes, mas as transferências de pacote por meio de Ações não contarão para suas quantidades incluídas ou pagas. O uso da largura de banda dos pacotes é limitado pela [Política de Uso Aceitável](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use), e a quantidade de largura de banda incluída é determinada por seu [plano de Conta](https://github.com/pricing).

O uso de armazenamento pelas Ações e Pacotes é compartilhado entre os dois recursos de Serviço. O uso do armazenamento é calculado como uma média ponderada ao longo do mês e não é redefinido a cada mês. Os repositórios públicos e privados têm diferentes quantidades de armazenamento incluídas, e as quantidades incluídas para repositórios privados dependem de seu [plano de Conta](https://github.com/pricing).

#### c. Pagamento e Faturamento para Ações e Pacotes
O faturamento de Ações e Pacotes é baseado no uso. Quantidades adicionais de Ações ou Pacotes não podem ser adquiridos separadamente.  Para clientes com cobrança mensal, é necessário ter um método de pagamento registrado para optar por pagar por quantidades adicionais desses recursos do Serviço. Você será cobrado mensalmente, com base no seu uso no mês anterior, a menos que seja cobrado por fatura. Para clientes faturados, você deve pagar as taxas no prazo de trinta (30) dias a contar da data da fatura do GitHub. Para os clientes que pagam antecipadamente os excedentes dos recursos de Serviço, os minutos pré-pagos não utilizados não serão transferidos para o próximo período de cobrança e não serão reembolsados.

Você pode definir um limite mensal de gastos em suas [configurações de conta](https://github.com/settings/billing/cost_management). Você será notificado por e-mail antes de atingir o limite das quantidades incluídas e o limite de gastos designado das suas quantidades adicionais pagas.

### 6. Learning Lab

**Inscrição.** Para concluir a inscrição no Learning Lab para Organizações, você concorda em criar uma organização separada para fins do Learning Lab, e nos autoriza a adicionar materiais de curso do Learning Lab a essa organização em seu nome.

**Materiais do Curso Learning Lab**. Quaisquer materiais do curso que o GitHub fornecer será propriedade exclusiva do GitHub, contanto que o GitHub conceda a você uma licença mundial não exclusiva, não transferível, de prazo limitado e isenta de royalties para copiar, manter, utilizar e executar esses materiais do curso para fins comerciais internos, associados ao uso do Learning Lab. Essa concessão de licença está sujeita a qualquer contrato de licenciamento de código aberto que possa ser fornecido junto com o código-fonte.  Os materiais de curso que você cria são de sua propriedade exclusiva, desde que você conceda ao GitHub uma licença mundial, não exclusiva, perpétua, intransferível, livre de royalties para copiar, manter, usar, hospedar e executar (conforme aplicável) no Serviço, tais materiais do curso. Seu uso de materiais de curso do GitHub e sua criação e armazenamento de materiais de seu próprio curso não representam propriedade conjunta da respectiva propriedade intelectual de uma das partes pela outra.

**Privacidade.** O Learning Lab pode coletar informações pessoais. Você controla quais informações o Learning Lab coleta em seu painel de configurações de perfil GitHub.com. Se o Learning Lab coletar informações pessoais em nome do GitHub, o GitHub processará essas informações de acordo com a [Declaração de Privacidade do GitHub](/github/site-policy/github-privacy-statement). Se você se inscrever ou estiver concluindo um curso privado através do Learning Lab, o GitHub poderá compartilhar suas informações de matrícula e progressão no curso até a conclusão com os administradores da organização. Isso pode incluir dados individuais, como seu nome de usuário GitHub, data de início do curso e data de término do curso. Os dados de conclusão do curso também podem ser apresentados de forma agregada para ajudá-lo a orientar melhorias no conteúdo do curso.

### 7. Connect

Para acessar o GitHub Connect, o Cliente deve ter pelo menos 01 (uma) conta no GitHub.com e 01 (uma) instância licenciada do Software. O GitHub Connect pode ser usado para executar tarefas automatizadas. Além disso, vários Usuários podem direcionar determinadas ações com o GitHub Connect. O Cliente é responsável pelas ações realizadas em suas contas ou por meio delas. O GitHub pode coletar informações sobre o modo como o Cliente usa o GitHub Connect para fornecer e aprimorar o recurso. Ao usar o GitHub Connect, o Cliente autoriza o GitHub a coletar dados protegidos, que incluem dados de Repositório privado e Informações pessoais do usuário (conforme definido na Declaração de privacidade do GitHub), na conta do GitHub Enterprise Server do Cliente. O Cliente também autoriza a transferência de informações de instância de identificação para o GitHub por meio do GitHub Connect, cujas informações são regidas pela Declaração de privacidade do GitHub.

### 8. Programa Sponsors

Para se tornar um Desenvolvedor Patrocinado, você deve concordar com os [Termos Adicionais do Programa GitHub Sponsors](/github/site-policy/github-sponsors-additional-terms).

### 9. Segurança Avançada GitHub

A Segurança Avançada GitHub permite identificar vulnerabilidades de segurança por meio de análise de código semântica personalizável e automatizada. A Segurança Avançada GitHub é licenciada na base por usuário. Se você está usando a Segurança Avançada GitHub como parte do GitHub Enterprise Cloud, muitos recursos da Segurança Avançada GitHub, incluindo a varredura automatizada de códigos de repositórios privados, também exigem o uso das GitHub Actions. O faturamento para o uso das GitHub Actions é baseado no uso e está sujeito aos [Termos das GitHub Actions](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages).

### 10. Dependabot Preview

O uso de seu Dependabot Preview é regido por [Termos de Serviço](https://dependabot.com/terms) e [Política de Privacidade](https://dependabot.com/privacy) separados.

### 11. Spectrum

O seu uso do Spectrum é regido por [Termos de Serviço](/github/site-policy/github-terms-of-service) e [Declaração de Privacidade](/github/site-policy/github-privacy-statement) do GitHub.

### 12. Banco de Dados Consultivo

#### a. Concessão de licença para nós

Precisamos do direito de submeter suas contribuições para o Banco de Dados Consultivo do GitHub a conjuntos de dados de domínio público, como a [Base de Dados de Vulnerabilidade Nacional](https://nvd.nist.gov/) e licenciar o Banco de Dados Consultivo do GitHub, sob termos abertos, para uso de pesquisadores de segurança, comunidade de código aberto, setor industrial e o público em geral. Você concorda em lançar suas contribuições no Banco de Dados Consultivo do GitHub sob a [licença Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/).

#### b. Licença para o Banco de Dados Consultivo GitHub

O Banco de Dados Consultivo GitHub está licenciado sob a [licença 4.0 Creative Commons Attribution](https://creativecommons.org/licenses/by/4.0/). O termo de atribuição pode ser cumprido linkando para o Banco de Dados Consultivo do GitHub em <https://github.com/advisories> ou para registros individuais do Banco de Dados Consultivo do GitHub usado e prefixado por <https://github.com/advisories>.

