---
title: Políticas de uso aceitável do GitHub
redirect_from:
  - /articles/github-acceptable-use-policies
versions:
  free-pro-team: '*'
---

**Versão curta:** _hospedamos uma ampla variedade de projetos colaborativos de todo o mundo, e essa colaboração só funciona quando todos os nossos usuários conseguem trabalhar juntos de boa fé. Ao usar o Serviço, você deve estar de acordo com nossas Políticas de Uso Aceitável, que inclui algumas restrições sobre o conteúdo que você pode publicar, conduta no serviço e outras limitações. Em resumo, sejam excelentes uns com os outros._

Termos com iniciais em letras maiúsculas, mas não definidos nestas Políticas de Uso Aceitável, têm o significado atribuído a eles em nossos [Termos de serviço](/articles/github-terms-of-service), [Termos de serviço corporativos](/articles/github-corporate-terms-of-service) e [Declaração de privacidade](/articles/github-privacy-statement). Para clientes sujeitos aos [Termos de serviço corporativos](/articles/github-corporate-terms-of-service), "você", "seu(sua)" e "seus(suas)" referem-se ao "Cliente" ou "Usuários". "Nós", "nos", "nosso(a)", "nossos(as)" referem-se ao "GitHub".

### 1. Cumprimento de leis e regulamentos
Você é responsável por usar o Serviço em conformidade com as leis aplicáveis, regulamentos e todas as nossas Políticas de Uso Aceitável. Essas políticas podem ser atualizadas periodicamente e estão dispostas abaixo, assim como em nossos [Termos de serviço](/articles/github-terms-of-service) e [Termos de serviço corporativos](/articles/github-corporate-terms-of-service).

### 2. Restrições de conteúdo
Em nenhuma circunstância, os Usuários farão upload, publicarão, hospedarão, executarão ou transmitirão qualquer Conteúdo para quaisquer repositórios que:

- seja ilegal ou promova atividades ilegais;

- seja ou tenha conteúdo sexualmente obsceno;

- seja injurioso, difamatório ou fraudulento;

- seja discriminatório ou abusivo contra qualquer indivíduo ou grupo;

- gratuitamente represente ou exalte a violência, inclusive imagens violentas;

- seja ou contenha informações falsas, imprecisas ou intencionalmente enganosas que provavelmente afetarão negativamente o interesse público (incluindo saúde, segurança, integridade eleitoral e participação cívica);

- contenha ou instale qualquer vírus de computador, ou explore ou use nossa plataforma para explorar a entrega (como uma parte de um comando ou sistema de controle); ou

- infrinja qualquer direito de propriedade de qualquer parte, incluindo patentes, marcas comerciais, segredos comerciais, direitos autorais, direito de publicidade ou outros direitos.

### 3. Restrições de conduta
Ao usar o Serviço, em nenhuma circunstância você irá:

- assediar, abusar, ameaçar ou incitar a violência contra qualquer indivíduo ou grupo, incluindo nossos funcionários, dirigentes e agentes ou outros usuários;

- usar nossos servidores para qualquer forma de atividade em massa automatizada excessiva (por exemplo, envio de spams ou mineração de criptomoeda), sobrecarregar indevidamente nossos servidores por meios automatizados, ou transmitir qualquer outra forma de publicidade ou demanda não solicitada por meio de nossos servidores, como esquemas do tipo enriqueça rápido;

- usar nossos servidores para interromper ou tentar interromper, ou ganhar ou tentar ganhar acesso não autorizado a qualquer serviço, dispositivo, dados, conta ou rede (a menos que autorizado pelo [programa GitHub Bug Bounty](https://bounty.github.com));

- representar qualquer pessoa ou entidade, inclusive quaisquer de nossos funcionários ou representantes, incluindo por meio de falsa associação ao GitHUb ou por adulterar fraudulentamente sua identidade ou propósito do site; ou

- violar a privacidade de qualquer terceiro, como publicar informações pessoais de outra pessoa sem consentimento.

### 4. Limites de uso dos serviços
Você não reproduzirá, duplicará, copiará, venderá, revenderá ou explorará qualquer parte do Serviço, uso do Serviço ou acesso ao Serviço sem nossa permissão expressa por escrito.

### 5. Restrições de scraping (raspagem) e uso da API
Scraping refere-se à extração de dados de nosso Serviço por meio de um processo automatizado, como um bot ou rastreador web (webcrawler). Não se refere à coleta de informações por meio de nossa API. Por favor, consulte a Seção H de nossos [Termos de Serviço](/articles/github-terms-of-service#h-api-terms) para nossos Termos da API. Você pode raspar o site pelos seguintes motivos:

- Pesquisadores podem raspar informações públicas e não pessoais do Serviço para fins de pesquisa, somente se quaisquer publicações resultantes da pesquisa forem de acesso aberto.
- Arquivistas podem raspar o Serviço para dados públicos com fins de arquivo.

Você não poderá raspar o Serviço para fins de envio de spams, inclusive com propósito de vender Informações Pessoais do Usuário (como definido na [Declaração de privacidade do GitHub](/articles/github-privacy-statement)) para, por exemplo, recrutadores, headhunters e anúncios de empregos.

Todo uso de dados coletados por meio de scraping (raspagem) devem estar de acordo com a [Declaração de privacidade do GitHub](/articles/github-privacy-statement).

### 6. Privacidade
Uso indevido de Informações Pessoais é proibido.

Qualquer pessoa, entidade ou serviço que colete dados do Serviço deve estar em conformidade com a [Declaração de privacidade do GitHub](/articles/github-privacy-statement), especialmente no que diz respeito à coleta de Informações Pessoais do Usuário. Se você coletar qualquer Informação Pessoal do Usuário a partir do Serviço, você concorda que somente usará essa Informação Pessoal do Usuário para os fins autorizados pelo usuário. Você concorda que protegerá de forma razoável qualquer Informação Pessoal do Usuário que você coletou do Serviço, e que você responderá prontamente a reclamações, solicitações de remoção e solicitações de "não contatar" nossas e de outros usuários.

### 7. Uso excessivo da largura de banda
As limitações de largura de banda do Serviço variam com base nos recursos que você usa. Se constatarmos que seu uso de largura de banda é significativamente excessivo em relação a outros usuários com recursos similares, reservamos o direito de suspender sua Conta, reduzir a hospedagem de seu arquivo ou até mesmo limitar sua atividade até que você possa reduzir seu consumo de largura de banda. Também reservamos o direito — depois de fornecer aviso prévio — de excluir repositórios que avaliamos estar colocando pressão indevida em nossa infraestrutura. Para obter orientação sobre o uso aceitável do armazenamento de objetos em repositórios, consulte "[Qual é a minha cota de disco?](/github/managing-large-files/what-is-my-disk-quota)". Para obter mais detalhes sobre as limitações de largura de banda de recursos específicos, consulte os [Termos Adicionais do Produto GitHub](/github/site-policy/github-additional-product-terms).

### 8. Advertising on GitHub
**Versão reduzida:***Geralmente não proibimos o uso do GitHub para publicidade. No entanto, esperamos que nossos usuários sigam certas limitações, de forma que o GitHub não se torne um paraíso do spam. Ninguém quer isso.*

Embora entendamos que você pode querer promover seu Conteúdo publicando nomes de patrocinadores ou logotipos em sua Conta, o foco principal do Conteúdo postado em ou através de sua Conta para o Serviço não deve ser a publicidade ou o marketing promocional. Isto inclui Conteúdo publicado em ou através de Pages, pacotes, repositórios e todas as outras partes do Serviço. Você pode incluir imagens estáticas, links e texto promocional nos documentos LEIAME ou seções de descrição do projeto associadas à sua Conta, mas eles devem estar relacionados ao projeto que você está hospedando no GitHub. Você não pode fazer propaganda em Contas de outros Usuários, por exemplo, postando conteúdo em massa excessivo ou monetizado em "problemas".

Você não pode promover ou distribuir conteúdo ou atividade ilegal ou proibida por nossos [Termos de Serviço](/github/site-policy/github-terms-of-service/), [Diretrizes da Comunidade](/github/site-policy/github-community-guidelines/), ou [Política de Uso Aceitável](/github/site-policy/github-acceptable-use-policies/), incluindo a atividade em massa excessiva automatizada (por exemplo, spamming), esquemas do tipo fique rico rápido e erros de representação ou armadilhas relacionados com sua promoção.

Se você decidir postar quaisquer materiais promocionais em sua Conta, você é o único responsável por cumprir todas as leis e regulamentos aplicáveis, inclusive, sem limitações, as Diretrizes da Comissão Federal de Comércio dos EUA sobre Endossos e Depoimentos. Federal Trade Commission's Guidelines on Endorsements and Testimonials. Nós nos reservamos o direito de remover quaisquer materiais promocionais ou anúncios que, a nosso exclusivo critério, violem quaisquer termos ou políticas do GitHub.

### 9. Spam e Atividade Inautêntica no GitHub
Atividade em massa excessiva automatizada e atividade coordenada inautêntica, como spamming, são proibidas no GitHub. As atividades proibidas incluem:
* distribuição em massa de promoções e publicidade proibida pelos termos e políticas do GitHub
* interações inautênticas, como contas falsas e atividade inautêntica automatizada
* abuso de classificação, como estrelas ou following automatizados
* criação ou participação em mercados secundários para efeitos da proliferação de atividades inautênticas
* usar o GitHub como uma plataforma para disseminar abusos em outras plataformas
* phishing ou tentativa de phishing

O GitHub reserva-se o direito de remover qualquer Conteúdo que viole essa política.

### 10. Proteção do usuário
Você não deve se envolver em atividades que prejudicam significativamente outros usuários. Resolveremos disputas em favor da proteção dos usuários como um todo.
