---
title: Política de retirada DMCA
redirect_from:
  - /dmca/
  - /dmca-takedown/
  - /dmca-takedown-policy/
  - /articles/dmca-takedown/
  - /articles/dmca-takedown-policy
versions:
  free-pro-team: '*'
---

Bem-vindo ao Guia do GitHub para a Lei dos Direitos Autorais do Milênio Digital, comumente conhecida como "DMCA" - Digital Millenium Copyright Act Policy. Esta página não tem a finalidade de ser uma cartilha abrangente sobre o regimento. No entanto, se você recebeu um aviso de retirada DMCA direcionado ao conteúdo que você postou no GitHub, ou se você é um detentor de direitos que pretende enviar tal aviso, esta página vai ajudá-lo a desmistificar a lei, bem como nossas políticas relacionadas.

(Se deseja somente enviar um aviso, você pode [pular para o final](#f-submitting-notices).)

Como em todas as questões jurídicas, é sempre melhor consultar um profissional sobre suas dúvidas ou situação específica. Incentivamos a fazê-lo antes de tomar quaisquer medidas que possam impactar seus direitos. Este guia não é um aconselhamento jurídico e não deve ser tomado como tal.

### O que é DMCA?

Para compreender a DMCA e algumas das linhas políticas que ela traça, talvez seja útil considerar a vida antes de ela ser promulgada.

A DMCA fornece um porto seguro para fornecedores de serviços que hospedam conteúdo gerado pelos usuários. Uma vez que, mesmo uma única denúncia de violação de direitos autorais pode acarretar indenização de até 150.000 dólares, a possibilidade de ser responsabilizado por conteúdos gerados por usuários pode ser muito prejudicial para os prestadores de serviços. Com potenciais danos multiplicados por milhões de usuários, a computação em nuvem e os sites de conteúdo gerados pelo usuário, tais como YouTube, Facebook ou o GitHub, provavelmente [nunca teriam existido](https://arstechnica.com/tech-policy/2015/04/how-the-dmca-made-youtube/) sem a DMCA (ou, pelo menos, sem passar alguns desses custos aos seus usuários).

A DMCA resolve esse problema criando um [porto seguro de responsabilidade por direitos autorais](https://www.copyright.gov/title17/92chap5.html#512) para provedores de serviços de internet que hospedam conteúdo gerado por usuários que, supostamente, estejam infringindo esses direitos. Em resumo, enquanto um provedor de serviços seguir as regras de notificação e retirada DMCA, ele não será responsabilizado por violações de direitos autorais com base no conteúdo gerado pelo usuário. Por isso, é importante que o GitHub mantenha seu status de porto seguro DMCA.

### Avisos DMCA em poucas palavras

A DMCA fornece dois procedimentos simples e objetivos que todos os usuários do GitHub devem conhecer: (i) um procedimento de [aviso de retirada](/articles/guide-to-submitting-a-dmca-takedown-notice) para que os titulares de direitos autorais solicitem que o conteúdo seja removido; e (ii) um procedimento de [contra-aviso de retirada](/articles/guide-to-submitting-a-dmca-counter-notice) para que os usuários possam ter seu conteúdo reativado quando o mesmo tiver sido retirado por erro ou identificação incorreta.

Os [avisos de retirada](/articles/guide-to-submitting-a-dmca-takedown-notice) DMCA são utilizados por proprietários de direitos autorais para solicitar ao GitHub a retirada de conteúdo que eles acreditam estar infringindo esses direitos. Se você é um desenvolvedor ou designer de software, você cria conteúdo protegido por direitos autorais todos os dias. Se outra pessoa estiver utilizando seus conteúdos protegidos por direitos autorais de forma não autorizada no GitHub, você poderá enviar-nos um aviso de retirada DMCA para solicitar que o conteúdo inapropriado seja alterado ou removido.

Por outro lado, [contra-avisos de retirada](/articles/guide-to-submitting-a-dmca-counter-notice) podem ser usados para corrigir erros. Talvez a pessoa que enviou o aviso de retirada não tenha direitos autorais ou não tenha percebido que você tem uma licença ou tenha cometido algum outro erro na notificação emitida. Considerando que o GitHub geralmente não sabe se houve um erro, o contra-aviso de retirada de conteúdo DMCA permite que você nos avise e peça que coloquemos o conteúdo de volta.

O processo de aviso e retirada DMCA deve ser utilizado apenas para queixas relativas a violações dos direitos autorais. Os avisos enviados através do nosso processo DMCA devem identificar a obra ou o trabalho protegido por direitos autorais que estejam alegadamente sendo violados. O processo não pode ser utilizado para outras queixas, tais como reclamações sobre alegada [violação de marca registrada](/articles/github-trademark-policy/) ou [dados confidenciais](/articles/github-sensitive-data-removal-policy/); oferecemos processos separados para essas situações.

### A. Como realmente funciona?

A abordagem DMCA é um pouco como trocar bilhetinhos em sala de aula. O proprietário dos direitos autorais faz uma reclamação ao GitHub sobre um usuário. Se estiver escrito corretamente, passamos a reclamação para o usuário. Se o usuário discordar da reclamação, pode devolver uma notificação dizendo os motivos. O GitHub atua pouco no processo, determinando se as notificações atendem aos requisitos mínimos da DMCA. Cabe às partes (e aos seus advogados) avaliar o mérito das suas reivindicações, tendo em conta que os avisos devem ser feitos corretamente sob pena de perjúrio.

Aqui estão os passos básicos do processo.

1. **O proprietário dos direitos autorais faz uma investigação.** O proprietário dos direitos autorais deve sempre realizar uma investigação inicial para confirmar que (a) possui os direitos autorais de uma obra original e (b) o conteúdo no GitHub não é autorizado e viola direitos. Isso inclui a confirmação de que o uso não está protegido como [uso justo](https://www.lumendatabase.org/topics/22). Um determinado uso pode ser considerado justo se utilizar apenas uma pequena quantidade de conteúdo com direitos autorais, se utilizar esse conteúdo de forma transformada, se usá-lo para fins educacionais, ou alguma combinação do exposto acima. Como o código se presta naturalmente a tais usos, cada caso de utilização é diferente, e deve ser considerado separadamente.
> **Exemplo:** Um funcionário da Acme Web Company encontra algum código da empresa em um repositório GitHub. A Acme Web licencia seu código-fonte para vários parceiros confiáveis. Antes de enviar um aviso de retirada, a Acme deve revisar essas licenças e seus acordos para confirmar que o código no GitHub não está autorizado sob nenhuma delas.

2. **O proprietário dos direitos autorais envia um aviso.** Depois de realizar uma investigação, o proprietário dos direitos autorais se prepara e envia um [aviso de retirada](/articles/guide-to-submitting-a-dmca-takedown-notice) ao GitHub. Considerando que a notificação recebida seja suficientemente detalhada, de acordo com as exigências estatutárias (conforme explicado no [guia de como fazer](/articles/guide-to-submitting-a-dmca-takedown-notice)), iremos [postar o aviso](#d-transparency) em nosso [repositório público](https://github.com/github/dmca) e passar o link para o usuário afetado.

3. **O GitHub solicita que o Usuário faça Alterações.** Se a notificação alegar que todo o conteúdo de um repositório ou um pacote estão cometendo violações, pularemos para a Etapa 6 e desabilitaremos todo o repositório ou pacote de forma rápida. Caso contrário, como o GitHub não pode desabilitar o acesso a arquivos específicos dentro de um repositório, entraremos em contato com o usuário que criou o repositório e daremos aproximadamente 1 dia útil para que ele exclua ou modifique o conteúdo especificado na notificação. Nós notificaremos o proprietário dos direitos autorais se e quando dermos ao usuário a chance de fazer alterações. Porque os pacotes são imutáveis, se apenas parte de um pacote estiver sendo infringido, o GitHub deverá desabilitar todo o pacote. No entanto, permitimos a reposição uma vez que a parte infração seja removida.

4. **O usuário notifica o GitHub sobre as alterações.** Se o usuário escolher fazer as alterações especificadas, ele *deve* nos informar dentro de, aproximadamente, 1 dia útil. Caso contrário, desativaremos o repositório (como descrito na Etapa 6). Se o usuário nos notificar que fez as alterações, verificaremos se as alterações foram realmente feitas e, em seguida, notificaremos o detentor dos direitos autorais.

5. **O proprietário dos direitos autorais revisa ou retira o aviso.** Se o usuário fizer mudanças, o proprietário dos direitos autorais deve revisá-las e reenviar ou revisar seu aviso de retirada, caso as alterações sejam insuficientes. O GitHub não tomará nenhuma outra ação a não ser que o proprietário dos direitos autorais entre em contato conosco para refazer o aviso original de retirada ou enviar uma versão revisada. Se o proprietário dos direitos autorais estiver satisfeito com as mudanças, ele pode enviar uma retratação formal ou não fazer nada. O GitHub interpretará o silêncio por mais de duas semanas como uma retratação implícita do aviso de retirada.

6. **O GitHub pode desativar o acesso ao conteúdo.** O GitHub irá desativar o conteúdo de um usuário se: (i) o titular dos direitos autorais tem alegados direitos autorais sobre todo o repositório ou pacote do usuário (conforme mencionado na Etapa 3); (ii) o usuário não fez nenhuma alteração depois de ter sido dada a oportunidade de fazê-la (conforme mencionado na Etapa 4); ou (ii) o proprietário dos direitos autorais renovou o seu aviso de retirada depois que o usuário teve a chance de fazer alterações. Se, em vez disso, o proprietário dos direitos autorais escolher *revisar* o aviso, voltaremos à Etapa 2 e repetiremos o processo como se o aviso revisado fosse uma nova notificação.

7. **O usuário pode enviar um contra-aviso de retirada.** Encorajamos usuários com conteúdo desabilitado a consultar um advogado sobre as opções que possui. Se um usuário acredita que seu conteúdo foi desabilitado como resultado de um erro ou identificação incorreta, ele pode nos enviar um [contra-aviso de retirada](/articles/guide-to-submitting-a-dmca-counter-notice). Como na notificação original, garantiremos que o contra-aviso seja suficientemente detalhado (conforme explicado no [guia prático](/articles/guide-to-submitting-a-dmca-counter-notice)). Se estiver, vamos [postá-lo](#d-transparency) em nosso [repositório público](https://github.com/github/dmca) e passar o aviso de volta para o proprietário dos direitos autorais, enviando o link para ele.

8. **O proprietário dos direitos autorais pode entrar com uma ação legal.** Se um proprietário de direitos autorais deseja manter o conteúdo desativado após receber um contra-aviso, ele precisará entrar com uma ação judicial em busca de uma ordem da justiça para evitar que o usuário se envolva em infração à atividade relacionada ao conteúdo no GitHub. Em outras palavras, você pode processar. Se o proprietário dos direitos autorais não der um aviso ao GitHub dentro de 10-14 dias, enviando uma cópia de uma reclamação legal válida apresentada em tribunal competente, o GitHub reativará o conteúdo desabilitado.

### B. O que significa Bifurcação? (ou O que é uma Bifurcação?)

Um dos melhores recursos do GitHub é a possibilidade de os usuários "bifurcarem" repositórios uns dos outros. O que isso significa? Basicamente, isso significa que os usuários podem fazer uma cópia de um projeto no GitHub em seus próprios repositórios. Conforme a licença ou a lei permitirem, os usuários podem fazer alterações nessa bifurcação para ou fazer push de volta para o projeto principal ou simplesmente manter como sua própria variação de um projeto. Cada uma dessas cópias é uma "[bifurcação](/articles/github-glossary#fork)" do repositório original que, por sua vez, também pode ser chamado de "principal" da bifurcação.

O GitHub *não* irá desabilitar bifurcações automaticamente quando desabilitar um repositório principal. Isto ocorre porque as bifurcações pertencem a diferentes usuários, podem ter sido alteradas de maneira significativa e podem ser licenciadas ou utilizadas de uma forma diferente que seja protegida pela doutrina do uso justo. O GitHub não realiza nenhuma investigação independente sobre as bifurcações. Esperamos que os titulares de direitos autorais façam essa investigação e, se acreditarem que as bifurcações também estão violando direitos, incluam expressamente as bifurcações no seu aviso de retirada.

### C. E se eu, inadvertidamente, deixar passar o período para fazer as alterações?

Reconhecemos que há muitas razões válidas para que você possa não conseguir fazer alterações dentro da janela aproximada de 1 dia útil que fornecemos antes que seu repositório seja desativado. Talvez a nossa mensagem tenha sido sinalizada como spam, talvez você estivesse de férias, talvez você não verifique essa conta de e-mail regularmente, ou talvez você estivesse apenas ocupado. Nós entendemos isso. Se você responder para nos informar que gostaria de ter feito as alterações, mas de alguma forma perdeu a primeira oportunidade, reativaremos o repositório por um tempo adicional de aproximadamente 1 dia útil para permitir que você faça as alterações. Novamente, você deve nos notificar que fez as alterações para manter o repositório ativo após essa janela de 1 dia útil, conforme mencionado acima na [Etapa A.4](#a-how-does-this-actually-work). Por favor, note que só forneceremos esta chance adicional.

### D. Transparência

Acreditamos que a transparência é uma virtude. O público deve saber qual conteúdo está sendo removido do GitHub e por quê. Um público informado pode notar e supervisionar problemas potenciais que, de outra forma, passariam despercebidos num sistema obscuro. Publicamos cópias com conteúdo pessoal suprimido de quaisquer avisos legais que recebamos (incluindo avisos originais, contra-avisos ou retratações) em <https://github.com/github/dmca>. Não tornaremos públicas suas informações de contato pessoais; removeremos informações pessoais (exceto nomes de usuários nas URLs) antes de publicar avisos. No entanto, não iremos suprimir quaisquer outras informações do seu aviso, a menos que nos solicite especificamente que o façamos. Aqui estão alguns exemplos de um [aviso](https://github.com/github/dmca/blob/master/2014/2014-05-28-Delicious-Brains.md) publicado e um [contra-aviso](https://github.com/github/dmca/blob/master/2014/2014-05-01-Pushwoosh-SDK-counternotice.md) para você ver como eles são. Quando removermos o conteúdo, publicaremos no seu lugar um link para o aviso relacionado.

Note também que, embora não divulguemos publicamente avisos sem a exclusão de dados pessoais, podemos fornecer uma cópia completa sem conteúdo suprimido de qualquer aviso que recebermos diretamente para qualquer uma das partes cujos direitos seriam afetados por ele.

### E. Violação recorrente

É política do GitHub, em circunstâncias apropriadas e a seu exclusivo critério, desativar e encerrar as contas de usuários que possam infringir direitos autorais ou outros direitos de propriedade intelectual do GitHub ou de terceiros.

### F. Enviando avisos

Se estiver pronto para enviar um aviso ou contra-aviso:
- [Como enviar um Aviso DMCA](/articles/guide-to-submitting-a-dmca-takedown-notice)
- [Como enviar um Contra-aviso DMCA](/articles/guide-to-submitting-a-dmca-counter-notice)

### Saiba Mais e Fale Mais

Se você navegar pela internet, não é muito difícil encontrar comentários e críticas sobre o sistema de direitos autorais em geral e sobre a DMCA em particular. Embora o GitHub reconheça e aprecie o papel importante que a DMCA tem desempenhado na promoção da inovação online, acreditamos que as leis de direitos autorais poderiam passar uma ou outra correção, ou mesmo uma nova versão completa. Em questão de software, estamos constantemente melhorando e atualizando nosso código. Pense no quanto a tecnologia mudou desde 1998, quando a DMCA foi escrita. Não faria sentido atualizar essa lei no que se aplica aos softwares?

Não presumimos ter todas as respostas. Mas se você é curioso, aqui estão alguns links para artigos acadêmicos e posts de blog que encontramos com opiniões e propostas de reforma:

- [Consequências inesperadas: Doze anos sob a DMCA](https://www.eff.org/wp/unintended-consequences-under-dmca) (Electronic Frontier Foundation)
- [Danos estatutários em Direitos Autorais: um remédio precisando de reforma](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1375604) (William & Mary Law Review)
- [O período de proteção de direitos autorais é muito longo?](https://the1709blog.blogspot.com/2012/11/is-term-of-protection-of-copyright-too.html) (The 1709 Blog)
- [Se vamos alterar a "Notificação de & Retirada" da DMCA, vamos focar no quão ela é amplamente abusiva](https://www.techdirt.com/articles/20140314/11350426579/if-were-going-to-change-dmcas-notice-takedown-lets-focus-how-widely-its-abused.shtml) (TechDirt)
- [Oportunidades para a reforma dos Direitos Autorais](https://www.cato-unbound.org/issues/january-2013/opportunities-copyright-reform) (Cato Unbound)
- [Doutrina do uso justo e a Digital Millennium Copyright Act: o uso justo existe na internet sob a DMCA?](https://digitalcommons.law.scu.edu/lawreview/vol42/iss1/6/) (Santa Clara Law Review)

O GitHub não necessariamente apoia nenhum dos pontos de vista desses artigos. Fornecemos os links para incentivá-lo a aprender mais, formar suas próprias opiniões e, em seguida, entrar em contato com o(s) seu(s) representante(s) (por exemplo, no [Congresso dos EUA](https://www.govtrack.us/congress/members) ou [Parlamento Europeu](https://www.europarl.europa.eu/meps/en/home)) para procurar quaisquer mudanças que você achar que devam ser feitas. Congresso</a> ou [E.U. Parlamento](https://www.europarl.europa.eu/meps/en/home)) para procurar quaisquer alterações que você entenda que devem ser feitas.
