---
title: Níveis de permissão do repositório da organização
intro: 'Você pode personalizar o acesso a cada repositório da organização com níveis granulares de permissão, fornecendo aos usuários o acesso aos recursos e às tarefas que eles precisam.'
redirect_from:
  - /articles/repository-permission-levels-for-an-organization-early-access-program/
  - /articles/repository-permission-levels-for-an-organization
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

Usuários com permissões de administrador podem gerenciar acessos individuais e da equipe a um repositório de propriedade da organização.

### Níveis de permissão para repositórios de propriedade de uma organização

Você pode atribuir diferentes níveis de acesso aos repositórios de propriedade de uma organização a integrantes, colaboradores externos e equipes da organização. Cada nível de permissão aumenta progressivamente o acesso ao conteúdo e às configurações de um repositório. Escolha o nível mais adequado para a função de cada pessoa ou equipe do projeto, sem dar aos usuários um acesso mais abrangente do que o necessário.

Do acesso mais restritivo ao acesso mais abrangente, estes são os níveis de permissão de um repositório da organização:
- **Read** (Leitura): recomendado para contribuidores que não escrevem códigos e desejam visualizar ou discutir o projeto{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Triage** (Triagem): recomendado para contribuidores que precisam gerenciar proativamente problemas e pull requests sem acesso de gravação{% endif %}
- **Write** (Gravação): recomendado para contribuidores que proativamente fazem push no projeto{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Maintain** (Manutenção): recomendado para gerentes de projeto que precisam gerenciar o repositório, mas não devem ter acesso a ações destrutivas ou confidenciais{% endif %}
- **Admin** (Administrador): recomendado para usuários que precisam ter acesso completo ao projeto, incluindo ações confidenciais e destrutivas, como gerenciar a segurança e excluir um repositório

{% if currentVersion == "free-pro-team@latest" %}

{% endif %}

Para obter mais informações sobre como atribuir acesso aos repositórios para usuários e equipes, consulte "[Gerenciar acessos aos repositórios da organização](/articles/managing-access-to-your-organizations-repositories)".

Os proprietários da organização podem definir permissões básicas que se aplicam a todos os integrantes da organização ao acessar qualquer um dos repositórios da organização. Para obter mais informações, consulte "[Configurar permissões básicas para uma organização](/github/setting-up-and-managing-organizations-and-teams/setting-base-permissions-for-an-organization#setting-base-permissions)".

Os proprietários da organização também podem optar por limitar ainda mais o acesso a configurações e ações específicas na organização. Para obter mais informações sobre as opções para configurações específicas, consulte "[Gerenciar as configurações da organização](/articles/managing-organization-settings)".

Além de gerenciar as configurações da organização, os proprietários da organização têm permissões de administrador em todos os repositórios de propriedade da organização. Para obter mais informações, consulte "[Níveis de permissão para uma organização](/articles/permission-levels-for-an-organization)".

{% warning %}

**Aviso:** quando alguém adiciona uma chave de implantação a um repositório, qualquer usuário com a chave privada pode ler e gravar no repositório (dependendo das configurações da chave), mesmo que ele seja removido posteriormente da organização.

{% endwarning %}

### Acesso ao repositório de cada nível de permissão
{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Ação no repositório                                                                                                                                                                                                                                                                         | Leitura | Triagem | Gravação | Manutenção |                                                                                Administrador                                                                                 |
|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-------:|:-------:|:--------:|:----------:|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| Fazer pull nos repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                               |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Bifurcar os repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                                  |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Editar e excluir seus próprios comentários                                                                                                                                                                                                                                                  |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Criar problemas                                                                                                                                                                                                                                                                             |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Fechar os problemas que eles criaram                                                                                                                                                                                                                                                        |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Reabrir problemas que eles fecharam                                                                                                                                                                                                                                                         |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Ter um problema atribuído a eles                                                                                                                                                                                                                                                            |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Enviar pull requests de bifurcações dos repositórios atribuídos à equipe                                                                                                                                                                                                                    |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Enviar revisões em pull requests                                                                                                                                                                                                                                                            |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Exibir as versões publicadas                                                                                                                                                                                                                                                                |  **X**  |  **X**  |  **X**   |   **X**    |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Visualizar [execuções de fluxo de trabalho no GitHub Actions](/actions/automating-your-workflow-with-github-actions/managing-a-workflow-run)                                                                                                                                                |  **X**  |  **X**  |  **X**   |   **X**    |                                                                              **X** |{% endif %}
| Editar wikis                                                                                                                                                                                                                                                                                |  **X**  |  **X**  |  **X**   |   **X**    |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Denunciar conteúdo abusivo ou spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                                     |  **X**  |  **X**  |  **X**   |   **X**    |                                                                              **X** |{% endif %}
| Aplicar etiquetas                                                                                                                                                                                                                                                                           |         |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Fechar, reabrir e atribuir todos os problemas e pull requests                                                                                                                                                                                                                               |         |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Aplicar marcos                                                                                                                                                                                                                                                                              |         |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Marcar [problemas e pull requests duplicados](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                                                           |         |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Solicitar [revisões de pull requests](/articles/requesting-a-pull-request-review)                                                                                                                                                                                                           |         |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Fazer push (gravar) nos repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                      |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Editar e excluir comentários de qualquer usuário em commits, pull request e problemas                                                                                                                                                                                                       |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Ocultar comentários de qualquer usuário](/articles/managing-disruptive-comments)                                                                                                                                                                                                           |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Bloquear conversas](/articles/locking-conversations)                                                                                                                                                                                                                                       |         |         |  **X**   |   **X**    |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Transferir problemas (consulte "[Transferir um problema para outro repositório](/articles/transferring-an-issue-to-another-repository)" para obter mais informações)                                                                                                                        |         |         |  **X**   |   **X**    |                                                                              **X** |{% endif %}
| [Atuar como um proprietário do código designado de um repositório](/articles/about-code-owners)                                                                                                                                                                                             |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Marcar uma pull request de rascunho como pronta para revisão](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                              |         |         |  **X**   |   **X**    |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| [Converter um pull request em rascunho](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                                                     |         |         |  **X**   |   **X**    |                                                                              **X** |{% endif %}
| Enviar revisões que afetam a capacidade de merge de uma pull request                                                                                                                                                                                                                        |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Aplicar alterações sugeridas](/articles/incorporating-feedback-in-your-pull-request) a pull requests                                                                                                                                                                                       |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Criar [verificações de status](/articles/about-status-checks)                                                                                                                                                                                                                               |         |         |  **X**   |   **X**    |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Criar, editar, executar, reexecutar e cancelar [fluxos de trabalho no GitHub Actions](/actions/automating-your-workflow-with-github-actions/)                                                                                                                                               |         |         |  **X**   |   **X**    |                                                                              **X** |{% endif %}
| Criar e editar versões                                                                                                                                                                                                                                                                      |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Exibir versões de rascunho                                                                                                                                                                                                                                                                  |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| Editar a descrição de um repositório                                                                                                                                                                                                                                                        |         |         |          |   **X**    |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Visualizar e instalar pacotes](/packages/publishing-and-managing-packages)                                                                                                                                                                                                                 |  **X**  |  **X**  |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Publicar pacotes](/packages/publishing-and-managing-packages/publishing-a-package)                                                                                                                                                                                                         |         |         |  **X**   |   **X**    |                                                                                    **X**                                                                                     |
| [Excluir pacotes](/packages/publishing-and-managing-packages/deleting-a-package)                                                                                                                                                                                                            |         |         |          |            |                                                                                    **X**                                                                                     |{% endif %}
| Gerenciar [tópicos](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                                                      |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| Habilitar wikis e restringir editores de wiki                                                                                                                                                                                                                                               |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| Habilitar quadros de projeto                                                                                                                                                                                                                                                                |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| Configurar [merges de pull request](/articles/configuring-pull-request-merges)                                                                                                                                                                                                              |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| Configurar [uma fonte de publicação para {% data variables.product.prodname_pages %}](/articles/configuring-a-publishing-source-for-github-pages)                                                                                                                                      |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| [Fazer push em branches protegidos](/articles/about-protected-branches)                                                                                                                                                                                                                     |         |         |          |   **X**    |                                                                                    **X**                                                                                     |
| [Criar e editar cartões sociais do repositório](/articles/customizing-your-repositorys-social-media-preview)                                                                                                                                                                                |         |         |          |   **X**    |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Limitar [interações em um repositório](/github/building-a-strong-community/limiting-interactions-in-your-repository)                                                                                                                                                                        |         |         |          |   **X**    |                                                                              **X** |{% endif %}
| Excluir um problema (consulte "[Excluir um problema](/articles/deleting-an-issue)")                                                                                                                                                                                                         |         |         |          |            |                                                                                    **X**                                                                                     |
| Fazer merge de pull requests em branches protegidos, mesmo sem revisões de aprovação                                                                                                                                                                                                        |         |         |          |            |                                                                                    **X**                                                                                     |
| [Definir os proprietários do código de um repositório](/articles/about-code-owners)                                                                                                                                                                                                         |         |         |          |            |                                                                                    **X**                                                                                     |
| Adicionar um repositório a uma equipe (consulte "[Gerenciar o acesso da equipe ao repositório de uma organização](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)" para obter informações) |         |         |          |            |                                                                                    **X**                                                                                     |
| [Gerenciar o acesso dos colaboradores externos a um repositório](/articles/adding-outside-collaborators-to-repositories-in-your-organization)                                                                                                                                               |         |         |          |            |                                                                                    **X**                                                                                     |
| [Alterar a visibilidade de um repositório](/articles/restricting-repository-visibility-changes-in-your-organization)                                                                                                                                                                        |         |         |          |            |                                                    **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Criar um modelo de repositório (consulte "[Criar um modelo de repositório](/articles/creating-a-template-repository)")                                                                                                                                                                      |         |         |          |            |                                                                              **X** |{% endif %}
| Alterar as configurações do repositório                                                                                                                                                                                                                                                     |         |         |          |            |                                                                                    **X**                                                                                     |
| Gerenciar o acesso de equipe e de colaborador ao repositório                                                                                                                                                                                                                                |         |         |          |            |                                                                                    **X**                                                                                     |
| Editar o branch padrão do repositório                                                                                                                                                                                                                                                       |         |         |          |            |                                                                                    **X**                                                                                     |
| Gerenciar webhooks e chaves de implantação                                                                                                                                                                                                                                                  |         |         |          |            |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Habilitar o gráfico de dependências](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) em um repositório privado                                                                                                                  |         |         |          |            |                                                                                    **X**                                                                                     |
| Receber [{% data variables.product.prodname_dependabot_alerts %} para dependências vulneráveis](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) em um repositório                                                                                |         |         |          |            |                                                                                    **X**                                                                                     |
| [Ignorar {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                                         |         |         |          |            |                                                                                    **X**                                                                                     |
| [Designar outras pessoas ou equipes para receber {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository) para as dependências vulneráveis                                           |         |         |          |            |                                                                                    **X**                                                                                     |
| [Gerenciar as configurações do uso de dados para seu repositório privado](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                              |         |         |          |            | **X**,{% endif %}{% if currentVersion == "free-pro-team@latest" %}├Criar [consultorias de segurança](/github/managing-security-vulnerabilities/about-github-security-advisories) ├├├├├ **X** |{% endif %}
| [Gerenciar a política de bifurcação de um repositório](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                                  |         |         |          |            |                                                                                    **X**                                                                                     |
| [Transferir repositório na organização](/articles/restricting-repository-creation-in-your-organization)                                                                                                                                                                                     |         |         |          |            |                                                                                    **X**                                                                                     |
| [Excluir ou transferir repositórios na organização](/articles/setting-permissions-for-deleting-or-transferring-repositories)                                                                                                                                                                |         |         |          |            |                                                                                    **X**                                                                                     |
| [Arquivar repositórios](/articles/about-archiving-repositories)                                                                                                                                                                                                                             |         |         |          |            |                                                                   **X** |{% if currentVersion == "free-pro-team@latest" %}
| Exibir um botão de patrocinador (consulte "[Exibir um botão de patrocinador no seu repositório](/articles/displaying-a-sponsor-button-in-your-repository)")                                                                                                                                 |         |         |          |            |                                              **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Criar referências de link automático para recursos externos, como JIRA ou Zendesk (consulte "[Configurar links automáticos para apontar para recursos externos](/articles/configuring-autolinks-to-reference-external-resources)")                                                          |         |         |          |            |                                                                              **X** |{% endif %}

{% else %}

| Ação no repositório                                                                                                                                                                                                                                                                           | Permissões de leitura | Permissões de gravação |                      Permissões de administrador                       |
|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:---------------------:|:----------------------:|:----------------------------------------------------------------------:|
| Fazer pull (ler) nos repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                           |         **X**         |         **X**          |                                 **X**                                  |
| Bifurcar (copiar) os repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                           |         **X**         |         **X**          |                                 **X**                                  |
| Editar e excluir seus próprios comentários em commits, pull request e problemas                                                                                                                                                                                                               |         **X**         |         **X**          |                                 **X**                                  |
| Criar problemas                                                                                                                                                                                                                                                                               |         **X**         |         **X**          |                                 **X**                                  |
| Fechar os problemas que eles criaram                                                                                                                                                                                                                                                          |         **X**         |         **X**          |                                 **X**                                  |
| Reabrir problemas que eles fecharam                                                                                                                                                                                                                                                           |         **X**         |         **X**          |                                 **X**                                  |
| Ter um problema atribuído a eles                                                                                                                                                                                                                                                              |         **X**         |         **X**          |                                 **X**                                  |
| Enviar pull requests de bifurcações dos repositórios atribuídos à equipe                                                                                                                                                                                                                      |         **X**         |         **X**          |                                 **X**                                  |
| Enviar revisões em pull requests                                                                                                                                                                                                                                                              |         **X**         |         **X**          |                                 **X**                                  |
| Exibir as versões publicadas                                                                                                                                                                                                                                                                  |         **X**         |         **X**          |                                 **X**                                  |
| Editar wikis                                                                                                                                                                                                                                                                                  |         **X**         |         **X**          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Denunciar conteúdo abusivo ou spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                                       |         **X**         |         **X**          |                           **X** |{% endif %}
| Fazer push (gravar) nos repositórios atribuídos ao usuário ou à equipe                                                                                                                                                                                                                        |                       |         **X**          |                                 **X**                                  |
| Editar e excluir comentários de qualquer usuário em commits, pull request e problemas                                                                                                                                                                                                         |                       |         **X**          |                                 **X**                                  |
| [Ocultar comentários de qualquer usuário](/articles/managing-disruptive-comments)                                                                                                                                                                                                             |                       |         **X**          |                                 **X**                                  |
| [Bloquear conversas](/articles/locking-conversations)                                                                                                                                                                                                                                         |                       |         **X**          |                                 **X**                                  |
| Aplicar etiquetas e marcos                                                                                                                                                                                                                                                                    |                       |         **X**          |                                 **X**                                  |
| Fechar, reabrir e atribuir todos os problemas                                                                                                                                                                                                                                                 |                       |         **X**          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| Marcar [problemas e pull requests duplicados](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                                                             |                       |         **X**          |                           **X** |{% endif %}
| [Atuar como um proprietário do código designado de um repositório](/articles/about-code-owners)                                                                                                                                                                                               |                       |         **X**          |                                 **X**                                  |
| [Marcar uma pull request de rascunho como pronta para revisão](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                                |                       |         **X**          |                                 **X**                                  |
| Solicitar [revisões de pull requests](/articles/requesting-a-pull-request-review)                                                                                                                                                                                                             |                       |         **X**          |                                 **X**                                  |
| Enviar revisões que afetam a capacidade de merge de uma pull request                                                                                                                                                                                                                          |                       |         **X**          |                                 **X**                                  |
| Aplicar alterações sugeridas a pull requests (consulte "[Incluir feedback na pull request](/articles/incorporating-feedback-in-your-pull-request)" para obter mais informações)                                                                                                               |                       |         **X**          |                                 **X**                                  |
| Criar [verificações de status](/articles/about-status-checks)                                                                                                                                                                                                                                 |                       |         **X**          |                                 **X**                                  |
| Criar e editar versões                                                                                                                                                                                                                                                                        |                       |         **X**          |                                 **X**                                  |
| Exibir versões de rascunho                                                                                                                                                                                                                                                                    |                       |         **X**          |                                 **X**                                  |
| Excluir um problema (consulte "[Excluir um problema](/articles/deleting-an-issue)")                                                                                                                                                                                                           |                       |                        |                                 **X**                                  |
| Fazer merge de pull requests em branches protegidos, mesmo sem revisões de aprovação                                                                                                                                                                                                          |                       |                        |                                 **X**                                  |
| [Definir os proprietários do código de um repositório](/articles/about-code-owners)                                                                                                                                                                                                           |                       |                        |                                 **X**                                  |
| Editar a descrição de um repositório                                                                                                                                                                                                                                                          |                       |                        |                                 **X**                                  |
| Gerenciar [tópicos](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                                                        |                       |                        | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Criar e editar cartões sociais do repositório (consulte "[Personalizar a exibição das redes sociais do repositório](/articles/customizing-your-repositorys-social-media-preview)" para obter mais informações)                                                                                |                       |                        |                           **X** |{% endif %}
| Adicionar um repositório a uma equipe (consulte "[Gerenciar o acesso da equipe ao repositório de uma organização](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)" para obter informações)   |                       |                        |                                 **X**                                  |
| Gerenciar o acesso dos colaboradores externos a um repositório (consulte "[Adicionar colaboradores externos a repositórios na sua organização](/articles/adding-outside-collaborators-to-repositories-in-your-organization)" para obter mais informações)                                     |                       |                        |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| Limitar [interações em um repositório](/github/building-a-strong-community/limiting-interactions-in-your-repository)                                                                                                                                                                          |                       |                        |                           **X** |{% endif %}
| Alterar a visibilidade de um repositório (consulte "[Restringir alterações da visibilidade do repositório na organização](/articles/restricting-repository-visibility-changes-in-your-organization)" para obter mais informações)                                                             |                       |                        | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Criar um modelo de repositório (consulte "[Criar um modelo de repositório](/articles/creating-a-template-repository)")                                                                                                                                                                        |                       |                        |                         | | **X** |{% endif %}
| Alterar as configurações do repositório                                                                                                                                                                                                                                                       |                       |                        |                                 **X**                                  |
| Gerenciar o acesso de equipe e de colaborador ao repositório                                                                                                                                                                                                                                  |                       |                        |                                 **X**                                  |
| Editar o branch padrão do repositório                                                                                                                                                                                                                                                         |                       |                        |                                 **X**                                  |
| Gerenciar webhooks e chaves de implantação                                                                                                                                                                                                                                                    |                       |                        |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Habilitar o gráfico de dependências](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) em um repositório privado                                                                                                                    |                       |                        |                                 **X**                                  |
| Receber [{% data variables.product.prodname_dependabot_alerts %} para dependências vulneráveis](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) em um repositório                                                                                  |                       |                        |                                 **X**                                  |
| [Ignorar {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                                           |                       |                        |                                 **X**                                  |
| [Designar outras pessoas ou equipes para receber {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-github-dependabot-alerts) para as dependências vulneráveis |                       |                        |                                 **X**                                  |
| [Gerenciar as configurações do uso de dados para seu repositório privado](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                                |                       |                        |          **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}
| Criar [consultorias de segurança](/github/managing-security-vulnerabilities/about-github-security-advisories)")                                                                                                                                                                               |                       |                        |                                 **X**                                  |{% endif %}
| [Gerenciar a política de bifurcação de um repositório](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                                    |                       |                        |                                 **X**                                  |
| Transferir repositórios para a conta da organização (consulte "[Restringir a criação de repositórios na organização](/articles/restricting-repository-creation-in-your-organization)" para obter mais informações)                                                                            |                       |                        |                                 **X**                                  |
| Excluir ou transferir repositórios (consulte "[Configurar permissões para excluir ou transferir repositórios na organização](/articles/setting-permissions-for-deleting-or-transferring-repositories)" para obter mais informações)                                                           |                       |                        |                                 **X**                                  |
| [Arquivar repositórios](/articles/about-archiving-repositories)                                                                                                                                                                                                                               |                       |                        |                                 **X**                                  |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Criar referências de link automático para recursos externos, como JIRA ou Zendesk (consulte "[Configurar links automáticos para apontar para recursos externos](/articles/configuring-autolinks-to-reference-external-resources)"                                                             |                       |                        |                         | | **X** |{% endif %}

{% endif %}

### Leia mais

- "[Gerenciar acessos aos repositórios da organização](/articles/managing-access-to-your-organization-s-repositories)"
- "[Adicionar colaboradores externos a repositórios na sua organização](/articles/adding-outside-collaborators-to-repositories-in-your-organization)"
- "[Permissões de quadro de projeto para uma organização](/articles/project-board-permissions-for-an-organization)"
