---
title: Recursos de aprendizagem Git e GitHub
redirect_from:
  - /articles/good-resources-for-learning-git-and-github/
  - /articles/what-are-other-good-resources-for-learning-git-and-github/
  - /articles/git-and-github-learning-resources
intro: 'Existem muitos recursos Git e {% data variables.product.product_name %} na Web. Essa é uma lista de nossos preferidos!'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Usar o Git

Familiarize-se com o Git acessando o [site oficial do projeto Git](https://git-scm.com) e lendo o [e-book ProGit](http://git-scm.com/book). Você pode revisar a [lista de comandos Git](https://git-scm.com/docs) ou a [referência de consultas de comandos Git](http://gitref.org) e usar o simulador [Try Git](https://try.github.com) (Experimentar o Git).

### Usar {% data variables.product.product_name %}

{% if currentVersion == "free-pro-team@latest" %}

O {% data variables.product.prodname_learning %} oferece cursos interativos grátis que são desenvolvidos em {% data variables.product.prodname_dotcom %} e possuem ajuda e respostas automáticas e instantâneas. Aprenda a abrir sua primeira pull request, fazer sua primeira contribuição a um código aberto, criar um site {% data variables.product.prodname_pages %} e muito mais. Para obter mais informações sobre a oferta de cursos, consulte [{% data variables.product.prodname_learning %}]({% data variables.product.prodname_learning_link %}).

{% endif %}

Conheça melhor o {% data variables.product.product_name %} por meio de nossos artigos [bootcamp](/categories/bootcamp/). Consulte nosso fluxo [{% data variables.product.prodname_dotcom %} ](https://guides.github.com/introduction/flow) para uma introdução ao processo. Examine as [orientações gerais](https://guides.github.com) para conhecer os conceitos básicos.

{% data reusables.support.ask-and-answer-forum %}

#### Branches, bifurcações e pull requests

Saiba como [criar branches no Git ](http://learngitbranching.js.org/) com uma ferramenta interativa. Leia sobre [bifurcações](/articles/about-forks) e [pull requests](/articles/using-pull-requests) e também sobre [como usamos pull requests](https://github.com/blog/1124-how-we-use-pull-requests-to-build-github) em {% data variables.product.prodname_dotcom %}.

Faça consultas rápidas sobre [linha de comando](https://hub.github.com) e também sobre {% data variables.product.prodname_dotcom %} [ listas de verificação, folhas de consultas e mais](https://services.github.com/on-demand/resources).

#### Fique antenado

Nosso {% data variables.product.prodname_dotcom %} [canal do YouTube de Treinamentos e Orientações](https://youtube.com/githubguides) oferece tutoriais sobre as funções [pull request](https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=19), [bifurcar](https://www.youtube.com/watch?v=5oJHRbqEofs), [rebase](https://www.youtube.com/watch?v=SxzjZtJwOgo&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=22) e [redefinir](https://www.youtube.com/watch?v=BKPjPMVB81g). Cada tema é abordado em cinco minutos ou menos.

### Treinamentos

#### Aulas grátis

O {% data variables.product.product_name %} oferece uma série de [treinamentos sob demanda](https://services.github.com/on-demand/) interativos, inclusive {% data variables.product.prodname_dotcom %} 101: [Introdução](https://services.github.com/on-demand/intro-to-github/), {% data variables.product.prodname_dotcom %} 102: [Desktop GitHub](https://services.github.com/on-demand/github-desktop) e {% data variables.product.prodname_dotcom %} 103: [Linha de comando](https://services.github.com/on-demand/github-cli).

#### Programas educacionais online do {% data variables.product.prodname_dotcom %}

O {% data variables.product.prodname_dotcom %} disponibiliza [treinamentos](https://services.github.com/#upcoming-events) ao vivo com abordagens práticas e baseadas em projetos para aqueles que adoram linhas de comando e também para aqueles que as odeiam.

#### Treinamentos para sua empresa

O {% data variables.product.prodname_dotcom %} oferece [aulas presenciais](https://services.github.com/#offerings) com nossos instrutores altamente qualificados. [Entre em contato](https://services.github.com/#contact) para tirar suas dúvidas sobre os treinamentos.

### Extras

Um [curso online e interativo sobre o Git](http://www.codeschool.com/courses/git-real) da [Code School](http://codeschool.com) tem sete níveis com dezenas de exercícios em formato de jogos divertidos. Fique à vontade para adaptar nossos [modelos .gitignore](https://github.com/github/gitignore) de acordo com as suas necessidades.

Amplie seu alcance {% data variables.product.prodname_dotcom %} com {% if currentVersion == "free-pro-team@latest" %}[integrações](/articles/about-integrations){% else %}integrações{% endif %} ou instalando [{% data variables.product.prodname_desktop %}](https://desktop.github.com) o robusto editor de texto [Atom](https://atom.io).

Saiba como iniciar e desenvolver seu projeto de código aberto em [Open Source Guides](https://opensource.guide/) (Guias de Código aberto).
