---
title: Criar um aplicativo GitHub usando parâmetros de URL
intro: 'Você pode pré-selecionar as configurações de um novo {% data variables.product.prodname_github_app %} usando URL [parâmetros de consulta](https://en.wikipedia.org/wiki/Query_string) para definir rapidamente a configuração do novo {% data variables.product.prodname_github_app %}.'
redirect_from:
  - /apps/building-github-apps/creating-github-apps-using-url-parameters
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---


### Sobre parâmetros de URL do {% data variables.product.prodname_github_app %}.

Você pode adicionar parâmetros de consulta a essas URLs para pré-selecionar a configuração de um {% data variables.product.prodname_github_app %} em uma conta pessoal ou de organização:
* **Conta de usuário:** `https://github.com/settings/apps/new`
* **Conta de organização:** `https://github.com/organizations/:org/settings/apps/new`

A pessoa que está criando o aplicativo pode editar os valores pré-selecionados a partir da página de registro do {% data variables.product.prodname_github_app %}, antes de enviar o aplicativo. Se você não incluir os parâmetros necessários na string de consulta da URL, como, por exemplo, o `nome`, a pessoa que criar o aplicativo deverá inserir um valor antes de enviar o aplicativo.

A URL a seguir cria um novo aplicativo pública denominado `octocat-github-app` com uma descrição pré-configurada e URL de chamada de retorno. Esta URL também seleciona permissões de leitura e gravação para `verificações`, inscreve-se nos eventos webhook de </code>check_run` e <code>check_suite` e seleciona a opção de solicitar autorização do usuário (OAuth) durante a instalação:

  ```
  https://github.com/settings/apps/new?name=octocat-github-app&description=An%20Octocat%20App&callback_url=https://example.com&request_oauth_on_install=true&public=true&checks=write&events[]=check_run&events[]=check_suite
  ```

Lista completa de parâmetros de consulta, permissões e eventos disponíveis encontra-se nas seções abaixo.

### Parâmetros de configuração do {% data variables.product.prodname_github_app %}

 | Nome                       | Tipo               | Descrição                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
 | -------------------------- | ------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
 | `name`                     | `string`           | O nome do {% data variables.product.prodname_github_app %}. Dê um nome claro e sucinto ao seu aplicativo. Seu aplicativo não pode ter o mesmo nome de um usuário existente no GitHub, a menos que seja o seu próprio nome de usuário ou da sua organização. Uma versão movida do nome do seu aplicativo será exibida na interface do usuário quando sua integração realizar uma ação.                                                                                                                                       |
 | `descrição`                | `string`           | Uma descrição do {% data variables.product.prodname_github_app %}.                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
 | `url`                      | `string`           | A URL completa da página inicial do site do seu {% data variables.product.prodname_github_app %}.                                                                                                                                                                                                                                                                                                                                                                                                                           |
 | `callback_url`             | `string`           | A URL completa para onde redirecionar após alguém autorizar uma instalação. Esta URL é usada se o aplicativo precisar identificar e autorizar solicitações de usuário para servidor.                                                                                                                                                                                                                                                                                                                                               |
 | `request_oauth_on_install` | `boolean`          | Se seu aplicativo autoriza usuários a usar o fluxo OAuth, você poderá definir essa opção como `verdadeiro` para permitir que pessoas autorizem o aplicativo ao instalá-lo, economizando um passo. Se você selecionar esta opção, `setup_url` irá tornar-se indisponível e os usuários serão redirecionados para sua `callback_url` após instalar o aplicativo.                                                                                                                                                                     |
 | `setup_url`                | `string`           | A URL completa para redirecionamento após alguém instalar o {% data variables.product.prodname_github_app %}, se o aplicativo precisar de configuração adicional após a instalação.                                                                                                                                                                                                                                                                                                                                         |
 | `setup_on_update`          | `boolean`          | Defina como `verdadeiro` para redirecionar as pessoas para a URL de configuração quando as instalações forem atualizadas, por exemplo, após os repositórios serem adicionados ou removidos.                                                                                                                                                                                                                                                                                                                                        |
 | `público`                  | `boolean`          | Defina `verdadeiro` quando seu {% data variables.product.prodname_github_app %} estiver disponível para o público ou como `falso` quando só for acessível pelo proprietário do aplicativo.                                                                                                                                                                                                                                                                                                                                  |
 | `webhook_url`              | `string`           | A URL completa para a qual você deseja enviar as cargas do evento de webhook.                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
 | `webhook_secret`           | `string`           | Você pode especificar um segredo para proteger seus webhooks. Consulte "[Protegendo seus webhooks](/webhooks/securing/)" para obter mais detalhes.                                                                                                                                                                                                                                                                                                                                                                                 |
 | `eventos`                  | `array de strigns` | Eventos webhook. Alguns eventos de webhook exigem permissões de `leitura` ou `gravação` para um recurso antes de poder selecionar o evento ao registrar um novo {% data variables.product.prodname_github_app %}, . Consulte a seção "[{% data variables.product.prodname_github_app %} eventos de webhook](#github-app-webhook-events)" para eventos disponíveis e suas permissões necessárias. Você pode selecionar vários eventos em uma string de consulta. Por exemplo, `eventos[]=public&eventos[]=label`. |
 | `domínio`                  | `string`           | A URL de uma referência de conteúdo.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
 | `single_file_name`         | `string`           | Ao conceder acesso de `leitura` ou `gravação` à permissão `single_file`, este campo fornecerá o caminho o para o único arquivo que seu {% data variables.product.prodname_github_app %} irá gerenciar.                                                                                                                                                                                                                                                                                                                      |

### Permissões do {% data variables.product.prodname_github_app %}

Você pode selecionar permissões em uma string de consultas usando o nome da permissão na tabela a seguir como o nome do parâmetro de consulta e o tipo de permissão como valor da consulta. Por exemplo, para selecionar permissões de `Leitura & gravação` na interface de usuário para `conteúdo`, sua string de consulta incluiria `&contents=write`. Para selecionar as permissões `Somente leitura` na interface de usuário para `bloquear`, sua string de consulta incluiria `&blocking=read`. Para selecionar `sem acesso` na interface do usuário para `verificações`, sua string de consulta não incluiria a permissão `verificações`.

| Permissão                                                                                                                        | Descrição                                                                                                                                                                                                                                                                                         |
| -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [`administração`](/rest/reference/permissions-required-for-github-apps/#permission-on-administration)                            | Concede acesso a vários pontos finais para administração de organização e repositório. Pode ser: `nenhum`, `leitura` ou `gravação`.{% if currentVersion == "free-pro-team@latest" %}
| [`bloqueio`](/rest/reference/permissions-required-for-github-apps/#permission-on-blocking)                                       | Concede acesso à [API de usuários de bloqueio](/v3/users/blocking/). Pode ser: `nenhum`, `leitura` ou `gravação`.{% endif %}
| [`Verificações`](/rest/reference/permissions-required-for-github-apps/#permission-on-checks)                                     | Concede acesso à [API de verificação](/v3/checks/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                                  |
| `content_references`                                                                                                             | Concede acesso ao ponto final "[Criar um anexo de conteúdo](/v3/apps/installations/#create-a-content-attachment). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                    |
| [`Conteúdo`](/rest/reference/permissions-required-for-github-apps/#permission-on-contents)                                       | Concede acesso a vários pontos finais que permitem modificar o conteúdo do repositório. Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                              |
| [`Implantações`](/rest/reference/permissions-required-for-github-apps/#permission-on-deployments)                                | Concede acesso à [API de implementação](/v3/repos/deployments/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                     |
| [`emails`](/rest/reference/permissions-required-for-github-apps/#permission-on-emails)                                           | Concede acesso à [API de e-mails](/v3/users/emails/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                                |
| [`seguidores`](/rest/reference/permissions-required-for-github-apps/#permission-on-followers)                                    | Concede acesso à [API de seguidores](/v3/users/followers/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                          |
| [`gpg_keys`](/rest/reference/permissions-required-for-github-apps/#permission-on-gpg-keys)                                       | Concede acesso à [API de chaves de GPG](/v3/users/gpg_keys/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                        |
| [`Problemas`](/rest/reference/permissions-required-for-github-apps/#permission-on-issues)                                        | Concede acesso à [API de problemas](/v3/issues/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                                    |
| [`chaves`](/rest/reference/permissions-required-for-github-apps/#permission-on-keys)                                             | Concede acesso à [API de chaves públicas](/v3/users/keys/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                          |
| [`members`](/rest/reference/permissions-required-for-github-apps/#permission-on-members)                                         | Concede acesso para gerenciar os membros de uma organização. Pode ser: `nenhum`, `leitura` ou `gravação`.{% if currentVersion == "free-pro-team@latest" %}
| [`metadados`](/rest/reference/permissions-required-for-github-apps/#metadata-permissions)                                        | Concede acesso a pontos finais somente leitura que não vazam dados confidenciais. Pode ser `leitura ` ou `nenhum`. O padrão é `leitura`, ao definir qualquer permissão, ou `nenhum` quando você não especificar nenhuma permissão para o {% data variables.product.prodname_github_app %}. |
| [`organization_administration`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-administration) | Concede acesso ao ponto final "[Atualizar uma organização](/v3/orgs/#update-an-organization)" ponto final e Pa [API de restrições de interação da organização](/v3/interactions/orgs/#set-interaction-restrictions-for-an-organization). Pode ser: `nenhum`, `leitura` ou `gravação`.{% endif %}
| [`organization_hooks`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-hooks)                   | Concede acesso à [API de webhooks da organização](/v3/orgs/hooks/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                  |
| `organization_plan`                                                                                                              | Concede acesso para obter informações sobre o plano de uma organização usando o ponto final "[Obter uma organização](/v3/orgs/#get-an-organization)". Pode ser: `nenhum` ou `leitura`.                                                                                                            |
| [`organization_projects`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-projects)             | Concede acesso à [API de Projetos](/v3/projects/). Pode ser: `nenhum`, `leitura`, `gravação` ou `administrador`.{% if currentVersion == "free-pro-team@latest" %}
| [`organization_user_blocking`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-projects)        | Concede acesso à [API de usuários de bloqueio da organização](/v3/orgs/blocking/). Pode ser: `nenhum`, `leitura` ou `gravação`.{% endif %}
| [`Páginas`](/rest/reference/permissions-required-for-github-apps/#permission-on-pages)                                           | Concede acesso à [API de páginas](/v3/repos/pages/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                                 |
| `plano`                                                                                                                          | Concede acesso para obter informações sobre o plano de um usuário do GitHub que usa o ponto final "[Obter um usuário](/v3/users/#get-a-user)". Pode ser: `nenhum` ou `leitura`.                                                                                                                   |
| [`pull_requests`](/rest/reference/permissions-required-for-github-apps/#permission-on-pull-requests)                             | Concede acesso a vários pontos finais do pull request. Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                               |
| [`repository_hooks`](/rest/reference/permissions-required-for-github-apps/#permission-on-repository-hooks)                       | Concede acesso à [API de webhooks do repositório](/v3/repos/hooks/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                 |
| [`repository_projects`](/rest/reference/permissions-required-for-github-apps/#permission-on-repository-projects)                 | Concede acesso à [API de Projetos](/v3/projects/). Pode ser: `nenhum`, `leutra`, `gravação` ou `administrador`.                                                                                                                                                                                   |
| [`single_file`](/rest/reference/permissions-required-for-github-apps/#permission-on-single-file)                                 | Concede acesso à [API de conteúdo](/v3/repos/contents/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                             |
| [`estrela`](/rest/reference/permissions-required-for-github-apps/#permission-on-starring)                                        | Concede acesso à [API estrelada](/v3/activity/starring/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                            |
| [`Status`](/rest/reference/permissions-required-for-github-apps/#permission-on-statuses)                                         | Concede acesso à [API de status](/v3/repos/statuses/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                                               |
| [`team_discussions`](/rest/reference/permissions-required-for-github-apps/#permission-on-team-discussions)                       | Concede acesso à [API de discussões de equipe](/v3/teams/discussions/) e à [API de comentários de discussão de equipe](/v3/teams/discussion_comments/). Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                              |
| `vulnerability_alerts`                                                                                                           | Concede acesso a alertas de segurança para dependências vulneráveis em um repositório. Consulte "[Sobre alertas de segurança para dependências vulneráveis](/articles/about-security-alerts-for-vulnerable-dependencies)" para saber mais. Pode ser: `nenhum` ou `leitura`.                       |
| `inspecionando`                                                                                                                  | Concede acesso à lista e alterações de repositórios que um usuário assinou. Pode ser: `nenhum`, `leitura` ou `gravação`.                                                                                                                                                                          |

### Eventos webhook do {% data variables.product.prodname_github_app %}

| Nome do evento webhook                                                                 | Permissão necessária                             | Descrição                                                                                     |
| -------------------------------------------------------------------------------------- | ------------------------------------------------ | --------------------------------------------------------------------------------------------- |
| [`check_run`](/webhooks/event-payloads/#check_run)                                     | `Verificações`                                   | {% data reusables.webhooks.check_run_short_desc %}                                     |
| [`check_suite`](/webhooks/event-payloads/#check_suite)                                 | `Verificações`                                   | {% data reusables.webhooks.check_suite_short_desc %}                                    |
| [`commit_comment`](/webhooks/event-payloads/#commit_comment)                           | `Conteúdo`                                       | {% data reusables.webhooks.commit_comment_short_desc %}                                |
| [`content_reference`](/webhooks/event-payloads/#content_reference)                     | `content_references`                             | {% data reusables.webhooks.content_reference_short_desc %}                             |
| [`create`](/webhooks/event-payloads/#create)                                           | `Conteúdo`                                       | {% data reusables.webhooks.create_short_desc %}                                        |
| [`delete`](/webhooks/event-payloads/#delete)                                           | `Conteúdo`                                       | {% data reusables.webhooks.delete_short_desc %}                                        |
| [`implantação`](/webhooks/event-payloads/#deployment)                                  | `Implantações`                                   | {% data reusables.webhooks.deployment_short_desc %}                                    |
| [`implantação_status`](/webhooks/event-payloads/#deployment_status)                    | `Implantações`                                   | {% data reusables.webhooks.deployment_status_short_desc %}                             |
| [`bifurcação`](/webhooks/event-payloads/#fork)                                         | `Conteúdo`                                       | {% data reusables.webhooks.fork_short_desc %}                                          |
| [`gollum`](/webhooks/event-payloads/#gollum)                                           | `Conteúdo`                                       | {% data reusables.webhooks.gollum_short_desc %}                                        |
| [`Problemas`](/webhooks/event-payloads/#issues)                                        | `Problemas`                                      | {% data reusables.webhooks.issues_short_desc %}                                        |
| [`issue_comment`](/webhooks/event-payloads/#issue_comment)                             | `Problemas`                                      | {% data reusables.webhooks.issue_comment_short_desc %}                                 |
| [`etiqueta`](/webhooks/event-payloads/#label)                                          | `metadados`                                      | {% data reusables.webhooks.label_short_desc %}                                         |
| [`integrante`](/webhooks/event-payloads/#member)                                       | `members`                                        | {% data reusables.webhooks.member_short_desc %}                                        |
| [`filiação`](/webhooks/event-payloads/#membership)                                     | `members`                                        | {% data reusables.webhooks.membership_short_desc %}                                    |
| [`marco`](/webhooks/event-payloads/#milestone)                                         | `pull_request`                                   | {% data reusables.webhooks.milestone_short_desc %}{% if currentVersion == "free-pro-team@latest" %}
| [`org_block`](/webhooks/event-payloads/#org_block)                                     | `organization_administration`                    | {% data reusables.webhooks.org_block_short_desc %}{% endif %}
| [`organização`](/webhooks/event-payloads/#organization)                                | `members`                                        | {% data reusables.webhooks.organization_short_desc %}                                  |
| [`page_build`](/webhooks/event-payloads/#page_build)                                   | `Páginas`                                        | {% data reusables.webhooks.page_build_short_desc %}                                    |
| [`project`](/webhooks/event-payloads/#project)                                         | `repository_projects` ou `organization_projects` | {% data reusables.webhooks.project_short_desc %}                                       |
| [`project_card`](/webhooks/event-payloads/#project_card)                               | `repository_projects` ou `organization_projects` | {% data reusables.webhooks.project_card_short_desc %}                                  |
| [`project_column`](/webhooks/event-payloads/#project_column)                           | `repository_projects` ou `organization_projects` | {% data reusables.webhooks.project_column_short_desc %}                                |
| [`público`](/webhooks/event-payloads/#public)                                          | `metadados`                                      | {% data reusables.webhooks.public_short_desc %}                                        |
| [`pull_request`](/webhooks/event-payloads/#pull_request)                               | `pull_requests`                                  | {% data reusables.webhooks.pull_request_short_desc %}                                  |
| [`pull_request_review`](/webhooks/event-payloads/#pull_request_review)                 | `pull_request`                                   | {% data reusables.webhooks.pull_request_review_short_desc %}                         |
| [`pull_request_review_comment`](/webhooks/event-payloads/#pull_request_review_comment) | `pull_request`                                   | {% data reusables.webhooks.pull_request_review_comment_short_desc %}                 |
| [`push`](/webhooks/event-payloads/#push)                                               | `Conteúdo`                                       | {% data reusables.webhooks.push_short_desc %}                                          |
| [`versão`](/webhooks/event-payloads/#release)                                          | `Conteúdo`                                       | {% data reusables.webhooks.release_short_desc %}                                       |
| [`repositório`](/webhooks/event-payloads/#repository)                                  | `metadados`                                      | {% data reusables.webhooks.repository_short_desc %}{% if currentVersion == "free-pro-team@latest"%}
| [`repository_dispatch`](/webhooks/event-payloads/#repository_dispatch)                 | `Conteúdo`                                       | Permite aos integradores que usam o GitHub Actions acionar eventos personalizados.{% endif %}
| [`status`](/webhooks/event-payloads/#status)                                           | `Status`                                         | {% data reusables.webhooks.status_short_desc %}                                        |
| [`equipe`](/webhooks/event-payloads/#team)                                             | `members`                                        | {% data reusables.webhooks.team_short_desc %}                                          |
| [`team_add`](/webhooks/event-payloads/#team_add)                                       | `members`                                        | {% data reusables.webhooks.team_add_short_desc %}                                      |
| [`inspecionar`](/webhooks/event-payloads/#watch)                                       | `metadados`                                      | {% data reusables.webhooks.watch_short_desc %}                                         |
