---
title: Libraries
intro: 'You can use the official Octokit library and other third-party libraries to extend and simplify how you use the {% data variables.product.prodname_dotcom %} API.'
redirect_from:
  - /libraries/
  - /v3/libraries
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

<div class="jumbotron libraries-jumbotron">
  <img src="/assets/images/gundamcat.png" class="gundamcat" alt="The Gundamcat" />
  <h1>Octokit comes in<br />
  many flavors</h1>
  <p class="lead">Use the official Octokit library, or choose between any of the available third party libraries.</p>
  <div class="octokit-links">
    <div class="octokit-language"><span>Ruby</span> <a href="https://github.com/octokit/octokit.rb">octokit.rb</a></div>
    <div class="octokit-language"><span>.NET</span> <a href="https://github.com/octokit/octokit.net">octokit.net</a></div>
    <div class="octokit-language"><span>JavaScript</span> <a href="https://github.com/octokit/rest.js">octokit/rest.js</a></div>
  </div>
</div>

# Third-party libraries

### Clojure

* [Tentacles][tentacles]

### Dart

* [github.dart][github.dart]

### Emacs Lisp

* [gh.el][gh.el]

### Erlang

* [octo.erl][octo-erl]

### Go

* [go-github][]

### Haskell

* [github][haskell-github]

### Java

* The [GitHub Java API (org.eclipse.egit.github.core)](https://github.com/eclipse/egit-github/tree/master/org.eclipse.egit.github.core) library is part of the [GitHub Mylyn Connector](https://github.com/eclipse/egit-github) and aims to support the entire GitHub v3 API.  Builds are available in [Maven Central](http://search.maven.org/#search%7Cga%7C1%7Ca%3A%22org.eclipse.egit.github.core%22).
* [GitHub API for Java (org.kohsuke.github)](http://github-api.kohsuke.org/) defines an object oriented representation of the GitHub API.
* [JCabi GitHub API](http://github.jcabi.com) is based on Java7 JSON API (JSR-353), simplifies tests with a runtime GitHub stub, and covers the entire API.

### JavaScript

* [NodeJS GitHub library][octonode]
* [gh3 client-side API v3 wrapper][gh3]
* [GitHub.js wrapper around the GitHub API][github]
* [Promise-Based CoffeeScript library for the browser or NodeJS][github-client]

### Julia

* [GitHub.jl][github.jl]

### OCaml

* [ocaml-github][ocaml-github]

### Perl

* [Pithub][pithub-github] ([CPAN][pithub-cpan])
* [Net::GitHub][net-github-github] ([CPAN][net-github-cpan])

### PHP

* [GitHub PHP Client][github-php-client]
* [PHP GitHub API][php-github-api]
* [GitHub API][github-api]
* [GitHub Joomla! Package][joomla]
* [Github Nette Extension][kdyby-github]
* [GitHub API Easy Access][milo-github-api]
* [GitHub bridge for Laravel][github-laravel]
* [PHP5.6|PHP7 Client & WebHook wrapper][flexyproject-githubapi]

### Python

* [PyGithub][jacquev6_pygithub]
* [libsaas][libsaas]
* [github3.py][github3py]
* [sanction][sanction]
* [agithub][agithub]
* [octohub][octohub]
* [Github-Flask][github-flask]
* [torngithub][torngithub]

### Ruby

* [GitHub API Gem][ghapi]
* [Ghee][ghee]

### Scala

* [Hubcat][hubcat]
* [Github4s][github4s]

### Shell

* [ok.sh][ok.sh]

[tentacles]: https://github.com/Raynes/tentacles

[github.dart]: https://github.com/DirectMyFile/github.dart

[gh.el]: https://github.com/sigma/gh.el

[octo-erl]: https://github.com/sdepold/octo.erl

[go-github]: https://github.com/google/go-github

[haskell-github]: https://github.com/fpco/GitHub

[octonode]: https://github.com/pksunkara/octonode
[gh3]: https://github.com/k33g/gh3
[github]: https://github.com/michael/github
[github-client]: https://github.com/philschatz/github-client

[github.jl]: https://github.com/WestleyArgentum/GitHub.jl

[ocaml-github]: https://github.com/mirage/ocaml-github

[net-github-github]: https://github.com/fayland/perl-net-github
[net-github-cpan]: https://metacpan.org/pod/Net::GitHub
[pithub-github]: https://github.com/plu/Pithub
[pithub-cpan]: http://metacpan.org/module/Pithub

[github-php-client]: https://github.com/tan-tan-kanarek/github-php-client
[php-github-api]: https://github.com/KnpLabs/php-github-api
[github-api]: https://github.com/yiiext/github-api
[joomla]: https://github.com/joomla-framework/github-api
[kdyby-github]: https://github.com/kdyby/github
[milo-github-api]: https://github.com/milo/github-api
[github-laravel]: https://github.com/GrahamCampbell/Laravel-GitHub
[flexyproject-githubapi]: https://github.com/FlexyProject/GitHubAPI

[jacquev6_pygithub]: https://github.com/PyGithub/PyGithub
[libsaas]: https://github.com/ducksboard/libsaas
[github3py]: https://github.com/sigmavirus24/github3.py
[sanction]: https://github.com/demianbrecht/sanction
[agithub]: https://github.com/jpaugh/agithub "Agnostic GitHub"
[octohub]: https://github.com/turnkeylinux/octohub
[github-flask]: http://github-flask.readthedocs.org
[torngithub]: https://github.com/jkeylu/torngithub

[ghapi]: https://github.com/peter-murach/github
[ghee]: https://github.com/rauhryan/ghee

[hubcat]: https://github.com/softprops/hubcat
[github4s]: https://github.com/47deg/github4s

[ok.sh]: https://github.com/whiteinge/ok.sh
