---
title: GitHub Additional Product Terms
versions:
  free-pro-team: '*'
---

When you create an Account, you're given access to lots of different features and products that are all a part of the Service. Because many of these features and products offer different functionality, they may require additional terms and conditions specific to that feature or product. Below, we've listed those features and products, along with the corresponding additional rules that apply to those parts of the Service.

Your use of GitHub is subject to your applicable terms (the "Agreement") as well as the following GitHub Additional Product Terms (the "Additional Terms"). By agreeing to the Agreement, and using additional products and features, you also agree to these Additional Terms. Any violation of the Additional Terms is a violation of the Agreement. Capitalized terms not defined in the Additional Terms will have the meaning given to them in the Agreement.

### 1. 마켓플레이스

If you list a Developer Product through GitHub Marketplace, then you must agree to the [GitHub Marketplace Developer Agreement](/github/site-policy/github-marketplace-developer-agreement), prior to submitting the project to be listed.

If you buy Developer Products through GitHub Marketplace, the [GitHub Marketplace Terms of Service](/github/site-policy/github-marketplace-terms-of-service) controls your purchase. The Agreement, as well as the [GitHub Marketplace Terms of Service](/github/site-policy/github-marketplace-terms-of-service), will govern your use of GitHub Marketplace.

### 2. Third Party Integrations

#### a. Creating Applications
If you create a third-party application or other developer product that collects User Personal Information or User-Generated Content and integrates with the Service through GitHub's API, OAuth mechanism, or otherwise ("Developer Product"), and make it available for other Users, then you must comply with the following requirements:
- You must comply with this Agreement and the GitHub Privacy Statement.
- Except as otherwise permitted, such as by law or by a license, you must limit your usage of the User Personal Information or User-Generated Content you collect to that purpose for which the User has authorized its collection.
- You must take all reasonable security measures appropriate to the risks, such as against accidental or unlawful destruction, or accidental loss, alteration, unauthorized disclosure or access, presented by processing the User Personal Information or User-Generated Content.
- You must not hold yourself out as collecting any User Personal Information or User-Generated Content on GitHub’s behalf, and provide sufficient notice of your privacy practices to the User, such as by posting a privacy policy.
- You must provide Users with a method of deleting any User Personal Information or User-Generated Content you have collected through GitHub after it is no longer needed for the limited and specified purposes for which the User authorized its collection, except where retention is required by law or otherwise permitted, such as through a license.

#### b. Using Third-Party Applications
You may grant a Developer Product authorization to use, access, and disclose the contents of your repositories, including your private repositories. Some Developer Products are available through [GitHub Marketplace](https://github.com/marketplace). Some Developer Products can be used for performing automated tasks, and often times multiple Users may direct the actions of a Developer Product. However, if you purchase and/or set up a Developer Product on your Account, or you are an owner of an Account with an integrated Developer Product, then you will be responsible for the Developer Product's actions that are performed on or through your Account. Please see our [Privacy Statement](/github/site-policy/github-privacy-statement#third-party-applications) for more information about how we share data with Developer Products.

**GitHub makes no warranties of any kind in relation to Developer Products and is not liable for disclosures to third parties that you authorize to access Your Content. Your use of any third-party applications is at your sole risk.**

### 3. Git LFS Support

If you enable Git Large File Storage ("Git LFS") on your Account, you'll be able to fetch, modify, and push large files just as you would expect with any file that Git manages. Your Account comes with a certain amount of bandwidth and storage for use with Git LFS, which can be found in the [Git LFS documentation](/github/managing-large-files/about-storage-and-bandwidth-usage). Git LFS bandwidth and storage usage is displayed within your [account settings](https://github.com/settings/billing). If you want to use Git LFS beyond your allotted bandwidth and storage, then you may [purchase additional data packs](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage).

### 4. Pages

Each GitHub Account comes with access to the [GitHub Pages static hosting service](/github/working-with-github-pages/about-github-pages). This hosting service is intended to host static web pages for All Users, but primarily as a showcase for personal and organizational projects. Some monetization efforts are permitted on Pages, such as donation buttons and crowdfunding links.

GitHub Pages are subject to some specific bandwidth and usage limits, and may not be appropriate for some high-bandwidth uses or other prohibited uses. Please see our [GitHub Pages guidelines](/github/working-with-github-pages/about-github-pages) for more information. GitHub reserves the right at all times to reclaim any GitHub subdomain without liability.

### 5. Actions and Packages

#### a. Actions Usage
GitHub Actions enables you to create custom software development lifecycle workflows directly in your GitHub repository. Each Account comes with included compute and storage quantities for use with Actions, depending on your Account plan, which can be found in the [Actions documentation](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions). Your Actions compute usage is displayed within [your Account settings](https://github.com/settings/billing), and you will be notified by email in advance of reaching the limit of your included quantities. If you want to use Actions beyond your included quantities, then you may [enable overages](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions).

Compute usage for included and paid quantities is calculated in minutes based on the type of Actions you execute (e.g. Linux, Windows, macOS). The minutes used for each Action's job or task will be rounded up to the nearest minute. For included quantities and depending on the type of Action, a multiplier may be applied to the amount of time used to execute each job or task, prior to being rounded up to the nearest minute. Overage minutes are charged at the [stated per minute price](https://github.com/features/actions) based on the type of Actions you execute. Actions and Packages share storage, and your storage usage is displayed within your [account settings](https://github.com/settings/billing). For additional details about included quantity usage calculations, see the [Actions documentation](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions).

Actions and any elements of the Action service may not be used in violation of the Agreement, the [Acceptable Use Policy](/github/site-policy/github-acceptable-use-policies), or the GitHub Actions [service limitations](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits). Additionally, Actions should not be used for:
- cryptomining;
- using our servers to disrupt, or to gain or to attempt to gain unauthorized access to, any service, device, data, account or network (other than those authorized by the [GitHub Bug Bounty program](https://bounty.github.com))
- the provision of a stand-alone or integrated application or service offering Actions or any elements of Actions for commercial purposes;
- any activity that places a burden on our servers, where that burden is disproportionate to the benefits provided to users (for example, don't use Actions as a content delivery network or as part of a serverless application, but a low benefit Action could be ok if it’s also low burden); or
- any other activity unrelated to the production, testing, deployment, or publication of the software project associated with the repository where GitHub Actions are used.

In order to prevent violations of these limitations and abuse of GitHub Actions, GitHub may monitor your use of GitHub Actions. Misuse of GitHub Actions may result in termination of jobs, or restrictions in your ability to use GitHub Actions.

#### b. Packages Usage
GitHub Packages may be used to download, publish, and manage packages of Content. Each Account plan comes with included bandwidth and storage quantities for use with Packages, which can be found in the [Packages documentation](/github/managing-packages-with-github-package-registry/about-github-package-registry). Actions and Packages share storage between the two Service features. Storage and bandwidth usage are displayed within your [account settings](https://github.com/settings/billing), and you will be notified by email in advance of reaching the limit of your included quantities. If you want to use Packages beyond your included bandwidth and storage quantities, then you may [enable overages](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages).

Bandwidth usage is calculated based on the amount of data transferred out of your repositories through Packages, but package transfers through Actions will not count toward your included or paid quantities. Packages bandwidth usage is limited by the [Acceptable Use Policy](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use), and included bandwidth quantities are determined by your [Account plan](https://github.com/pricing).

Actions and Packages storage usage is shared between the two Service features. Storage usage is calculated as a weighted average over the course of the month and does not reset each month. Public and private repositories have different included storage quantities, and the included quantities for private repositories depend on your [Account plan](https://github.com/pricing).

#### c. Payment and Billing for Actions and Packages
Billing for Actions and Packages is usage-based. Additional quantities of Actions or Packages cannot be purchased separately.  For monthly-billed customers, you must have a payment method on file to choose to pay for additional quantities of these Service features. You will be charged on a monthly, recurring basis based on your usage in the preceding month, unless you are billed by invoice. For invoiced customers, you must pay the fees within thirty (30) days of the GitHub invoice date. For customers paying for Service feature overages in advance, unused prepaid minutes will not roll over to the next billing period and will not be refunded.

You can set a monthly spending limit in your [account settings](https://github.com/settings/billing/cost_management). You will be notified by email in advance of reaching the limit of your included quantities and the designated spending limit of your paid additional quantities.

### 6. Learning Lab

**Enrollment.** To complete enrollment in Learning Lab for Organizations, you agree to create a separate organization for Learning Lab purposes, and you authorize us to add Learning Lab course materials to that organization on your behalf.

**Learning Lab Course Materials.** Any course materials GitHub provides are owned solely by GitHub; provided, however, that GitHub grants you a worldwide, non-exclusive, limited-term, non-transferable, royalty-free license to copy, maintain, use and run such course materials for your internal business purposes associated with Learning Lab use. This license grant is subject to any additional open source licensing agreements that may be provided along with the source code.  Course materials you create are owned solely by you, provided, however, that you grant to GitHub a worldwide, non-exclusive, perpetual, non-transferable, royalty-free license to copy, maintain, use, host, and run (as applicable) on the Service, such course materials. Your use of GitHub course materials and your creation and storage of your own course materials does not constitute joint ownership in either party's respective intellectual property by the other party.

**Privacy.** Learning Lab may collect personal information. You control what information Learning Lab collects in your GitHub.com profile settings panel. If Learning Lab collects personal information on GitHub's behalf, GitHub will process that information in accordance with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement). If you enroll in or are completing a private course through Learning Lab, GitHub may share your enrollment information and course progress through completion with the organization admins. This may include individual data such as your GitHub username, course start date, and course end date. Course completion data may also be presented in aggregate form to help guide improvements to the course content.

### 7. Connect

In order to access GitHub Connect, Customer must have at least one (1) account on GitHub.com and one (1) licensed instance of the Software. GitHub Connect may be used for performing automated tasks. In addition, multiple Users may direct certain actions with GitHub Connect. Customer is responsible for actions that are performed on or through its accounts. GitHub may collect information about how Customer uses GitHub Connect to provide and improve the feature. By using GitHub Connect, Customer authorizes GitHub to collect protected data, which includes Private Repository data and User Personal Information (as defined in the GitHub Privacy Statement), from Customer’s GitHub Enterprise Server account. Customer also authorizes the transfer of identifying instance information to GitHub through GitHub Connect, which information is governed by the GitHub Privacy Statement.

### 8. Sponsors Program

In order to become a Sponsored Developer, you must agree to the [GitHub Sponsors Program Additional Terms](/github/site-policy/github-sponsors-additional-terms).

### 9. GitHub Advanced Security

GitHub Advanced Security enables you to identify security vulnerabilities through customizable and automated semantic code analysis. GitHub Advanced Security is licensed on a per User basis. If you are using GitHub Advanced Security as part of GitHub Enterprise Cloud, many features of GitHub Advanced Security, including automated code scanning of private repositories, also require the use of GitHub Actions. Billing for usage of GitHub Actions is usage-based and is subject to the [GitHub Actions terms](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages).

### 10. Dependabot Preview

Your use of Dependabot Preview is governed by a separate [Terms of Service](https://dependabot.com/terms) and [Privacy Policy](https://dependabot.com/privacy).

### 11. Spectrum

Your use of Spectrum is governed by the GitHub [Terms of Service](/github/site-policy/github-terms-of-service) and [Privacy Statement](/github/site-policy/github-privacy-statement).

### 12. Advisory Database

#### a. License Grant to Us

We need the legal right to submit your contributions to the GitHub Advisory Database into public domain datasets such as the [National Vulnerability Database](https://nvd.nist.gov/) and to license the GitHub Advisory Database under open terms for use by security researchers, the open source community, industry, and the public. You agree to release your contributions to the GitHub Advisory Database under the [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/).

#### b. License to the GitHub Advisory Database

The GitHub Advisory Database is licensed under the [Creative Commons Attribution 4.0 license](https://creativecommons.org/licenses/by/4.0/). The attribution term may be fulfilled by linking to the GitHub Advisory Database at <https://github.com/advisories> or to individual GitHub Advisory Database records used, prefixed by <https://github.com/advisories>.

