---
title: Git and GitHub learning resources
redirect_from:
  - /articles/good-resources-for-learning-git-and-github/
  - /articles/what-are-other-good-resources-for-learning-git-and-github/
  - /articles/git-and-github-learning-resources
intro: 'There are a lot of helpful Git and {% data variables.product.product_name %} resources on the web. This is a short list of our favorites!'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Using Git

Familiarize yourself with Git by visiting the [official Git project site](https://git-scm.com) and reading the [ProGit ebook](http://git-scm.com/book). You can review the [Git command list](https://git-scm.com/docs) or [Git command lookup reference](http://gitref.org) while using the [Try Git](https://try.github.com) simulator.

### Using {% data variables.product.product_name %}

{% if currentVersion == "free-pro-team@latest" %}

{% data variables.product.prodname_learning %} offers free interactive courses that are built into {% data variables.product.prodname_dotcom %} with instant automated feedback and help. Learn to open your first pull request, make your first open source contribution, create a {% data variables.product.prodname_pages %} site, and more. For more information about course offerings, see [{% data variables.product.prodname_learning %}]({% data variables.product.prodname_learning_link %}).

{% endif %}

Become better acquainted with {% data variables.product.product_name %} through our [bootcamp](/categories/bootcamp/) articles. See our [{% data variables.product.prodname_dotcom %} flow](https://guides.github.com/introduction/flow) for a process introduction. Refer to our [overview guides](https://guides.github.com) to walk through basic concepts.

{% data reusables.support.ask-and-answer-forum %}

#### Branches, forks, and pull requests

Learn about [Git branching](http://learngitbranching.js.org/) using an interactive tool. Read about [forks](/articles/about-forks) and [pull requests](/articles/using-pull-requests) as well as [how we use pull requests](https://github.com/blog/1124-how-we-use-pull-requests-to-build-github) at {% data variables.product.prodname_dotcom %}.

Access quick references about the [command line](https://hub.github.com) as well as {% data variables.product.prodname_dotcom %} [checklists, cheat sheets, and more](https://services.github.com/on-demand/resources).

#### Tune in

Our {% data variables.product.prodname_dotcom %} [YouTube Training and Guides channel](https://youtube.com/githubguides) offers tutorials about [pull requests](https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=19), [forking](https://www.youtube.com/watch?v=5oJHRbqEofs), [rebase](https://www.youtube.com/watch?v=SxzjZtJwOgo&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=22), and [reset](https://www.youtube.com/watch?v=BKPjPMVB81g) functions. Each topic is covered in 5 minutes or less.

### 연습

#### Free classes

{% data variables.product.product_name %} offers a series of interactive, [on-demand training courses](https://services.github.com/on-demand/) including {% data variables.product.prodname_dotcom %} 101: [Introduction](https://services.github.com/on-demand/intro-to-github/), {% data variables.product.prodname_dotcom %} 102: [GitHub Desktop](https://services.github.com/on-demand/github-desktop), and {% data variables.product.prodname_dotcom %} 103: [Command Line](https://services.github.com/on-demand/github-cli).

#### {% data variables.product.prodname_dotcom %}'s web-based educational programs

{% data variables.product.prodname_dotcom %} offers live [trainings](https://services.github.com/#upcoming-events) with a hands-on, project-based approach for those who love the command line and those who don't.

#### Training for your company

{% data variables.product.prodname_dotcom %} offers [in-person classes](https://services.github.com/#offerings) taught by our highly-experienced educators. [Contact us](https://services.github.com/#contact) to ask your training-related questions.

### Extras

An interactive [online Git course](http://www.codeschool.com/courses/git-real) from [Code School](http://codeschool.com) has seven levels with dozens of exercises in a fun game format. Feel free to adapt our [.gitignore templates](https://github.com/github/gitignore) to meet your needs.

Extend your {% data variables.product.prodname_dotcom %} reach through {% if currentVersion == "free-pro-team@latest" %}[integrations](/articles/about-integrations){% else %}integrations{% endif %}, or by installing [{% data variables.product.prodname_desktop %}](https://desktop.github.com) and the robust [Atom](https://atom.io) text editor.

Learn how to launch and grow your open source project with the [Open Source Guides](https://opensource.guide/).
