---
title: Finding ways to contribute to open source on GitHub
intro: 'You can find ways to contribute to open source projects on {% data variables.product.product_name %} that are relevant to you.'
redirect_from:
  - /articles/where-can-i-find-open-source-projects-to-work-on/
  - /articles/finding-interesting-projects-on-github/
  - /articles/about-official-github-mirrors/
  - /articles/about-github-mirrors/
  - /articles/finding-open-source-projects-on-github
  - /github/getting-started-with-github/finding-open-source-projects-on-github
versions:
  free-pro-team: '*'
---

### Discovering relevant projects

If there's a particular topic that interests you, visit `github.com/topics/<topic>`. For example, if you are interested in machine learning, you can find relevant projects and good first issues by visiting https://github.com/topics/machine-learning. You can browse popular topics by visiting [Topics](https://github.com/topics). You can also search for repositories that match a topic you're interested in. For more information, see "[Searching for repositories](/articles/searching-for-repositories#search-by-topic)."

If you've been active on {% data variables.product.product_name %}, you can find personalized recommendations for projects and good first issues based on your past contributions, stars, and other activities in [Explore](https://github.com/explore). You can also sign up for the Explore newsletter to receive emails about opportunities to contribute to {% data variables.product.product_name %} based on your interests. To sign up, see [Explore email newsletter](https://github.com/explore/subscribe).

Keep up with recent activity from repositories you watch and people you follow in the "All activity" section of your personal dashboard. For more information, see "[About your personal dashboard](/articles/about-your-personal-dashboard)."

{% data reusables.support.ask-and-answer-forum %}

### Finding good first issues

If you already know what project you want to work on, you can find beginner-friendly issues in that repository by visiting `github.com/<owner>/<repository>/contribute`. For an example, you can find ways to make your first contribution to `electron/electron` at https://github.com/electron/electron/contribute.

### Open source projects with mirrors on {% data variables.product.prodname_dotcom %}

Some open-source projects provide mirrors on {% data variables.product.prodname_dotcom_the_website %} in addition to their official repositories, which are hosted elsewhere.

Here are a few prominent repositories that are mirrored on {% data variables.product.prodname_dotcom_the_website %}:

- [android](https://github.com/android)
- [The Apache Software Foundation](https://github.com/apache)
- [The Chromium Project](https://github.com/chromium)
- [The Eclipse Foundation](https://github.com/eclipse)
- [The FreeBSD Project](https://github.com/freebsd)
- [The Glasgow Haskell Compiler](https://github.com/ghc)
- [GNOME](https://github.com/GNOME)
- [The Linux kernel source tree](https://github.com/torvalds/linux)
- [Qt](https://github.com/qt)

To set up your own mirror, you can configure [a post-receive hook](https://git-scm.com/book/en/Customizing-Git-Git-Hooks) on your official project repository to automatically push commits to a mirror repository on {% data variables.product.product_name %}.

You can search repositories based on whether they're a mirror. To learn more, see "[Searching for repositories](/articles/searching-for-repositories/#search-based-on-whether-a-repository-is-a-mirror)."

### 더 읽을거리

- "[Classifying your repository with topics](/articles/classifying-your-repository-with-topics)"
- "[About your organization dashboard](/articles/about-your-organization-dashboard)"
