---
title: About repositories
intro: A repository is like a folder for your project. Your project's repository contains all of your project's files and stores each file's revision history. You can also discuss and manage your project's work within the repository.
redirect_from:
  - /articles/about-repositories
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

You can own repositories individually, or you can share ownership of repositories with other people in an organization.

You can restrict who has access to a repository by choosing the repository's visibility. For more information, see "[About repository visibility](/github/creating-cloning-and-archiving-repositories/about-repository-visibility)."

For user-owned repositories, you can give other people collaborator access so that they can collaborate on your project. If a repository is owned by an organization, you can give organization members access permissions to collaborate on your repository. For more information, see "[Permission levels for a user account repository](/articles/permission-levels-for-a-user-account-repository/)" and "[Repository permission levels for an organization](/articles/repository-permission-levels-for-an-organization/)."

{% if currentVersion == "free-pro-team@latest" %}
With {% data variables.product.prodname_free_team %} for user accounts and organizations, you can work with unlimited collaborators on unlimited public repositories with a full feature set, or unlimited private repositories with a limited feature set. To get advanced tooling for private repositories, you can upgrade to {% data variables.product.prodname_pro %}, {% data variables.product.prodname_team %}, or {% data variables.product.prodname_ghe_cloud %}. {% data reusables.gated-features.more-info %}
{% else %}
Each person and organization can own unlimited repositories and invite an unlimited number of collaborators to all repositories.
{% endif %}

You can collaborate on your project with others using your repository's issues, pull requests, and project boards.

![Main page of the octocat/Hello-World repository](/assets/images/help/repository/repo-main-page.png)

{% data reusables.repositories.repo-size-limit %}

### 더 읽을거리

- "[Creating a new repository](/articles/creating-a-new-repository)"
- "[Collaborating with issues and pull requests](/categories/collaborating-with-issues-and-pull-requests)"
- "[Managing your work on {% data variables.product.prodname_dotcom %}](/categories/managing-your-work-on-github/)"
- "[Administering a repository](/categories/administering-a-repository)"
- "[Visualizing repository data with graphs](/categories/visualizing-repository-data-with-graphs/)"
- "[About wikis](/articles/about-wikis)"
- "[{% data variables.product.prodname_dotcom %} glossary](/articles/github-glossary)"
