---
title: Keyboard shortcuts
intro: 'You can use keyboard shortcuts in {% data variables.product.prodname_desktop %}.'
redirect_from:
  - /desktop/getting-started-with-github-desktop/keyboard-shortcuts-in-github-desktop/
  - /desktop/getting-started-with-github-desktop/keyboard-shortcuts
versions:
  free-pro-team: '*'
---

{% mac %}

GitHub Desktop keyboard shortcuts on macOS

### Site wide shortcuts

| Keyboard shortcut                    | 설명                                                                      |
| ------------------------------------ | ----------------------------------------------------------------------- |
| <kbd>⌘</kbd><kbd>,</kbd>             | Go to Preferences                                                       |
| <kbd>⌘</kbd><kbd>H</kbd>             | Hide the {% data variables.product.prodname_desktop %} application |
| <kbd>⌥</kbd><kbd>⌘</kbd><kbd>H</kbd> | Hide all other applications                                             |
| <kbd>⌘</kbd><kbd>Q</kbd>             | Quit {% data variables.product.prodname_desktop %}                 |
| <kbd>⌃</kbd><kbd>⌘</kbd><kbd>F</kbd> | Toggle full screen view                                                 |
| <kbd>⌘</kbd><kbd>0</kbd>             | Reset zoom to default text size                                         |
| <kbd>⌘</kbd><kbd>=</kbd>             | Zoom in for larger text and graphics                                    |
| <kbd>⌘</kbd><kbd>-</kbd>             | Zoom out for smaller text and graphics                                  |
| <kbd>⌥</kbd><kbd>⌘</kbd><kbd>I</kbd> | Toggle Developer Tools                                                  |

### Repositories

| Keyboard shortcut                    | 설명                                                                                  |
| ------------------------------------ | ----------------------------------------------------------------------------------- |
| <kbd>⌘</kbd><kbd>N</kbd>             | Add a new repository                                                                |
| <kbd>⌘</kbd><kbd>O</kbd>             | Add a local repository                                                              |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>O</kbd> | Clone a repository from {% data variables.product.prodname_dotcom %}           |
| <kbd>⌘</kbd><kbd>T</kbd>             | Show a list of your repositories                                                    |
| <kbd>⌘</kbd><kbd>P</kbd>             | Push the latest commits to {% data variables.product.prodname_dotcom %}        |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>P</kbd> | Pull down the latest changes from {% data variables.product.prodname_dotcom %} |
| <kbd>⌘</kbd><kbd>⌫</kbd>             | Remove an existing repository                                                       |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>G</kbd> | View the repository on {% data variables.product.prodname_dotcom %}            |
| <kbd>⌃</kbd><kbd>&grave;</kbd>       | Open repository in your preferred terminal tool                                     |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>F</kbd> | Show the repository in Finder                                                       |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>A</kbd> | Open the repository in your preferred editor tool                                   |
| <kbd>⌘</kbd><kbd>I</kbd>             | Create an issue on {% data variables.product.prodname_dotcom %}                |

### Branches

| Keyboard shortcut                    | 설명                                                                                 |
| ------------------------------------ | ---------------------------------------------------------------------------------- |
| <kbd>⌘</kbd><kbd>1</kbd>             | Show all your changes before committing                                            |
| <kbd>⌘</kbd><kbd>2</kbd>             | Show your commit history                                                           |
| <kbd>⌘</kbd><kbd>B</kbd>             | Show all your branches                                                             |
| <kbd>⌘</kbd><kbd>G</kbd>             | Go to the commit summary field                                                     |
| <kbd>space</kbd>                     | Select or deselect all highlighted files                                           |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>N</kbd> | Create a new branch                                                                |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>R</kbd> | Rename the current branch                                                          |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>D</kbd> | Delete the current branch                                                          |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>U</kbd> | Update from default branch                                                         |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>B</kbd> | Compare to an existing branch                                                      |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>M</kbd> | Merge into current branch                                                          |
| <kbd>⌃</kbd><kbd>H</kbd>             | Show or hide stashed changes                                                       |
| <kbd>⇧</kbd><kbd>⌘</kbd><kbd>C</kbd> | Compare branches on {% data variables.product.prodname_dotcom %}              |
| <kbd>⌘</kbd><kbd>R</kbd>             | Show the current pull request on {% data variables.product.prodname_dotcom %} |

{% endmac %}

{% windows %}

GitHub Desktop keyboard shortcuts on Windows

### Site wide shortcuts

| Keyboard shortcut                           | 설명                                     |
| ------------------------------------------- | -------------------------------------- |
| <kbd>Ctrl</kbd><kbd>,</kbd>                 | Go to Options                          |
| <kbd>F11</kbd>                              | Toggle full screen view                |
| <kbd>Ctrl</kbd><kbd>0</kbd>                 | Reset zoom to default text size        |
| <kbd>Ctrl</kbd><kbd>=</kbd>                 | Zoom in for larger text and graphics   |
| <kbd>Ctrl</kbd><kbd>-</kbd>                 | Zoom out for smaller text and graphics |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>I</kbd> | Toggle Developer Tools                 |

### Repositories

| Keyboard Shortcut                           | 설명                                                                                  |
| ------------------------------------------- | ----------------------------------------------------------------------------------- |
| <kbd>Ctrl</kbd><kbd>N</kbd>                 | Add a new repository                                                                |
| <kbd>Ctrl</kbd><kbd>O</kbd>                 | Add a local repository                                                              |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>O</kbd> | Clone a repository from {% data variables.product.prodname_dotcom %}           |
| <kbd>Ctrl</kbd><kbd>T</kbd>                 | Show a list of your repositories                                                    |
| <kbd>Ctrl</kbd><kbd>P</kbd>                 | Push the latest commits to {% data variables.product.prodname_dotcom %}        |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>P</kbd> | Pull down the latest changes from {% data variables.product.prodname_dotcom %} |
| <kbd>Ctrl</kbd><kbd>Delete</kbd>            | Remove an existing repository                                                       |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>G</kbd> | View the repository on {% data variables.product.prodname_dotcom %}            |
| <kbd>Ctrl</kbd><kbd>&grave;</kbd>           | Open repository in your preferred command line tool                                 |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>F</kbd> | Show the repository in Explorer                                                     |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>A</kbd> | Open the repository in your preferred editor tool                                   |
| <kbd>Ctrl</kbd><kbd>I</kbd>                 | Create an issue on {% data variables.product.prodname_dotcom %}                |

### Branches

| Keyboard shortcut                           | 설명                                                                                 |
| ------------------------------------------- | ---------------------------------------------------------------------------------- |
| <kbd>Ctrl</kbd><kbd>1</kbd>                 | Show all your changes before committing                                            |
| <kbd>Ctrl</kbd><kbd>2</kbd>                 | Show your commit history                                                           |
| <kbd>Ctrl</kbd><kbd>B</kbd>                 | Show all your branches                                                             |
| <kbd>Ctrl</kbd><kbd>G</kbd>                 | Go to the commit summary field                                                     |
| <kbd>space</kbd>                            | Select or deselect all highlighted files                                           |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>N</kbd> | Create a new branch                                                                |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>R</kbd> | Rename the current branch                                                          |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>D</kbd> | Delete the current branch                                                          |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>U</kbd> | Update from default branch                                                         |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>B</kbd> | Compare to an existing branch                                                      |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>M</kbd> | Merge into current branch                                                          |
| <kbd>Ctrl</kbd><kbd>H</kbd>                 | Show or hide stashed changes                                                       |
| <kbd>Ctrl</kbd><kbd>Shift</kbd><kbd>C</kbd> | Compare branches on {% data variables.product.prodname_dotcom %}              |
| <kbd>Ctrl</kbd><kbd>R</kbd>                 | Show the current pull request on {% data variables.product.prodname_dotcom %} |

{% endwindows %}
