---
title: About support for Advanced Security
intro: '{% data variables.contact.enterprise_support %} can help you troubleshoot issues you run into while using {% data variables.product.prodname_advanced_security %}.'
redirect_from:
  - /enterprise/admin/enterprise-support/about-support-for-advanced-security
versions:
  enterprise-server: '*'
---

{% note %}

**Note**: {% data reusables.support.data-protection-and-privacy %}

{% endnote %}

### About support for {% data variables.product.prodname_advanced_security %}

{% data variables.product.prodname_advanced_security %} includes {% data variables.contact.enterprise_support %} in English, by email.

### Scope of support

If your support request is outside of the scope of what our team can help you with, we may recommend next steps to resolve your issue outside of {% data variables.contact.enterprise_support %}. Your support request is possibly out of {% data variables.contact.enterprise_support %}'s scope if it's primarily about:
- Third party integrations
- Hardware setup
- Configuration of external systems
- Open source projects
- Building projects or repositories
- LGTM cluster design
- Writing or debugging new queries for {% data variables.product.prodname_codeql %}

If you're uncertain if the issue is out of scope, open a ticket and we're happy to help you determine the best way to proceed.

### Contacting {% data variables.contact.enterprise_support %}

You can contact {% data variables.contact.enterprise_support %} through the {% data variables.contact.contact_enterprise_portal %} for help with:
- Installing and using {% data variables.product.prodname_advanced_security %}
- Identifying and verifying the causes of supported errors

### Hours of operation

We offer support for {% data variables.product.prodname_advanced_security %} in English 24 hours per day, 5 days per week, excluding weekends and national U.S. holidays. The standard response time is 1 business day.

### Holiday schedule

{% data variables.contact.enterprise_support %} observes these U.S. holidays.

| U.S. holiday                | Date observed in 2018       |
| --------------------------- | --------------------------- |
| New Year's Day              | January 1                   |
| Martin Luther King, Jr. Day | Third Monday in January     |
| Presidents' Day             | Third Monday in February    |
| Memorial Day                | Last Monday in May          |
| Independence Day            | July 4                      |
| Labor Day                   | First Monday in September   |
| Veterans Day                | November 12                 |
| Thanksgiving Day            | Fourth Thursday in November |
| Day after Thanksgiving      | Fourth Friday in November   |
| Christmas Eve               | December 24                 |
| Christmas Day               | December 25                 |
| Day after Christmas         | December 26                 |
| New Year's Eve              | December 31                 |

### Installing {% data variables.product.prodname_advanced_security %} updates

To ensure that your {% data variables.product.prodname_advanced_security %} instance is stable, you must install and implement new releases when they are made available. This ensures that you have the latest features, modifications, and enhancements as well as any updates to features, code corrections, patches, or other general updates and fixes to {% data variables.product.prodname_advanced_security %}.

### Assigning a priority to a support ticket

When you contact {% data variables.contact.enterprise_support %} for help with {% data variables.product.prodname_advanced_security %}, you can choose one of three priorities for the ticket: {% data variables.product.support_ticket_priority_high %}, {% data variables.product.support_ticket_priority_normal %}, or {% data variables.product.support_ticket_priority_low %}.

{% data reusables.support.github-can-modify-ticket-priority %}

|                              Priority                              | 설명                                                                                                                                                                                                                         |
|:------------------------------------------------------------------:| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  {% data variables.product.support_ticket_priority_high %}  | {% data variables.product.prodname_advanced_security %} is not functioning or is stopped or severely impacted such that the end user cannot reasonably continue use of the software and no workaround is available. |
| {% data variables.product.support_ticket_priority_normal %} | {% data variables.product.prodname_advanced_security %} is functioning inconsistently, causing impaired end user usage and productivity.                                                                            |
|  {% data variables.product.support_ticket_priority_low %}   | {% data variables.product.prodname_advanced_security %} is functioning consistently, but the end user requests minor changes in the software, such as documentation updates, cosmetic defects, or enhancements.     |

### Resolving and closing support tickets

{% data reusables.support.enterprise-resolving-and-closing-tickets %}
