| キー                           | 種類       | 説明                                                                                                                                                                                                                                                                                                                                                         |
| ---------------------------- | -------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `action`                     | `string` | 実行されたアクション。 Can be:<ul><li>`completed` - All check runs in a check suite have completed.</li><li>`requested` - Occurs when new code is pushed to the app's repository. When you receive the `requested` action events, you'll need to [create a new check run](/v3/checks/runs/#create-a-check-run).</li><li>`rerequested` - Occurs when someone requests to re-run the entire check suite from the pull request UI. When you receive the `rerequested` action events, you'll need to [create a new check run](/v3/checks/runs/#create-a-check-run). See "[About status checks](/articles/about-status-checks#checks)" for more details about the GitHub UI.</li></ul>                                                                                                                                                                                                                                                                                                               |
| `check_suite`                | `オブジェクト` | The [check_suite](/v3/checks/suites/).                                                                                                                                                                                                                                                                                                                     |
| `check_suite[head_branch]`   | `string` | The head branch name the changes are on.                                                                                                                                                                                                                                                                                                                   |
| `check_suite[head_sha]`      | `string` | The SHA of the most recent commit for this check suite.                                                                                                                                                                                                                                                                                                    |
| `check_suite[status]`        | `string` | The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.                                                                                                                                                                                                                                 |
| `check_suite[conclusion]`    | `string` | The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`,  {% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.19" %}`action_required` or `stale`{% else %}or `action_required`{% endif %}. This value will be `null` until the check run has `completed`. |
| `check_suite[url]`           | `string` | URL that points to the check suite API resource.                                                                                                                                                                                                                                                                                                           |
| `check_suite[pull_requests]` | `array`  | An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.                                                                              |