##### **1つのイベントを使用する例**

```yaml
# プッシュでトリガー
on: push
```

##### **イベントのリストを使用する例**

```yaml
# プッシュあるいはプルリクエストでワークフローをトリガー
on: [push, pull_request]
```

##### **アクティビティの種類もしくは設定を伴う複数のイベントを使用する例**

イベントに対してアクティビティの種類もしくは設定を指定する必要がある場合、それぞれのイベントを個別に設定しなければなりません。 設定を持たないイベントも含め、すべてのイベントにはコロン (`:`)を追加しなければなりません。

```yaml
on:
  # プッシュもしくはプルリクエストでワークフローを起動する
  # ただしmasterブランチに対してのみ
  push:
    branches:
      - master
  pull_request:
    branches:
      - master
  # page_buildとリリース作成イベントでも起動
  page_build:
  release:
    types: # この設定は上のpage_buildイベントには影響しない
      - created
```
