##### 署名のverificationオブジェクト

レスポンスには、コミットの署名を検証した結果を記述する`verification`オブジェクトが含まれます。 `verification`オブジェクトには、以下のフィールドが含まれます。

| 名前          | 種類        | 説明                                         |
| ----------- | --------- | ------------------------------------------ |
| `verified`  | `boolean` | GitHubがこのコミットの署名を検証すべきと見なしているかを示します。       |
| `reason`    | `string`  | `verified`値の理由。 取り得る値とその意味は、以下の表に列挙されています。 |
| `signature` | `string`  | コミットから抽出された署名。                             |
| `payload`   | `string`  | 署名された値。                                    |

以下は、`verification`オブジェクトの`reason`が取り得る値です。

| 値                        | 説明                                                                      |
| ------------------------ | ----------------------------------------------------------------------- |
| `expired_key`            | 署名を作成したキーは期限切れです。                                                       |
| `not_signing_key`        | "signing"フラグは、署名を作成したGPGキーの利用フラグ中にありません。                                |
| `gpgverify_error`        | 署名の検証サービスとの通信でエラーがありました。                                                |
| `gpgverify_unavailable`  | 署名の検証サービスが現在利用できません。                                                    |
| `unsigned`               | このオブジェクトには署名が含まれていません。                                                  |
| `unknown_signature_type` | コミット中に非PGP署名が見つかりました。                                                   |
| `no_user`                | コミット中の`committer`メールアドレスに関連づけたユーザがいません。                                 |
| `unverified_email`       | コミット中の`committer`メールアドレスがユーザに関連づけられていますが、そのメールアドレスはユーザのアカウントで検証されていません。 |
| `bad_email`              | コミット中の`committer`メールアドレスは、署名を作成したPGPキーのアイデンティティに含まれていません。               |
| `unknown_key`            | 署名を作成したキーは、どのユーザのアカウントにも登録されていません。                                      |
| `malformed_signature`    | 署名のパースでエラーがありました。                                                       |
| `invalid`                | 署名中で見つかったキーidのキーを使って、暗号的に署名を検証することができませんでした。                            |
| `valid`                  | 上記のエラーはいずれも適用されないため、署名は検証されたものと考えられます。                                  |
