---
title: ユーザデータの法的リクエストに関するガイドライン
redirect_from:
  - /law-enforcement-guidelines/
  - /articles/guidelines-for-legal-requests-of-user-data
versions:
  free-pro-team: '*'
---

ここは、GitHub にホストされているユーザコンテンツを調査する法執行官の方や、 当社が法執行機関とどのような情報をどのような状況で共有するのかを知りたいとお考えの方に ご覧いただきたいページです。

このガイドラインでは、GitHub の簡単な背景、当社が保有しているデータの種類、当社が個人的なユーザ情報を開示する条件について説明します。 詳細に入る前に、皆様が関心をお持ちになるかもしれない大切なことを以下に述べておきます。

- 法律または裁判所命令により禁止されていない限り、アカウント情報の要求がある場合は当社はその旨を[**影響を受けるユーザに通知**](#we-will-notify-any-affected-account-owners)します。
- [有効な裁判所命令または捜査令状](#with-a-court-order-or-a-search-warrant)がない限り、当社は IP アドレスログなどの**位置追跡データ**を開示しません。
- 有効な[検索令状](#only-with-a-search-warrant)がない限り、当社はプライベートリポジトリのコンテンツを含む**個人的なユーザコンテンツ**を開示しません。

### 本ガイドラインについて

ソフトウェアプロジェクトやコードは、多くの場合、最も貴重なビジネス資産または個人資産の一部であり、その取り扱いについて、当社はユーザから信頼されています。 その信頼を裏切らない、つまり、ユーザデータを安心、安全、プライベートに保つことは当社にとって極めて重要です。

ほとんどのユーザは新しいビジネスを立ち上げたり、新しいテクノロジーを構築したり、または人類のために GitHub のサービスを使用していますが、世界中に何百万人ものユーザがいる中で、悪意を持つ者が存在することも否めません。 そのような場合、私たちは、公衆を保護するという正当な利益に取り組む法執行機関を支援したいと考えています。

当社は、法執行機関の担当者にガイドラインを提供することで、ユーザのプライバシーと正義というしばしば競合する利害のバランスを取りたいと考えています。 このガイドラインが双方の期待値の設定に役立つと同時に、GitHub の内部プロセスに透明性をもたらすことを願っています。 ユーザの皆様には、当社が個人情報を大切にし、それを保護するために何を行っているのかを認識していただきたく存じます。 少なくとも適切な法的要件が満たされない限り、当社がデータを第三者に明け渡すことはありません。 同様に法執行官の方に対しては、より効率的なデータ要求を行い、調査の実施に必要な情報のみにターゲットを絞ることができるように GitHub のシステムについて理解していただきたいと考えています。

### GitHub の用語

データの開示を要求する前に、当社のシステムがどのように実装されているかを理解しておくことをお勧めします。 GitHub は、[Git バージョン管理システム](https://git-scm.com/video/what-is-version-control)を使用して、何百万ものデータリポジトリをホストしています。 GitHub のリポジトリ（公開されている場合も非公開の場合もあります）は、ソフトウェア開発プロジェクトで使用されるのが最も一般的ですが、あらゆる種類のコンテンツの作業にも使用されます。

- [**ユーザ**](/articles/github-glossary#user) — ユーザは、当社のシステム内では個人の GitHub アカウントとして表されます。 各ユーザには個人プロフィールがあり、複数のリポジトリを所有できます。 ユーザは Organization を作成したり招待を受けて Organization に参加することで、別のユーザのリポジトリでコラボレーションすることができます。

- [**コラボレータ**](/articles/github-glossary#collaborator) — コラボレータとは、コントリビューションのためにリポジトリ所有者から招待されたリポジトリへの読み取りおよび書き込みアクセス権を持つユーザです。

- [**Organization**](/articles/github-glossary#organization) — Organization は、通常、ビジネスやプロジェクトなどの現実の組織を反映する 2 人以上のユーザのグループです。 Organization はユーザによって管理され、リポジトリとユーザのチームの両方を含めることができます。

- [**リポジトリ**](/articles/github-glossary#repository) — リポジトリは、GitHub の最も基本的な要素の 1 つです。 プロジェクトのフォルダと考えればいいでしょう。 リポジトリ 1 つに (ドキュメントを含む) すべてのプロジェクトファイルが含まれ、各ファイルのリビジョン履歴が格納されます。 リポジトリには複数のコラボレータが参加可能で、管理者の裁量により、公開される場合とされない場合があります。

- [**Pages**](/articles/what-is-github-pages) — GitHub Pages は GitHub が無料でホストする公開ウェブページで、ユーザはリポジトリに保存されたコードを使用して簡単に公開できます。 ユーザまたは Organization に GitHub Pages がある場合、通常は `https://username.github.io` などの URL で見つけることができます。または、ウェブページが独自のカスタムドメイン名にマップされている場合もあります。

- [**Gist**](/articles/creating-gists) — Gist は、ユーザがアイデアを保存したり、友人と共有したりするために使用できるソースコードまたはその他のテキストの断片です。 通常の GitHub リポジトリと同様に、Gist は Git で作成されるため、自動的にバージョン管理され、フォークおよびダウンロードが可能です。 Gist は、パブリックにすることもシークレット（既知の URL からのみアクセス可能）にすることもできます。 ただし、パブリック Gist をシークレット Gist に変換することはできません。

### GitHub.com のユーザデータ

ここでは、当社が管理している GitHub のユーザとプロジェクトに関する各種データについて説明します。

- <a name="public-account-data"></a>
**パブリックアカウントデータ** — GitHub には、ユーザとそのリポジトリに関するさまざまな情報が公開されています。 ユーザプロフィールは、`https://github.com/username` などの URL にあります。 ユーザプロフィールには、ユーザがいつアカウントを作成したかに関する情報や、GitHub.com での公開アクティビティやソーシャルインタラクションが表示されます。 パブリックユーザプロフィールには、ユーザがパブリックに共有すること選択したその他の情報が含まれる場合もあります。 すべてのユーザパブリックプロフィールには、以下が表示されます。
  - ユーザ名
  - ユーザが Star を付けたリポジトリ
  - ユーザがフォローする他の GitHub ユーザ
  - その人をフォローしているユーザ

  オプションで、ユーザは次の情報をパブリックに共有することもできます。
  - 本名
  - アバター
  - 所属先の会社
  - 所在地
  - 公開メールアドレス
  - 個人的なウェブページ
  - ユーザがメンバーになっている Organization（*Organization またはユーザの環境設定によります*）

- <a name="private-account-data"></a>
**プライベートアカウントデータ** — GitHub は、[プライバシーポリシー](/articles/github-privacy-statement)に記載されているように、ユーザに関する特定のプライベート情報も収集および管理します。 これには以下が含まれます。
  - プライベートメールアドレス
  - 支払い情報
  - セキュリティアクセスログ
  - プライベートリポジトリとのやり取りに関するデータ

  GitHub が収集するプライベートアカウント情報の種類を確認するには、{% data reusables.user_settings.personal_dashboard %} にアクセスして、左側のメニューバーのセクションを参照してください。

- <a name="organization-account-data"></a>
**Organization アカウントデータ** — Organization、その管理ユーザー、およびリポジトリに関する情報は、GitHub で公開されています。 Organization プロフィールは、`https://github.com/organization` などの URL にあります。 パブリック Organization プロフィールには、コードオーナーがパブリックに共有することを選択したその他の情報が含まれる場合もあります。 すべての Organization パブリックプロフィールには、以下が表示されます。
  - Organization 名
  - コードオーナーが Star を付けたリポジトリ
  - Organization のコードオーナーであるすべての GitHub ユーザ

  オプションで、管理ユーザは次の情報をパブリックに共有することもできます。
  - アバター
  - 所属先の会社
  - 所在地
  - 直属のメンバーとチーム
  - コラボレータ

- <a name="public-repository-data"></a>
**パブリックリポジトリデータ** — GitHub は、何百万ものパブリックなオープンソースソフトウェアプロジェクトの拠点です。 ほぼすべてのパブリックリポジトリ（たとえば、[Atom プロジェクト](https://github.com/atom/atom)）を参照して、GitHub がリポジトリについて収集および管理する情報を確認できます。 これには以下が含まれます。

  - コードそのもの
  - コードの以前のバージョン
  - プロジェクトの安定リリースバージョン
  - コラボレータ、コントリビューター、リポジトリメンバーに関する情報
  - コミット、ブランチ、プッシュ、プル、フォーク、クローンなどの Git 操作のログ
  - プルリクエストまたはコミットに関するコメントなど、Git 操作に関連する会話
  - Issue や Wiki ページなどのプロジェクト文書
  - プロジェクトへのコントリビューションとコントリビューターのネットワークを示す、統計とグラフ

- <a name="private-repository-data"></a>
**プライベートリポジトリデータ** — GitHub は、パブリックリポジトリと同じタイプのデータをプライベートリポジトリとして収集および管理しますが、プライベートリポジトリデータにアクセスできるのは、招待されたユーザのみです。

- <a name="other-data"></a>
**その他のデータ** — さらに GitHub は、ページ訪問などの分析データや、ユーザが随時提供する情報（サポートチームとの通信内容、アンケート情報、サイト登録など）を収集します。

### 影響を受けるアカウントオーナーに対する通知

当社は、法律または裁判所命令により禁止されている場合を除き、アカウントまたはリポジトリに関する保留中の要求についてユーザに通知することを方針としています。 必要に応じて法的手続きに異議を申し立てることができるよう、ユーザ情報を開示する前に、私たちは合理的な努力を払って影響を受けるアカウントオーナーに通知します。具体的には、確認済みのメールアドレスにメッセージを送信し、召喚状、裁判所命令、または令状の写しを提供します。 （まれなことではありますが）緊急時、人の死亡や重大な危害を防ぐために遅延が必要であると判断した場合は、当社は通知を遅延させることがあります。

### 非公開情報の開示

当社は、ユーザの同意がある場合、または有効な召喚状、民事捜査要求、裁判所命令、捜査令状、もしくはその他の同様の有効な法的手続きを受け取った場合にのみ、民事または刑事捜査に関連して非公開ユーザ情報を開示することをポリシーとしています。 特定の緊急事態（下記参照）においては、当社は限られた情報を共有する場合がありますが、あくまでも状況の性質に応じて対応し、それを超えるものについては法的手続きを要求します。 GitHub は、非公開情報の要求に反対する権利を留保します。 GitHub は、合法的な要求に応じて非公開情報を提出することに同意した場合、要求された情報の合理的な調査を行います。 当社が提出に応じる情報の種類は次のとおりですが、これは当社が対応する法的手続きの種類次第です。

- <a name="with-user-consent"></a>
**ユーザの同意がある場合** — GitHub は、要求を受けた場合、ユーザの身元確認後、ユーザ（Organization アカウントの場合はコードオーナー）に直接、またはユーザの書面による同意がある場合は指定された第三者に、プライベートアカウント情報を提供します。

- <a name="with-a-subpoena"></a>
**召喚状がある場合** — 有効な召喚状、民事捜査要求、または正式な刑事もしくは民事捜査に関連して発行された同様の法的手続きによって求められた場合、当社は、以下を含む特定の非公開アカウント情報を提供する場合があります。

  - アカウントに関連付けられた名前
  - アカウントに関連付けられたメールアドレス
  - 支払い情報
  - 登録日と解約日
  - アカウント登録時の IP アドレスと日時
  - 調査に関連する特定の時間またはイベント時にアカウントにアクセスするために使用された IP アドレス

Organization アカウントの場合、当社はアカウントオーナーの名前およびメールアドレス、並びに Organization アカウント作成時の日付と IP アドレスを提供する場合があります。 特定のユーザに確認要求を行うことなく、当社が Organization アカウントの他のメンバーもしくはコントリビューター（存在する場合）に関する情報、または特定されたアカウントオーナーに関する他の情報を提出することはありません。

なお、対象となる情報はケースバイケースで異なりますのでご注意ください。 ユーザの任意で提供される情報もあります。 また、当社が情報を収集または保持していない場合もあります。

- <a name="with-a-court-order-or-a-search-warrant"></a>
**With a court order *or* a search warrant** — We will not disclose account access logs unless compelled to do so by either (i) a court order issued under 18 U.S.C. Section 2703(d), upon a showing of specific and articulable facts showing that there are reasonable grounds to believe that the information sought is relevant and material to an ongoing criminal investigation; or (ii) a search warrant issued under the procedures described in the Federal Rules of Criminal Procedure or equivalent state warrant procedures, upon a showing of probable cause. 上記の非公開ユーザアカウント情報に加えて、当社は裁判所命令または捜査令状に応じてアカウントアクセスログを提供する場合があります。これには以下が含まれます。

  - 一定期間にわたるユーザの動きを明らかにするあらゆるログ
  - アカウントまたはプライベートリポジトリの設定（たとえば、どのユーザが特定の権限を持つかなど）
  - 閲覧履歴などのユーザまたは IP 固有の分析データ
  - アカウント作成以外または特定の日時のセキュリティアクセスログ

- <a name="only-with-a-search-warrant"></a>
**捜索令状がある場合のみ** — 連邦刑事訴訟規則または同等の州令状手続きに記載されている手続きの下で発行された、推定原因を示す捜査令状に基づいて強制されない限り、当社はユーザアカウントの個人的なコンテンツを開示しません。 上記の非公開ユーザアカウント情報とアカウントアクセスログに加えて、当社は検索令状に応じて個人的なユーザアカウントのコンテンツも提供します。これには以下が含まれます。

  - シークレット Gist のコンテンツ
  - プライベートリポジトリのソースコードまたはその他のコンテンツ
  - プライベートリポジトリのコントリビューションとコラボレーションの記録
  - プライベートリポジトリのコミュニケーションまたはドキュメント（Issue や Wiki など）
  - 認証または暗号化に使用されるセキュリティキー

- <a name="in-exigent-circumstances"></a>**緊急事態** — 特定の緊急事態において情報の要求を受け取った場合（人の死亡または重傷の危険を伴う緊急事態を防ぐために開示が必要であると考える場合）、当社は、法執行機関が緊急事態に対処するために必要だと当社が判断する限られた情報を開示する場合があります。 その範囲を超える情報については、上記のとおり、当社は召喚状、捜査令状、または裁判所命令を求めます。 たとえば、私たちは、捜査令状なしにプライベートリポジトリのコンテンツを開示しません。 当社は、情報を開示する前に、要求が法執行機関からのものであること、当局が緊急事態を要約した公式通知を送付したこと、および要求された情報が緊急事態の対応にどのように役立つかを確認します。

### 費用の払い戻し

当社は、法律で許可されているとおり、情報の要求への対応に伴う管理費の払い戻しを求める権利を留保します。

### データ保存

We will take steps to preserve account records for up to 90 days upon formal request from U.S. law enforcement in connection with official criminal investigations, and pending the issuance of a court order or other process.

### 要求の提出

要求は以下までお送りください。

```
GitHub, Inc. c/o Corporation Service Company
2710 Gateway Oaks Drive, Suite 150N
Sacramento, CA 95833-3505
```

また、legal@support.github.com に写しを送信することもできます。

要求を送る際は、次の情報を含めて、できるだけ具体的かつ範囲を絞った内容にしてください。

- 情報の要求を発行する機関に関する完全な情報
- 担当者の名前とバッジ/ID
- 正式なメールアドレスと連絡先電話番号
- 対象のユーザ、Organization、リポジトリ名
- 対象のページ、Gist、またはファイルの URL
- 必要な記録の種類の説明

要求の確認には 2 週間以上の時間が必要になりますのでご了承ください。

### 外国の法執行機関からの要求

カリフォルニア州に本拠を置く米国企業である GitHub には、外国当局が発行した法的手続きに応じて、外国政府にデータを提供する義務はありません。 GitHub に情報を要求する外国の法執行官は、米司法省刑事局の国際部に連絡する必要があります。 GitHub は、刑事共助条約（「MLAT」）または証人尋問要求書を経由して、米国の裁判所を介して発行された要求に迅速に対応します。 court by way of a mutual legal assistance treaty (“MLAT”) or letter rogatory.

### 質問

質問やコメント、提案などがございましたら、 {% data variables.contact.contact_support %} にお問い合わせください。
