---
title: DMCAテイクダウン通知のガイドの提出
redirect_from:
  - /dmca-notice-how-to/
  - /articles/dmca-notice-how-to/
  - /articles/guide-to-submitting-a-dmca-takedown-notice
versions:
  free-pro-team: '*'
---

このガイドでは、DMCA テイクダウンリクエストを処理するために GitHub が必要とする情報について説明します。 DMCA とは何かや、GitHub が DMCA テイクダウンリクエストをどのように処理するかなど、一般的な質問については [DMCA テイクダウンポリシー](/articles/dmca-takedown-policy)をご覧ください。

GitHub がホストするコンテンツの種類（主にソフトウェアコード）やコンテンツの管理方法（Git を使用）の性質上、苦情はできるだけ具体的にする必要があります。 このガイドラインの目的は、著作権侵害の申し立て通知の処理をできるだけ簡単にすることです。 以下に定める当社の通知形式は、DMCA 法で提案されている形式と一致しています。 これは、米著作権局の公式ウェブサイト（<https://www.copyright.gov>）でご確認いただけます。

法律に関わるあらゆる事項と同様、具体的な疑問や状況については専門家に相談するのが常に最善です。 あなたの権利に影響を及ぼす可能性のある行動をとる前に、そうすることを強くお勧めします。 このガイドは法律上の助言ではなく、またそのように解釈されるべきではありません。

### はじめる前に

*** 真実を教えてください。***DMCA では、*偽証罪によって罰せられるという条件で*著作権侵害の申し立てを行うことを義務付けています。 宣誓宣言で意図的に虚偽の陳述を行うと連邦犯罪になります。 (*See*U.S. （[合衆国法典、タイトル 18、セクション 1621](https://www.gpo.gov/fdsys/pkg/USCODE-2011-title18/html/USCODE-2011-title18-partI-chap79-sec1621.htm) *を参照してください</em>。 ）虚偽の情報を提出すると、民事責任が発生する可能性もあります。 つまり、金銭的損害で訴えられる可能性があります。 DMCA 自体には、資料や活動が権利を侵害していることを故意かつ実質的に不実表示した人物に対する[損害賠償が規定](https://en.wikipedia.org/wiki/Online_Copyright_Infringement_Liability_Limitation_Act#%C2%A7_512(f)_Misrepresentations)されています。</p> 

***調査してください。***何百万人ものユーザや組織が、GitHub で作成およびコントリビューションするプロジェクトに心血を注ぎ込んでいます。 このようなプロジェクトに対して DMCA の苦情を申し立てることは、実在する人々に現実的な結果をもたらすことになる、重大な法的措置です。 そのため、テイクダウンを送信する前に徹底的な調査を行い、弁護士に相談して、実際に使用が許可されていないことを確認してください。

***まずは丁寧にお願いしてください。***当社にテイクダウン通知を送信する前に、まずはユーザに直接連絡することが重要です。 連絡先情報は公開プロフィールページやリポジトリの README に記載されている場合があります。または、Issue を開いたり、リポジトリでプルリクエストを送信して連絡を取ることもできます。 これは厳密には義務ではありませんが、その方が上品なやり方と言えるでしょう。

***リクエストは正しく送信してください。***当社は、著作権で保護されている著作物についての、特定の著作物を特定している DMCA テイクダウン通知のみを受け入れることができます。 商標権侵害についての苦情がある場合は、[商標ポリシー](/articles/github-trademark-policy/)をご覧ください。 パスワードなどの機密データを削除したい場合は、[機密データに関するポリシー](/articles/github-sensitive-data-removal-policy/)をご覧ください。 名誉毀損またはその他の虐待行為が対象の場合は、[コミュニティガイドライン](/articles/github-community-guidelines/)をご覧ください。

***コードは他のクリエイティブコンテンツとは異なります。***GitHub はソフトウェアコードのコラボレーションのために構築されています。 このため、著作権侵害を正しく特定することが、写真、音楽、ビデオなどの他のものと比べて難しくなります。

コードが他のクリエイティブコンテンツと異なる理由はいくつもあります。 以下はその例です。

- リポジトリにはさまざまな人々からのコードの断片が含まれる場合がありますが、1 つのファイル、さらにはファイル内のサブルーチンでさえ著作権侵害に該当します。
- コードは機能性と創造的な表現の組み合わせですが、著作権が保護するのは機能的な部分ではなく、表現要素のみです。
- 多くの場合、考慮すべきライセンスがあります。 コードの一部に著作権表示があるからといって、必ずしも著作権を侵害しているとは限りません。 コードがオープンソースライセンスに従って使用されている可能性もあります。
- 著作権で保護されたコンテンツを少量のみ使用する場合、そのコンテンツを変革的な方法で使用する場合、教育目的で使用する場合、または上記を組み合わせた場合、特定の使用が[フェアユース](https://www.lumendatabase.org/topics/22)に該当する場合があります。 コードは当然そのような用途に適しているため、使用事例ごとに異なり、個別に検討する必要があります。
- コードに関する著作権侵害の申し立てにはさまざまな形があるため、著作物の詳細な説明と識別が求められます。

このリストはすべてを網羅しているわけではありません。そのため、コードを扱う際にあなたが申し立てる苦情について法律専門家に相談することは二重の意味で重要です。

***ボットを使わないでください。***熟練の専門家に、あなたが送信するすべてのテイクダウン通知の事実を評価してもらうべきです。 取り組みを第三者に外部委託している場合は、その活動内容を把握し、第三者が自動化されたボットを使用して苦情を一括送信していないことを確認してください。 ボットを使った苦情は多くの場合無効であり、このような処理を行うとプロジェクトが不必要に削除されてしまいます。

***著作権の問題は難解です。***特定の対象が著作権で保護されているかどうかを判断するのは非常に困難な場合があります。 たとえば、事実（データを含む）は一般に著作権の対象ではありません。 また、単語や短いフレーズは一般に著作権の対象ではありません。 そして、URL やドメイン名も一般に著作権の対象ではありません。 DMCA プロセスを使用できるのは著作権で保護されているコンテンツを対象とする場合のみであるため、コンテンツが保護可能かどうかについて質問がある場合は弁護士に相談する必要があります。

***異議申し立て通知を受け取る可能性があります。***テイクダウン通知の影響を受けるユーザは、[異議申し立て通知](/articles/guide-to-submitting-a-dmca-counter-notice)を送信することができます。 その場合、GitHub のコンテンツに関連する侵害行為にユーザが関与することを差し止めるよう求める法的措置を講じたことがあなたから当社に通知されない限り、当社は 10〜14 日以内にコンテンツを再度有効にします。

***あなたの苦情は公開されます。***[DMCA テイクダウンポリシー](/articles/dmca-takedown-policy#d-transparency)に記載されているように、当社は、完全かつ法的に有効なすべてのテイクダウン通知を、個人情報を編集した上、<https://github.com/github/dmca> で公開しています。

***GitHub は裁判官ではありません。***GitHub は、通知が DMCA の最小要件を満たしているかどうかを判断する以外、このプロセスではほとんど裁量権を行使しません。 主張の価値の評価は当事者（およびその弁護士）に委ねられます。なお、通知は偽証罪によって罰せられる対象になることにご注意ください。



### 申し立てられる苦情は ...

1. **"I have read and understand GitHub's Guide to Filing a DMCA Notice."（GitHub の DMCA 通知提出ガイドを読んで理解しました。）という文言を含んでいなければなりません。**この文言が含まれていないとしても、苦情に不備がなければ当社は処理を拒否しません。 ただし、このガイドラインを読んでいないと判断できるため、ガイドラインを読むように求める場合があります。

2. **侵害されていると思われる著作物を特定しなければなりません。**この情報は重要です。なぜなら、影響を受けるユーザがあなたの主張を評価し、あなたのコンテンツと自分のコンテンツを比較するために、この情報が役立つからです。 特定の具体性は、侵害されたと思われるコンテンツの性質によって異なります。 あなたがコンテンツを公開している場合は、そのコンテンツが存在するウェブページへのリンクを貼ることができるかもしれません。 プロプライエタリで公開されていないコンテンツの場合は、それを説明し、所有権があることを説明できます。 著作権局に登録しているコンテンツの場合は、登録番号を記載する必要があります。 ホストされたコンテンツが自分のコンテンツを直接的、文字通りに複製していると主張する場合は、その事実を説明することもできます。

3. **上記の第 2 項に記載されている著作物を侵害しているとあなたが主張するデータを特定してください。**できる限り具体的に特定することが大切です。 GitHub がそのデータを見つけるために十分な情報を提供してください。 具体的には、少なくとも、著作権を侵害しているとされるデータの URL を含める必要があります。 リポジトリ全体が著作権を侵害していると主張する場合は、あなたが侵害を主張する特定のファイルまたはファイル内の行番号を特定してください。 URL のすべてのコンテンツが著作権を侵害していると主張する場合は、それについても明示してください。 最後に、親リポジトリを無効にしても[フォーク](/articles/dmca-takedown-policy#b-what-about-forks-or-whats-a-fork)は自動的に*無効にならない*点にご注意ください。 リポジトリのフォークを調査、分析し、フォークも著作権を侵害していると思われる場合は、侵害の疑いのある各フォークを明示的に特定してください。 また、個々のケースを調査したことと、宣誓の上での陳述が特定された各フォークに適用されることを確認してください。

4. **著作権侵害を是正するために、影響を受けるユーザが何をする必要があるかを説明しなければなりません。**繰り返しになりますが、具体性は重要です。 当社があなたの苦情をユーザに伝える際、この情報があることで残りのコンテンツが無効にされないようにするためにユーザが何をする必要があるかがわかります。 ユーザは帰属表示を追加するだけでいいのか、 コード内の特定の行、またはファイル全体を削除する必要があるのか。 もちろん、ユーザのコンテンツ全体が著作権を侵害している場合は、コンテンツをすべて削除する以外にユーザに選択肢はありません。 そのような場合は、やはりそれを明示してください。

5. **あなたの連絡先情報を提供しなければなりません。**メールアドレス、名前、電話番号、住所を記載してください。

6. **著作権侵害の疑いがある人の連絡先情報を知っている場合は、それを提供しなければなりません。**通常、この条件は、著作権を侵害しているとされるコンテンツに関連付けられた GitHub ユーザ名を提供することで満たされます。 しかし、著作権侵害の疑いがある人について他にも知っていることがある場合もあるでしょう。 そのような場合は、その情報を当社に伝えてください。

7. **"I have a good faith belief that use of the copyrighted materials described above on the infringing web pages is not authorized by the copyright owner, or its agent, or the law. I have taken fair use into consideration."（私は、著作権所有者、その代理人、または法律により、著作権を侵害するウェブページで上記の著作物の使用が許可されていないことを確信しています。フェアユースの可能性も検討しましたが、フェアユースには該当しません。） という文言を含んでいなければなりません。**

8. **"I swear, under penalty of perjury, that the information in this notification is accurate and that I am the copyright owner, or am authorized to act on behalf of the owner, of an exclusive right that is allegedly infringed."（私は、偽証罪の罰則に基づき、この通知の情報は正確であり、私が侵害が申し立てられる排他的権利の著作権所有者であるか、所有者に代わって行動することが認められている者であることを誓います。）という文言も含んでいなければなりません。**

9. **物理的または電子的な署名を含めてください。**



### 反迂回技術に関する苦情

著作権法は、著作権で保護されている著作物へのアクセスを効果的に制御する技術的手段の迂回も禁止しています。 GitHub でホストされているコンテンツがこの禁止事項に違反していると思われる場合は、{% data variables.contact.contact_dmca %} からレポートを送信し、その禁止事項に違反しているコンテンツ、あなたが行った技術的対策、およびコンテンツが禁止事項に違反する理由に関する具体的な情報をお知らせください。



### 苦情の提出方法

{% data variables.contact.contact_dmca %} で情報を入力し、すべての質問に答えることで、最も早く回答を得ることができます。

また、<copyright@github.com> にメール通知を送信することもできます。 必要に応じて添付ファイルを含めることもできますが、メッセージの本文には平文版の文書も含めてください。

通知を郵送する必要がある場合は、それも可能ですが、通知の受け取りと応答には*相当な*時間がかかります。 当社は、平文のメールで作られた通知の方が、PDF ファイルが添付されている場合や郵送の場合よりもずっと早く回答することができます。 それでも通知を郵送する場合は、当社の住所は次のとおりです。



```
GitHub, Inc
Attn: DMCA Agent
88 Colin P Kelly Jr St
San Francisco, CA. 94107
```
