---
title: DMCAカウンター通知の提出ガイド
redirect_from:
  - /dmca-counter-notice-how-to/
  - /articles/dmca-counter-notice-how-to/
  - /articles/guide-to-submitting-a-dmca-counter-notice
versions:
  free-pro-team: '*'
---

このガイドでは、DMCA テイクダウンリクエストに対する異議申し立て通知を処理するために GitHub が必要とする情報について説明します。 DMCA とは何かや、GitHub が DMCA テイクダウンリクエストをどのように処理するかなど、一般的な質問については [DMCA テイクダウンポリシー](/articles/dmca-takedown-policy)をご覧ください。

GitHub のあなたのコンテンツが DMCA テイクダウンリクエストにより誤って無効にされたと思われる場合、異議申し立て通知を提出して削除に異議を申し立てる権利があります。 異議を申し立てた場合、10〜14 日の期間内に著作権所有者があなたに対して法的措置を講じない限り、当社はコンテンツを再度有効にします。 以下に定める当社の異議申し立て通知の形式は、DMCA 法で提案されている形式と一致しています。 これは、米著作権局の公式ウェブサイト（<https://www.copyright.gov>）でご確認いただけます。

法律に関わるあらゆる事項と同様、具体的な疑問や状況については専門家に相談するのが常に最善です。 あなたの権利に影響を及ぼす可能性のある行動をとる前に、そうすることを強くお勧めします。 このガイドは法律上の助言ではなく、またそのように解釈されるべきではありません。

### はじめる前に

*** 真実を教えてください。***DMCA では、宣誓を行い、虚偽の申し立てを行った場合には*偽証罪によって罰せられるという条件で*異議申し立て通知を行うことを義務付けています。 宣誓宣言で意図的に虚偽の陳述を行うと連邦犯罪になります。 (*See*U.S. （[合衆国法典、タイトル 18、セクション 1621](https://www.gpo.gov/fdsys/pkg/USCODE-2011-title18/html/USCODE-2011-title18-partI-chap79-sec1621.htm) *を参照してください</em>。 ）虚偽の情報を提出すると、民事責任が発生する可能性もあります。 つまり、金銭的損害で訴えられる可能性があります。</p> 

***調査してください。***DMCA 異議申し立て通知を提出すると、現実的な法的結果が生じる可能性があります。 苦情を申し立てた当事者がテイクダウン通知が間違っていることに同意しない場合、コンテンツを無効にし続けるためにあなたに対して訴訟を起こすことがあります。 あなたは、テイクダウン通知でなされた申し立てを徹底的に調査し、そして異議申し立て通知を提出する前に弁護士に相談するべきでしょう。

***You Must Have a Good Reason to Submit a Counter Notice.*** In order to file a counter notice, you must have "a good faith belief that the material was removed or disabled as a result of mistake or misidentification of the material to be removed or disabled." ([U.S. Code, Title 17, Section 512(g)](https://www.copyright.gov/title17/92chap5.html#512).) Whether you decide to explain why you believe there was a mistake is up to you and your lawyer, but you *do* need to identify a mistake before you submit a counter notice. 過去に当社が受け取った異議申し立て通知で挙げられたテイクダウン通知の間違いとしては、「苦情を申し立てた当事者に著作権がない」、「私はライセンスを持っている」、「コードは、私の使用を許可するオープンソースライセンスの下でリリースされている」、「苦情は、私の使用がフェアユースの原則によって保護されているという事実を考慮していない」などがあります。 もちろん、テイクダウン通知の欠陥には他の内容も考えられます。

***著作権法は複雑です。***テイクダウン通知による侵害の申し立ては、奇妙であったり直接的でないように思える場合があります。 著作権法は複雑であり、予期しない結果を招く可能性があります。 場合によっては、テイクダウン通知では、コンパイルおよび実行後にできることが理由で、あなたのソースコードが著作権を侵害していると申し立てられる場合があります。 例:

  - 著作物に対する[アクセス制御を迂回](https://www.copyright.gov/title17/92chap12.html)するためにあなたのソフトウェアが使用されていると申し立てられる場合があります。
  - ソフトウェアを使用して著作物を侵害するようエンドユーザを誘導した場合、ソフトウェアの配布が著作権侵害になる[場合があります](https://www.copyright.gov/docs/mgm/)。
  - 著作権侵害の申し立てが、ソースコード自体ではなく、ソフトウェアのデザイン要素の[文字通りでない複製](https://en.wikipedia.org/wiki/Substantial_similarity)に基づいている場合もあります。つまり、あなたの*デザイン*が他の誰かのデザインに酷似しているという通知を受け取る場合があります。

これらは、著作権法の複雑さを示すほんの一例に過ぎません。 法律には多くの微妙な点があり、上記のようなケースには未解決の疑問が残っているため、侵害の申し立てが簡単ではないと思われる場合は専門家のアドバイスを受けることが特に重要です。

***異議申し立て通知は法的声明です。***異議申し立て通知は当社に対してだけでなく、苦情を申し立てた当事者に対する法的声明でもあるため、異議申し立て通知を提出する場合はすべてのフィールドを不備なく記入する必要があります。 上述したように、異議申し立て通知を受け取った後も、苦情を申し立てた当事者側が引き続きコンテンツを無効にしたい場合、GitHub のコンテンツに関連する侵害行為にあなたが関与することを差し止める裁判所命令を求めて、法的措置を講じる必要があります。 つまり、あなたは訴えられる可能性があります（また、あなたは異議申し立て通知でこれに同意します）。

***あなたの異議申し立て通知は公開されます。***[DMCA テイクダウンポリシー](/articles/dmca-takedown-policy#d-transparency)に記載されているように、当社は、完全かつ法的に有効なすべての異議申し立て通知を、**個人情報を編集した上**、<https://github.com/github/dmca> で公開しています。 また、当社は編集後の通知しか公開しませんが、それによって自身の権利が影響を受ける当事者に対しては、受け取った通知の未編集の完全な写しを直接提供する場合がありますのでご注意ください。 プライバシーが心配な場合は、あなたの代わりに弁護士または他の法定代理人に異議申し立て通知を提出してもらうことができます。

***GitHub は裁判官ではありません。***GitHub は、通知が DMCA の最小要件を満たしているかどうかを判断する以外、このプロセスではほとんど裁量権を行使しません。 主張の価値の評価は当事者（およびその弁護士）に委ねられます。なお、通知は偽証罪によって罰せられる対象になることにご注意ください。

***その他のリソース。***さらにサポートが必要な場合は、インターネット上に利用できるリソースが数多く用意されています。 Lumen には、[著作権](https://www.lumendatabase.org/topics/5)と [DMCA セーフハーバー](https://www.lumendatabase.org/topics/14)に関する有益なガイドがあります。 法的助言が必要なオープンソースプロジェクトに関与している場合は、[Software Freedom Law Center](https://www.softwarefreedom.org/about/contact/) に問い合わせることができます。 また、特に困難な事態に直面したと思われる場合は、[Electronic Frontier Foundation](https://www.eff.org/pages/legal-assistance) などの非営利団体から直接支援を受けたり、弁護士を紹介してもらえる場合もあります。



### 異議申し立て通知は...

1. **"I have read and understand GitHub's Guide to Filing a DMCA Counter Notice."（GitHub の DMCA 異議申し立て通知提出ガイドを読んで理解しました。）という文言を含んでいなければなりません。**この文言が含まれていないとしても、異議申し立て通知に不備がなければ当社は処理を拒否しません。ただし、このガイドラインを読んでいないと判断できるため、ガイドラインを読むように求める場合があります。

2. ***無効にされたコンテンツとそれが表示されていた場所を特定しなければなりません。***無効にされたコンテンツは、テイクダウン通知の URL で特定されているはずです。 このため、すべきことは異議申し立て通知の対象の URL をコピーするだけです。

3. **あなたの連絡先情報を提供しなければなりません。**メールアドレス、名前、電話番号、住所を記載してください。

4. ***"I swear, under penalty of perjury, that I have a good-faith belief that the material was removed or disabled as a result of a mistake or misidentification of the material to be removed or disabled."（私は、偽証罪の罰則に基づき、削除または無効化の対象の資料の間違いまたは誤認の結果、その資料が削除または無効化されたという誠実な信念を持っていると誓います。）という文言を含んでいなければなりません。***また、間違いや誤認があったと思われる理由を伝えることもできます。 これは、苦情を申し立てている当事者への「通告」として異議申し立て通知を提出する場合、相手が次の手段として訴訟を起こすべきではない理由を説明する機会になります。 これもまた、異議申し立て通知を提出する際に弁護士と協力すべき理由の 1 つです。

5. ***"I consent to the jurisdiction of Federal District Court for the judicial district in which my address is located (if in the United States, otherwise the Northern District of California where GitHub is located), and I will accept service of process from the person who provided the DMCA notification or an agent of such person."（私は、私の住所がある司法管轄区（米国の場合は GitHub が所在するカリフォルニア州北部地区）の連邦地方裁判所の管轄に同意し、DMCA 通知を提供した人物またはかかる人物の代理人からの令状の送達を受け入れます。）という文言を含んでいなければなりません。***

6. **物理的または電子的な署名を含めてください。**



### 異議申し立て通知の提出方法

{% data variables.contact.contact_dmca %} で情報を入力し、すべての質問に答えることで、最も早く回答を得ることができます。

また、<copyright@github.com> にメール通知を送信することもできます。 必要に応じて添付ファイルを含めることもできますが、メッセージの本文には平文版の文書も含めてください。

通知を郵送する必要がある場合は、それも可能ですが、通知の受け取りと応答には*相当な*時間がかかります。具体的には、当社が異議申し立て通知を*受領*してから 10〜14 日お待ちいただくことになります。 当社は、平文のメールで作られた通知の方が、PDF ファイルが添付されている場合や郵送の場合よりもずっと早く回答することができます。 それでも通知を郵送する場合は、当社の住所は次のとおりです。



```
GitHub, Inc
Attn: DMCA Agent
88 Colin P Kelly Jr St
San Francisco, CA. 94107
```
