---
title: プライバシーのグローバルプラクティス
redirect_from:
  - /eu-safe-harbor/
  - /articles/global-privacy-practices
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

GitHub provides the same high standard of privacy protection—as described in GitHub’s [Privacy Statement](/github/site-policy/github-privacy-statement#githubs-global-privacy-practices)—to all our users and customers around the world, regardless of their country of origin or location, and GitHub is proud of the level of notice, choice, accountability, security, data integrity, access, and recourse we provide.

GitHub also complies with certain legal frameworks relating to the transfer of data from the European Economic Area, the United Kingdom, and Switzerland (collectively, “EU”) to the United States. When GitHub engages in such transfers, GitHub relies on Standard Contractual Clauses as the legal mechanism to help ensure your rights and protections travel with your personal information. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about the European Commission’s decisions on international data transfer, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection_en).

### Standard Contractual Clauses

GitHub relies on the European Commission-approved Standard Contractual Clauses (“SCCs”) as a legal mechanism for data transfers from the EU. SCCs are contractual commitments between companies transferring personal data, binding them to protect the privacy and security of such data. GitHub adopted SCCs so that the necessary data flows can be protected when transferred outside the EU to countries which have not been deemed by the European Commission to adequately protect personal data, including protecting data transfers to the United States.

To learn more about SCCs, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en).

### プライバシー シールド フレームワーク

GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-US Privacy Shield Framework as a legal basis for transfers of personal information in light of the judgment of the Court of Justice of the EU in Case C-311/18.

The EU-US and Swiss-US Privacy Shield Frameworks are set forth by the US Department of Commerce regarding the collection, use, and retention of User Personal Information transferred from the European Union, the UK, and Switzerland to the United States. GitHubは、プライバシーシールド原則を遵守することを商務省に証明しています。 If our vendors or affiliates process User Personal Information on our behalf in a manner inconsistent with the principles of either Privacy Shield Framework, GitHub remains liable unless we prove we are not responsible for the event giving rise to the damage.

For purposes of our certifications under the Privacy Shield Frameworks, if there is any conflict between the terms in these Global Privacy Practices and the Privacy Shield Principles, the Privacy Shield Principles shall govern. プライバシーシールプログラムについて詳細を知りたい場合、および、当社の証明を閲覧したい場合、[プライバシーシールドウェブサイト](https://www.privacyshield.gov/)を確認ください。

The Privacy Shield Frameworks are based on seven principles, and GitHub adheres to them in the following ways:

- **通知**
  - 当社は、個人情報を収集する際に、お客様に通知します。
  - 当社は、当社の[プライバシーに関する声明](/articles/github-privacy-statement/)において、お客様の個人情報を収集および利用する目的、その情報を共有する対象、およびお客様が自らのデータに対して所有するアクセスをお知らせします。
  - 当社は、プライバシーシールドフレームワークに参加していること、そしてそれがお客様にとって持つ意味をお知らせします。
  - 当社は、プライバシーに関するご質問を受け付けるため、{% data variables.contact.contact_privacy %}をご用意しています。
  - 万が一、紛争が生じた場合は、お客様に無償で提供される、拘束力のある仲裁を求める権利についてお知らせします。
  - 当社は、米国連邦取引委員会の管轄下にあるということをお知らせします。
- **選択肢の提供**
  - 当社は、お客様のデータに起こることをお客様に選択していただきます。 お客様のデータを、当社に提供した以外の目的で利用する前に、お客様にお知らせして許可を得ます。
  - 当社は、お客様が選択を行うための合理的な仕組みを提供します。
- **第三者移転に関する責任**
  - 当社に代わってお客様の個人情報を処理する第三者のベンダーに情報を転送する場合、当社はお客様のデータを、当社のプライバシーに関する声明に従って保護する第三者に対してのみ、当社との契約の下に送信します。 当社がプライバシーシールドの下でお客様のデータをベンダーに転送する場合、当社はそれに対して責任を負います。
  - 当社は、トランザクションを完了するために必要な量のデータのみを第三者ベンダーに共有します。
- **セキュリティ**
  - 当社は、[合理的かつ適切なセキュリティ対策](https://github.com/security)をもってお客様の個人情報を保護します。
- **データの正確性と目的外利用の制限**
  - 当社は、お客様に当社のサービスを提供する目的に関してのみ、お客様のデータを収集します。
  - 当社は、できる限り少ない量の個人情報を収集します。ただし、お客様がそれ以上の情報を提供することを選択した場合は除きます。
  - 当社は、お客様について所有するデータが正確、最新、かつ利用目的において信頼できることを保証するための合理的な措置を講じます。
- **アクセス**
  - お客様は、[ユーザプロフィール](https://github.com/settings/profile)で当社がお客様について所有するデータに常にアクセスできます。 その画面において、お客様はご自身の情報に対してアクセス、更新、修正、削除できます。
- **救済機関、執行および責任**
  - 当社のプライバシー慣行についてご質問がある場合は、{% data variables.contact.contact_privacy %}でご連絡ください。遅くとも45日以内に返信いたします。
  - 万が一、私たちが解決できない紛争が生じた場合、お客様は拘束力のある仲裁を無償で利用できます。 詳細は、「[プライバシーについての声明](/articles/github-privacy-statement/)」を参照してください。
  - 当社は、当社の約束に従っていることを確認するため、関連するプライバシー慣行について定期的な監査を実施します。
  - 当社は、従業員にプライバシーの約束を尊重することを義務付けており、当社のプライバシーポリシーに違反することは、雇用の終了を含む懲戒処分の対象となります。


#### 紛争解決プロセス

As further explained in the [Resolving Complaints](/github/site-policy/github-privacy-statement#resolving-complaints) section of our [Privacy Statement](/github/site-policy/github-privacy-statement), we encourage you to contact us should you have a Privacy Shield-related (or general privacy-related) complaint. For any complaints that cannot be resolved with GitHub directly, we have selected to cooperate with the relevant EU Data Protection Authority, or a panel established by the European data protection authorities, for resolving disputes with EU individuals, and with the Swiss Federal Data Protection and Information Commissioner (FDPIC) for resolving disputes with Swiss individuals. 当社からお客様に対して、お客様のデータ保護機関の連絡先を提供することをご希望の場合、当社にご連絡ください。

さらに、お客様がEUメンバー国の住民の場合、お客様の地元国の監督機関に苦情を申し立てる権利を有します。

#### 独立した仲裁者

一定の制限された状況において、EU、欧州経済領域（EEA）、スイスおよびイギリスの個人は、他の紛争解決方法が成功しなかった場合、最終手段として、拘束力のあるプライバシーシールド仲裁の救済を求めることができます。 解決方法および利用可能性について知りたい場合、詳細は、[プライバシーシールド](https://www.privacyshield.gov/article?id=ANNEX-I-introduction)を参照してください。 仲裁は必須ではありません。お客様が選択した場合に利用できるツールです。

We are subject to the jurisdiction of the US Federal Trade Commission (FTC).

詳細は、「[プライバシーについての声明](/articles/github-privacy-statement/)」を参照してください。
